/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.common;

import com.iscobol.rts.Config;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class RpcSocketFactory {
    private static final SocketFactory socketFactory;
    private static final ServerSocketFactory serverSocketFactory;

    public static final Socket createSocket(String host, int port) throws IOException {
        return RpcSocketFactory.createSocket(host, port, 0);
    }

    public static final Socket createSocket(String host, int port, int connectionTimeout) throws IOException {
        Socket s = socketFactory.createSocket();
        s.connect(new InetSocketAddress(host, port), connectionTimeout);
        return s;
    }

    public static final ServerSocket createServerSocket() throws IOException {
        return serverSocketFactory.createServerSocket();
    }

    public static final ServerSocket createServerSocket(int port, int bl, InetAddress ia) throws IOException {
        return serverSocketFactory.createServerSocket(port, bl, ia);
    }

    static {
        boolean sslClient;
        String prop = Config.getProperty(".net.ssl.trust_store", null);
        if (prop != null && prop.length() > 0) {
            sslClient = true;
            if (!"*".equals(prop)) {
                System.setProperty("javax.net.ssl.trustStore", prop);
                prop = Config.getProperty(".net.ssl.trust_store_password", null);
                if (prop != null) {
                    System.setProperty("javax.net.ssl.trustStorePassword", prop);
                }
            }
        } else {
            sslClient = false;
        }
        if ((prop = Config.getProperty(".net.ssl.key_store", null)) != null) {
            System.setProperty("javax.net.ssl.keyStore", prop);
            prop = Config.getProperty(".net.ssl.key_store_password", null);
            if (prop != null) {
                System.setProperty("javax.net.ssl.keyStorePassword", prop);
            }
        }
        socketFactory = sslClient || System.getProperty("javax.net.ssl.trustStore") != null ? SSLSocketFactory.getDefault() : SocketFactory.getDefault();
        serverSocketFactory = System.getProperty("javax.net.ssl.keyStore") != null ? SSLServerSocketFactory.getDefault() : ServerSocketFactory.getDefault();
    }
}

