/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.client;

import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.ISessionControl;
import com.iscobol.rpc.messageserver.common.JavaSerializer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.RpcSocketFactory;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;

public class MessageClient
implements ISessionControl {
    private String host;
    private int port;
    private int connectionTimeout;
    private Session session;
    private boolean isSendAndReceiveMessages = true;
    private IMessageSerializer messageSerializer = new JavaSerializer();

    public MessageClient(String host, int port) {
        this(host, port, 0);
    }

    public MessageClient(String host, int port, int connectionTimeout) {
        this.host = host;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
    }

    public void connect() throws UnknownHostException, IOException, GeneralSecurityException {
        Socket socket = RpcSocketFactory.createSocket(this.host, this.port, this.connectionTimeout);
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(0);
        socket.setKeepAlive(true);
        Session incomingSession = new Session(this, socket, true);
        incomingSession.startMessageHandlers();
        this.setSession(incomingSession);
    }

    public void sendMessage(Message msg) throws SessionException {
        this.getSession().sendMessage(msg);
    }

    public Message getMessage(boolean blockUntilMessage) throws SessionException {
        return this.getSession().getMessage(blockUntilMessage);
    }

    public void disconnect() {
        this.getSession().closeSession();
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public synchronized void setSendAndReceiveMessages(boolean isSendAndReceiveMessages) {
        this.isSendAndReceiveMessages = isSendAndReceiveMessages;
    }

    @Override
    public synchronized boolean isSendAndReceiveMessages() {
        return this.isSendAndReceiveMessages;
    }

    public void setMessageSerializer(IMessageSerializer messageSerializer) {
        this.messageSerializer = messageSerializer;
    }

    @Override
    public IMessageSerializer getMessageSerializer() {
        return this.messageSerializer;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }
}

