/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.profiler;

import com.iscobol.profiler.Paragraph;
import com.iscobol.profiler.Program;
import com.iscobol.profiler.Transformer;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Profiler {
    public static final String ident = "$Id: Profiler.java 40229 2025-06-24 15:57:54Z gianni_578 $";
    public static final String rev = "$Revision: 40229 $";
    public static final String SEP = "::";
    private static final String[] resources = new String[]{"app.js", "clear.png", "clear.svg", "down.gif", "method.gif", "program.gif", "report.css", "report.gif", "sort.gif", "sort.js", "up.gif", "warn.gif"};
    private static final NumberFormat percFormat;
    private static final DateFormat dateFormat;
    private static final NumberFormat secFormat;
    private static final Calendar calendar;
    private static Profiler sharedInstance;
    private static RuntimeImpl rtn;
    private Map<String, Paragraph> paragraphMap;
    private Map<String, Program> programMap;
    private Stack<Paragraph> paragraphStack = new Stack();
    private final long overhead1;
    private final long overhead2;
    private Map<String, byte[]> resourcesStream;
    private long startTime = System.nanoTime();
    private String executionStarted = dateFormat.format(calendar.getTime());
    private long disabledTime;
    private long disabledTimeAccum;
    private File htmlDir;
    private File xmlFile;
    private File txtFile;
    private boolean enabled = true;
    private final Pattern[][] inclRegExp;
    private final Pattern[][] exclRegExp;
    private Transformer transformer;
    private final boolean logEnabled;
    private static final String blanks = "                                     ";

    static RuntimeImpl getRtn() {
        if (rtn == null) {
            rtn = new RuntimeImpl();
        }
        return rtn;
    }

    public static Profiler newProfiler(File htmlDir, File xmlFile, File txtFile) {
        String[] propNames = new String[]{"iscobol.profiler.enable", "iscobol.tracelevel"};
        Object[] propDefs = new Object[]{Boolean.TRUE, 0};
        Object[] propValues = Profiler.getRtn().getPropertiesSeparate(propNames, propDefs);
        boolean enabled = (Boolean)propValues[0];
        boolean logEnabled = (Integer)propValues[1] > 0;
        return Profiler.newProfiler(htmlDir, xmlFile, txtFile, enabled, logEnabled);
    }

    public static Profiler newProfiler(File htmlDir, File xmlFile, File txtFile, boolean enabled, boolean logEnabled) {
        return Profiler.newProfiler(htmlDir, xmlFile, txtFile, enabled, logEnabled, null, null);
    }

    public static Profiler newProfiler(File htmlDir, File xmlFile, File txtFile, boolean enabled, boolean logEnabled, String incl, String excl) {
        Profiler p = new Profiler(null, null, null, true, false, incl, excl, 0L, 0L);
        int PROBE_COUNT = 100000;
        Paragraph p0 = p.getParagraph("00", "00", "00");
        Paragraph p1 = p.getParagraph("AA", "AA", "AA");
        Paragraph p2 = p.getParagraph("BB", "BB", "BB");
        Paragraph p3 = p.getParagraph("CC", "CC", "CC");
        p.enterPar(p0);
        for (int j = 0; j < 100000; ++j) {
            p.enterPar(p1);
            p.enterPar(p2);
            p.enterPar(p3);
            p.exitPar();
            p.enterPar(p3);
            p.exitPar();
            p.exitPar();
            p.exitPar();
        }
        p.exitPar();
        long o1 = p3.accum / 200000L;
        long o2 = (p2.accum - p1.accum) / 100000L;
        return new Profiler(htmlDir, xmlFile, txtFile, enabled, logEnabled, incl, excl, o1, o2);
    }

    public static Profiler getSharedInstance(File htmlDir, File xmlFile, File txtFile, String incl, String excl) {
        if (sharedInstance == null) {
            String[] propNames = new String[]{"iscobol.profiler.enable", "iscobol.tracelevel", "iscobol.profiler.elapse_time"};
            Object[] propDefs = new Object[]{Boolean.TRUE, 0, 0};
            Object[] propValues = Profiler.getRtn().getPropertiesSeparate(propNames, propDefs);
            boolean enabled = (Boolean)propValues[0];
            boolean logEnabled = (Integer)propValues[1] > 0;
            long elapsTime = ((Integer)propValues[2]).intValue();
            Profiler p = Profiler.newProfiler(htmlDir, xmlFile, txtFile, enabled, logEnabled, incl, excl);
            if (elapsTime > 0L) {
                Timer t = new Timer();
                t.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Profiler.disableAll();
                        Profiler.flushAll();
                    }
                }, elapsTime * 1000L);
            }
            try {
                p.setTransformer(new Transformer(incl, excl));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            sharedInstance = p;
        }
        return sharedInstance;
    }

    public static Profiler getProfiler() {
        return sharedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int enableAll() {
        if (sharedInstance == null) {
            return 1;
        }
        Profiler profiler = sharedInstance;
        synchronized (profiler) {
            Profiler p = sharedInstance;
            if (!p.enabled) {
                p.disabledTimeAccum += System.nanoTime() - p.disabledTime;
                p.disabledTime = 0L;
                try {
                    Paragraph par = p.paragraphStack.peek();
                    par.start = p.overhead1 + System.nanoTime();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                p.enabled = true;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int disableAll() {
        if (sharedInstance == null) {
            return 1;
        }
        Profiler profiler = sharedInstance;
        synchronized (profiler) {
            Profiler p = sharedInstance;
            if (p.enabled) {
                p.disabledTime = System.nanoTime();
                p.enabled = false;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int flushAll() {
        if (sharedInstance == null) {
            return 1;
        }
        int Return2 = 0;
        Profiler profiler = sharedInstance;
        synchronized (profiler) {
            Profiler p = sharedInstance;
            Vector<Paragraph> tmp = new Vector<Paragraph>(p.paragraphStack);
            while (!p.paragraphStack.isEmpty()) {
                p.exitPar();
            }
            try {
                p.doReport();
            }
            catch (IOException e) {
                Return2 = 2;
            }
            p.startTime = System.nanoTime();
            p.executionStarted = dateFormat.format(calendar.getTime());
            p.disabledTime = !p.enabled ? p.startTime : 0L;
            p.disabledTimeAccum = 0L;
            for (Paragraph par : p.paragraphMap.values()) {
                par.count = 0;
                par.accum = 0L;
                par.start = 0L;
            }
            for (Program pgm : p.programMap.values()) {
                pgm.count = 0;
            }
            for (Paragraph par : tmp) {
                p.enterPar(par);
            }
            p.xmlFile = null;
            p.htmlDir = null;
            p.txtFile = null;
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setAll(String[] type, File[] outputPath) {
        if (sharedInstance == null) {
            return 1;
        }
        Profiler profiler = sharedInstance;
        synchronized (profiler) {
            Profiler p = sharedInstance;
            for (int i = 0; i < type.length; ++i) {
                if ("xml".equalsIgnoreCase(type[i])) {
                    p.xmlFile = outputPath[i];
                    continue;
                }
                if ("html".equalsIgnoreCase(type[i])) {
                    p.htmlDir = outputPath[i];
                    continue;
                }
                if (!"txt".equalsIgnoreCase(type[i])) continue;
                p.txtFile = outputPath[i];
            }
        }
        return 0;
    }

    private Profiler(File htmlDir, File xmlFile, File txtFile, boolean enabled, boolean logEnabled, String incl, String excl, long o1, long o2) {
        int idx;
        String regex;
        int i;
        this.enabled = enabled;
        this.htmlDir = htmlDir;
        this.xmlFile = xmlFile;
        this.txtFile = txtFile;
        this.overhead1 = o1;
        this.overhead2 = o2;
        this.paragraphMap = new HashMap<String, Paragraph>();
        this.programMap = new HashMap<String, Program>();
        this.logEnabled = logEnabled;
        ArrayList<Pattern[]> l = new ArrayList<Pattern[]>();
        if (incl != null && incl.length() > 0) {
            String[] s = incl.split(",");
            for (i = 0; i < s.length; ++i) {
                regex = s[i];
                idx = regex.indexOf(SEP);
                if (idx <= 0 || idx >= regex.length() - SEP.length() - 1) continue;
                l.add(new Pattern[]{Pattern.compile(regex.substring(0, idx)), Pattern.compile(regex.substring(idx + 2))});
            }
        }
        if (!l.isEmpty()) {
            this.inclRegExp = new Pattern[l.size()][2];
            for (int i2 = 0; i2 < l.size(); ++i2) {
                this.inclRegExp[i2] = (Pattern[])l.get(i2);
            }
        } else {
            this.inclRegExp = null;
        }
        l = new ArrayList();
        if (excl != null && excl.length() > 0) {
            String[] s = excl.split(",");
            for (i = 0; i < s.length; ++i) {
                regex = s[i];
                idx = regex.indexOf(SEP);
                if (idx <= 0 || idx >= regex.length() - SEP.length() - 1) continue;
                l.add(new Pattern[]{Pattern.compile(regex.substring(0, idx)), Pattern.compile(regex.substring(idx + 2))});
            }
        }
        if (!l.isEmpty()) {
            this.exclRegExp = new Pattern[l.size()][2];
            for (int i3 = 0; i3 < l.size(); ++i3) {
                this.exclRegExp[i3] = (Pattern[])l.get(i3);
            }
        } else {
            this.exclRegExp = null;
        }
    }

    public final Program getProgram(String progName, boolean debug) {
        Program pgm = this.programMap.get(progName);
        if (pgm == null) {
            pgm = new Program(progName, debug);
            this.programMap.put(progName, pgm);
        }
        return pgm;
    }

    private boolean matches(Paragraph p) {
        int i;
        boolean Return2 = true;
        if (this.inclRegExp != null && this.inclRegExp.length > 0) {
            Return2 = false;
            for (i = 0; i < this.inclRegExp.length; ++i) {
                if (!this.inclRegExp[i][0].matcher(p.progName).matches() || !this.inclRegExp[i][1].matcher(p.parName).matches()) continue;
                Return2 = true;
                break;
            }
        }
        if (Return2 && this.exclRegExp != null && this.exclRegExp.length > 0) {
            for (i = 0; i < this.exclRegExp.length; ++i) {
                if (!this.exclRegExp[i][0].matcher(p.progName).matches() || !this.exclRegExp[i][1].matcher(p.parName).matches()) continue;
                Return2 = false;
                break;
            }
        }
        return Return2;
    }

    public final void enterPar(Paragraph p) {
        if (this.enabled && !p.excluded) {
            if (this.matches(p)) {
                long timeIn = System.nanoTime();
                ++p.count;
                try {
                    Paragraph pLast = this.paragraphStack.peek();
                    pLast.accum += Math.max(0L, timeIn - pLast.start);
                    pLast.start = 0L;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.paragraphStack.push(p);
                p.start = this.overhead1 + System.nanoTime();
            } else {
                p.excluded = true;
                this.paragraphStack.push(p);
            }
        } else {
            this.paragraphStack.push(p);
        }
    }

    public final void exitPar() {
        if (this.enabled) {
            long timeIn = System.nanoTime();
            try {
                Paragraph p = this.paragraphStack.pop();
                if (!p.excluded) {
                    p.accum += Math.max(0L, timeIn - p.start);
                    p.start = 0L;
                    Paragraph pLast = this.paragraphStack.peek();
                    pLast.start = this.overhead2 + System.nanoTime();
                }
            }
            catch (Throwable throwable) {}
        } else {
            this.paragraphStack.pop();
        }
    }

    static final String fmt(String Return2, int len, boolean left) {
        int sLen = Return2.length();
        if (sLen < len) {
            Return2 = left ? Return2 + blanks.substring(0, len - sLen) : blanks.substring(0, len - sLen) + Return2;
        }
        return Return2;
    }

    private long getElapsed(long currTime) {
        return currTime - this.startTime - this.disabledTimeAccum;
    }

    public void doReport() throws IOException {
        if (this.htmlDir != null) {
            this.createHtmlReport();
        }
        if (this.xmlFile != null) {
            try {
                this.createXmlReport();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        if (this.txtFile != null) {
            this.createTextReport();
        }
    }

    public void loadResources() {
        this.resourcesStream = new HashMap<String, byte[]>();
        for (String resourceName : resources) {
            try {
                InputStream in = this.getClass().getClassLoader().getResourceAsStream("com/iscobol/coverage/resources/" + resourceName);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buff = new byte[4096];
                int r = in.read(buff);
                while (r >= 0) {
                    out.write(buff, 0, r);
                    r = in.read(buff);
                }
                in.close();
                out.close();
                this.resourcesStream.put(resourceName, out.toByteArray());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void createHtmlReport() throws IOException {
        if (!this.htmlDir.exists() && !this.htmlDir.mkdirs()) {
            System.err.println("Cannot create '" + this.htmlDir + "'");
            return;
        }
        File res = new File(this.htmlDir.getAbsolutePath() + "/resources");
        res.mkdir();
        if (this.resourcesStream == null) {
            this.loadResources();
        }
        for (String rn : this.resourcesStream.keySet()) {
            try {
                FileOutputStream out = new FileOutputStream(new File(res.getAbsolutePath() + "/" + rn));
                ((OutputStream)out).write(this.resourcesStream.get(rn));
                ((OutputStream)out).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        long elps = this.getElapsed(System.nanoTime());
        this.createHtmlReport(false, elps);
        this.createHtmlReport(true, elps);
    }

    private void warn(PrintStream out, String msg) {
        out.println("      <div><img src=\"resources/warn.gif\" style=\"position:relative;width:16;height:16;top:3\"></img>" + msg + "</div>");
    }

    private void createHtmlReport(boolean pgmTable, long elps) throws IOException {
        int parCol;
        boolean b = false;
        for (Program pgm : this.programMap.values()) {
            if (pgm.count <= 0 || !pgm.debug) continue;
            b = true;
            break;
        }
        boolean hasDebugPgm = b;
        String reportTitle = "isCOBOL Profile Report";
        String fileName = pgmTable ? "indexpgm.html" : "index.html";
        PrintStream out = new PrintStream(new File(this.htmlDir.getAbsolutePath() + "/" + fileName));
        out.println("<html>");
        out.println("  <head>");
        out.println("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
        out.println("    <link rel=\"stylesheet\" href=\"resources/report.css\" type=\"text/css\" />");
        out.println("    <link rel=\"shortcut icon\" href=\"resources/report.gif\" type=\"image/gif\" />");
        out.println("    <title>isCOBOL Profile Report</title>");
        out.println("    <script type=\"text/javascript\" src=\"resources/sort.js\"></script>");
        out.println("    <script type=\"text/javascript\" src=\"resources/app.js\"></script>");
        out.println("   </head>");
        out.println("   <body onload=\"init()\">");
        out.println("      <h1>isCOBOL Profile Report</h1>");
        calendar.setTimeInMillis(System.currentTimeMillis());
        out.println("      <p><b>Execution started:</b> " + this.executionStarted + "</p>");
        out.println("      <p><b>Execution terminated:</b> " + dateFormat.format(calendar.getTime()) + "</p>");
        out.print("      <p><b>Elapsed:</b> " + secFormat.format((double)elps / 1.0E9) + "s;");
        long eval = 0L;
        List<Paragraph> paragraphList = this.getParagraphList();
        if (pgmTable) {
            Iterator<Paragraph> map = new HashMap();
            for (Paragraph p : paragraphList) {
                Paragraph p0 = (Paragraph)map.get(p.progName);
                if (p0 == null) {
                    p0 = new Paragraph(p.progName, p.progName, p.progName);
                    Program pgm = this.programMap.get(p.progName);
                    p0.count = pgm.count;
                    p0.debug = pgm.debug ? 1 : 0;
                    map.put(p.progName, p0);
                }
                p0.accum += p.accum;
            }
            paragraphList = new ArrayList(map.values());
        } else {
            for (Paragraph p : paragraphList) {
                p.debug = this.programMap.get((Object)p.progName).debug ? 1 : 0;
            }
        }
        for (Paragraph p : paragraphList) {
            eval += p.accum;
        }
        out.print(" <b>Evaluated:</b> " + secFormat.format((double)eval / 1.0E9) + "s;");
        out.print(" <b>Overhead1:</b> " + this.overhead1 + ";");
        out.println(" <b>Overhead2:</b> " + this.overhead2 + "</p>");
        if (this.logEnabled) {
            this.warn(out, "Warning: running with iscobol.tracelevel > 0, this affects performances");
        }
        if (hasDebugPgm) {
            this.warn(out, "Warning: some programs are compiled in debug mode, this affects performances");
        }
        out.println("      <p style=\"display:flex;flex-direction: row;align-items: center;\">");
        out.println("         <span>Search: </span>");
        out.println("         <input type=\"text\" id=\"filter\" oninput=\"filter()\" placeholder=\"filter...\" style=\"margin-left:6px;padding-right:20px\">");
        out.println("         <img src=\"resources/clear.svg\" onclick=\"clearFilter()\" style=\"position:relative;left:-20px;width:20px;height:20px;padding-right:22px;cursor:pointer;top:-1px;\"></img>");
        out.println("      </p>");
        if (pgmTable) {
            out.println("      <p><a href=\"index.html\">View Paragraph table</a></p>");
        } else {
            out.println("      <p><a href=\"indexpgm.html\">View Program table</a></p>");
        }
        out.println("      <table class=\"coverage\" cellspacing=\"0\" id=\"coveragetable\">");
        out.println("        <thead>");
        out.println("          <tr>");
        out.println("            <td class=\"sortable\" id=\"a\" onclick=\"toggleSort(this)\">Program</td>");
        if (hasDebugPgm) {
            out.println("            <td class=\"sortable\" id=\"b\" onclick=\"toggleSort(this)\">Debug</td>");
        }
        if (!pgmTable) {
            out.println("            <td class=\"sortable\" id=\"c\" onclick=\"toggleSort(this)\">Paragraph</td>");
        }
        out.println("            <td class=\"down sortable\" id=\"d\" onclick=\"toggleSort(this)\">Self %</td>");
        out.println("            <td class=\"sortable\" id=\"e\" onclick=\"toggleSort(this)\">Seconds</td>");
        out.println("            <td class=\"sortable\" id=\"f\" onclick=\"toggleSort(this)\">Count</td>");
        out.println("          </tr>");
        out.println("        </thead>");
        out.println("        <tbody>");
        int n = parCol = hasDebugPgm ? 2 : 1;
        int numCols = pgmTable ? (hasDebugPgm ? 5 : 4) : (hasDebugPgm ? 6 : 5);
        int selfCol = numCols - 3;
        ArrayList<Paragraph> paragraphs = new ArrayList<Paragraph>(paragraphList);
        Collections.sort(paragraphs, new ParagraphComparator(selfCol, pgmTable, hasDebugPgm));
        ArrayList<Paragraph> tmp = new ArrayList<Paragraph>(paragraphs);
        int[][] sortPos = new int[tmp.size()][numCols];
        for (int i = 0; i < sortPos.length; ++i) {
            sortPos[i][selfCol] = i;
        }
        for (int colIdx = 0; colIdx < numCols; ++colIdx) {
            if (colIdx == selfCol) continue;
            Collections.sort(tmp, new ParagraphComparator(colIdx, pgmTable, hasDebugPgm));
            block6: for (int i1 = 0; i1 < paragraphs.size(); ++i1) {
                for (int i2 = 0; i2 < tmp.size(); ++i2) {
                    if (paragraphs.get(i1) != tmp.get(i2)) continue;
                    sortPos[i1][colIdx] = i2;
                    continue block6;
                }
            }
        }
        int parIdx = 0;
        for (Paragraph p : paragraphs) {
            out.println("          <tr>");
            out.print("            <td id=\"a" + sortPos[parIdx][0] + "\">");
            if (pgmTable) {
                out.print("<a href=\"index.html?filter=" + p.progName + "\">");
            }
            String cls = p.progName.indexOf(SEP) >= 0 ? "el_method" : "el_program";
            out.print("<span class=\"" + cls + "\">" + p.progName + "</span>");
            if (pgmTable) {
                out.print("</a>");
            }
            out.println("</td>");
            if (hasDebugPgm) {
                out.println("            <td id=\"b" + sortPos[parIdx][1] + "\" class=\"ctr2\">" + (p.debug != 0 ? "Yes" : "No") + "</td>");
            }
            if (!pgmTable) {
                out.println("            <td id=\"c" + sortPos[parIdx][parCol] + "\">" + p.parDisplayName + "</td>");
            }
            out.println("            <td id=\"d" + sortPos[parIdx][selfCol] + "\" class=\"ctr2\">" + percFormat.format((double)p.accum / (double)eval) + "</td>");
            out.println("            <td id=\"e" + sortPos[parIdx][selfCol + 1] + "\" class=\"ctr2\">" + secFormat.format((double)p.accum / 1.0E9) + "</td>");
            out.println("            <td id=\"f" + sortPos[parIdx][selfCol + 2] + "\" class=\"ctr2\">" + p.count + "</td>");
            out.println("          </tr>");
            ++parIdx;
        }
        out.println("        </tbody>");
        out.println("        <tfoot>");
        out.println("           <tr style=\"background-color:#e7e7e7\">");
        String cspn = pgmTable ? (hasDebugPgm ? " colspan=\"2\"" : "") : (hasDebugPgm ? " colspan=\"3\"" : " colspan=\"2\"");
        out.println("             <td" + cspn + "><span class=\"el_total\">Totals:</span></td>");
        out.println("             <td class=\"ctr2\" id=\"totalPerc\"></td>");
        out.println("             <td class=\"ctr2\" id=\"totalSecs\"></td>");
        out.println("             <td />");
        out.println("           </tr>");
        out.println("        </tfoot>");
        out.println("      </table>");
        if (pgmTable) {
            out.println("      <p><a href=\"index.html\">View Paragraph table</a></p>");
        } else {
            out.println("      <p><a href=\"indexpgm.html\">View Program table</a></p>");
        }
        out.println("   </body>");
        out.println("</html>");
        out.close();
    }

    private void createXmlReport() throws ParserConfigurationException, TransformerException, IOException {
        DocumentBuilderFactory documentBuilderFactory = RtsUtil.newDocumentBuilderFactory();
        DocumentBuilder documentBuilder = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element sessionElem = document.createElement("session");
        document.appendChild(sessionElem);
        sessionElem.setAttribute("executed", Long.toString(System.currentTimeMillis()));
        sessionElem.setAttribute("elapsed", Long.toString(this.getElapsed(System.nanoTime())));
        sessionElem.setAttribute("overhead1", Long.toString(this.overhead1));
        sessionElem.setAttribute("overhead2", Long.toString(this.overhead2));
        sessionElem.setAttribute("logEnabled", Boolean.toString(this.logEnabled));
        List<Paragraph> paragraphList = this.getParagraphList();
        long eval = 0L;
        for (Paragraph p : paragraphList) {
            eval += p.accum;
        }
        eval = Math.max(1L, eval);
        sessionElem.setAttribute("evaluated", Long.toString(eval));
        for (Program pgm : this.programMap.values()) {
            if (pgm.count <= 0) continue;
            Element pgmElem = document.createElement("program");
            pgmElem.setAttribute("name", pgm.name);
            pgmElem.setAttribute("count", Integer.toString(pgm.count));
            pgmElem.setAttribute("debug", Boolean.toString(pgm.debug));
            sessionElem.appendChild(pgmElem);
        }
        for (Paragraph p : paragraphList) {
            Element parElem = document.createElement("paragraph");
            parElem.setAttribute("name", p.parDisplayName);
            parElem.setAttribute("programName", p.progName);
            parElem.setAttribute("accum", Long.toString(p.accum));
            parElem.setAttribute("count", Integer.toString(p.count));
            sessionElem.appendChild(parElem);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", new Integer(3));
        }
        catch (Exception p) {
            // empty catch block
        }
        javax.xml.transform.Transformer transformer = transformerFactory.newTransformer();
        Properties outProps = transformer.getOutputProperties();
        outProps.setProperty("indent", "yes");
        transformer.setOutputProperties(outProps);
        DOMSource source = new DOMSource(document);
        FileOutputStream out = new FileOutputStream(this.xmlFile);
        StreamResult result = new StreamResult(new OutputStreamWriter(out));
        transformer.transform(source, result);
        out.close();
    }

    private void createTextReport() throws IOException {
        PrintStream osstream = new PrintStream(this.txtFile);
        long totTime = 0L;
        long accum = 0L;
        List<Paragraph> paragraphList = this.getParagraphList();
        for (Paragraph p : paragraphList) {
            if (p.accum < 0L) {
                p.accum = 0L;
            }
            totTime += p.accum;
        }
        if (totTime == 0L) {
            totTime = 1L;
        }
        Collections.sort(paragraphList);
        String out = "isCOBOL profile rev $Revision: 40229 $ created " + new Date();
        osstream.println(out);
        long elapsed = this.getElapsed(System.nanoTime());
        long percInt = Math.round((double)elapsed / 1.0E9);
        long percDec = elapsed / 10L % 100L;
        if (percDec < 10L) {
            osstream.println("elapsed   time = " + percInt + ".0" + percDec);
        } else {
            osstream.println("elapsed   time = " + percInt + "." + percDec);
        }
        percInt = totTime / 1000000000L;
        percDec = totTime / 10000000L % 100L;
        if (percDec < 10L) {
            osstream.println("evaluated time = " + percInt + ".0" + percDec);
        } else {
            osstream.println("evaluated time = " + percInt + "." + percDec);
        }
        osstream.println("overhead1=" + this.overhead1 + "; overhead2=" + this.overhead2);
        osstream.println("-------+-------+---------+-----------+-----------------");
        osstream.println("self % |accum %| seconds |   count   |program:paragraph");
        osstream.println("-------+-------+---------+-----------+-----------------");
        for (Paragraph p : paragraphList) {
            percInt = p.accum * 100L / totTime;
            out = Profiler.fmt("" + percInt, 3, false);
            out = out + ".";
            percDec = p.accum * 10000L / totTime % 100L;
            out = percDec < 10L ? out + Profiler.fmt("0" + percDec, 2, false) : out + Profiler.fmt("" + percDec, 2, false);
            out = out + "%|";
            percInt = (accum += p.accum) * 100L / totTime;
            out = out + Profiler.fmt("" + percInt, 3, false);
            out = out + ".";
            percDec = accum * 10000L / totTime % 100L;
            out = percDec < 10L ? out + Profiler.fmt("0" + percDec, 2, false) : out + Profiler.fmt("" + percDec, 2, false);
            out = out + "%|";
            percInt = p.accum / 1000000000L;
            percDec = p.accum / 10000000L % 100L;
            out = out + Profiler.fmt("" + percInt, 6, false);
            out = percDec < 10L ? out + Profiler.fmt(".0" + percDec, 2, false) : out + Profiler.fmt("." + percDec, 2, false);
            out = out + "|";
            out = out + Profiler.fmt("" + p.count, 11, false);
            out = out + "|";
            out = out + p.progName + ":" + p.parDisplayName;
            osstream.println(out);
        }
        osstream.close();
    }

    public final Paragraph getParagraph(String className, String parName, String parDisplayName) {
        String key = className + ":" + parDisplayName;
        Paragraph Return2 = this.paragraphMap.get(key);
        if (Return2 == null) {
            Return2 = new Paragraph(className, parName, parDisplayName);
            this.paragraphMap.put(key, Return2);
        }
        return Return2;
    }

    private List<Paragraph> getParagraphList() {
        ArrayList<Paragraph> paragraphList = new ArrayList<Paragraph>();
        for (Paragraph p : this.paragraphMap.values()) {
            if (p.count <= 0) continue;
            paragraphList.add(p);
        }
        return paragraphList;
    }

    public void exitAllParagraphs() {
        while (!this.paragraphStack.isEmpty()) {
            this.exitPar();
        }
    }

    public void shutdownAndPrintReports() {
        this.exitAllParagraphs();
        try {
            this.doReport();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    static {
        calendar = Calendar.getInstance();
        Class<ParagraphComparator> c = ParagraphComparator.class;
        percFormat = NumberFormat.getPercentInstance();
        percFormat.setMinimumFractionDigits(2);
        percFormat.setRoundingMode(RoundingMode.HALF_DOWN);
        dateFormat = DateFormat.getDateTimeInstance(1, 2);
        secFormat = NumberFormat.getNumberInstance();
        secFormat.setMaximumFractionDigits(3);
        secFormat.setMinimumFractionDigits(3);
        secFormat.setRoundingMode(RoundingMode.HALF_DOWN);
    }

    private static class ParagraphComparator
    implements Comparator<Paragraph> {
        int colIdx;
        boolean pgmTable;
        boolean hasDebugPgm;

        ParagraphComparator(int colIdx, boolean pgmTable, boolean hasDebugPgm) {
            this.colIdx = colIdx;
            this.pgmTable = pgmTable;
            this.hasDebugPgm = hasDebugPgm;
        }

        @Override
        public int compare(Paragraph o1, Paragraph o2) {
            if (this.pgmTable) {
                if (this.hasDebugPgm) {
                    switch (this.colIdx) {
                        default: {
                            return o2.progName.compareTo(o1.progName);
                        }
                        case 1: {
                            return o2.debug - o1.debug;
                        }
                        case 2: 
                        case 3: {
                            long dl = o2.accum - o1.accum;
                            return dl > 0L ? 1 : (dl < 0L ? -1 : 0);
                        }
                        case 4: 
                    }
                    return o2.count - o1.count;
                }
                switch (this.colIdx) {
                    default: {
                        return o2.progName.compareTo(o1.progName);
                    }
                    case 1: 
                    case 2: {
                        long dl = o2.accum - o1.accum;
                        return dl > 0L ? 1 : (dl < 0L ? -1 : 0);
                    }
                    case 3: 
                }
                return o2.count - o1.count;
            }
            if (this.hasDebugPgm) {
                switch (this.colIdx) {
                    default: {
                        return o2.progName.compareTo(o1.progName);
                    }
                    case 1: {
                        return o2.debug - o1.debug;
                    }
                    case 2: {
                        return o2.parDisplayName.compareTo(o1.parDisplayName);
                    }
                    case 3: 
                    case 4: {
                        long dl = o2.accum - o1.accum;
                        return dl > 0L ? 1 : (dl < 0L ? -1 : 0);
                    }
                    case 5: 
                }
                return o2.count - o1.count;
            }
            switch (this.colIdx) {
                default: {
                    return o2.progName.compareTo(o1.progName);
                }
                case 1: {
                    return o2.parDisplayName.compareTo(o1.parDisplayName);
                }
                case 2: 
                case 3: {
                    long dl = o2.accum - o1.accum;
                    return dl > 0L ? 1 : (dl < 0L ? -1 : 0);
                }
                case 4: 
            }
            return o2.count - o1.count;
        }
    }
}

