/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.procinfo;

import com.iscobol.procinfo.JThreadInfoExt;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.hatter.tools.commons.misc.ShutdownSignal;
import me.hatter.tools.jtop.management.JTopMXBean;
import me.hatter.tools.jtop.rmi.RmiClient;
import me.hatter.tools.jtop.rmi.interfaces.JMemoryInfo;
import me.hatter.tools.jtop.rmi.interfaces.JThreadInfo;
import me.hatter.tools.jtop.util.EnvUtil;

public class ProcessInfo {
    private String _pid = "";
    private RmiClient rc;
    private JTopMXBean jTopMXBean;

    public ProcessInfo() {
        this._pid = "";
    }

    public static String getJVMPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return processName.split("@")[0];
    }

    public ProcessInfo(String pid) {
        this.attachToPid(pid);
    }

    public void attachToPid(String pid) {
        this._pid = pid;
        this.rc = new RmiClient(pid);
        this.jTopMXBean = this.rc.getJTopMXBean();
    }

    public JMemoryInfo getMemoryInfo() throws IllegalStateException {
        if ("".equals(this._pid)) {
            throw new IllegalStateException("PID not assigned");
        }
        JMemoryInfo jMemoryInfo = null;
        ShutdownSignal shutdownSignal = new ShutdownSignal();
        try {
            jMemoryInfo = this.jTopMXBean.getMemoryInfo();
        }
        finally {
            shutdownSignal.release();
        }
        return jMemoryInfo;
    }

    public JThreadInfoExt[] getThreadInfo() throws InterruptedException {
        JThreadInfoExt[] resThreadInfos = null;
        long lastNano = System.nanoTime();
        long nano = System.nanoTime();
        ShutdownSignal shutdownSignal = new ShutdownSignal();
        shutdownSignal.acquire();
        try {
            JThreadInfo[] jThreadInfos = this.jTopMXBean.listThreadInfos();
            resThreadInfos = JThreadInfoExt.fromJThreadInfos(jThreadInfos);
        }
        finally {
            shutdownSignal.release();
        }
        return resThreadInfos;
    }

    public JThreadInfoExt getThreadInfo(long threadId) throws InterruptedException {
        JThreadInfoExt resThreadInfos = null;
        long lastNano = System.nanoTime();
        long nano = System.nanoTime();
        ShutdownSignal shutdownSignal = new ShutdownSignal();
        shutdownSignal.acquire();
        try {
            JThreadInfo jThreadInfo = this.jTopMXBean.getThreadInfo(threadId);
            if (jThreadInfo == null) {
                return null;
            }
            resThreadInfos = JThreadInfoExt.fromJThreadInfo(jThreadInfo);
        }
        finally {
            shutdownSignal.release();
        }
        return resThreadInfos;
    }

    public JThreadInfoExt getThreadInfoWithLoad(long threadId) throws InterruptedException {
        JThreadInfoExt[] resThreadInfos = null;
        long lastNano = System.nanoTime();
        long nano = System.nanoTime();
        ShutdownSignal shutdownSignal = new ShutdownSignal();
        shutdownSignal.acquire();
        try {
            JThreadInfo jThreadInfo;
            JThreadInfo[] jThreadInfos = new JThreadInfo[]{this.jTopMXBean.getThreadInfo(threadId)};
            if (jThreadInfos[0] == null) {
                return null;
            }
            Map<Long, JThreadInfo> lastJThreadInfoMap = ProcessInfo.jThreadInfoToMap(jThreadInfos);
            Thread.sleep(EnvUtil.getSleepMillis());
            nano = System.nanoTime();
            jThreadInfos[0] = this.jTopMXBean.getThreadInfo(threadId);
            JThreadInfo[] cJThreadInfos = ProcessInfo.caculateJThreadInfos(jThreadInfos, lastJThreadInfoMap);
            cJThreadInfos = ProcessInfo.sortJThreadInfos(cJThreadInfos);
            long cost = nano - lastNano;
            HashMap<Thread.State, AtomicInteger> stateMap = new HashMap<Thread.State, AtomicInteger>();
            JThreadInfo[] jThreadInfoArray = cJThreadInfos;
            int n = cJThreadInfos.length;
            int n2 = 0;
            while (n2 < n) {
                jThreadInfo = jThreadInfoArray[n2];
                Thread.State state = jThreadInfo.getThreadState();
                if (stateMap.containsKey((Object)state)) {
                    ((AtomicInteger)stateMap.get((Object)state)).incrementAndGet();
                } else {
                    stateMap.put(state, new AtomicInteger(1));
                }
                ++n2;
            }
            resThreadInfos = JThreadInfoExt.fromJThreadInfos(cJThreadInfos);
            jThreadInfoArray = resThreadInfos;
            n = resThreadInfos.length;
            n2 = 0;
            while (n2 < n) {
                jThreadInfo = jThreadInfoArray[n2];
                jThreadInfo.calcCPU(cost);
                ++n2;
            }
        }
        finally {
            shutdownSignal.release();
        }
        return resThreadInfos[0];
    }

    public JThreadInfoExt[] getThreadInfoWithLoad() throws InterruptedException {
        JThreadInfoExt[] resThreadInfos = null;
        long lastNano = System.nanoTime();
        long nano = System.nanoTime();
        ShutdownSignal shutdownSignal = new ShutdownSignal();
        shutdownSignal.acquire();
        try {
            JThreadInfo jThreadInfo;
            JThreadInfo[] jThreadInfos = this.jTopMXBean.listThreadInfos();
            Map<Long, JThreadInfo> lastJThreadInfoMap = ProcessInfo.jThreadInfoToMap(jThreadInfos);
            Thread.sleep(EnvUtil.getSleepMillis());
            nano = System.nanoTime();
            jThreadInfos = this.jTopMXBean.listThreadInfos();
            JThreadInfo[] cJThreadInfos = ProcessInfo.caculateJThreadInfos(jThreadInfos, lastJThreadInfoMap);
            cJThreadInfos = ProcessInfo.sortJThreadInfos(cJThreadInfos);
            long cost = nano - lastNano;
            HashMap<Thread.State, AtomicInteger> stateMap = new HashMap<Thread.State, AtomicInteger>();
            JThreadInfo[] jThreadInfoArray = cJThreadInfos;
            int n = cJThreadInfos.length;
            int n2 = 0;
            while (n2 < n) {
                jThreadInfo = jThreadInfoArray[n2];
                Thread.State state = jThreadInfo.getThreadState();
                if (stateMap.containsKey((Object)state)) {
                    ((AtomicInteger)stateMap.get((Object)state)).incrementAndGet();
                } else {
                    stateMap.put(state, new AtomicInteger(1));
                }
                ++n2;
            }
            resThreadInfos = JThreadInfoExt.fromJThreadInfos(cJThreadInfos);
            jThreadInfoArray = resThreadInfos;
            n = resThreadInfos.length;
            n2 = 0;
            while (n2 < n) {
                jThreadInfo = jThreadInfoArray[n2];
                jThreadInfo.calcCPU(cost);
                ++n2;
            }
        }
        finally {
            shutdownSignal.release();
        }
        return resThreadInfos;
    }

    public static boolean killThread(String tid) {
        Thread[] threads;
        ThreadGroup g2;
        boolean found = false;
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while ((g2 = g.getParent()) != null) {
            g = g2;
        }
        for (int size = 256; g.enumerate(threads = new Thread[size]) >= size; size *= 2) {
        }
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Thread thread = threadArray[n2];
            if (thread != null && (name = thread.getName()).contains(tid)) {
                found = true;
                thread.stop();
            }
            ++n2;
        }
        return found;
    }

    public static boolean killThread(long threadId) {
        Thread[] threads;
        ThreadGroup g2;
        boolean found = false;
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while ((g2 = g.getParent()) != null) {
            g = g2;
        }
        for (int size = 256; g.enumerate(threads = new Thread[size]) >= size; size *= 2) {
        }
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            long tid;
            Thread thread = threadArray[n2];
            if (thread != null && (tid = thread.getId()) == threadId) {
                found = true;
                thread.stop();
                break;
            }
            ++n2;
        }
        return found;
    }

    private static Map<Long, JThreadInfo> jThreadInfoToMap(JThreadInfo[] jThreadInfos) {
        HashMap<Long, JThreadInfo> jThreadInfoMap = new HashMap<Long, JThreadInfo>();
        JThreadInfo[] jThreadInfoArray = jThreadInfos;
        int n = jThreadInfos.length;
        int n2 = 0;
        while (n2 < n) {
            JThreadInfo jThreadInfo = jThreadInfoArray[n2];
            jThreadInfoMap.put(jThreadInfo.getThreadId(), jThreadInfo);
            ++n2;
        }
        return jThreadInfoMap;
    }

    private static JThreadInfo[] caculateJThreadInfos(JThreadInfo[] jThreadInfos, Map<Long, JThreadInfo> lastJThreadInfoMap) {
        JThreadInfo[] cjThreadInfos = new JThreadInfo[jThreadInfos.length];
        int i = 0;
        while (i < jThreadInfos.length) {
            JThreadInfo jThreadInfo = jThreadInfos[i];
            JThreadInfo lastJThreadInfo = lastJThreadInfoMap.get(jThreadInfo.getThreadId());
            cjThreadInfos[i] = lastJThreadInfo == null ? jThreadInfo : new JThreadInfo(jThreadInfo, jThreadInfo.getCpuTime() - lastJThreadInfo.getCpuTime(), jThreadInfo.getUserTime() - lastJThreadInfo.getUserTime(), jThreadInfo.getAlloctedBytes() - lastJThreadInfo.getAlloctedBytes());
            ++i;
        }
        return cjThreadInfos;
    }

    static JThreadInfo[] sortJThreadInfos(JThreadInfo[] cJThreadInfos) {
        boolean isSortMem = EnvUtil.getSortMem();
        if (isSortMem) {
            Arrays.sort(cJThreadInfos, new Comparator<JThreadInfo>(){

                @Override
                public int compare(JThreadInfo o1, JThreadInfo o2) {
                    int rMem = Long.valueOf(o2.getAlloctedBytes()).compareTo(o1.getAlloctedBytes());
                    if (rMem != 0) {
                        return rMem;
                    }
                    return o2.getThreadName().compareTo(o1.getThreadName());
                }
            });
        } else {
            Arrays.sort(cJThreadInfos, new Comparator<JThreadInfo>(){

                @Override
                public int compare(JThreadInfo o1, JThreadInfo o2) {
                    int rCpu = Long.valueOf(o2.getCpuTime()).compareTo(o1.getCpuTime());
                    if (rCpu != 0) {
                        return rCpu;
                    }
                    int rUser = Long.valueOf(o2.getUserTime()).compareTo(o1.getUserTime());
                    if (rUser != 0) {
                        return rUser;
                    }
                    return o2.getThreadName().compareTo(o1.getThreadName());
                }
            });
        }
        return cJThreadInfos;
    }
}

