/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.BaseFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class StringFile
extends BaseFile {
    private static final char[] eol = System.getProperty("line.separator", "\n").toCharArray();
    private ICobolVar varString;
    private StringWriter outFile;
    private StringReader inpFile;
    private boolean lineSeq;
    private int minRecSize;
    private int maxRecSize;
    private boolean stripTrailingSpace;

    public StringFile(String nam, ICobolVar memBuf, int minLen, boolean opt, ICobolVar var, boolean ls) {
        this(nam, 0, memBuf, minLen, opt, var, ls);
    }

    public StringFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, ICobolVar var, boolean ls) {
        super(nam, maxLen, memBuf, minLen, opt, 1);
        this.varString = var;
        this.lineSeq = ls;
    }

    private int calcLen() {
        int Return2;
        char[] buff = this.getBufferAsChars();
        for (Return2 = buff.length - 1; Return2 >= this.minRecSize && buff[Return2] == ' '; --Return2) {
        }
        return Return2 + 1;
    }

    @Override
    public void peerOpen(String path, int openType, int lockType) {
        this.stripTrailingSpace = Config.getProperty(".file.strip_trailing_spaces", ".strip_trailing_spaces", false);
        if (this.stripTrailingSpace) {
            this.minRecSize = Config.getProperty(".file.min_rec_size", ".min_rec_size", 1);
            if (this.minRecSize < 0) {
                this.minRecSize = 0;
            }
        }
        if (this.varString == null) {
            CobolIOException.get(130, "", this, 1);
        }
        switch (openType) {
            case 3: {
                CobolIOException.get(142, "", this, 1);
                break;
            }
            case 2: 
            case 6: {
                this.outFile = new StringWriter();
                break;
            }
            case 1: {
                this.inpFile = new StringReader(this.varString.toString());
                break;
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
            }
        }
        this.setOpenMode(openType);
    }

    @Override
    protected void peerClose(int opts) {
        if (this.inpFile != null) {
            this.inpFile.close();
            this.inpFile = null;
        } else if (this.outFile != null) {
            try {
                this.outFile.close();
                this.varString.set(this.outFile.toString());
                this.outFile = null;
            }
            catch (IOException _ex) {
                CobolIOException.get(_ex, this, 2);
            }
        }
        this.setOpenMode(0);
    }

    @Override
    public boolean write(boolean lock, int len) {
        super.write(lock, len);
        try {
            if (this.stripTrailingSpace) {
                this.outFile.write(this.getBufferAsChars(), 0, this.calcLen());
            } else {
                this.outFile.write(this.getBufferAsChars(), 0, len);
            }
            if (this.lineSeq) {
                this.outFile.write(eol);
            }
        }
        catch (IOException _ex) {
            CobolIOException.get(_ex, this, 3);
        }
        return false;
    }

    @Override
    public boolean writeAdvancing(int kind, int lines, boolean lock, int len, int opts) {
        return false;
    }

    @Override
    public int readNext(int lock, ICobolVar into) {
        int Return2 = 0;
        super.readNext(lock, into);
        try {
            byte[] in;
            char[] inc = new char[this.getBufferLength()];
            if (this.lineSeq) {
                int c;
                int i;
                for (i = 0; i < inc.length; ++i) {
                    c = this.inpFile.read();
                    if (c < 0) {
                        if (i != 0) break;
                        AtEndException.get(this, 6);
                        return Return2;
                    }
                    if (c == 10) {
                        if (i <= 0 || inc[i - 1] != '\r') break;
                        --i;
                        break;
                    }
                    inc[i] = (char)c;
                }
                if (i == inc.length) {
                    this.inpFile.mark(2);
                    c = this.inpFile.read();
                    switch (c) {
                        case 13: {
                            if (this.inpFile.read() == 10) break;
                            this.inpFile.reset();
                            break;
                        }
                        case -1: 
                        case 10: {
                            break;
                        }
                        default: {
                            this.inpFile.reset();
                        }
                    }
                }
                in = new String(inc, 0, i).getBytes();
            } else {
                Return2 = this.inpFile.read(inc, 0, this.getBufferLength());
                if (Return2 <= 0) {
                    AtEndException.get(this, 6);
                    return Return2;
                }
                in = new String(inc).getBytes();
            }
            Return2 = in.length;
            this.updateBuffer(in);
            if (into != null) {
                into.setUsingMaxLen(in);
            }
        }
        catch (IOException ex) {
            CobolIOException.get(ex, this, 6);
        }
        return Return2;
    }

    @Override
    public void deleteFile(ICobolVar path) {
        super.deleteFile(path);
        if (this.varString == null) {
            CobolIOException.get(203, "", this, 11);
        } else {
            this.varString.set("");
        }
    }

    @Override
    public void rewrite(boolean lock, int len) {
        if (this.getOpenMode() != 0) {
            CobolIOException.get(101, "01", this, 4);
        } else {
            CobolIOException.get(101, "02", this, 4);
        }
    }

    @Override
    public void delete() {
        if (this.getOpenMode() != 0) {
            CobolIOException.get(101, "01", this, 5);
        } else {
            CobolIOException.get(101, "02", this, 5);
        }
    }

    @Override
    public int readPrev(boolean lock, ICobolVar into) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public int readKey(ICobolVar[] key, boolean lock, ICobolVar into) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }

    @Override
    public void start(ICobolVar[] key, int type, int keyLen) {
        throw new IscobolRuntimeException(4, this.getLogicName());
    }
}

