/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolPanel;
import com.iscobol.gui.client.swing.PicobolWebBrowser;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteMenu;
import com.iscobol.gui.client.swing.SearchKeyEvent;
import com.iscobol.gui.client.swing.SearchKeyEventListener;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.OSValidator;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class RemoteWebBrowser
extends RemoteBaseGUIControl
implements Constants {
    public static final String JDIC_WEBBROWSER_CLASSNAME = "com.iscobol.gui.client.swing.JDICWebBrowser";
    private static final String DJ_WEBBROWSER_OLDCLASSNAME = "com.iscobol.dj.DJWebBrowser";
    public static final String DJ_WEBBROWSER_CLASSNAME = "com.iscobol.browser.dj.DJWebBrowser";
    private static final String JAVAFX_WEBBROWSER_OLDCLASSNAME = "com.iscobol.fx.JFXWebBrowser";
    public static final String JAVAFX_WEBBROWSER_CLASSNAME = "com.iscobol.browser.fx.JFXWebBrowser";
    public static final String DEFAULT_SEARCH_URL = "www.google.com";
    public static final String DEFAULT_HOME_URL = "www.veryant.com";
    private float rows;
    private float cols;
    private String value;
    private String fileName;
    private PicobolWebBrowser webBrowser;
    private boolean useReturn;
    private boolean useTab;
    private boolean useAlt;
    private boolean noMsgBeforeNavigate;
    private String searchUrl;
    private String homeUrl;
    private String webBrowserClassName;
    private Map<String, String> webBrowserAttrs;
    private PropertyChangeListener pcListener;
    private CobolEventListener ceListener;
    private SearchKeyEventListener shListener;

    public RemoteWebBrowser(final GuiFactoryImpl gf) {
        super(gf);
        this.noMsgBeforeNavigate = gf.getCsProperty().get("iscobol.gui.webbrowser.no_msg_before_navigate", false);
        this.searchUrl = gf.getCsProperty().get("iscobol.gui.web_browser.search", DEFAULT_SEARCH_URL);
        this.homeUrl = gf.getCsProperty().get("iscobol.gui.web_browser.home", DEFAULT_HOME_URL);
        this.webBrowserClassName = gf.getCsProperty().get("iscobol.gui.webbrowser.class", DJ_WEBBROWSER_CLASSNAME);
        if (DJ_WEBBROWSER_OLDCLASSNAME.equals(this.webBrowserClassName)) {
            this.webBrowserClassName = DJ_WEBBROWSER_CLASSNAME;
        } else if (JAVAFX_WEBBROWSER_OLDCLASSNAME.equals(this.webBrowserClassName)) {
            this.webBrowserClassName = JAVAFX_WEBBROWSER_CLASSNAME;
        }
        int idx = this.webBrowserClassName.indexOf(63);
        if (idx >= 0) {
            String attrs = this.webBrowserClassName.substring(idx + 1);
            this.webBrowserAttrs = new HashMap<String, String>();
            this.webBrowserClassName = this.webBrowserClassName.substring(0, idx);
            StringTokenizer stn = new StringTokenizer(attrs, "&");
            while (stn.hasMoreTokens()) {
                String tk = stn.nextToken();
                idx = tk.indexOf(61);
                if (idx >= 0) {
                    this.webBrowserAttrs.put(tk.substring(0, idx), tk.substring(idx + 1));
                    continue;
                }
                this.webBrowserAttrs.put(tk, "");
            }
        }
        this.pcListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String key = evt.getPropertyName();
                if (key.equals("iscobol.gui.webbrowser.no_msg_before_navigate")) {
                    RemoteWebBrowser.this.noMsgBeforeNavigate = gf.getCsProperty().get("iscobol.gui.webbrowser.no_msg_before_navigate", false);
                } else if (key.equals("iscobol.gui.web_browser.search")) {
                    RemoteWebBrowser.this.searchUrl = gf.getCsProperty().get("iscobol.gui.web_browser.search", RemoteWebBrowser.DEFAULT_SEARCH_URL);
                } else if (key.equals("iscobol.gui.web_browser.home")) {
                    RemoteWebBrowser.this.homeUrl = gf.getCsProperty().get("iscobol.gui.web_browser.home", RemoteWebBrowser.DEFAULT_HOME_URL);
                }
            }
        };
        gf.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    @Override
    public float getDefaultWidth() {
        return 1.0f;
    }

    @Override
    public float getDefaultHeight() {
        return 1.0f;
    }

    @Override
    public void setCols(float c) {
        this.setRowsCols(this.rows, c);
    }

    @Override
    public void setRows(float r) {
        this.setRowsCols(r, this.cols);
    }

    @Override
    public void setRowsCols(float r, float c) {
        this.rows = r;
        this.cols = c;
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        this.init();
    }

    private static URL getUrl(String val) {
        URL Return2;
        block9: {
            Return2 = null;
            if (val != null) {
                boolean isWin = OSValidator.isWindows();
                String lcVal = val.toLowerCase();
                if (isWin && lcVal.startsWith("file:")) {
                    val = lcVal;
                }
                try {
                    Return2 = new URL(val);
                }
                catch (MalformedURLException _ex) {
                    if (val.indexOf("://") != -1) break block9;
                    File furl = new File(val);
                    if (furl != null && furl.exists()) {
                        String nValue = OSValidator.isWindows() ? "file:///" + lcVal : "file://" + val;
                        try {
                            Return2 = new URL(nValue);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    try {
                        Return2 = new URL("http://" + val);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
        return Return2;
    }

    void init() {
        String html = null;
        URL url = null;
        if (this.value != null && this.value.toLowerCase().startsWith("<html>")) {
            html = this.value;
        } else {
            url = RemoteWebBrowser.getUrl(this.value);
        }
        Class<?> c = null;
        try {
            c = Class.forName(this.webBrowserClassName);
            if (c != null) {
                if (this.webBrowserAttrs != null) {
                    try {
                        this.webBrowser = (PicobolWebBrowser)c.getConstructor(Map.class).newInstance(this.webBrowserAttrs);
                    }
                    catch (Exception ex) {
                        this.webBrowser = (PicobolWebBrowser)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                } else {
                    this.webBrowser = (PicobolWebBrowser)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new IscobolRuntimeException(e);
        }
        this.webBrowser.setFileName(this.fileName);
        this.webBrowser.setNoMsgBeforeNavigate(this.noMsgBeforeNavigate);
        if (url != null) {
            this.webBrowser.setURL(url);
        } else if (html != null) {
            this.webBrowser.setContent(html);
        } else if (this.value != null && this.value.length() > 0) {
            this.webBrowser.setValue(this.value);
        }
        this.setComponent(new PicobolPanel((PicobolWidget)((Object)this.webBrowser)));
        this.ceListener = new CobolEventListener(){

            @Override
            public void cobolEvent(CobolEvent evt) {
                CobolEventCouple cc = new CobolEventCouple(RemoteWebBrowser.this, new RemoteRecordAccept(evt.getType(), 0, evt.getId(), 0, 0, false, false, evt.getId() == 16429));
                RemoteWebBrowser.this.pushEvent(cc);
            }
        };
        this.webBrowser.addCobolEventListener(this.ceListener);
        this.shListener = new SearchKeyEventListener(){

            @Override
            public boolean isSearchKeyEvent(SearchKeyEvent evt) {
                return RemoteWebBrowser.this.gf.getRemoteVirtualKeyboard().isSearchKey(evt.getCode(), evt.isShiftDown(), evt.isControlDown(), evt.isAltDown(), "web-browser");
            }
        };
        this.webBrowser.addSearchKeyEventListener(this.shListener);
        this.guiComponent.addKeyListener(this);
        super.intInitialize();
    }

    @Override
    public int getGUIControlHeight(float height) {
        int Return2 = 0;
        if (this.font != null) {
            Return2 = (int)((float)this.font.getHeight() * height);
        }
        return Return2;
    }

    @Override
    public int getGUIControlWidth(float width) {
        int Return2 = 0;
        if (this.font != null) {
            Return2 = (int)((float)this.font.getWidth() * width);
        }
        return Return2;
    }

    @Override
    public String getValue() {
        String Return2 = "";
        Return2 = this.webBrowser == null || this.webBrowser.getURL() == null ? this.value : this.webBrowser.getURL().toString();
        if (Return2 == null) {
            Return2 = "";
        }
        return Return2;
    }

    @Override
    public String setValue(String v) {
        this.value = v;
        if (this.webBrowser != null) {
            if (v.toLowerCase().startsWith("<html>")) {
                this.webBrowser.setContent(v);
                return v;
            }
            URL url = RemoteWebBrowser.getUrl(this.value);
            if (url != null) {
                this.webBrowser.setURL(url);
                return v;
            }
            if (v != null && v.length() > 0) {
                this.webBrowser.setValue(v);
                return v;
            }
            return null;
        }
        return null;
    }

    @Override
    public void setTitle(String v) {
    }

    @Override
    public void setStyle(int s, boolean set) {
        if ((s & 0x100) == 256) {
            this.useReturn = set;
        }
        if ((s & 0x200) == 512) {
            this.useTab = set;
        }
        if ((s & 0x400) == 1024) {
            this.useAlt = set;
        }
        if ((s & 0x800) == 2048) {
            this.noMsgBeforeNavigate = set;
            if (this.guiComponent != null) {
                ((PicobolWebBrowser)((Object)this.guiComponent)).setNoMsgBeforeNavigate(set);
            }
        }
    }

    @Override
    public String getTitle() {
        if (this.webBrowser != null && this.webBrowser.getTitle() != null) {
            return this.webBrowser.getTitle();
        }
        return "";
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
    }

    @Override
    public void setSize(int w, int h, boolean setOnComp) {
        super.setSize(w, h, setOnComp);
        if (this.guiComponent != null && setOnComp) {
            ((PicobolPanel)this.guiComponent).doLayout();
        }
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public boolean isInputField() {
        boolean Return2 = false;
        if (this.webBrowserClassName == null || !this.webBrowserClassName.equalsIgnoreCase(JAVAFX_WEBBROWSER_CLASSNAME)) {
            // empty if block
        }
        Return2 = true;
        return Return2;
    }

    @Override
    public void displayProp() {
    }

    @Override
    public String getProp(int key) {
        switch (key) {
            case 282: {
                return this.fileName != null ? this.fileName : "";
            }
            case 24: {
                if (this.webBrowser != null) {
                    return this.webBrowser.isBusy() ? "1" : "0";
                }
                return "0";
            }
            case 155: {
                if (this.webBrowser != null) {
                    String urlStr = this.webBrowser.getURLString();
                    if (urlStr != null) {
                        return urlStr;
                    }
                    URL url = this.webBrowser.getURL();
                    if (url != null) {
                        return url.toString();
                    }
                    return "";
                }
                return "";
            }
            case 228: {
                return this.webBrowser != null ? this.webBrowser.getStatusText() : "";
            }
            case 175: {
                return this.webBrowser != null ? this.webBrowser.getProgress() : "0";
            }
            case 146: {
                return "100";
            }
        }
        return super.getProp(key);
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        int intValue;
        try {
            intValue = Integer.parseInt(value.trim());
        }
        catch (Exception ex) {
            intValue = -1;
        }
        switch (key) {
            case 102: {
                if (this.webBrowser != null && intValue == 1 && this.searchUrl != null) {
                    this.webBrowser.setValue(this.searchUrl);
                    return "1";
                }
                return "0";
            }
            case 101: {
                if (this.webBrowser != null && intValue == 1 && this.homeUrl != null) {
                    this.webBrowser.setValue(this.homeUrl);
                    return "1";
                }
                return "0";
            }
            case 311: {
                if (this.webBrowser != null && intValue == 1) {
                    this.webBrowser.selectAll();
                    return "1";
                }
                return "0";
            }
            case 312: {
                if (this.webBrowser != null && intValue == 1) {
                    this.webBrowser.copySelection();
                    return "1";
                }
                return "0";
            }
            case 99: {
                if (this.webBrowser != null && intValue == 1) {
                    this.webBrowser.back();
                    return "1";
                }
                return "0";
            }
            case 100: {
                if (this.webBrowser != null && intValue == 1) {
                    this.webBrowser.forward();
                    return "1";
                }
                return "0";
            }
            case 181: {
                if (this.webBrowser != null && intValue == 1) {
                    this.webBrowser.refresh();
                    return "1";
                }
                return "0";
            }
            case 229: {
                if (this.webBrowser != null && intValue == 1) {
                    this.webBrowser.stop();
                    return "1";
                }
                return "0";
            }
            case 278: {
                if (this.webBrowser != null && intValue == 1) {
                    this.webBrowser.printContent(true);
                    return "1";
                }
                return "0";
            }
            case 279: {
                if (this.webBrowser != null && intValue == 1) {
                    this.webBrowser.printNoPrompt(true);
                    return "1";
                }
                return "0";
            }
            case 280: {
                if (this.webBrowser != null && intValue == 1) {
                    this.webBrowser.saveAs(true);
                    return "1";
                }
                return "0";
            }
            case 281: {
                if (this.webBrowser != null && intValue == 1) {
                    this.webBrowser.saveAsNoPrompt(true);
                    return "1";
                }
                return "0";
            }
            case 282: {
                String string = this.fileName = value != null ? value.trim() : null;
                if (this.webBrowser != null) {
                    this.webBrowser.setFileName(this.fileName);
                }
                return "1";
            }
        }
        return super.setProp(key, value, length);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                if (!this.useReturn) break;
                return;
            }
            case 9: {
                if (!this.useTab) break;
                return;
            }
            default: {
                if (!e.isAltDown() || !this.useAlt) break;
                return;
            }
        }
        super.keyPressed(e);
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        if (this.webBrowser != null && rra.getEventType() == 16429) {
            if (eventAction == 4 || eventAction == 7) {
                this.webBrowser.abortOpenURL();
            } else {
                this.webBrowser.doOpenURL();
            }
        }
    }

    @Override
    public String getType() {
        return "webbrowser";
    }

    @Override
    public void destroy() {
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        this.pcListener = null;
        if (this.guiComponent != null) {
            this.guiComponent.removeKeyListener(this);
        }
        if (this.webBrowser != null) {
            if (this.ceListener != null) {
                this.webBrowser.removeCobolEventListener(this.ceListener);
            }
            if (this.shListener != null) {
                this.webBrowser.removeSearchKeyEventListener(this.shListener);
            }
            try {
                new IsguiWorker(true, () -> this.webBrowser.destroy()).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.destroy();
    }

    @Override
    public void setPopupMenu(RemoteMenu rm) {
        super.setPopupMenu(rm);
        this.webBrowser.setPopupMenuEnabled(rm != null);
    }
}

