/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.ChipsBoxElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class Etichetta
extends JLabel
implements MouseListener {
    ImageIcon x1;
    ImageIcon x2;
    JPanel p;
    Image transparentImg;
    ChipsBoxElement parent;
    Image mouseentered;
    Image mouseexited;

    Etichetta(ChipsBoxElement parent, JPanel p, Image mouseentered, Image mouseexited) {
        this.p = p;
        this.parent = parent;
        this.mouseentered = mouseentered;
        this.mouseexited = mouseexited;
        this.x1 = mouseentered != null ? new ImageIcon(mouseentered) : new ImageIcon(this.getClass().getResource("x1up.png"), "x");
        this.x2 = mouseexited != null ? new ImageIcon(mouseexited) : new ImageIcon(this.getClass().getResource("x1down.png"), "x");
        int iconw = this.x2.getIconWidth();
        int iconh = this.x2.getIconHeight();
        if (this.x1.getIconWidth() > iconw) {
            iconw = this.x1.getIconWidth();
        }
        if (this.x1.getIconHeight() > iconh) {
            iconh = this.x1.getIconHeight();
        }
        Dimension size = new Dimension(iconw, iconh);
        RGBImageFilter filter = new RGBImageFilter(){
            int transparentColor = Color.white.getRGB() | 0xFF000000;

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.transparentColor) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource filteredImgProd = new FilteredImageSource(this.x2.getImage().getSource(), filter);
        this.transparentImg = Toolkit.getDefaultToolkit().createImage(filteredImgProd);
        this.setIcon(new ImageIcon(this.transparentImg));
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setSize(size);
        this.setLayout(null);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.parent.sendmousePressed(e);
        this.parent.sendClose();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.parent.setMouseentered(true);
        this.setIcon(this.x1);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.parent.setMouseentered(false);
        this.setIcon(new ImageIcon(this.transparentImg));
    }

    public ImageIcon createImageIcon(String path) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }
}

