/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.docking.eleritec.CursorProvider;
import com.iscobol.docking.eleritec.Dockable;
import com.iscobol.docking.eleritec.DockingManager;
import com.iscobol.docking.eleritec.DockingPort;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.swing.DockingPanel;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.UndockedDialog;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;
import javax.swing.border.LineBorder;

public class DockablePanel
extends JPanel
implements Dockable,
WindowConstants {
    private final String NO_TITLE = "#";
    private Window parentWin;
    private TitleBar titleBar;
    private WindowListener winListener;
    private WindowFocusListener winFocusListener;
    private WindowStateListener winStateListener;
    private boolean undecorated;
    private JRootPane rootPane;
    private DockingPanel dockPanel;
    private DockingPort port;
    private int defaultCloseOperation = 1;
    private UndockedDialog undockedDialog;

    public DockablePanel(GuiFactoryImpl gf, DockingPanel df) {
        Container w0;
        this.dockPanel = df;
        this.titleBar = new TitleBar("#");
        this.rootPane = new JRootPane();
        this.add(this.rootPane);
        Container w1 = df;
        while (!(w1 instanceof Window) && (w0 = w1.getParent()) != null) {
            w1 = w0;
        }
        this.parentWin = (Window)w1;
        this.setVisible(false);
    }

    public void init() {
        String title = this.titleBar.getTitle();
        if (title != "#") {
            this.add((Component)this.titleBar, 0);
        }
        this.dock();
        if (title != "#") {
            this.titleBar.getCloseButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (DockablePanel.this.winListener == null) {
                        DockablePanel.this.doDefaultCloseAction();
                    } else {
                        DockablePanel.this.winListener.windowClosing(new WindowEvent(DockablePanel.this.parentWin, 201, DockablePanel.this.parentWin));
                    }
                }
            });
        }
        KeyboardBuffer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DockablePanel.this.undockedDialog != null) {
                    return;
                }
                for (Container c = DockablePanel.this.getParent(); c != null; c = c.getParent()) {
                    if (!(c instanceof JTabbedPane)) continue;
                    return;
                }
                MouseEvent me = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, DockablePanel.this);
                if (DockablePanel.this.contains(me.getX(), me.getY()) && !DockablePanel.this.isFocused()) {
                    DockablePanel.this.setFocused(true);
                }
            }
        });
    }

    public void dock() {
        this.undockedDialog = null;
        DockingManager.registerDockable(this);
        this.port.dock(this, this.titleBar.getTitle(), "CENTER", false);
        this.dockPanel.addDockable(this);
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFocused() {
        DockingPanel dockingPanel = this.dockPanel;
        synchronized (dockingPanel) {
            return this.dockPanel.focused == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFocused(boolean b) {
        DockingPanel dockingPanel = this.dockPanel;
        synchronized (dockingPanel) {
            DockablePanel old = this.dockPanel.focused;
            if (b) {
                if (old != this) {
                    if (old != null) {
                        old.setFocused(false);
                    }
                    this.dockPanel.focused = this;
                    WindowEvent we = new WindowEvent(this.parentWin, 207, this.parentWin);
                    if (this.winFocusListener != null) {
                        this.winFocusListener.windowGainedFocus(we);
                    }
                }
            } else if (old == this) {
                WindowEvent we = new WindowEvent(this.parentWin, 208, this.parentWin);
                if (this.winFocusListener != null) {
                    this.winFocusListener.windowLostFocus(we);
                }
                this.dockPanel.focused = null;
            }
            if (this.undockedDialog == null) {
                this.titleBar.setFocusLayout(b);
            }
        }
    }

    private void _dispose() {
        if (this.undockedDialog != null) {
            this.undockedDialog.dispose();
        }
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof DockingPort)) continue;
            this.setVisible(false);
            ((DockingPort)((Object)c)).undock(this);
            break;
        }
        if (this.winListener != null) {
            this.winListener.windowClosed(new WindowEvent(this.parentWin, 202, this.parentWin));
        }
    }

    public void dispose() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._dispose();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DockablePanel.this._dispose();
                }
            });
        }
    }

    @Override
    public void undock(Point p) {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof DockingPort)) continue;
            this.setVisible(false);
            ((DockingPort)((Object)c)).undock(this);
            break;
        }
        this.undockedDialog = new UndockedDialog(this, p);
    }

    @Override
    public void setVisible(boolean b) {
        if (this.undockedDialog != null) {
            this.undockedDialog.setVisible(b);
        } else {
            super.setVisible(b);
        }
    }

    @Override
    public void doLayout() {
        Dimension min;
        Insets ins = this.getInsets();
        if (this.undecorated || this.titleBar.getTitle() == "#") {
            min = new Dimension(0, 0);
        } else {
            min = this.titleBar.getMinimumSize();
            this.titleBar.setBounds(ins.left, ins.top, this.getWidth() - ins.left - ins.right, min.height);
        }
        this.rootPane.setBounds(ins.left, ins.top + min.height, this.getWidth() - ins.left - ins.right, this.getHeight() - min.height);
    }

    @Override
    public CursorProvider getCursorProvider() {
        return null;
    }

    @Override
    public void dockingCanceled() {
    }

    @Override
    public void dockingCompleted(DockingPort p) {
        this.port = p;
    }

    @Override
    public Component getDockable() {
        return this;
    }

    @Override
    public String getDockableDesc() {
        return this.titleBar.getText().trim();
    }

    @Override
    public Component getInitiator() {
        return this.titleBar;
    }

    @Override
    public boolean isDockedLayoutResizable() {
        return true;
    }

    @Override
    public boolean isDockingEnabled() {
        return true;
    }

    @Override
    public boolean mouseMotionListenersBlockedWhileDragging() {
        return false;
    }

    @Override
    public void setDockedLayoutResizable(boolean b) {
    }

    @Override
    public void setDockingEnabled(boolean b) {
    }

    @Override
    public void setDockableDesc(String desc) {
    }

    public void setUndecorated(boolean b) {
        if (b != this.undecorated) {
            this.undecorated = b;
        }
    }

    @Override
    public void setSelected() {
        this.setFocused(true);
    }

    @Override
    public String toString() {
        return "DockablePanel: " + this.getDockableDesc();
    }

    public void setJMenuBar(JMenuBar jmb) {
    }

    public boolean isResizable() {
        return false;
    }

    public void setResizable(boolean b) {
    }

    public String getTitle() {
        if (this.titleBar == null) {
            return "";
        }
        return this.titleBar.getTitle();
    }

    @Override
    public String getName() {
        return this.getTitle();
    }

    public void setTitle(String t) {
        this.titleBar.setTitle(" " + t);
    }

    public void setDefaultCloseOperation(int op) {
        switch (op) {
            case 0: 
            case 1: 
            case 2: {
                this.defaultCloseOperation = op;
            }
        }
    }

    public void doDefaultCloseAction() {
        switch (this.defaultCloseOperation) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.dispose();
            }
        }
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public Container getContentPane() {
        return this.rootPane.getContentPane();
    }

    public void setPort(String l) {
        if (this.port == null) {
            this.port = this.dockPanel.getPort(l);
            this.init();
        }
    }

    public void pack() {
    }

    public Frame getRootWindow() {
        Window w0;
        Window Return2 = this.parentWin;
        while ((w0 = Return2.getOwner()) != null) {
            Return2 = w0;
        }
        return (Frame)Return2;
    }

    public Component getFocusOwner() {
        return this.parentWin.getFocusOwner();
    }

    public void addWindowListener(WindowListener l) {
        this.winListener = AWTEventMulticaster.add(this.winListener, l);
    }

    public void removeWindowListener(WindowListener l) {
        this.winListener = AWTEventMulticaster.remove(this.winListener, l);
    }

    public WindowListener getWindowListener() {
        return this.winListener;
    }

    public void addWindowFocusListener(WindowFocusListener l) {
        this.winFocusListener = AWTEventMulticaster.add(this.winFocusListener, l);
    }

    public void removeWindowFocusListener(WindowFocusListener l) {
        this.winFocusListener = AWTEventMulticaster.remove(this.winFocusListener, l);
    }

    public WindowFocusListener getWindowFocusListener() {
        return this.winFocusListener;
    }

    public void addWindowStateListener(WindowStateListener l) {
        this.winStateListener = AWTEventMulticaster.add(this.winStateListener, l);
    }

    public void removeWindowStateListener(WindowStateListener l) {
        this.winStateListener = AWTEventMulticaster.remove(this.winStateListener, l);
    }

    public WindowStateListener getWindowStateListener() {
        return this.winStateListener;
    }

    public void toFront() {
        if (this.undockedDialog != null) {
            this.undockedDialog.toFront();
        } else {
            this.setFocused(true);
        }
    }

    public void setActive(boolean b) {
    }

    public String getPortName() {
        if (this.port != null) {
            return this.port.getName();
        }
        return null;
    }

    class TitleBar
    extends JPanel {
        private String title;
        private JLabel titleLabel;
        private JComponent drag;
        private JButton close;
        private boolean focusLayout;
        private final Dimension minSize;

        public TitleBar(String t) {
            this.setLayout(new BorderLayout());
            this.title = t;
            this.titleLabel = new JLabel("", 2);
            this.titleLabel.setOpaque(true);
            this.setFocusLayout(true);
            this.drag = new JComponent(){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    int width = this.getSize().width;
                    int height = this.getSize().height;
                    if (TitleBar.this.focusLayout) {
                        g.drawLine(2, height / 3, width - 4, height / 3);
                        g.drawLine(2, 2 * height / 3, width - 4, 2 * height / 3);
                    }
                }
            };
            ImageIcon close1 = new ImageIcon(this.getToolkit().getImage(this.getClass().getResource("close1.png")));
            ImageIcon close2 = new ImageIcon(this.getToolkit().getImage(this.getClass().getResource("close2.png")));
            this.setFocusable(false);
            this.close = new JButton(close1);
            this.close.setFocusable(false);
            this.close.setFocusPainted(false);
            this.close.setRolloverIcon(close2);
            this.close.setRolloverEnabled(true);
            Dimension d = this.titleLabel.getMinimumSize();
            d.width = d.height;
            if (d.width < close1.getIconHeight()) {
                d.width = d.height = close1.getIconHeight();
            }
            this.close.setPreferredSize(d);
            this.minSize = new Dimension(d.width + 4, d.height + 4);
            this.add((Component)this.titleLabel, "West");
            this.add((Component)this.drag, "Center");
            this.add((Component)this.close, "East");
            LineBorder ln = new LineBorder(Color.black, 1, true);
            this.setBorder(ln);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        DockablePanel.this.undock(null);
                    } else {
                        DockablePanel.this.setFocused(true);
                    }
                }
            });
        }

        private void setFocusLayout(boolean b) {
            if (this.focusLayout != b) {
                this.focusLayout = b;
                this.setEnabled(this.focusLayout);
                this.revalidate();
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.minSize;
        }

        public String getText() {
            return this.title;
        }

        public JButton getCloseButton() {
            return this.close;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String t) {
            this.title = t;
            this.titleLabel.setText(this.title);
        }
    }
}

