/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.IscobolWindow;
import com.iscobol.rts.Config;
import java.awt.Component;
import java.awt.Container;
import java.awt.TextField;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class RemoteVirtualKeyboard
extends VirtualKeyboard {
    private static KeyEvent ENTER_KEY_EVENT;
    public static final int MOUSE_MOVED = 10001;
    public static final int LEFT_DOWN = 10002;
    public static final int LEFT_UP = 10003;
    public static final int LEFT_DOUBLE = 10004;
    public static final int MIDDLE_DOWN = 10005;
    public static final int MIDDLE_UP = 10006;
    public static final int MIDDLE_DOUBLE = 10007;
    public static final int RIGHT_DOWN = 10008;
    public static final int RIGHT_UP = 10009;
    public static final int RIGHT_DOUBLE = 10010;
    private VirtualKey vkEnter = new VirtualKey("enter", 18874381);
    private VirtualKey vkTab = new VirtualKey("tab", 35848201);
    private VirtualKey vkBcksp = new VirtualKey("backspace", 0x30C0000);
    private VirtualKey vkEnd = new VirtualKey("end", 0x4020000);
    private VirtualKey vkHome = new VirtualKey("home", 0x5010000);
    private VirtualKey vkInsert = new VirtualKey("insert", 0x60D0000);
    private VirtualKey vkDelete = new VirtualKey("delete", 0x70B0000);
    private VirtualKey vkHelp = new VirtualKey("help", 152043610);
    private VirtualKey vkLeft = new VirtualKey("left", 0xA090000);
    private VirtualKey vkRight = new VirtualKey("right", 0xB0A0000);
    private VirtualKey vkUp = new VirtualKey("up", 202637364);
    private VirtualKey vkDown = new VirtualKey("down", 219349045);
    private VirtualKey vkPageUp = new VirtualKey("pageup", 236388419);
    private VirtualKey vkPageDown = new VirtualKey("pagedown", 253231172);
    private VirtualKey vkF1 = new VirtualKey("f1", 0x10100001);
    private VirtualKey vkF2 = new VirtualKey("f2", 0x11100002);
    private VirtualKey vkF3 = new VirtualKey("f3", 303038467);
    private VirtualKey vkF4 = new VirtualKey("f4", 319815684);
    private VirtualKey vkF5 = new VirtualKey("f5", 336592901);
    private VirtualKey vkF6 = new VirtualKey("f6", 353370118);
    private VirtualKey vkF7 = new VirtualKey("f7", 370147335);
    private VirtualKey vkF8 = new VirtualKey("f8", 386924552);
    private VirtualKey vkF9 = new VirtualKey("f9", 403701769);
    private VirtualKey vkF10 = new VirtualKey("f10", 420478986);
    private VirtualKey vkF11 = new VirtualKey("f11", 437256203);
    private VirtualKey vkF12 = new VirtualKey("f12", 454033420);
    private VirtualKey vkEscape = new VirtualKey("escape", 605028379);
    private VirtualKey vkPause = new VirtualKey("pause", 621871103);
    private VirtualKey vkDivide = new VirtualKey("divide", 0x26000000);
    private VirtualKey vkMultiply = new VirtualKey("multiply", 0x27000000);
    private VirtualKey vkSubtract = new VirtualKey("subtract", 0x28000000);
    private VirtualKey vkAdd = new VirtualKey("add", 0x29000000);
    private VirtualKey vkDecimal = new VirtualKey("decimal", 0x2A000000);
    private VirtualKey vkNumpad0 = new VirtualKey("numpad0", 0x2B000000);
    private VirtualKey vkNumpad1 = new VirtualKey("numpad1", 0x2C000000);
    private VirtualKey vkNumpad2 = new VirtualKey("numpad2", 0x2D000000);
    private VirtualKey vkNumpad3 = new VirtualKey("numpad3", 0x2E000000);
    private VirtualKey vkNumpad4 = new VirtualKey("numpad4", 0x2F000000);
    private VirtualKey vkNumpad5 = new VirtualKey("numpad5", 0x30000000);
    private VirtualKey vkNumpad6 = new VirtualKey("numpad6", 0x31000000);
    private VirtualKey vkNumpad7 = new VirtualKey("numpad7", 0x32000000);
    private VirtualKey vkNumpad8 = new VirtualKey("numpad8", 0x33000000);
    private VirtualKey vkNumpad9 = new VirtualKey("numpad9", 0x34000000);
    private VirtualKey mMoved = new VirtualKey("mmov", 1058013264);
    private VirtualKey mLeftDown = new VirtualKey("mldw", 907018321);
    private VirtualKey mLeftUp = new VirtualKey("mlup", 923795538);
    private VirtualKey mLeftDouble = new VirtualKey("mldc", 940572755);
    private VirtualKey mMiddleDown = new VirtualKey("mmdw", 957349972);
    private VirtualKey mMiddleUp = new VirtualKey("mmup", 974127189);
    private VirtualKey mMiddleDouble = new VirtualKey("mmdc", 990904406);
    private VirtualKey mRightDown = new VirtualKey("mrdw", 1007681623);
    private VirtualKey mRightUp = new VirtualKey("mrup", 1024458840);
    private VirtualKey mRightDouble = new VirtualKey("mrdc", 1041236057);
    private VirtualKey[] mKeyArray = new VirtualKey[]{this.vkEnter, this.vkTab, this.vkBcksp, this.vkEnd, this.vkHome, this.vkInsert, this.vkDelete, new VirtualKey("clear", 0x80E0000), new VirtualKey("cl2end", 890175488), this.vkHelp, this.vkLeft, this.vkRight, this.vkUp, this.vkDown, this.vkPageUp, this.vkPageDown, this.vkF1, this.vkF2, this.vkF3, this.vkF4, this.vkF5, this.vkF6, this.vkF7, this.vkF8, this.vkF9, this.vkF10, this.vkF11, this.vkF12, new VirtualKey("f13", 470810637), new VirtualKey("f14", 487587854), new VirtualKey("f15", 504365071), new VirtualKey("f16", 0x1F100010), new VirtualKey("f17", 0x20100011), new VirtualKey("f18", 0x21100012), new VirtualKey("f19", 571473939), new VirtualKey("f20", 588251156), this.vkEscape, this.vkPause, this.vkDivide, this.vkMultiply, this.vkSubtract, this.vkAdd, this.vkDecimal, this.vkNumpad0, this.vkNumpad1, this.vkNumpad2, this.vkNumpad3, this.vkNumpad4, this.vkNumpad5, this.vkNumpad6, this.vkNumpad7, this.vkNumpad8, this.vkNumpad9, this.mMoved, this.mLeftDown, this.mLeftUp, this.mLeftDouble, this.mMiddleDown, this.mMiddleUp, this.mMiddleDouble, this.mRightDown, this.mRightUp, this.mRightDouble};
    private Hashtable mKeyHash;
    private Hashtable hotKeys;
    private Hashtable searchKeys;
    private VirtualKey[] letters;
    private VirtualKey[] digits;
    private int autoterminatedvalue;
    private AbstractGuiFactoryImpl gf;
    private boolean havepastemouse = false;
    private boolean havepastekey = false;

    public RemoteVirtualKeyboard(AbstractGuiFactoryImpl g) {
        int i;
        this.gf = g;
        this.vkTab.shift = new VirtualKey(this.vkTab.description, 262144);
        this.mKeyHash = new Hashtable(this.mKeyArray.length);
        for (i = this.mKeyArray.length - 1; i >= 0; --i) {
            this.mKeyHash.put(this.mKeyArray[i].description, this.mKeyArray[i]);
        }
        this.modifyKey("decimal", "data=" + LOCALE_DECIMAL_SEPARATOR);
        this.hotKeys = new Hashtable();
        this.searchKeys = new Hashtable();
        this.letters = new VirtualKey[26];
        for (i = 0; i < 26; ++i) {
            char c = (char)(65 + i);
            this.letters[i] = new VirtualKey(c, true);
            this.letters[i].ctrl = (this.letters[i].shiftCtrl = new VirtualKey("" + c, 0x100000 | i + 1));
        }
        this.digits = new VirtualKey[10];
        for (i = 0; i < 10; ++i) {
            this.digits[i] = new VirtualKey((char)(48 + i), true);
        }
        this.modifyKey("*f", "searchdefault=print-preview,web-browser,grid,list-box,tree-view");
        this.modifyKey("mrdw", "paste_key");
    }

    private VirtualKey findKey(int keyCode) {
        switch (keyCode) {
            case 10: {
                return this.vkEnter;
            }
            case 9: {
                return this.vkTab;
            }
            case 8: {
                return this.vkBcksp;
            }
            case 35: {
                return this.vkEnd;
            }
            case 36: {
                return this.vkHome;
            }
            case 155: {
                return this.vkInsert;
            }
            case 127: {
                return this.vkDelete;
            }
            case 156: {
                return this.vkHelp;
            }
            case 37: 
            case 226: {
                return this.vkLeft;
            }
            case 39: 
            case 227: {
                return this.vkRight;
            }
            case 38: 
            case 224: {
                return this.vkUp;
            }
            case 40: 
            case 225: {
                return this.vkDown;
            }
            case 33: {
                return this.vkPageUp;
            }
            case 34: {
                return this.vkPageDown;
            }
            case 112: {
                return this.vkF1;
            }
            case 113: {
                return this.vkF2;
            }
            case 114: {
                return this.vkF3;
            }
            case 115: {
                return this.vkF4;
            }
            case 116: {
                return this.vkF5;
            }
            case 117: {
                return this.vkF6;
            }
            case 118: {
                return this.vkF7;
            }
            case 119: {
                return this.vkF8;
            }
            case 120: {
                return this.vkF9;
            }
            case 121: {
                return this.vkF10;
            }
            case 122: {
                return this.vkF11;
            }
            case 123: {
                return this.vkF12;
            }
            case 27: {
                return this.vkEscape;
            }
            case 19: {
                return this.vkPause;
            }
            case 111: {
                return this.vkDivide;
            }
            case 106: {
                return this.vkMultiply;
            }
            case 109: {
                return this.vkSubtract;
            }
            case 107: {
                return this.vkAdd;
            }
            case 110: {
                return this.vkDecimal;
            }
            case 96: {
                return this.vkNumpad0;
            }
            case 97: {
                return this.vkNumpad1;
            }
            case 98: {
                return this.vkNumpad2;
            }
            case 99: {
                return this.vkNumpad3;
            }
            case 100: {
                return this.vkNumpad4;
            }
            case 101: {
                return this.vkNumpad5;
            }
            case 102: {
                return this.vkNumpad6;
            }
            case 103: {
                return this.vkNumpad7;
            }
            case 104: {
                return this.vkNumpad8;
            }
            case 105: {
                return this.vkNumpad9;
            }
            case 10001: {
                return this.mMoved;
            }
            case 10002: {
                return this.mLeftDown;
            }
            case 10003: {
                return this.mLeftUp;
            }
            case 10004: {
                return this.mLeftDouble;
            }
            case 10005: {
                return this.mMiddleDown;
            }
            case 10006: {
                return this.mMiddleUp;
            }
            case 10007: {
                return this.mMiddleDouble;
            }
            case 10008: {
                return this.mRightDown;
            }
            case 10009: {
                return this.mRightUp;
            }
            case 10010: {
                return this.mRightDouble;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.letters[keyCode - 65];
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.digits[keyCode - 48];
            }
        }
        return null;
    }

    public boolean modifyKey(String name, String values) {
        StringTokenizer searchLc;
        String savename = name;
        boolean Return2 = false;
        if (name.equals("kbd_auto_return")) {
            int kdbar = 0;
            try {
                kdbar = Integer.parseInt(values);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setAutoTerminatedValue(kdbar);
            return true;
        }
        boolean ctrl = false;
        boolean shift = false;
        boolean alt = false;
        char c = name.charAt(0);
        if (c == '^' || c == '*' || c == '@') {
            if (c == '^') {
                shift = true;
            } else if (c == '*') {
                ctrl = true;
            } else {
                alt = true;
            }
            if (name.length() > 1 && (c = name.charAt(1)) == '^' || c == '*' || c == '@') {
                if (c == '^') {
                    shift = true;
                } else if (c == '*') {
                    ctrl = true;
                } else {
                    alt = true;
                }
                if (name.length() > 2 && (c = name.charAt(2)) == '^' || c == '*' || c == '@') {
                    if (c == '^') {
                        shift = true;
                    } else if (c == '*') {
                        ctrl = true;
                    } else {
                        alt = true;
                    }
                    name = name.substring(3);
                } else {
                    name = name.substring(2);
                }
            } else {
                name = name.substring(1);
            }
        }
        VirtualKey k = name.length() == 1 ? ((c = Character.toUpperCase(name.charAt(0))) >= 'A' && c <= 'Z' ? this.letters[c - 65] : (c >= '0' && c <= '9' ? this.digits[c - 48] : (VirtualKey)this.mKeyHash.get(name))) : (VirtualKey)this.mKeyHash.get(name);
        if (k != null) {
            if (ctrl || shift || alt) {
                if (ctrl && shift && alt) {
                    if (k.altShiftCtrl == null) {
                        k.altShiftCtrl = new VirtualKey(k.description, k.type);
                    }
                    k = k.altShiftCtrl;
                } else if (ctrl && shift) {
                    if (k.shiftCtrl == null) {
                        k.shiftCtrl = new VirtualKey(k.description, k.type);
                    }
                    k = k.shiftCtrl;
                } else if (ctrl && alt) {
                    if (k.altCtrl == null) {
                        k.altCtrl = new VirtualKey(k.description, k.type);
                    }
                    k = k.altCtrl;
                } else if (shift && alt) {
                    if (k.altShift == null) {
                        k.altShift = new VirtualKey(k.description, k.type);
                    }
                    k = k.altShift;
                } else if (ctrl) {
                    if (k.ctrl == null) {
                        k.ctrl = new VirtualKey(k.description, k.type);
                    }
                    k = k.ctrl;
                } else if (alt) {
                    if (k.alt == null) {
                        k.alt = new VirtualKey(k.description, k.type);
                    }
                    k = k.alt;
                } else if (shift) {
                    if (k.shift == null) {
                        k.shift = new VirtualKey(k.description, k.type);
                    }
                    k = k.shift;
                }
            }
            int savetype = k.type;
            VirtualKey virtualKey = k;
            virtualKey.type = virtualKey.type & 0xFF00FFFF;
            StringTokenizer stOc = new StringTokenizer(values);
            values = values.toLowerCase();
            StringTokenizer stLc = new StringTokenizer(values);
            while (stOc.hasMoreTokens()) {
                VirtualKey virtualKey2;
                String subLc;
                String sOc = stOc.nextToken();
                String sLc = stLc.nextToken();
                if (sLc.startsWith("edit=")) {
                    if (sLc.length() > 5) {
                        subLc = sLc.substring(5);
                        if (subLc.equals("first")) {
                            k.type = k.type & 0xFFF0FFFF | 0x10000;
                            continue;
                        }
                        if (subLc.equals("last")) {
                            k.type = k.type & 0xFFF0FFFF | 0x20000;
                            continue;
                        }
                        if (subLc.equals("next")) {
                            k.type = k.type & 0xFFF0FFFF | 0x30000;
                            continue;
                        }
                        if (subLc.equals("previous")) {
                            k.type = k.type & 0xFFF0FFFF | 0x40000;
                            continue;
                        }
                        if (subLc.equals("up")) {
                            k.type = k.type & 0xFFF0FFFF | 0x50000;
                            continue;
                        }
                        if (subLc.equals("down")) {
                            k.type = k.type & 0xFFF0FFFF | 0x60000;
                            continue;
                        }
                        if (subLc.equals("pageup")) {
                            k.type = k.type & 0xFFF0FFFF | 0x70000;
                            continue;
                        }
                        if (subLc.equals("pagedown")) {
                            k.type = k.type & 0xFFF0FFFF | 0x80000;
                            continue;
                        }
                        if (subLc.equals("left")) {
                            k.type = k.type & 0xFFF0FFFF | 0x90000;
                            continue;
                        }
                        if (subLc.equals("right")) {
                            k.type = k.type & 0xFFF0FFFF | 0xA0000;
                            continue;
                        }
                        if (subLc.equals("backspace")) {
                            k.type = k.type & 0xFFF0FFFF | 0xC0000;
                            continue;
                        }
                        if (subLc.equals("insert")) {
                            k.type = k.type & 0xFFF0FFFF | 0xD0000;
                            continue;
                        }
                        if (subLc.equals("delete")) {
                            k.type = k.type & 0xFFF0FFFF | 0xB0000;
                            continue;
                        }
                        if (subLc.equals("clear")) {
                            k.type = k.type & 0xFFF0FFFF | 0xE0000;
                            continue;
                        }
                        if (subLc.equals("cl2end")) {
                            k.type = k.type & 0xFFF0FFFF | 0xF0000;
                            continue;
                        }
                        if (!subLc.equals("erase-all")) continue;
                        k.exttype = k.exttype & 0xFFF0FFFF | 0x10000;
                        k.type = savetype;
                        continue;
                    }
                    k.type = k.type & 0xFFF0FFFF;
                    continue;
                }
                if (sLc.startsWith("termination=")) {
                    if (sLc.length() <= 12) continue;
                    subLc = sLc.substring(12);
                    try {
                        int t = Integer.parseInt(subLc);
                        if (t < 0) continue;
                        virtualKey2 = k;
                        virtualKey2.type = virtualKey2.type | 0x200000;
                        k.type = k.type & 0xFFFF0000 | t;
                    }
                    catch (NumberFormatException t) {}
                    continue;
                }
                if (sLc.startsWith("exception=")) {
                    if (sLc.length() <= 10) continue;
                    subLc = sLc.substring(10);
                    try {
                        int t = Integer.parseInt(subLc);
                        if (t < 0) continue;
                        virtualKey2 = k;
                        virtualKey2.type = virtualKey2.type | 0x100000;
                        k.type = k.type & 0xFFFF0000 | t;
                    }
                    catch (NumberFormatException t) {}
                    continue;
                }
                if (sLc.startsWith("data=")) {
                    if (sOc.length() <= 5) continue;
                    k.value = sOc.charAt(5);
                    continue;
                }
                if (sLc.startsWith("invalid=")) {
                    if (sLc.length() <= 8) continue;
                    subLc = sLc.substring(8);
                    k.invalid = Config.isTrue(subLc);
                    continue;
                }
                if (sLc.startsWith("hotkey=")) {
                    if (sLc.length() > 7) {
                        k.type = k.type & 0xFF00FFFF | 0x400000;
                        this.hotKeys.put(this.getKey(k.type, shift, ctrl, alt), sOc.substring(7));
                        continue;
                    }
                    k.type = k.type & 0xFF0FFFFF;
                    this.hotKeys.remove(this.getKey(k.type, shift, ctrl, alt));
                    continue;
                }
                if (sLc.startsWith("search=") || sLc.startsWith("searchdefault=")) {
                    VirtualKeySearch vks = null;
                    VirtualKeySearch vkstmp = null;
                    Vector vksv = null;
                    Iterator itr = null;
                    Iterator itr2 = null;
                    boolean found = false;
                    String keycomp2 = "";
                    boolean searchdefault = sLc.startsWith("searchdefault=");
                    Set keys = this.searchKeys.keySet();
                    int lenslc = 7;
                    if (searchdefault) {
                        lenslc = 14;
                    } else {
                        for (String keycomp2 : keys) {
                            vksv = (Vector)this.searchKeys.get(keycomp2);
                            if (vksv == null || vksv.size() <= 0 || (vkstmp = (VirtualKeySearch)vksv.firstElement()) == null || !vkstmp.isDefaultValue()) continue;
                            vksv.remove(0);
                        }
                    }
                    keys = this.searchKeys.keySet();
                    String strkey = this.getKey(k.type, shift, ctrl, alt);
                    k.value = c;
                    vks = new VirtualKeySearch(k, strkey, searchdefault, name, shift, alt, ctrl);
                    itr = keys.iterator();
                    keycomp2 = "";
                    while (itr.hasNext()) {
                        keycomp2 = (String)itr.next();
                        vksv = (Vector)this.searchKeys.get(keycomp2);
                        if (vksv == null) continue;
                        itr2 = vksv.iterator();
                        while (!Return2 && itr2.hasNext()) {
                            vkstmp = (VirtualKeySearch)itr2.next();
                            if (!vkstmp.equals(vks)) continue;
                            itr2.remove();
                        }
                    }
                    if (sLc.length() > lenslc) {
                        StringTokenizer searchLc2 = new StringTokenizer(sOc.substring(lenslc), ",");
                        while (searchLc2.hasMoreTokens()) {
                            sOc = searchLc2.nextToken();
                            vksv = (Vector)this.searchKeys.get(sOc);
                            if (vksv == null) {
                                vksv = new Vector();
                                this.searchKeys.put(sOc, vksv);
                            }
                            itr = vksv.iterator();
                            found = false;
                            while (!found && itr.hasNext()) {
                                vkstmp = (VirtualKeySearch)itr.next();
                                found = vkstmp.equals(vks);
                            }
                            if (found) continue;
                            vksv.add(vks);
                        }
                    }
                    vkstmp = null;
                    keys = this.searchKeys.keySet();
                    for (String keycomp2 : keys) {
                        vksv = (Vector)this.searchKeys.get(keycomp2);
                        if (vksv == null) continue;
                        itr2 = vksv.iterator();
                        while (!Return2 && itr2.hasNext()) {
                            vkstmp = (VirtualKeySearch)itr2.next();
                        }
                    }
                    continue;
                }
                if (!sLc.equals("paste_key")) continue;
                if (VirtualKeyboard.isMouseEvent(savetype)) {
                    this.mRightDown.exttype = this.mRightDown.exttype & 0xFFFDFFFF;
                    this.havepastemouse = true;
                } else {
                    this.havepastekey = true;
                }
                k.exttype = k.exttype & 0xFFF0FFFF | 0x20000;
                k.type = savetype;
            }
            Return2 = true;
        } else if (values != null && values.equalsIgnoreCase("paste_key") && (searchLc = new StringTokenizer(savename, ",")) != null && searchLc.countTokens() > 1) {
            while (searchLc.hasMoreTokens()) {
                this.modifyKey(searchLc.nextToken(), values);
            }
        }
        return Return2;
    }

    private String getKey(int type, boolean shift, boolean ctrl, boolean alt) {
        StringBuffer key = new StringBuffer();
        if (shift) {
            key.append('^');
        }
        if (ctrl) {
            key.append('*');
        }
        if (alt) {
            key.append('@');
        }
        key.append(type);
        return key.toString();
    }

    private int mapKey(VirtualKey vk, InputEvent ie, boolean checkLorD) {
        if (vk.invalid) {
            return 0x300000;
        }
        if (!(checkLorD && vk.isLetterOrDigit || vk.value == 0 || !(ie instanceof KeyEvent))) {
            KeyEvent ke = (KeyEvent)ie;
            ke.setKeyChar((char)vk.value);
            ke.setKeyCode(vk.value);
        }
        return vk.type;
    }

    public int mapMouseEvent(MouseEvent me, int code) {
        return this.mapKey(me, code);
    }

    public int mapKey(KeyEvent ke) {
        int Return2 = this.mapKey(ke, ke.getKeyCode());
        switch (Return2 & 0xF00000) {
            case 0x100000: 
            case 0x400000: {
                String key = null;
                switch (Return2 & 0xFF000000) {
                    case 0x10000000: {
                        key = "f1";
                        break;
                    }
                    case 0x11000000: {
                        key = "f2";
                        break;
                    }
                    case 0x12000000: {
                        key = "f3";
                        break;
                    }
                    case 0x13000000: {
                        key = "f4";
                        break;
                    }
                    case 0x14000000: {
                        key = "f5";
                        break;
                    }
                    case 0x15000000: {
                        key = "f6";
                        break;
                    }
                    case 0x16000000: {
                        key = "f7";
                        break;
                    }
                    case 0x17000000: {
                        key = "f8";
                        break;
                    }
                    case 0x18000000: {
                        key = "f9";
                        break;
                    }
                    case 0x19000000: {
                        key = "f10";
                        break;
                    }
                    case 0x1A000000: {
                        key = "f11";
                        break;
                    }
                    case 0x1B000000: {
                        key = "f12";
                        break;
                    }
                    case 0x1C000000: {
                        key = "f13";
                        break;
                    }
                    case 0x1D000000: {
                        key = "f14";
                        break;
                    }
                    case 0x1E000000: {
                        key = "f15";
                        break;
                    }
                    case 0x1F000000: {
                        key = "f16";
                        break;
                    }
                    case 0x20000000: {
                        key = "f17";
                        break;
                    }
                    case 0x21000000: {
                        key = "f18";
                        break;
                    }
                    case 0x22000000: {
                        key = "f19";
                        break;
                    }
                    case 0x23000000: {
                        key = "f20";
                        break;
                    }
                }
                if (key == null) break;
                String prop = "iscobol.key.";
                if (ke.isShiftDown()) {
                    prop = prop + "^";
                }
                if (ke.isControlDown()) {
                    prop = prop + "*";
                }
                if (ke.isAltDown()) {
                    prop = prop + "@";
                }
                prop = prop + key;
                if ("iscobol.key.f10.system".equals(prop = prop + ".system")) {
                    if (this.hasMenuBar(ke.getComponent())) {
                        if (this.gf == null || this.gf.getCsProperty().get(prop, true)) {
                            Return2 = 0;
                            break;
                        }
                        ke.consume();
                        break;
                    }
                    ke.consume();
                    break;
                }
                if (!"iscobol.key.@f4.system".equals(prop)) break;
                if (this.gf == null || this.gf.getCsProperty().get(prop, true)) {
                    Return2 = 0;
                    break;
                }
                ke.consume();
                break;
            }
        }
        return Return2;
    }

    private boolean hasMenuBar(Component c) {
        for (Container cnt = c.getParent(); cnt != null; cnt = cnt.getParent()) {
            if (!(cnt instanceof IscobolWindow)) continue;
            return ((IscobolWindow)((Object)cnt)).hasMenuBar();
        }
        return false;
    }

    public int mapKey(InputEvent ke, int keyCode) {
        VirtualKey vk = this.findKey(keyCode);
        int Return2 = vk != null ? (ke.isShiftDown() ? (ke.isControlDown() ? (ke.isAltDown() ? (vk.altShiftCtrl != null ? this.mapKey(vk.altShiftCtrl, ke, false) : this.mapKey(vk, ke, true)) : (vk.shiftCtrl != null ? this.mapKey(vk.shiftCtrl, ke, false) : this.mapKey(vk, ke, true))) : (ke.isAltDown() ? (vk.altShift != null ? this.mapKey(vk.altShift, ke, false) : this.mapKey(vk, ke, true)) : (vk.shift != null ? this.mapKey(vk.shift, ke, false) : this.mapKey(vk, ke, true)))) : (ke.isControlDown() ? (ke.isAltDown() ? (vk.altCtrl != null ? this.mapKey(vk.altCtrl, ke, false) : this.mapKey(vk, ke, true)) : (vk.ctrl != null ? this.mapKey(vk.ctrl, ke, false) : this.mapKey(vk, ke, true))) : (ke.isAltDown() ? (vk.alt != null ? this.mapKey(vk.alt, ke, false) : this.mapKey(vk, ke, true)) : this.mapKey(vk, ke, true)))) : 0;
        return Return2;
    }

    public int mapExtKey(KeyEvent ke) {
        int Return2 = 0;
        VirtualKey vk = this.findKey(ke.getKeyCode());
        if (vk != null) {
            if (ke.isShiftDown()) {
                if (ke.isControlDown()) {
                    if (ke.isAltDown()) {
                        if (vk.altShiftCtrl != null) {
                            vk = vk.altShiftCtrl;
                        }
                    } else if (vk.shiftCtrl != null) {
                        vk = vk.shiftCtrl;
                    }
                } else if (ke.isAltDown()) {
                    if (vk.altShift != null) {
                        vk = vk.altShift;
                    }
                } else if (vk.shift != null) {
                    vk = vk.shift;
                }
            } else if (ke.isControlDown()) {
                if (ke.isAltDown()) {
                    if (vk.altCtrl != null) {
                        vk = vk.altCtrl;
                    }
                } else if (vk.ctrl != null) {
                    vk = vk.ctrl;
                }
            } else if (ke.isAltDown() && vk.alt != null) {
                vk = vk.alt;
            }
            Return2 = vk.exttype;
        }
        return Return2;
    }

    public int mapMouseExtKey(MouseEvent ke, int code) {
        int Return2 = 0;
        VirtualKey vk = this.findKey(code);
        if (vk != null) {
            Return2 = vk.exttype;
        }
        return Return2;
    }

    public String toString(int type) {
        return this.toString(type, 0);
    }

    public String toString(int type, int exttype) {
        StringBuffer Return2 = new StringBuffer();
        switch (type & 0xF00000) {
            case 0: {
                Return2.append("data");
                break;
            }
            case 0x100000: {
                Return2.append("exception=" + (type & 0xFFFF));
                break;
            }
            case 0x200000: {
                Return2.append("termination=" + (type & 0xFFFF));
                break;
            }
            case 0x300000: {
                Return2.append("invalid");
                break;
            }
            case 0x400000: {
                Return2.append("hotkey");
                break;
            }
            default: {
                Return2.append("" + (type & 0xF00000) + "," + (type & 0xFFFF));
            }
        }
        Return2.append(", edit=");
        switch (type & 0xF0000) {
            case 0: {
                if ((exttype & 0xF0000) == 65536) {
                    Return2.append("erase-all");
                    break;
                }
                if ((exttype & 0xF0000) == 131072) {
                    Return2.append("paste_key");
                    break;
                }
                Return2.append("null");
                break;
            }
            case 65536: {
                Return2.append("first");
                break;
            }
            case 131072: {
                Return2.append("last");
                break;
            }
            case 196608: {
                Return2.append("next");
                break;
            }
            case 262144: {
                Return2.append("prev");
                break;
            }
            case 983040: {
                Return2.append("" + (type & 0xF0000));
            }
        }
        return Return2.toString();
    }

    public String getHotKey(int code, boolean shift, boolean ctrl, boolean alt) {
        return (String)this.hotKeys.get(this.getKey(code, shift, ctrl, alt));
    }

    public boolean isSearchKey(int code, boolean shift, boolean ctrl, boolean alt, String component) {
        boolean Return2 = false;
        if (code != 0) {
            VirtualKey vk = null;
            if (code >= 65 && code <= 90) {
                vk = this.letters[code - 65];
            }
            if (vk != null) {
                VirtualKey virtualKey = vk;
                virtualKey.type = virtualKey.type & 0xFF00FFFF;
                vk.value = code;
            }
            String strkey = this.getKey(vk != null ? vk.type : code, shift, ctrl, alt);
            VirtualKeySearch vks = null;
            vks = new VirtualKeySearch(vk, strkey, false, new Integer(code).toString(), shift, alt, ctrl);
            VirtualKeySearch vkstmp = null;
            Vector vksv = (Vector)this.searchKeys.get(component);
            if (vksv != null) {
                Iterator itr = vksv.iterator();
                while (!Return2 && itr.hasNext()) {
                    vkstmp = (VirtualKeySearch)itr.next();
                    Return2 = vkstmp.equals(vks);
                }
            }
        }
        return Return2;
    }

    public int[] getSearchChars(String component) {
        int[] Return2 = null;
        VirtualKeySearch vks = null;
        Vector vksv = (Vector)this.searchKeys.get(component);
        if (vksv != null && vksv.size() > 0) {
            Return2 = new int[vksv.size()];
            for (int i = 0; i < vksv.size(); ++i) {
                vks = (VirtualKeySearch)vksv.elementAt(i);
                if (vks == null) continue;
                Return2[i] = vks.getValue();
            }
        }
        return Return2;
    }

    public int[] getSearchMasks(String component) {
        int[] Return2 = null;
        VirtualKeySearch vks = null;
        Vector vksv = (Vector)this.searchKeys.get(component);
        if (vksv != null && vksv.size() > 0) {
            Return2 = new int[vksv.size()];
            for (int i = 0; i < vksv.size(); ++i) {
                vks = (VirtualKeySearch)vksv.elementAt(i);
                if (vks == null) continue;
                if (vks.isControlDown()) {
                    int n = i;
                    Return2[n] = Return2[n] + 128;
                }
                if (vks.isAltDown()) {
                    int n = i;
                    Return2[n] = Return2[n] + 512;
                }
                if (!vks.isShiftDown()) continue;
                int n = i;
                Return2[n] = Return2[n] + 64;
            }
        }
        return Return2;
    }

    public int getAutoTerminated() {
        return 0x230000 | this.autoterminatedvalue;
    }

    public void setAutoTerminatedValue(int i) {
        this.autoterminatedvalue = i;
    }

    private static KeyEvent getEKE() {
        if (ENTER_KEY_EVENT == null) {
            ENTER_KEY_EVENT = new KeyEvent(new TextField(), 401, System.currentTimeMillis(), 0, 10, '\uffff');
        }
        return ENTER_KEY_EVENT;
    }

    public boolean isPushButtonActivatedByEnter() {
        if (this.gf.getCsProperty().get("iscobol.gui.push_activated_by_enter", false)) {
            return true;
        }
        int cobFun = this.mapKey(RemoteVirtualKeyboard.getEKE());
        return RemoteVirtualKeyboard.isTermination(cobFun) && RemoteVirtualKeyboard.termination(cobFun) == 13;
    }

    public boolean havePasteKey() {
        return this.havepastekey;
    }

    public boolean havePasteMouse() {
        return this.havepastemouse;
    }

    private void debug(VirtualKey vk, String s) {
        if (vk != null) {
            System.out.println(s + " type [" + vk.type + "] exttype [" + vk.exttype + "] shift [" + vk.shift + "] ctrl [" + vk.ctrl + "] shiftctrl [" + vk.shiftCtrl + "] alt [" + vk.alt + "] altshift [" + vk.altShift + "] atctrl [" + vk.altCtrl + "] altshiftctrl [" + vk.altShiftCtrl + "] value [" + vk.value + "]");
        }
    }

    private class VirtualKeySearch {
        private VirtualKey vk;
        boolean defaultvalue;
        String name;
        String getkey;
        boolean shift;
        boolean alt;
        boolean control;

        VirtualKeySearch(VirtualKey vk, String getkey, boolean defaultvalue, String name, boolean shift, boolean alt, boolean control) {
            this.vk = vk;
            this.defaultvalue = defaultvalue;
            this.name = name;
            this.getkey = getkey;
            this.shift = shift;
            this.alt = alt;
            this.control = control;
        }

        public String getGetkey() {
            return this.getkey;
        }

        public boolean isShiftDown() {
            return this.shift;
        }

        public boolean isAltDown() {
            return this.alt;
        }

        public boolean isControlDown() {
            return this.control;
        }

        public boolean isDefaultValue() {
            return this.defaultvalue;
        }

        public int getValue() {
            if (this.vk != null) {
                return this.vk.getValue();
            }
            return 0;
        }

        public boolean equals(VirtualKeySearch vks) {
            if (vks != null) {
                return this.shift == vks.isShiftDown() && this.alt == vks.isAltDown() && this.control == vks.isControlDown() && (this.vk != null && this.vk.getValue() == vks.getValue() || this.vk == null && this.getkey.equals(vks.getGetkey()));
            }
            return false;
        }

        public String toString() {
            return "==>VKS: [" + this.name + "] [" + this.defaultvalue + "] [" + this.getkey + "] shift [" + this.shift + "] alt [" + this.alt + "] ctrl [" + this.control + "] value [" + this.getValue() + "]";
        }
    }

    public class VirtualKey {
        private String description;
        private int value;
        private int type;
        private int exttype;
        private boolean invalid;
        private final boolean isLetterOrDigit;
        private VirtualKey shift;
        private VirtualKey ctrl;
        private VirtualKey shiftCtrl;
        private VirtualKey alt;
        private VirtualKey altShift;
        private VirtualKey altCtrl;
        private VirtualKey altShiftCtrl;

        private VirtualKey(String d, int t, int extt) {
            this.description = d;
            this.type = t;
            this.exttype = extt;
            this.isLetterOrDigit = false;
        }

        private VirtualKey(String d, int t) {
            this(d, t, 0);
        }

        private VirtualKey(char c, boolean l) {
            this.description = "" + c;
            this.type = 0 | (c << 24 | Integer.MIN_VALUE) & 0xFF000000;
            this.value = c;
            this.isLetterOrDigit = l;
        }

        public void setExtendedType(int extt) {
            this.exttype = extt;
        }

        public int getExtendedType() {
            return this.exttype;
        }

        public int getValue() {
            return this.value;
        }
    }
}

