/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.commands.BreakpointCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SetBreakpointCommand
extends BreakpointCommand {
    private static final long serialVersionUID = 1000007L;
    public static final int ID = 0;
    public static final String STRING_ID = "break";
    public static final String SHORT_DESCRIPTION = " : set a breakpoint at a line or in a method";
    public static final String USAGE = " usage:" + eol + "   break [" + "-d" + "] line-number|paragraph [cobolfile] [when variable-name [=|!=|<|>|<=|>=] const]" + eol + "or break " + "-l" + " (to list breakpoints)" + eol;
    public static final String HELP_PAGE = "break.html";
    private boolean listing;
    private boolean enabled;
    private Expression condition;

    public SetBreakpointCommand() {
    }

    public SetBreakpointCommand(int line, String file, int fileIndex, String prog, boolean en, String path) {
        super(line, file, fileIndex, prog, path);
        this.enabled = en;
    }

    public SetBreakpointCommand(int line, String file, int fileIndex, String prog, boolean en, String path, Expression condition) {
        super(line, file, fileIndex, prog, path);
        this.enabled = en;
        this.condition = condition;
    }

    public SetBreakpointCommand(String par, String file, int fileIndex, String prog, boolean en, String path, Expression condition) {
        super(par, file, fileIndex, prog, path);
        this.enabled = en;
        this.condition = condition;
    }

    public SetBreakpointCommand(String par, String file, int fileIndex, String prog, boolean en, String path) {
        super(par, file, fileIndex, prog, path);
        this.enabled = en;
    }

    public SetBreakpointCommand(boolean listing) {
        super(0, null, -1, null, null);
        this.listing = listing;
    }

    public boolean isListing() {
        return this.listing;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.listing);
        if (!this.listing) {
            super.writeExternal(out);
            out.writeBoolean(this.enabled);
            if (this.condition != null) {
                out.writeByte(1);
                this.condition.writeExternal(out);
            } else {
                out.writeByte(0);
            }
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.listing = in.readBoolean();
        if (!this.listing) {
            super.readExternal(in);
            this.enabled = in.readBoolean();
            switch (in.readByte()) {
                default: {
                    break;
                }
                case 1: {
                    this.condition = new Expression();
                    this.condition.readExternal(in);
                    break;
                }
                case 2: {
                    try {
                        this.condition = new Expression(new DebugTM(RtsUtil.readUTFOptmz(in)), true, false, false);
                        break;
                    }
                    catch (DebuggerException e) {
                        throw new IOException(e);
                    }
                }
            }
        }
    }
}

