/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.BreakpointManager;
import com.iscobol.debugger.CommandListener;
import com.iscobol.debugger.Condition;
import com.iscobol.debugger.ConnectionListener;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugFieldWrapper;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugOutputStream;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugSMAPReader;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.FileLoader;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.IscobolDebugger;
import com.iscobol.debugger.IscobolDebuggerExtension;
import com.iscobol.debugger.Level88;
import com.iscobol.debugger.MethodObject;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.RepositoryEntry;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.ClearMonitorCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.EnvCommand;
import com.iscobol.debugger.commands.GetInfoCommand;
import com.iscobol.debugger.commands.GetVariablesCommand;
import com.iscobol.debugger.commands.JumpCommand;
import com.iscobol.debugger.commands.LengthCommand;
import com.iscobol.debugger.commands.LetCommand;
import com.iscobol.debugger.commands.MethodBreakpointCommand;
import com.iscobol.debugger.commands.OffsetCommand;
import com.iscobol.debugger.commands.ProgramBreakpointCommand;
import com.iscobol.debugger.commands.RunCommand;
import com.iscobol.debugger.commands.SetBreakpointCommand;
import com.iscobol.debugger.commands.SetMonitorCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.commands.StepIntoCommand;
import com.iscobol.debugger.commands.StepToCommand;
import com.iscobol.debugger.commands.StepToNextProgramCommand;
import com.iscobol.debugger.commands.ThreadCommand;
import com.iscobol.debugger.commands.TraceOnCommand;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.gui.server.BaseGUIControl;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.io.CobolFile;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.GotoException;
import com.iscobol.rts.Handle;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IDebuggerHelper;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IObjectVar;
import com.iscobol.rts.IPicAnyLength;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IsNested;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolClass;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.MonitorNotifier;
import com.iscobol.rts.NewRunUnitException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.StopRunException;
import com.iscobol.rts.Version;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicX;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class Debugger {
    public static final String eol = System.getProperty("line.separator", "\n");
    static final Object NULL_OBJECT = new String("<null>");
    private static final InputStream systemIn = System.in;
    private static final PrintStream systemOut = System.out;
    private static final PrintStream systemErr = System.err;
    private static InputStream debugIn = systemIn;
    private static PrintStream debugOut = systemOut;
    private static PrintStream debugErr = systemErr;
    private static DataInputStream debugDataIn;
    private static DataOutputStream debugDataOut;
    private static CommandListener commandListener;
    private static boolean redirectStreams;
    private static int blockingMode;
    private static boolean firstBlock;
    private static ConnectionListener connList;
    private static String[] programArgs;
    private static Debugger activeDebugger;
    private static GlobalStatus globalStatus;
    private static boolean firstProcess;
    private static boolean[] firstWrite;
    private static Hashtable debuggerInstances;
    private static boolean doNotify;
    private static Vector deferredDisplayCommands;
    private static Map<Class, String[]> classLocations;
    private static int lastCmd;
    private static boolean isCompositeCmd;
    private static VarName dbgVar;
    private static String dbgEnvValue;
    private static DebugResponse.DebugInfo debugInfo;
    private static Vector tree;
    private static int returnCode;
    private int status = 0;
    private ByteArrayOutputStream response = new ByteArrayOutputStream();
    private PrintStream out;
    private Stack<ParagraphObject> parStack = new Stack();
    private Stack progStack = new Stack();
    private Stack<MethodObject> methodStack = new Stack();
    private boolean blockDebugger;
    private int currLine = 1;
    private String currFile = "";
    private int currFileIndex = -1;
    private int oldLine = 1;
    private int oldFileIndex;
    private String oldFile = "";
    private Class oldProgramClass;
    private Class currProgramClass;
    private char hyphenRepl = (char)95;
    private boolean cod1;
    private String currProgramClassLocation;
    private Object theProgramObj;
    private Object theMethodObj;
    private Object currProgram;
    private Class currMethodClass;
    private Object currMethod;
    private String currMethodName;
    private int intoDeep;
    private int intoDeepPrg;
    private int lastPerformParnum;
    private int stepNumber = 1;
    private ThreadObject threadObj;
    private final AppData appData;

    private void createOutStream() {
        try {
            this.out = new PrintStream((OutputStream)this.response, false, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            this.out = new PrintStream(this.response);
        }
    }

    private String getResponse() {
        try {
            return this.response.toString("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return this.response.toString();
        }
    }

    private static AppData getAppData() {
        AppData ad = (AppData)IscobolSystem.get(AppData.class);
        if (ad == null) {
            ad = new AppData();
            ad.parStackLog = LoggerFactory.get(4);
            ad.fileLoader = new FileLoader();
            LoggerFactory.addPropertyChangeListener(ad);
            IscobolSystem.set(AppData.class, ad);
        }
        return ad;
    }

    public Debugger(String file) {
        this();
        this.currFile = file;
    }

    public Debugger() {
        this.appData = Debugger.getAppData();
        this.createOutStream();
    }

    public Debugger(Debugger newDbg) {
        this.appData = newDbg.appData;
        this.createOutStream();
        this.currProgramClass = newDbg.currProgramClass;
        this.hyphenRepl = newDbg.hyphenRepl;
        this.cod1 = newDbg.cod1;
        this.currProgramClassLocation = newDbg.currProgramClassLocation;
        this.currMethodClass = newDbg.currMethodClass;
        this.updateMethodObj(newDbg.currMethod);
        this.currMethod = newDbg.currMethod;
        this.currMethodName = newDbg.currMethodName;
        this.updateProgramObj(newDbg.currProgram);
        this.currProgram = newDbg.currProgram;
    }

    IDebuggerHelper getHelper() {
        return DebugUtilities.getHelper(this.getCurrClass());
    }

    public static IDebuggerHelper getHelper(Class cls) {
        return DebugUtilities.getHelper(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String className, String[] argv) {
        Class progClass;
        String fileName = "";
        String msg = "";
        int rc = 0;
        try {
            try {
                progClass = Debugger.classForName(className, null);
            }
            catch (ClassNotFoundException | NoClassDefFoundError ex0) {
                progClass = Debugger.classForName(RtsUtil.normalizeClassName(className), null);
            }
            if (!DebuggerConstants.DEBUGGER_CLASS.isAssignableFrom(progClass)) {
                fileName = progClass.getName();
                msg = "+ Warning: class '" + progClass.getName() + "' has not debugging informations";
                rc = 203;
            }
        }
        catch (Exception e) {
            Object progClass2 = null;
            msg = "Cannot load class '" + className + "'";
            Debugger.writeResponse(new DebugResponse(201, msg));
            return;
        }
        Method mainMethod = null;
        if (!DebuggerConstants.CALL_CLASS.isAssignableFrom(progClass)) {
            Class[] classParameters = new Class[]{new String[0].getClass()};
            try {
                mainMethod = progClass.getMethod("main", classParameters);
            }
            catch (NoSuchMethodException nsme) {
                msg = "Invalid class '" + className + "'";
                Debugger.writeResponse(new DebugResponse(202, msg));
                return;
            }
        }
        activeDebugger = new Debugger(fileName);
        Debugger.activeDebugger.threadObj = ThreadObject.getIscobolThreadObject(Thread.currentThread());
        Debugger.activeDebugger.status = 3;
        Debugger.activeDebugger.stepNumber = 1;
        debuggerInstances.put(Thread.currentThread(), activeDebugger);
        activeDebugger.setCurrProgramClass(progClass);
        Debugger.activeDebugger.response.reset();
        DebugResponse resp = new DebugResponse(rc, msg);
        resp.setInfo(Debugger.getInfo(991, progClass));
        if (resp.getInfo().getErrorString() != null) {
            resp.setReturnCode(1);
        }
        Debugger.writeResponse(resp);
        try {
            activeDebugger.process();
        }
        catch (GotoException nsme) {
            // empty catch block
        }
        if (mainMethod != null) {
            try {
                try {
                    mainMethod.invoke(null, new Object[]{programArgs});
                }
                catch (InvocationTargetException ite) {
                    Throwable t = ite.getCause();
                    if (t != null) {
                        throw t;
                    }
                    throw ite;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            IscobolCall progObj = null;
            try {
                progObj = (IscobolCall)progClass.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Object[] linkage = Factory.setCommandLineArgs(progObj, programArgs);
            IDebuggerHelper helper = DebugUtilities.getHelper(progClass);
            Object[] argvTmp = programArgs;
            try {
                Logger log = LoggerFactory.get(2);
                while (true) {
                    try {
                        activeDebugger.updateProgramObj(progObj);
                        Debugger.activeDebugger.currProgram = progObj;
                        IscobolCall isCall = helper.activeCallsPush(progObj, argvTmp);
                        if (log != null) {
                            log.info("ENTER PROGRAM '" + className + "' {");
                        }
                        ICobolVar returnCode = (ICobolVar)isCall.call(linkage);
                        helper.stopRun(returnCode.toint());
                        Debugger.writeResponse(new DebugResponse(103, ""));
                    }
                    catch (NewRunUnitException sra) {
                        helper.activeCallsPop();
                        progObj = sra.call;
                        argvTmp = sra.argv;
                        linkage = sra.argv;
                        continue;
                    }
                    finally {
                        if (log == null) continue;
                        log.info("EXIT PROGRAM '" + className + "' }");
                        continue;
                    }
                    break;
                }
            }
            catch (StopRunException sre) {
                Debugger.writeResponse(new DebugResponse(103, ""));
            }
            catch (Throwable e) {
                Debugger.unexpectedException(e);
            }
        }
    }

    private static DebugResponse.DebugInfo checkVersion(Class progClass) {
        String msg = DebuggerException.getFormattedInfoMessage(5, progClass.getName());
        if (IscobolClass.class.isAssignableFrom(progClass)) {
            try {
                IscobolClass cls = (IscobolClass)progClass.newInstance();
                try {
                    Version.checkVersion(cls);
                }
                catch (IscobolRuntimeException ex) {
                    msg = ex.getMessage();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DebugResponse.DebugInfo(msg);
    }

    public static void unexpectedException(Throwable e) {
        long timestamp;
        String par;
        if (globalStatus.getValue() == 0) {
            return;
        }
        Debugger currDbg = Debugger.getCurrentDebugger();
        IDebuggerHelper helper = currDbg.getHelper();
        try {
            helper.callErrorProc(e);
        }
        catch (Exception e2) {
            Debugger.unexpectedException(e2);
            return;
        }
        helper.layoutExceptionCobol(e);
        int line = currDbg.currLine;
        int fileIdx = currDbg.currFileIndex;
        if (!currDbg.parStack.empty()) {
            ParagraphObject po = currDbg.parStack.peek();
            par = po.getName();
        } else {
            par = "";
            try {
                DebugParagraph[] paragraphs = DebugUtilities.getParagraphs(currDbg.oldProgramClass);
                for (int i = paragraphs.length - 1; i >= 0; --i) {
                    if (paragraphs[i].getFileIndex() != fileIdx || paragraphs[i].getLineNumber() >= line) continue;
                    par = paragraphs[i].getParagraphName();
                    break;
                }
            }
            catch (Exception paragraphs) {
                // empty catch block
            }
        }
        String msg = "- Exception caught at line: " + line + ", file: " + Debugger.getFilename(currDbg.currFile) + ", paragraph: '" + par + "' (" + e + ")";
        try {
            timestamp = DebugUtilities.getTimestamp(currDbg.currProgramClass);
        }
        catch (Exception e1) {
            timestamp = 0L;
        }
        DebugResponse resp = new DebugResponse(104, currDbg.currLine, null, null, null, -1, 0L, 0L, currDbg.currFile, currDbg.currFileIndex, currDbg.currFile, timestamp, -1, null, (Tree[])null, msg);
        if (currDbg.oldProgramClass != null) {
            DebugResponse.DebugInfo dInfo = Debugger.getInfo(991, currDbg.oldProgramClass);
            resp.setInfo(dInfo);
        }
        Debugger.writeResponse(resp);
    }

    public static void activeRemoteDebugging() {
        if (globalStatus.getWait() && globalStatus.getValue() == 3) {
            Debugger.waitForConnection();
            globalStatus.setWait(false);
        }
    }

    public static void startListener(int rd, int port, boolean redStreams) {
        Debugger.startListener(rd, port, redStreams, true, 0);
    }

    public static void startListener(int rd, int port, boolean redStreams, boolean standaloneMode) {
        Debugger.startListener(rd, port, redStreams, standaloneMode, 0);
    }

    public static void startListener(int rd, int port, boolean redStreams, boolean standaloneMode, int blockMode) {
        if ((rd == 1 || rd == 2) && connList == null) {
            redirectStreams = redStreams;
            blockingMode = blockMode;
            connList = new ConnectionListener(port, standaloneMode);
            IscobolSystem.duplicateEnv(connList.getThread());
            connList.start();
            globalStatus.setValue(3);
            if (rd == 2) {
                globalStatus.setWait(true);
            }
        }
    }

    public static void stopListener(boolean closeCurrentConnection) {
        if (connList != null) {
            redirectStreams = true;
            blockingMode = 0;
            firstBlock = false;
            connList.stop(closeCurrentConnection);
            IscobolSystem.destroyEnv(connList.getThread());
            connList = null;
            activeDebugger = null;
            globalStatus.setValue(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForConnection() {
        doNotify = true;
        ConnectionListener connectionListener = connList;
        synchronized (connectionListener) {
            try {
                connList.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Debugger getCurrentDebugger() {
        Debugger Return2 = null;
        Hashtable hashtable = debuggerInstances;
        synchronized (hashtable) {
            int gs;
            Return2 = (Debugger)debuggerInstances.get(Thread.currentThread());
            if (Return2 == null) {
                Return2 = new Debugger();
                int gs2 = globalStatus.getValue();
                if (gs2 != 0) {
                    ThreadObject to = null;
                    if (activeDebugger == null) {
                        to = ThreadObject.getIscobolThreadObject(Thread.currentThread());
                        activeDebugger = Return2;
                    } else {
                        to = ThreadObject.getJavaThreadObject(Thread.currentThread());
                    }
                    Return2.threadObj = to;
                    if (gs2 != 3) {
                        Debugger.pruneDeathThreads();
                        if (debuggerInstances.size() == 0) {
                            Return2.status = gs2 == 4 && blockingMode == 1 ? 4 : 1;
                            activeDebugger = Return2;
                        } else {
                            Return2.status = 4;
                        }
                        Return2.stepNumber = 1;
                    }
                }
                debuggerInstances.put(Thread.currentThread(), Return2);
            } else if (Return2.threadObj == null && (gs = globalStatus.getValue()) != 0) {
                ThreadObject to = null;
                if (activeDebugger == null) {
                    to = ThreadObject.getIscobolThreadObject(Thread.currentThread());
                    activeDebugger = Return2;
                } else {
                    to = ThreadObject.getJavaThreadObject(Thread.currentThread());
                }
                Return2.threadObj = to;
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeResponse(DebugResponse dr) {
        DataOutputStream dataOutputStream = debugDataOut;
        synchronized (dataOutputStream) {
            DebugUtilities.writeResponse(dr, debugDataOut, firstWrite);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean process() throws GotoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean processCommand(DebugCommand cmd, boolean[] executeNext) throws GotoException {
        boolean returning = false;
        try {
            lastCmd = cmd.getId();
            switch (lastCmd) {
                case -1: {
                    break;
                }
                case 57: {
                    Debugger.setRedirectStreams(((SetRedirectStreamsCommand)cmd).getValue());
                    returnCode = 0;
                    break;
                }
                case 43: {
                    this.out.print(this.getVariables((GetVariablesCommand)cmd));
                    break;
                }
                case 2: {
                    String err = this.run((RunCommand)cmd);
                    returning = true;
                    break;
                }
                case 0: {
                    this.out.print(Debugger.setBreakpoint((SetBreakpointCommand)cmd, this.currFile, this.currFileIndex, this));
                    break;
                }
                case 9: {
                    this.out.print(Debugger.clearBreakpoint((ClearBreakpointCommand)cmd, this.currFile, this.currFileIndex));
                    break;
                }
                case 1: {
                    String err = this.Continue();
                    if (!err.equals("")) {
                        this.out.print(err);
                        break;
                    }
                    returning = true;
                    break;
                }
                case 3: {
                    String err = this.stepInto((StepIntoCommand)cmd);
                    if (!err.equals("")) {
                        this.out.print(err);
                        break;
                    }
                    returning = true;
                    break;
                }
                case 4: {
                    String err = this.stepOver();
                    if (!err.equals("")) {
                        this.out.print(err);
                        break;
                    }
                    returning = true;
                    break;
                }
                case 16: {
                    ThreadCommand tCmd = (ThreadCommand)cmd;
                    String ret = this.switchThread(tCmd);
                    if (returnCode != 0 || tCmd.isListing()) {
                        this.out.print(ret);
                        break;
                    }
                    returning = true;
                    break;
                }
                case 24: {
                    this.out.print(this.gc());
                    break;
                }
                case 25: {
                    this.out.print(this.memory());
                    break;
                }
                case 26: {
                    this.out.print(this.env((EnvCommand)cmd));
                    break;
                }
                case 17: {
                    this.out.print(this.traceOn((TraceOnCommand)cmd));
                    break;
                }
                case 18: {
                    this.out.print(this.traceOff());
                    break;
                }
                case 19: {
                    this.out.print(Debugger.setProgramBreakpoint((ProgramBreakpointCommand)cmd, this));
                    break;
                }
                case 52: {
                    this.out.print(Debugger.setMethodBreakpoint((MethodBreakpointCommand)cmd, this));
                    break;
                }
                case 5: {
                    this.out.print(this.display((DisplayCommand)cmd));
                    break;
                }
                case 6: {
                    this.out.print(this.let((LetCommand)cmd));
                    break;
                }
                case 10: {
                    String err = this.stepOutOfParagraph();
                    if (!err.equals("")) {
                        this.out.print(err);
                        break;
                    }
                    returning = true;
                    break;
                }
                case 11: {
                    String err = this.stepOutOfProgram();
                    if (!err.equals("")) {
                        this.out.print(err);
                        break;
                    }
                    returning = true;
                    break;
                }
                case 12: {
                    String err = this.stepToLine((StepToCommand)cmd);
                    if (!err.equals("")) {
                        this.out.print(err);
                        break;
                    }
                    returning = true;
                    break;
                }
                case 56: {
                    String err = this.stepToProgram((StepToNextProgramCommand)cmd);
                    if (!err.equals("")) {
                        this.out.print(err);
                        break;
                    }
                    returning = true;
                    break;
                }
                case 29: {
                    this.jumpToLine((JumpCommand)cmd);
                    returning = true;
                    executeNext[0] = false;
                    break;
                }
                case 13: {
                    this.out.print(this.setMonitor((SetMonitorCommand)cmd));
                    break;
                }
                case 14: {
                    this.out.print(this.clearMonitor((ClearMonitorCommand)cmd));
                    break;
                }
                case 54: {
                    this.out.print(this.length((LengthCommand)cmd));
                    break;
                }
                case 55: {
                    this.out.print(this.offset((OffsetCommand)cmd));
                    break;
                }
                case 23: {
                    returnCode = 0;
                    break;
                }
                case 30: {
                    this.getInfo((GetInfoCommand)cmd);
                    break;
                }
                default: {
                    throw new DebuggerException(26);
                }
            }
        }
        catch (DebuggerException e) {
            returnCode = e.getErrorId();
            String msg = e.getMessage();
            if (isCompositeCmd) {
                switch (lastCmd) {
                    case 13: {
                        msg = "- set monitor failed: " + msg.substring(2);
                        break;
                    }
                    case 0: {
                        msg = "- set breakpoint failed: " + msg.substring(2);
                        break;
                    }
                    case 52: {
                        msg = "- set method breakpoint failed: " + msg.substring(2);
                        break;
                    }
                    case 19: {
                        msg = "- set program breakpoint failed: " + msg.substring(2);
                        break;
                    }
                    case 5: {
                        msg = "- display -tree failed: " + msg.substring(2);
                    }
                }
            }
            this.out.println(msg);
        }
        return returning;
    }

    static InputStream getDebugIn() {
        return debugIn;
    }

    private static DebugCommand acceptCommand() {
        return commandListener.getDebugCommand();
    }

    private boolean[] disableAllWindows(Vector winList) {
        DisplayWindow dw;
        int i;
        winList.addAll(ScrFactory.getGUIEnviroment().getWindowList());
        int size = winList.size();
        boolean[] origEnabledState = new boolean[size];
        for (i = 0; i < size; ++i) {
            dw = (DisplayWindow)winList.elementAt(i);
            try {
                if (dw.getComponent() == null) continue;
                origEnabledState[i] = dw.getComponent().isEnabled();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (i = 0; i < size; ++i) {
            dw = (DisplayWindow)winList.elementAt(i);
            try {
                if (dw.getComponent() == null) continue;
                dw.getComponent().setProperty(-1, "_debug_window_enabled", Boolean.FALSE);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return origEnabledState;
    }

    private void restoreAllWindows(boolean[] origstate, Vector winList) {
        int size = winList.size();
        for (int i = 0; i < size; ++i) {
            DisplayWindow dw = (DisplayWindow)winList.elementAt(i);
            try {
                if (dw.getComponent() == null) continue;
                dw.getComponent().setProperty(-1, "_debug_window_enabled", origstate[i]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean debug(String currParagraph, String currSection) throws GotoException {
        int v;
        boolean Return2 = true;
        if (this != activeDebugger) {
            while (globalStatus.getValue() == 1) {
                GlobalStatus globalStatus = Debugger.globalStatus;
                synchronized (globalStatus) {
                    try {
                        Debugger.globalStatus.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((v = globalStatus.mustSuspend()) == 2) {
            this.getHelper().stopRun(0);
        } else if (v == 1) {
            this.status = 1;
            this.stepNumber = 1;
        }
        switch (this.status) {
            default: {
                break;
            }
            case 8: {
                if (this.checkJumppoint(currParagraph, currSection)) {
                    Return2 = this.process();
                    break;
                }
                Return2 = false;
                break;
            }
            case 1: {
                if (currParagraph != null) break;
                --this.stepNumber;
                if (this.stepNumber == 0) {
                    this.checkBreakMonitors();
                    Return2 = this.process();
                    break;
                }
                if (!this.checkBreakMonitors() && !this.checkBreakpoint(currParagraph, currSection)) break;
                Return2 = this.process();
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                if (this.blockDebugger) {
                    Return2 = this.process();
                    break;
                }
                Return2 = false;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                if (!this.checkBreakMonitors() && !this.blockDebugger && !this.checkBreakpoint(currParagraph, currSection)) break;
                Return2 = this.process();
                break;
            }
            case 4: {
                if (!this.checkBreakMonitors() && !this.checkBreakpoint(currParagraph, currSection)) break;
                Return2 = this.process();
                break;
            }
            case 7: {
                if (!this.checkBreakMonitors() && !this.checkTempBreakpoint() && !this.checkBreakpoint(currParagraph, currSection)) break;
                Return2 = this.process();
            }
        }
        return Return2;
    }

    protected Class getCurrClass() {
        Class<Object> Return2 = this.currProgramClass != null ? this.currProgramClass : (!this.progStack.isEmpty() ? this.progStack.peek().getClass() : null);
        return Return2;
    }

    private String getCurrClassname() {
        String Return2 = this.currMethodName != null ? this.currProgramClass.getName() + ":>" + this.currMethodName : (this.currMethodClass != null ? this.currMethodClass.getName() : this.currProgramClass.getName());
        return Return2;
    }

    protected Object getProgramObject() {
        return this.theProgramObj;
    }

    protected Object getMethodObject() {
        return this.theMethodObj;
    }

    protected Object getCurrProgram() {
        return this.currProgram;
    }

    protected Object getCurrMethod() {
        return this.currMethod;
    }

    protected Class getCurrProgramClass() {
        return this.currProgramClass;
    }

    protected Class getCurrMethodClass() {
        return this.currMethodClass;
    }

    private boolean checkBreakMonitors() {
        Watch[] ws = BreakpointManager.checkBreakMonitors(this.getCurrClassname(), this);
        if (ws != null && ws.length > 0) {
            dbgVar = new VarName();
            dbgVar.setFullName(ws[0].getFullName());
            dbgVar.setValue(ws[0].getValue());
            returnCode = 102;
            String other = "";
            for (int i = 0; i < ws.length; ++i) {
                other = other + eol + ws[i];
            }
            this.out.println(DebuggerException.getInfoMessage(1, other));
            return true;
        }
        return false;
    }

    private boolean checkBreakpoint(String currParagraph, String currSection) {
        String progName = this.currProgramClass.getName();
        if (currParagraph != null && BreakpointManager.checkBreakpoint(currParagraph, currSection, this.currFile, progName, this) || BreakpointManager.checkBreakpoint(this.currLine, this.currFile, this.currFileIndex, progName, this)) {
            returnCode = 101;
            if (currParagraph != null) {
                this.out.println(DebuggerException.getInfoMessage(2, currParagraph + ", file " + Debugger.getFilename(this.currFile)));
            } else {
                this.out.println(DebuggerException.getInfoMessage(3, this.currLine + ", file " + Debugger.getFilename(this.currFile)));
            }
            return true;
        }
        return false;
    }

    private boolean checkJumppoint(String currParagraph, String currSection) {
        return currParagraph != null && BreakpointManager.checkJumppoint(currParagraph, currSection, this.currFile) || BreakpointManager.checkJumppoint(this.currLine, this.currFile, this.currFileIndex);
    }

    private boolean checkTempBreakpoint() {
        if (BreakpointManager.checkTempBreakpoint(this.currLine, this.currFile, this.currFileIndex)) {
            returnCode = 101;
            this.out.println(DebuggerException.getInfoMessage(3, this.currLine + ", file " + Debugger.getFilename(this.currFile)));
            return true;
        }
        return false;
    }

    private String gc() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        Runtime.getRuntime().gc();
        returnCode = 0;
        return DebuggerException.getInfoMessage(4, eol);
    }

    private String memory() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        Runtime.getRuntime().gc();
        returnCode = 0;
        Runtime r = Runtime.getRuntime();
        long tot = r.totalMemory();
        long free = r.freeMemory();
        StringBuffer buff = new StringBuffer();
        buff.append("+ ");
        buff.append("Total memory: " + tot + " bytes" + eol);
        buff.append("   Used memory: " + (tot - free) + " bytes" + eol);
        buff.append("   Free memory: " + Runtime.getRuntime().freeMemory() + " bytes" + eol);
        return buff.toString();
    }

    private String env(EnvCommand cmd) throws DebuggerException {
        return this.env(cmd.getEnvName(), false, cmd.displayFull());
    }

    private String env(String key, boolean hex, boolean full) throws DebuggerException {
        String k = key.trim().toLowerCase().replace('-', '_');
        String propName = Config.getPrefix() + k;
        String propVal = Config.getProperty(propName, Config.getPropertyAlias(propName), null);
        if (propVal == null) {
            propVal = System.getProperty(k);
        }
        if (propVal != null) {
            if (hex) {
                byte[] b;
                try {
                    b = propVal.getBytes(CobolVar.encoding);
                }
                catch (UnsupportedEncodingException e) {
                    b = propVal.getBytes();
                }
                propVal = DebugUtilities.toHexString(b, -1, full ? Integer.MAX_VALUE : DebugUtilities.MAX_DISPLAY_LENGTH());
            }
            returnCode = 0;
            dbgEnvValue = propVal;
            return "+ " + key + " = " + propVal + eol;
        }
        throw new DebuggerException(27, "'" + key + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String switchThread(ThreadCommand cmd) throws DebuggerException {
        int i;
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        String newThread = cmd.getThreadName();
        if (cmd.isListing()) {
            returnCode = 0;
            return this.listThreads();
        }
        if (newThread.equalsIgnoreCase(Debugger.activeDebugger.threadObj.getName())) {
            throw new DebuggerException();
        }
        ThreadObject[] threads = Debugger.getThreads(false, null);
        for (i = 0; i < threads.length && !threads[i].getName().equalsIgnoreCase(newThread); ++i) {
        }
        if (i == threads.length) {
            throw new DebuggerException(19, "'" + newThread + "'");
        }
        this.status = 4;
        Hashtable hashtable = debuggerInstances;
        synchronized (hashtable) {
            activeDebugger = (Debugger)debuggerInstances.get(threads[i].getThread());
        }
        Debugger.activeDebugger.status = 1;
        Debugger.activeDebugger.stepNumber = 1;
        this.stepNumber = 1;
        returnCode = 0;
        return "";
    }

    private void jumpToLine(JumpCommand cmd) throws DebuggerException, GotoException {
        DebugParagraph[] paragraphs;
        String[] filenames;
        DebugLine[] lines;
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        if (!IscobolDebuggerExtension.class.isAssignableFrom(this.currProgramClass)) {
            throw new DebuggerException(36);
        }
        if (cmd.getType() != 0) {
            this.blockDebugger = false;
            if (cmd.isJumpOutParagraph()) {
                this.status = 9;
                this.intoDeep = this.parStack.size();
            } else if (cmd.isJumpOutProgram()) {
                this.status = 10;
                this.intoDeepPrg = this.getModuleStackSize();
            } else if (cmd.isJumpNext()) {
                this.intoDeep = this.parStack.size();
                this.intoDeepPrg = this.getModuleStackSize();
                this.status = 12;
            }
            this.stepNumber = 1;
            returnCode = 0;
            return;
        }
        try {
            lines = DebugUtilities.getLines(this.currProgramClass);
        }
        catch (Exception e) {
            lines = null;
        }
        if (lines == null) {
            throw new DebuggerException(36);
        }
        try {
            filenames = DebugUtilities.getFilenames(this.currProgramClass);
        }
        catch (Exception e) {
            filenames = null;
        }
        if (filenames == null) {
            throw new DebuggerException(36);
        }
        try {
            paragraphs = DebugUtilities.getParagraphs(this.currProgramClass);
        }
        catch (Exception e) {
            paragraphs = null;
        }
        if (paragraphs == null) {
            throw new DebuggerException(36);
        }
        boolean declaratives = this.parStack.peek().isDeclaratives();
        int lineNo = cmd.getLineNumber();
        int jumpParagraphId = 0;
        if (lineNo > 0) {
            int i;
            String filename;
            int fileIndex = -1;
            if (cmd.getFilename() != null) {
                filename = cmd.getFilename();
                if (cmd.getFileIndex() >= 0) {
                    fileIndex = cmd.getFileIndex();
                } else {
                    for (i = 0; i < filenames.length; ++i) {
                        if (!filenames[i].equalsIgnoreCase(filename)) continue;
                        fileIndex = i;
                        break;
                    }
                    if (fileIndex < 0) {
                        fileIndex = this.currFileIndex;
                    }
                }
            } else {
                filename = Debugger.getFilename(this.currFile);
                fileIndex = this.currFileIndex;
            }
            block7: for (i = 0; i < lines.length; ++i) {
                int l = lines[i].getLineNumber();
                int idx = lines[i].getFileIndex();
                if (lineNo != l || fileIndex != idx) continue;
                if (lines[i].getParagraphId() > 0) {
                    for (int j = 0; j < paragraphs.length; ++j) {
                        if (paragraphs[j].getParagraphNumber() != lines[i].getParagraphId() || paragraphs[j].isInDeclaratives() != lines[i].isInDeclaratives()) continue;
                        if (paragraphs[j].isInDeclaratives() == declaratives) {
                            jumpParagraphId = paragraphs[j].getParagraphNumber();
                            BreakpointManager.addJumppoint(lineNo, filename, fileIndex);
                            break;
                        }
                        if (declaratives) {
                            throw new DebuggerException(38);
                        }
                        throw new DebuggerException(37);
                    }
                    if (jumpParagraphId != 0) break;
                    throw new DebuggerException(2);
                }
                for (int ii = i - 1; ii >= 0; --ii) {
                    if (lines[ii].getParagraphId() <= 0) continue;
                    for (int j = 0; j < paragraphs.length; ++j) {
                        if (paragraphs[j].getParagraphNumber() != lines[ii].getParagraphId() || paragraphs[j].isInDeclaratives() != lines[ii].isInDeclaratives()) continue;
                        if (paragraphs[j].isInDeclaratives() == declaratives) {
                            jumpParagraphId = paragraphs[j].getParagraphNumber();
                            BreakpointManager.addJumppoint(lines[ii].getLineNumber(), filenames[lines[ii].getFileIndex()], lines[ii].getFileIndex());
                            this.out.println(DebuggerException.getInfoMessage(20, null));
                            break;
                        }
                        if (declaratives) {
                            throw new DebuggerException(38);
                        }
                        throw new DebuggerException(37);
                    }
                    if (jumpParagraphId != 0) break block7;
                    throw new DebuggerException(2);
                }
                break;
            }
            if (jumpParagraphId == 0) {
                for (int j = 0; j < paragraphs.length; ++j) {
                    if (paragraphs[j].getLineNumber() != lineNo || paragraphs[j].getFileIndex() != fileIndex) continue;
                    if (paragraphs[j].isInDeclaratives() == declaratives) {
                        jumpParagraphId = paragraphs[j].getParagraphNumber();
                        BreakpointManager.addJumppoint(paragraphs[j].getParagraphName(), filenames[paragraphs[j].getFileIndex()]);
                        break;
                    }
                    if (declaratives) {
                        throw new DebuggerException(38);
                    }
                    throw new DebuggerException(37);
                }
                if (jumpParagraphId == 0) {
                    throw new DebuggerException(2);
                }
            }
        } else {
            String paragraph = cmd.getParagraphName();
            String sec = null;
            int idx = paragraph.indexOf(" of ");
            if (idx >= 0) {
                sec = paragraph.substring(idx + 4).trim();
                paragraph = paragraph.substring(0, idx).trim();
            }
            DebugParagraph dp = null;
            for (int j = 0; j < paragraphs.length; ++j) {
                if (!paragraphs[j].getParagraphName().equalsIgnoreCase(paragraph)) continue;
                if (sec != null) {
                    if (!DebugUtilities.isInSection(this.currProgramClass, paragraphs[j].getParagraphNumber(), paragraphs[j].isInDeclaratives(), sec)) continue;
                    dp = paragraphs[j];
                    break;
                }
                if (dp == null) {
                    dp = paragraphs[j];
                    continue;
                }
                throw new DebuggerException(42, paragraph);
            }
            if (dp == null) {
                throw new DebuggerException(3, paragraph);
            }
            if (dp.isInDeclaratives() == declaratives) {
                jumpParagraphId = dp.getParagraphNumber();
                BreakpointManager.addJumppoint(dp.getParagraphName(), filenames[dp.getFileIndex()]);
            } else {
                if (declaratives) {
                    throw new DebuggerException(38);
                }
                throw new DebuggerException(37);
            }
        }
        this.status = 8;
        this.stepNumber = 1;
        returnCode = 0;
        Debugger.exitPar();
        throw new GotoException(jumpParagraphId);
    }

    private String stepToProgram(StepToNextProgramCommand cmd) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.stepNumber = 1;
        this.blockDebugger = false;
        this.status = 11;
        returnCode = 0;
        return "";
    }

    private String stepToLine(StepToCommand cmd) throws DebuggerException {
        String[] filenames;
        DebugLine[] lines;
        int fileIndex;
        String filename;
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        int lineNo = cmd.getLineNumber();
        if (cmd.getFilename() != null) {
            filename = cmd.getFilename();
            fileIndex = cmd.getFileIndex();
        } else {
            filename = Debugger.getFilename(this.currFile);
            fileIndex = this.currFileIndex;
        }
        try {
            lines = DebugUtilities.getLines(this.currProgramClass);
        }
        catch (Exception e) {
            lines = null;
        }
        if (lines == null) {
            returnCode = 203;
            return DebuggerException.getFormattedInfoMessage(5, this.currProgramClass.getName()) + eol;
        }
        try {
            filenames = DebugUtilities.getFilenames(this.currProgramClass);
        }
        catch (Exception e) {
            filenames = null;
        }
        if (filenames == null) {
            returnCode = 203;
            return DebuggerException.getInfoMessage(5, "'" + this.currProgramClass.getName() + "'" + eol);
        }
        boolean ok = false;
        Filename fn = new Filename(filename);
        for (int i = 0; i < lines.length; ++i) {
            int l = lines[i].getLineNumber();
            int idx = lines[i].getFileIndex();
            if (lineNo != l || !new Filename(filenames[idx]).equals(fn)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw new DebuggerException(2, "" + lineNo + ", file " + filename);
        }
        BreakpointManager.addTempBreakpoint(lineNo, filename, fileIndex);
        this.status = 7;
        this.stepNumber = 1;
        returnCode = 0;
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVariables(GetVariablesCommand cmd) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        VarName[] variables = cmd.getVariablesNames();
        TreeNode root = new TreeNode("GetVariables", null);
        String[] classNames = cmd.getClassNames();
        for (int varIdx = 0; varIdx < variables.length; ++varIdx) {
            String moduleName = classNames != null && varIdx < classNames.length ? classNames[varIdx] : null;
            Object[] current = null;
            try {
                current = this.setCurrentObjects(moduleName);
            }
            catch (DebuggerException ex) {
                continue;
            }
            try {
                IscobolDataItem field;
                IDebuggerHelper helper;
                int[] indexes;
                VarName parentVar;
                block25: {
                    parentVar = variables[varIdx];
                    indexes = new int[parentVar.getNSubscripts() + 1];
                    for (int i = 0; i < indexes.length - 1; ++i) {
                        Expression subscript = parentVar.getSubscript(i);
                        indexes[i] = ((BigDecimal)subscript.evaluate(this, true, false)).intValue();
                    }
                    helper = this.getHelper();
                    VarName tmp = (VarName)parentVar.clone();
                    if (cmd.getGetChildren()) {
                        tmp.clearSubscripts();
                    }
                    field = null;
                    try {
                        field = this.findObjectVar(tmp, false, true);
                    }
                    catch (DebuggerException ex) {
                        if (ex.getErrorId() != 41 && ex.getErrorId() != 25) break block25;
                        int type = 0;
                        tmp.clearSubscripts();
                        try {
                            field = this.findObjectVar(tmp, false, true);
                            type = DebugUtilities.getVarType(field.getVar(), helper);
                            field = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        StringBuffer buf = new StringBuffer();
                        buf.append(type);
                        buf.append("\u0001");
                        buf.append("\u0001");
                        buf.append("\u0001");
                        buf.append(DebuggerConstants.NULL_VALUE);
                        root.addNode(new TreeNode(parentVar.getFullName(), buf.toString()));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (field == null) continue;
                if (field.getVar() instanceof ICobolVar) {
                    ICobolVar cVar = (ICobolVar)field.getVar();
                    int[] dimensions = DebugUtilities.getDimensions(cVar);
                    String indexesStr = null;
                    int dimLen = dimensions != null ? dimensions.length : 0;
                    int startIdx = indexes[0];
                    if (dimLen > 0) {
                        StringBuffer buff = new StringBuffer();
                        buff.append("(");
                        for (int i = 0; i < dimensions.length - 1; ++i) {
                            buff.append(" ").append(indexes[i]);
                        }
                        indexesStr = buff.toString();
                    }
                    if (cmd.getGetChildren()) {
                        ArrayList<ICobolVar> list = new ArrayList<ICobolVar>();
                        if (dimLen >= indexes.length) {
                            int endIdx;
                            int maxArrayLength = cmd.getMaxArrayLength();
                            int startArrayOffset = cmd.getStartArrayOffset();
                            int arrayLength = dimensions[indexes.length - 1];
                            if (arrayLength <= maxArrayLength) {
                                startIdx = 1;
                                endIdx = arrayLength;
                            } else {
                                startIdx = Math.min(startArrayOffset, arrayLength - maxArrayLength);
                                endIdx = startIdx + maxArrayLength - 1;
                            }
                            int i = startIdx;
                            while (i <= endIdx) {
                                indexes[indexes.length - 1] = i++;
                                list.add(cVar.intIAt(indexes));
                            }
                            indexes[indexes.length - 1] = startIdx;
                        } else {
                            list.addAll(DebugUtilities.getAllChildren(cVar));
                            indexes = null;
                        }
                        if (list.isEmpty()) continue;
                        Object[] children = list.toArray();
                        Debugger.getChildVariables(children, indexesStr, startIdx, dimLen, root, cmd.getMaxHexDumpLength(), cmd.getStartHexDumpOffset(), cmd.getMaxTextLength(), indexes != null && dimLen >= indexes.length, helper);
                        continue;
                    }
                    String n = parentVar.getFullName();
                    Debugger.getChildVariable(cVar, n, indexesStr, startIdx, dimLen, root, cmd.getMaxHexDumpLength(), cmd.getStartHexDumpOffset(), cmd.getMaxTextLength(), indexes != null && dimLen >= indexes.length, helper);
                    continue;
                }
                if (parentVar.hasSubscript() && (field = this.findObjectVar(parentVar, false, true)) == null) continue;
                Object var = field.getVar();
                Debugger.getChildVariables(new Object[]{new DebugFieldWrapper(var, parentVar.getFullName())}, null, 0, 0, root, cmd.getMaxHexDumpLength(), cmd.getStartHexDumpOffset(), cmd.getMaxTextLength(), false, helper);
                continue;
            }
            finally {
                this.restoreCurrentObjects(current);
            }
        }
        Debugger.addTree(new Tree(root, false), null);
        returnCode = 0;
        return "";
    }

    private static void addTree(Tree t, String className) {
        if (tree == null) {
            tree = new Vector();
        }
        t.setClassName(className);
        tree.addElement(t);
    }

    private static void getChildVariables(Object[] children, String indexesStr, int startArrayOffset, int dimensions, TreeNode parent, int maxHexDumpLength, int startHexDumpOffset, int maxTextLength, boolean areArrayItems, IDebuggerHelper helper) {
        for (int childIdx = 0; childIdx < children.length; ++childIdx) {
            Debugger.getChildVariable(children[childIdx], null, indexesStr, startArrayOffset, dimensions, parent, maxHexDumpLength, startHexDumpOffset, maxTextLength, areArrayItems, helper);
        }
    }

    private static void getChildVariable(Object child, String n, String indexesStr, int startArrayOffset, int dimensions, TreeNode parent, int maxHexDumpLength, int startHexDumpOffset, int maxTextLength, boolean areArrayItems, IDebuggerHelper helper) {
        TreeNode node;
        if (child instanceof ICobolVar) {
            ICobolVar childCV = (ICobolVar)child;
            StringBuffer name = new StringBuffer();
            if (n != null) {
                name.append(n);
            } else {
                name.append(childCV.getName());
                if (indexesStr != null) {
                    name.append(indexesStr);
                    name.append(" ");
                    name.append(startArrayOffset);
                    name.append(" )");
                    if (areArrayItems) {
                        ++startArrayOffset;
                    }
                }
            }
            int[] dims = DebugUtilities.getDimensions(childCV);
            int occurs = dims != null && dims.length > dimensions ? dims[dimensions] : 0;
            String text = DebugUtilities.buildValueString(child, occurs, maxHexDumpLength, startHexDumpOffset, maxTextLength, helper);
            node = new TreeNode(name.toString(), text);
        } else {
            DebugFieldWrapper wrapper = (DebugFieldWrapper)child;
            String text = DebugUtilities.buildValueString(wrapper.getFieldValue(), 0, maxHexDumpLength, startHexDumpOffset, maxTextLength, helper);
            node = new TreeNode(wrapper.getFieldName(), text);
        }
        parent.addNode(node);
    }

    static String setBreakpoint(SetBreakpointCommand cmd, String currFile, int currFileIndex, Debugger dbg) throws DebuggerException {
        if (cmd.isListing()) {
            return Debugger.listBreakpoints();
        }
        int lineNo = cmd.getLineNumber();
        String paragraph = cmd.getParagraph();
        String file = Debugger.getFilename(currFile);
        int fileIndex = currFileIndex;
        if (cmd.getFilename() != null) {
            file = cmd.getFilename();
            fileIndex = cmd.getFileIndex();
        }
        String progName = cmd.getProgName();
        if (lineNo != 0) {
            return Debugger.setBreakpoint(lineNo, file, fileIndex, progName, cmd.isEnabled(), cmd.getPath(), cmd.getCondition(), dbg);
        }
        return Debugger.setBreakpoint(paragraph, file, fileIndex, progName, cmd.isEnabled(), cmd.getPath(), cmd.getCondition(), dbg);
    }

    static String clearBreakpoint(ClearBreakpointCommand cmd, String currFile, int currFileIndex) throws DebuggerException {
        if (cmd.isClearAll()) {
            return Debugger.clearAllBreakpoints();
        }
        int lineNo = cmd.getLineNumber();
        String paragraph = cmd.getParagraph();
        String file = Debugger.getFilename(currFile);
        int fileIndex = currFileIndex;
        if (cmd.getFilename() != null) {
            file = cmd.getFilename();
            fileIndex = cmd.getFileIndex();
        }
        String progName = cmd.getProgName();
        if (lineNo != 0) {
            return Debugger.clearBreakpoint(lineNo, file, fileIndex, progName);
        }
        return Debugger.clearBreakpoint(paragraph, file, fileIndex, progName, cmd.getPath());
    }

    private static Class classForName(String name, Debugger dbg) throws ClassNotFoundException {
        try {
            return DebugUtilities.classForName(name);
        }
        catch (ClassNotFoundException ex) {
            CallLoader ld = dbg != null ? dbg.appData.getCallLoader() : CallLoader.getInstance(Config.getProperty(".code_prefix", ""), false);
            if (ld != null) {
                return ld.loadClass(name);
            }
            throw ex;
        }
    }

    private void getInfo(GetInfoCommand cmd) {
        Class cls = null;
        if (cmd.getClassName() != null) {
            try {
                cls = Debugger.classForName(cmd.getClassName(), this);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            cls = this.currProgramClass;
        }
        if (cls != null) {
            debugInfo = Debugger.getInfo(cmd.getCode(), cls);
        }
    }

    static DebugResponse.DebugInfo getInfo(int code, String className) {
        try {
            Class cls = Debugger.classForName(className, null);
            return Debugger.getInfo(code, cls);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static DebugResponse.DebugInfo getInfo(int code, Class cls) {
        if (!IscobolDebugger.class.isAssignableFrom(cls)) {
            return new DebugResponse.DebugInfo(DebuggerException.getFormattedInfoMessage(5, cls.getName()) + ". Please recompile with -d option");
        }
        while (IsNested.class.isAssignableFrom(cls)) {
            cls = cls.getEnclosingClass();
        }
        String[] filenames = null;
        DebugLine[] lines = null;
        DebugParagraph[] paragraphs = null;
        DebugCopyFile[] copyfiles = null;
        String sourcefile = null;
        String copypath = null;
        long timestamp = 0L;
        String[] compilerOptions = null;
        String[] compilerProps = null;
        String[] fileSeparators = null;
        int infoFormat = 0;
        byte[] listingInfos = null;
        Throwable[] t = new Throwable[1];
        DebugSMAPReader dsr = DebugUtilities.getDSR(cls, t);
        if (dsr == null && t[0] != null) {
            return Debugger.checkVersion(cls);
        }
        if (dsr != null) {
            try {
                if ((code & 1) == 1) {
                    filenames = dsr.getFileNames().toArray(new String[dsr.getFileNames().size()]);
                }
                if ((code & 4) == 4 && dsr.getDbgParagraphs() != null) {
                    paragraphs = dsr.getDbgParagraphs().toArray(new DebugParagraph[dsr.getDbgParagraphs().size()]);
                }
                if ((code & 2) == 2 && dsr.getDbgLines() != null) {
                    lines = dsr.getDbgLines().toArray(new DebugLine[dsr.getDbgLines().size()]);
                }
                if ((code & 8) == 8 && dsr.getCopyFiles() != null) {
                    copyfiles = dsr.getCopyFiles().toArray(new DebugCopyFile[dsr.getCopyFiles().size()]);
                }
                if ((code & 0x10) == 16) {
                    sourcefile = dsr.getSourceFileName();
                }
                if ((code & 0x40) == 64) {
                    timestamp = dsr.getTimestamp();
                }
                try {
                    if ((code & 0x80) == 128) {
                        compilerOptions = DebugUtilities.getCompilerOptions(cls);
                    }
                }
                catch (Exception ex) {
                    if (cls.isInterface()) {
                        compilerOptions = new String[]{};
                    }
                    throw ex;
                }
                try {
                    if ((code & 0x100) == 256) {
                        fileSeparators = dsr.getFileSeparator();
                    }
                }
                catch (Exception ex) {
                    fileSeparators = new String[]{File.separator, File.pathSeparator};
                }
                if ((code & 0x200) == 512 && Config.getProperty("iscobol.debug.embedded_source", true)) {
                    listingInfos = dsr.getListingInfos();
                }
                infoFormat = dsr.getSmapFormat();
                compilerProps = dsr.getCompilerProps();
            }
            catch (Exception ex) {
                return Debugger.checkVersion(cls);
            }
        }
        try {
            if ((code & 1) == 1) {
                filenames = DebugUtilities.getFilenames(cls);
            }
            if ((code & 4) == 4) {
                paragraphs = DebugUtilities.getParagraphs(cls);
            }
            if ((code & 2) == 2) {
                lines = DebugUtilities.getLines(cls);
            }
            if ((code & 8) == 8) {
                copyfiles = DebugUtilities.getCopyfiles(cls);
            }
            if ((code & 0x20) == 32) {
                copypath = DebugUtilities.getCopyPath(cls);
            }
            if ((code & 0x10) == 16) {
                sourcefile = DebugUtilities.getSourcefile(cls);
            }
            if ((code & 0x40) == 64) {
                timestamp = DebugUtilities.getTimestamp(cls);
            }
            try {
                if ((code & 0x80) == 128) {
                    compilerOptions = DebugUtilities.getCompilerOptions(cls);
                }
            }
            catch (Exception ex) {
                if (cls.isInterface()) {
                    compilerOptions = new String[]{};
                }
                throw ex;
            }
            try {
                if ((code & 0x100) == 256) {
                    fileSeparators = DebugUtilities.getFileSeparators(cls);
                }
            }
            catch (Exception ex) {
                fileSeparators = new String[]{File.separator, File.pathSeparator};
            }
        }
        catch (Exception ex) {
            return Debugger.checkVersion(cls);
        }
        return new DebugResponse.DebugInfo(cls.getName(), filenames, lines, paragraphs, copyfiles, sourcefile, copypath, timestamp, IscobolDebuggerExtension.class.isAssignableFrom(cls), compilerOptions, fileSeparators, compilerProps, listingInfos, infoFormat);
    }

    private String display(DisplayCommand cmd) throws DebuggerException {
        if (cmd.displayAsTree()) {
            return this.displayTree(cmd);
        }
        if (cmd.getEnvName() != null) {
            return this.env(cmd.getEnvName(), cmd.displayAsHex(), cmd.displayFull());
        }
        if (cmd.displayClassInfo()) {
            return this.displayClassInfo();
        }
        if (cmd.displayAsHex() && cmd.getPropertyName() == null) {
            return this.displayAsHexString(cmd.getVarName(), cmd.getClassName(), cmd.displayFull());
        }
        return this.display(cmd.getVarName(), cmd.getClassName(), cmd.getPropertyName(), cmd.displayAsHex(), cmd.displayFull(), false);
    }

    private String length(LengthCommand cmd) throws DebuggerException {
        this.display(cmd.getVarName(), cmd.getClassName(), null, false, false, true);
        if (dbgVar != null) {
            return "+ length of " + cmd.getVarName().getFullName() + " = " + dbgVar.getLength() + eol;
        }
        return "- unknown length" + eol;
    }

    private String offset(OffsetCommand cmd) throws DebuggerException {
        this.display(cmd.getVarName(), cmd.getClassName(), null, false, false, true);
        if (dbgVar != null) {
            return "+ offset of " + cmd.getVarName().getFullName() + " = " + dbgVar.getOffset() + eol;
        }
        return "- unknown offset" + eol;
    }

    private String displayClassInfo() throws DebuggerException {
        StringBuffer Return2 = new StringBuffer();
        if (this.currProgramClass != null || this.currProgram != null) {
            returnCode = 0;
            Return2.append("+");
            Return2.append(" ");
            if (this.currProgram != null) {
                Return2.append(Factory.info(this.currProgram));
            } else {
                try {
                    Return2.append(Factory.info(this.currProgramClass));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new DebuggerException("isCOBOL class version: unknown");
                }
            }
        } else {
            Return2.append("isCOBOL class version: unknown");
            throw new DebuggerException(Return2.toString());
        }
        Return2.append(eol);
        return Return2.toString();
    }

    private static void pruneDeathThreads() {
        ArrayList threadToRemove = new ArrayList();
        for (Object key : debuggerInstances.keySet()) {
            Debugger dbg = (Debugger)debuggerInstances.get(key);
            if (dbg.threadObj == null || dbg.threadObj.isAlive()) continue;
            threadToRemove.add(key);
        }
        for (int i = 0; i < threadToRemove.size(); ++i) {
            debuggerInstances.remove(threadToRemove.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadObject[] getThreads(boolean setParStack, int[] curIdx) {
        ThreadObject[] Return2 = null;
        Hashtable hashtable = debuggerInstances;
        synchronized (hashtable) {
            Debugger.pruneDeathThreads();
            Vector<ThreadObject> v = new Vector<ThreadObject>();
            int i = 0;
            for (Object key : debuggerInstances.keySet()) {
                Debugger dbg = (Debugger)debuggerInstances.get(key);
                if (dbg.threadObj == null) continue;
                if (setParStack) {
                    dbg.threadObj.setParStack(dbg.getParStack());
                    if (dbg == activeDebugger) {
                        curIdx[0] = i;
                    }
                }
                v.addElement(dbg.threadObj);
                ++i;
            }
            Return2 = new ThreadObject[v.size()];
            v.toArray(Return2);
        }
        return Return2;
    }

    private String setMonitor(SetMonitorCommand cmd) throws DebuggerException {
        if (cmd.isListing()) {
            this.out.print(this.listMonitors());
            return "";
        }
        if (cmd.getEnvName() != null) {
            String envProp = cmd.getEnvName();
            Condition cond = cmd.getCondition();
            return this.setEnvMonitor(envProp, cond, cmd.isEnabled());
        }
        String cls = cmd.getClassName();
        if (cls != null && this.status == 3) {
            BreakpointManager.setMonitorToAdd(cls, cmd.getVarName(), cmd.getCondition(), cmd.getPropertyName(), cmd.isHexadecimal(), cmd.isEnabled());
            return "";
        }
        return this.setMonitor(cmd.getVarName(), cmd.getCondition(), cls, cmd.getPropertyName(), cmd.isHexadecimal(), cmd.isEnabled(), false);
    }

    private String clearMonitor(ClearMonitorCommand cmd) throws DebuggerException {
        if (cmd.isClearAll()) {
            this.out.print(this.clearAllMonitors());
            return "";
        }
        if (cmd.getEnvName() != null) {
            return this.clearEnvMonitor(cmd.getEnvName());
        }
        String cls = cmd.getClassName();
        return this.clearMonitor(cmd.getVarName(), cls, cmd.getPropertyName());
    }

    private IscobolDataItem[] getMethodFields(String name) {
        ArrayList al = new ArrayList();
        Debugger.addIscobolFields(name, this.currMethodClass, al);
        if (this.theMethodObj != null) {
            Class<?>[] decClasses = this.currMethodClass.getDeclaredClasses();
            for (int i = 0; i < decClasses.length; ++i) {
                if (!IscobolDebugger.class.isAssignableFrom(decClasses[i])) continue;
                Debugger.addIscobolFields(name, decClasses[i], al);
            }
        }
        return al.toArray(new IscobolDataItem[al.size()]);
    }

    private static IscobolDataItem[] getLocalStorageFields(String name, Class lsClass) {
        ArrayList al = new ArrayList();
        Debugger.addIscobolFields(name, lsClass, al);
        return al.toArray(new IscobolDataItem[al.size()]);
    }

    private IscobolDataItem[] getClassFields(String name) {
        ArrayList al = new ArrayList();
        Debugger.addIscobolFields(name, this.currProgramClass, al);
        return al.toArray(new IscobolDataItem[al.size()]);
    }

    private IscobolDataItem[] getProgramFields(String name) {
        ArrayList al = new ArrayList();
        Debugger.addIscobolFields(name, this.currProgramClass, al);
        if (this.theProgramObj != null) {
            for (Class c = this.currProgramClass.getSuperclass(); c != null && IscobolDebugger.class.isAssignableFrom(c); c = c.getSuperclass()) {
                Debugger.addIscobolFields(name, c, al);
            }
            for (Class<?> cls : this.currProgramClass.getDeclaredClasses()) {
                if (!IscobolDebugger.class.isAssignableFrom(cls) || IsNested.class.isAssignableFrom(cls)) continue;
                Debugger.addIscobolFields(name, cls, al);
            }
        }
        return al.toArray(new IscobolDataItem[al.size()]);
    }

    private static void addIscobolFields(String name, Class c, ArrayList al) {
        try {
            int idx = name.indexOf(35);
            if (idx >= 0) {
                name = name.substring(0, idx);
            }
            String regexp = name + "\\$\\d+";
            for (Field f : c.getDeclaredFields()) {
                String fName = f.getName();
                if (!fName.equals(name) && (!Handle.class.isAssignableFrom(f.getType()) || !fName.matches(regexp))) continue;
                IscobolDataItem isfld = new IscobolDataItem();
                isfld.field = f;
                al.add(isfld);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String let(LetCommand cmd) throws DebuggerException {
        if (cmd.getEnvName() != null) {
            return this.let(cmd.getEnvName(), cmd.getNewValue());
        }
        if (cmd.acceptAsHex()) {
            return this.letAsHex(cmd.getVarName(), cmd.getClassName(), cmd.getNewValue());
        }
        return this.let(cmd.getVarName(), cmd.getClassName(), cmd.getPropertyName(), cmd.getNewValue());
    }

    private String let(String envName, String value) throws DebuggerException {
        String key = Config.getPrefix() + envName.trim().toLowerCase().replace('-', '_');
        Config.setProperty(key, value);
        String propVal = Config.getProperty(key, null);
        returnCode = 0;
        if (envName.startsWith("debug.internal.")) {
            return "";
        }
        return "+ new value of " + key + " is " + propVal + eol;
    }

    private IscobolDataItem findObjectVar(VarName varname, boolean resolveSub) throws DebuggerException {
        return this.findObjectVar(varname, true, resolveSub);
    }

    private IscobolProp findProp(Class cls, IscobolDataItem dataItem, boolean next, String propName, boolean set) {
        propName = DebugUtilities.getJavaNameUpper(propName, this.hyphenRepl);
        Field field = null;
        try {
            field = cls.getField(propName);
            if (!Modifier.isStatic(field.getModifiers()) && dataItem == null && !next) {
                field = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (field != null) {
            return new IscobolProp(field, dataItem, set);
        }
        propName = (set ? "set" : "get") + propName;
        try {
            for (Method m : cls.getMethods()) {
                if (!m.getName().equals(propName) || !Modifier.isStatic(m.getModifiers()) && dataItem == null && !next) continue;
                if (set) {
                    if (m.getReturnType() == Void.TYPE && m.getParameterTypes().length == 1) {
                        return new IscobolProp(m, cls.getField("tmp" + propName), dataItem, set);
                    }
                } else if (m.getReturnType() != Void.TYPE && m.getParameterTypes().length == 0) {
                    return new IscobolProp(m, null, dataItem, set);
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private IscobolProp findProp(VarName varname, boolean set) {
        int ofs = varname.getNAncestors();
        if (ofs == 0) {
            return null;
        }
        RepositoryEntry[] res = null;
        try {
            res = DebugUtilities.getRepositoryEntries(this.getCurrClass());
        }
        catch (Exception e) {
            return null;
        }
        String cobolPropName = ofs > 1 ? varname.getAncestor(ofs - 2) : varname.getName();
        String propName = RepositoryEntry.findPropertyName(cobolPropName, res);
        if (propName == null) {
            return null;
        }
        Class cls = null;
        IscobolDataItem field = null;
        String cobolName = varname.getAncestor(ofs - 1);
        if ("self".equalsIgnoreCase(cobolName)) {
            cls = this.currProgramClass;
            field = new SelfDataItem(this.currProgram);
        } else if ("super".equalsIgnoreCase(cobolName)) {
            cls = this.currProgramClass.getSuperclass();
            field = new SelfDataItem(this.currProgram);
        } else {
            try {
                field = this.findObjectVar(new VarName(cobolName, null), false);
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
            if (field != null) {
                cls = ((IscobolDataItem)field).getType();
            } else {
                String className = RepositoryEntry.findClassName(cobolName, res);
                if (className != null) {
                    try {
                        cls = Debugger.classForName(className, this);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            }
        }
        if (cls == null || !IscobolClass.class.isAssignableFrom(cls)) {
            return null;
        }
        IscobolProp prop = this.findProp(cls, field, false, propName, set && ofs == 1);
        if (prop != null && ofs > 1) {
            String[] ss = new String[ofs - 1];
            ss[0] = varname.getName();
            for (int i = 0; i < ofs - 2; ++i) {
                ss[i + 1] = varname.getAncestor(i);
            }
            IscobolProp p = prop;
            for (int i = ss.length - 1; i >= 0; --i) {
                cls = p.getType();
                if (!IscobolClass.class.isAssignableFrom(cls)) {
                    return null;
                }
                propName = RepositoryEntry.findPropertyName(ss[i], res);
                if (propName == null) {
                    return null;
                }
                IscobolProp next = this.findProp(cls, null, true, propName, set && i == 0);
                if (next == null) {
                    return null;
                }
                p.next = next;
                p = next;
            }
        }
        return prop;
    }

    protected IscobolField findVar(VarName varname, boolean resolveSub) throws DebuggerException {
        IscobolField field = this.findObjectVar(varname, true, resolveSub);
        if (field == null) {
            field = this.findGetProp(varname);
        }
        return field;
    }

    private IscobolProp findSetProp(VarName varname) {
        return this.findProp(varname, true);
    }

    private IscobolProp findGetProp(VarName varname) {
        IscobolProp prop = this.findProp(varname, false);
        if (prop != null) {
            prop.refresh(this);
        }
        return prop;
    }

    private IscobolDataItem findObjectVar(VarName varname, boolean checkDimension, boolean resolveSub) throws DebuggerException {
        if (varname == null) {
            return null;
        }
        String javaname = DebugUtilities.getJavaNameUpper(varname.getName(), this.hyphenRepl);
        IscobolDataItem Return2 = this.findObjectVar(varname, "file$" + javaname, checkDimension, resolveSub);
        if (Return2 == null) {
            Return2 = this.findObjectVar(varname, javaname, checkDimension, resolveSub);
        }
        return Return2;
    }

    private Object[] setCurrentObjects(String moduleName) throws DebuggerException {
        Object[] Return2 = new Object[]{this.currProgramClass, this.currProgram, this.theProgramObj, this.currMethodClass, this.currMethod, this.theMethodObj};
        if (moduleName != null && !this.parStack.isEmpty()) {
            String[] ss = Debugger.getMethodAndClass(moduleName, false);
            int size = this.parStack.size();
            if (ss[2] != null) {
                String methodName = ss[2];
                String className = ss[0];
                boolean found = false;
                for (int i = size - 1; i >= 0; --i) {
                    ParagraphObject po = (ParagraphObject)this.parStack.elementAt(i);
                    if (!methodName.equals(po.getMethodName()) || !className.equals(po.getProgClass().getName())) continue;
                    this.currMethod = po.getMethod();
                    this.currMethodClass = this.currMethod.getClass();
                    this.theMethodObj = Debugger.getMethodObj(this.currMethod);
                    this.currProgramClass = po.getProgClass();
                    this.currProgram = po.getProgram();
                    this.theProgramObj = null;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new DebuggerException(40, methodName);
                }
            } else {
                String programName = ss[0];
                boolean found = false;
                for (int i = size - 1; i >= 0; --i) {
                    ParagraphObject po = (ParagraphObject)this.parStack.elementAt(i);
                    if (!programName.equalsIgnoreCase(po.getProgName())) continue;
                    this.currMethod = null;
                    this.currMethodClass = null;
                    this.theMethodObj = null;
                    this.currProgramClass = po.getProgClass();
                    this.currProgram = po.getProgram();
                    this.theProgramObj = Debugger.getProgramObj(this.currProgram);
                    found = true;
                    break;
                }
                if (!found) {
                    throw new DebuggerException(23, programName);
                }
            }
        }
        return Return2;
    }

    private void restoreCurrentObjects(Object[] o) {
        this.currProgramClass = (Class)o[0];
        this.currProgram = o[1];
        this.theProgramObj = o[2];
        this.currMethodClass = (Class)o[3];
        this.currMethod = o[4];
        this.theMethodObj = o[5];
    }

    private IscobolDataItem findObjectVar(VarName varname, String javaname, boolean checkDimension, boolean resolveSub) throws DebuggerException {
        Object tls;
        Object ls;
        IscobolDataItem[] fields;
        IscobolDataItem Return2 = null;
        if (this.currMethodClass != null) {
            fields = this.getMethodFields(javaname);
            if (fields.length > 0) {
                Return2 = this.findObjectVar(varname, checkDimension, resolveSub, fields, this.theMethodObj != null ? this.theMethodObj : this.currMethod);
            }
            if (Return2 == null && (fields = this.getClassFields(javaname)).length > 0) {
                Return2 = this.findObjectVar(varname, checkDimension, resolveSub, fields, this.currProgram);
            }
            if (Return2 == null && (ls = this.getHelper().peekMethodLocalStorage()) != null && (fields = Debugger.getLocalStorageFields(javaname, ls.getClass())).length > 0) {
                Return2 = this.findObjectVar(varname, checkDimension, resolveSub, fields, ls);
            }
            if (Return2 == null && (tls = this.getHelper().peekMethodThreadLocalStorage()) != null && (fields = Debugger.getLocalStorageFields(javaname, tls.getClass())).length > 0) {
                Return2 = this.findObjectVar(varname, checkDimension, resolveSub, fields, tls);
            }
        } else {
            fields = this.getProgramFields(javaname);
            if (fields.length > 0) {
                Return2 = this.findObjectVar(varname, checkDimension, resolveSub, fields, this.theProgramObj != null ? this.theProgramObj : this.currProgram);
            }
            if (Return2 == null && (ls = this.getHelper().peekCallLocalStorage()) != null && (fields = Debugger.getLocalStorageFields(javaname, ls.getClass())).length > 0) {
                Return2 = this.findObjectVar(varname, checkDimension, resolveSub, fields, ls);
            }
            if (Return2 == null && (tls = this.getHelper().peekCallThreadLocalStorage()) != null && (fields = Debugger.getLocalStorageFields(javaname, tls.getClass())).length > 0) {
                Return2 = this.findObjectVar(varname, checkDimension, resolveSub, fields, tls);
            }
            if (Return2 == null && this.currProgram instanceof IsNested) {
                Object inst = ((IsNested)this.currProgram).getParentObject();
                Class<?> cls = inst.getClass();
                while (true) {
                    ArrayList al = new ArrayList();
                    Debugger.addIscobolFields(javaname, cls, al);
                    if (al.size() > 0) {
                        fields = al.toArray(new IscobolDataItem[al.size()]);
                        Return2 = this.findObjectVar(varname, checkDimension, resolveSub, fields, inst);
                    }
                    if (Return2 != null || !(inst instanceof IsNested)) break;
                    inst = ((IsNested)inst).getParentObject();
                    cls = inst.getClass();
                }
            }
        }
        if (Return2 == null) {
            Object inst;
            Class clazz;
            if (this.currMethodClass != null) {
                clazz = this.currMethodClass;
                inst = this.currMethod;
            } else {
                clazz = this.currProgramClass;
                inst = this.currProgram;
            }
            try {
                Field f = clazz.getDeclaredField("$localVarsStack$");
                f.setAccessible(true);
                Stack stack = (Stack)((ThreadLocal)f.get(inst)).get();
                for (int i = stack.size() - 1; i >= 0 && Return2 == null; --i) {
                    Object obj = stack.elementAt(i);
                    ArrayList al = new ArrayList();
                    Debugger.addIscobolFields(javaname, obj.getClass(), al);
                    fields = al.toArray(new IscobolDataItem[al.size()]);
                    if (fields.length <= 0) continue;
                    Return2 = this.findObjectVar(varname, checkDimension, resolveSub, fields, obj);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Return2;
    }

    private IscobolDataItem findObjectVar(VarName varname, boolean checkDimension, boolean resolveSub, IscobolDataItem[] allFields, Object inst) throws DebuggerException {
        int nFound = 0;
        IscobolField Return2 = null;
        Object var = null;
        for (IscobolDataItem item : allFields) {
            item.field.setAccessible(true);
            int[] indexes = null;
            try {
                if (inst == null && !Modifier.isStatic(item.field.getModifiers())) continue;
                var = item.field.get(inst);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ICobolVar cVar = null;
            Level88 l88 = null;
            boolean found = true;
            if (varname.hasSubscript()) {
                indexes = this.resolveSubscripts(varname);
            }
            if (var instanceof ICobolVar) {
                cVar = this.findCobolVar((ICobolVar)var, item, varname, indexes, resolveSub);
                found = cVar != null;
            } else if (var instanceof Level88) {
                l88 = this.findLevel88((Level88)var, varname, indexes);
                found = l88 != null;
            } else if (varname.hasSubscript()) {
                item.adjustIndexes(indexes);
                var = Debugger.findObjectVarAt(var, indexes);
                boolean bl = found = var != null;
            }
            if (!found) continue;
            Return2 = item;
            IscobolDataItem.access$502((IscobolDataItem)Return2, indexes);
            ++nFound;
            if (cVar != null) {
                Return2.setVar(cVar);
            } else if (l88 != null) {
                Return2.setVar(l88);
            } else {
                Return2.setVar(var);
            }
            if (nFound <= 1) continue;
            throw new DebuggerException(8, "'" + varname.getName() + "'");
        }
        if (nFound == 1) {
            if (Return2.getVar() == null) {
                Return2.setVar(NULL_OBJECT);
            }
            if (checkDimension) {
                if (Return2.getVar() instanceof ICobolVar) {
                    int dimLen;
                    int n = dimLen = ((IscobolDataItem)Return2).dimensions == null ? 0 : ((IscobolDataItem)Return2).dimensions.length;
                    if (dimLen > varname.getNSubscripts()) {
                        throw new DebuggerException(6, "'" + varname.getName() + "'");
                    }
                    if (dimLen < varname.getNSubscripts()) {
                        throw new DebuggerException(25, "'" + varname.getName() + "'");
                    }
                } else if (Return2.getVar() instanceof Level88) {
                    Level88 l88 = (Level88)Return2.getVar();
                    int dim = l88.getDimCount();
                    if (dim > varname.getNSubscripts()) {
                        throw new DebuggerException(6, "'" + varname.getName() + "'");
                    }
                    if (dim < varname.getNSubscripts()) {
                        throw new DebuggerException(25, "'" + varname.getName() + "'");
                    }
                } else if (Return2.getVar().getClass().isArray() && varname.getNSubscripts() == 0) {
                    throw new DebuggerException(6, "'" + varname.getName() + "'");
                }
            }
            return Return2;
        }
        return null;
    }

    static Object findObjectVarAt(Object var, int[] indexes) throws DebuggerException {
        int i = 0;
        while (true) {
            try {
                var = Array.get(var, indexes[i]);
            }
            catch (Exception e) {
                throw new DebuggerException(25);
            }
            if (var == null || i == indexes.length - 1 && !var.getClass().isArray()) {
                return var != null ? var : NULL_OBJECT;
            }
            ++i;
        }
    }

    private ICobolVar findCobolVar(ICobolVar var, IscobolDataItem f, VarName varname, int[] indexes, boolean resolveSub) throws DebuggerException {
        if (var.isFinal()) {
            return var;
        }
        int idx = varname.getName().indexOf(35);
        int fillerIdx = 0;
        if (idx >= 0) {
            fillerIdx = Integer.parseInt(varname.getName().substring(idx + 1));
        }
        ICobolVar parent = var.getIParent();
        if (fillerIdx > 0 && parent != null) {
            int fillerCount = 0;
            Enumeration en = parent.getChildren();
            while (en.hasMoreElements()) {
                ICobolVar child = (ICobolVar)en.nextElement();
                if (child == var) {
                    if (++fillerCount == fillerIdx) break;
                    return null;
                }
                if (!child.getName().equalsIgnoreCase("filler")) continue;
                ++fillerCount;
            }
        }
        f.setCobolVar(true);
        IscobolDataItem.access$602(f, DebugUtilities.getDimensions(var));
        Enumeration eOf = varname.getAncestors();
        ICobolVar src = var;
        while (eOf.hasMoreElements()) {
            String str = eOf.nextElement().toString();
            idx = str.indexOf(35);
            fillerIdx = 0;
            if (idx >= 0) {
                fillerIdx = Integer.parseInt(str.substring(idx + 1));
                str = str.substring(0, idx);
            }
            boolean ok = false;
            while (parent != null && !ok) {
                ok = parent.getName().equalsIgnoreCase(str);
                if (ok && fillerIdx > 0 && parent.getIParent() != null) {
                    int fillerCount = 0;
                    Enumeration en = parent.getIParent().getChildren();
                    while (en.hasMoreElements()) {
                        ICobolVar child = (ICobolVar)en.nextElement();
                        if (child == parent) {
                            if (++fillerCount == fillerIdx) break;
                            ok = false;
                            break;
                        }
                        if (!child.getName().equalsIgnoreCase("filler")) continue;
                        ++fillerCount;
                    }
                }
                parent = parent.getIParent();
            }
            if (ok) continue;
            return null;
        }
        if (resolveSub && varname.hasSubscript()) {
            if (indexes == null) {
                return null;
            }
            if (this.shouldCheckDynamic() && !Debugger.checkDynamicIndexes(var, indexes)) {
                throw new DebuggerException(41, "'" + varname.getName() + "'");
            }
            try {
                var = var.intIAt(indexes);
                DebugUtilities.toString(var);
            }
            catch (Exception e) {
                throw new DebuggerException(25, "'" + varname.getName() + "'");
            }
        }
        if (this.cod1) {
            var = DebugUtilities.getVar(var, src, var.getOffset());
        }
        if (varname.hasSubvalue()) {
            Expression exp = varname.getSubLen();
            if (exp != null) {
                try {
                    f.subLen = this.evaluateExprAsInt(exp);
                }
                catch (Exception ee) {
                    return null;
                }
            }
            if ((exp = varname.getLeftPos()) != null) {
                try {
                    f.leftPos = this.evaluateExprAsInt(exp);
                }
                catch (Exception ee) {
                    return null;
                }
            }
            if (resolveSub) {
                try {
                    var = f.subLen != -1 ? var.intISub(f.leftPos, f.subLen) : var.intISub(f.leftPos);
                }
                catch (IscobolRuntimeException e) {
                    return null;
                }
            }
        }
        return var;
    }

    private Level88 findLevel88(Level88 var, VarName varname, int[] indexes) throws DebuggerException {
        ICobolVar parent = var.getParent();
        String name = varname.getName().replace(this.hyphenRepl, '-');
        boolean found = var.getName().equalsIgnoreCase(name);
        Enumeration eOf = varname.getAncestors();
        while (found && eOf.hasMoreElements()) {
            String parName = parent != null ? parent.getName() : "";
            String s = eOf.nextElement().toString();
            found &= parName.equalsIgnoreCase(s);
            parent = parent.getIParent();
        }
        if (found && varname.hasSubscript()) {
            if (indexes == null) {
                return null;
            }
            if (!this.shouldCheckDynamic() || Debugger.checkDynamicIndexes(var.getParent(), indexes)) {
                try {
                    var = var.intAt(indexes);
                }
                catch (IscobolRuntimeException e) {
                    found = false;
                }
            } else {
                throw new DebuggerException(41, "'" + varname.getName() + "'");
            }
        }
        if (found) {
            return var;
        }
        return null;
    }

    private int[] resolveSubscripts(VarName varname) {
        int n = varname.getNSubscripts();
        int[] indexes = new int[n];
        for (int j = 0; j < n; ++j) {
            Expression exp = varname.getSubscript(j);
            try {
                indexes[j] = this.evaluateExprAsInt(exp);
                continue;
            }
            catch (Exception ee) {
                return null;
            }
        }
        return indexes;
    }

    private int evaluateExprAsInt(Expression expr) throws DebuggerException {
        Object val = expr.evaluate(this, true, false);
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).intValue();
        }
        return 0;
    }

    public static void isIscobolDebugger(String className) {
        int gs = globalStatus.getValue();
        if (gs != 0 && gs != 3) {
            Debugger dbg = Debugger.getCurrentDebugger();
            try {
                Class cls = DebugUtilities.classForName(className);
                if (!DebuggerConstants.DEBUGGER_CLASS.isAssignableFrom(cls)) {
                    dbg.out.println(DebuggerException.getFormattedInfoMessage(5, cls.getName()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void callThreadAborted(Debugger newThread) {
        if (globalStatus.getValue() != 0 && newThread.status == 1) {
            Debugger currDbg = Debugger.getCurrentDebugger();
            currDbg.status = 1;
            currDbg.stepNumber = newThread.stepNumber;
            activeDebugger = currDbg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Debugger newThread() {
        ThreadObject to = null;
        Debugger Return2 = null;
        Debugger currDbg = Debugger.getCurrentDebugger();
        Return2 = new Debugger(currDbg);
        int gs = globalStatus.getValue();
        if (gs != 0) {
            to = ThreadObject.getIscobolThreadObject(null);
            if (currDbg == activeDebugger && currDbg.status == 1) {
                currDbg.status = 4;
                Return2.status = 1;
                Return2.stepNumber = currDbg.stepNumber;
                currDbg.stepNumber = 1;
                activeDebugger = Return2;
            } else if (gs != 3) {
                Hashtable hashtable = debuggerInstances;
                synchronized (hashtable) {
                    Debugger.pruneDeathThreads();
                    if (debuggerInstances.size() == 0) {
                        Return2.status = 1;
                        activeDebugger = Return2;
                    } else {
                        Return2.status = 4;
                    }
                    Return2.stepNumber = 1;
                }
            }
        }
        Return2.threadObj = to;
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterThread(Debugger newDbg) {
        if (newDbg != null) {
            if (globalStatus.getValue() != 0) {
                newDbg.threadObj.setThread();
            }
            Hashtable hashtable = debuggerInstances;
            synchronized (hashtable) {
                debuggerInstances.put(Thread.currentThread(), newDbg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exitThread() {
        Hashtable hashtable = debuggerInstances;
        synchronized (hashtable) {
            debuggerInstances.remove(Thread.currentThread());
        }
    }

    public static Object callThread(NumericVar handle, String origName, IscobolCall prg, Object[] argv) {
        return Debugger.callThread(handle, origName, prg, argv, DebugUtilities.getHelper(null));
    }

    public static Object callThread(INumericVar handle, String origName, IscobolCall prg, Object[] argv, IDebuggerHelper helper) {
        Debugger.callThread(handle, origName, prg, argv, null, helper);
        return helper.getNumLiteral(0L, 1, 0, false);
    }

    public static void callThread(INumericVar handle, String origName, IscobolCall prg, Object[] argv, ICobolVar Return2, IDebuggerHelper helper) {
        Debugger newThread = Debugger.newThread();
        try {
            helper.callThread(handle, origName, prg, argv, Return2, new MyNotifier(newThread));
        }
        catch (IscobolRuntimeException ex) {
            Debugger.callThreadAborted(newThread);
            throw ex;
        }
    }

    public static Object callRun(String origName, IscobolCall prg, Object[] argv) {
        return Debugger.callRun(origName, prg, argv, DebugUtilities.getHelper(null));
    }

    public static Object callRun(String origName, IscobolCall prg, Object[] argv, IDebuggerHelper helper) {
        Debugger.callRun(origName, prg, argv, null, helper);
        return helper.getNumLiteral(0L, 1, 0, false);
    }

    public static void callRun(String origName, IscobolCall prg, Object[] argv, ICobolVar Return2, IDebuggerHelper helper) {
        Debugger newThread = Debugger.newThread();
        try {
            helper.callRun(origName, prg, argv, Return2, new MyNotifier(newThread));
        }
        catch (IscobolRuntimeException ex) {
            Debugger.callThreadAborted(newThread);
            throw ex;
        }
    }

    public static Object clientCallThread(NumericVar handle, String origName, Object[] argv) {
        return Debugger.clientCallThread(handle, origName, argv, DebugUtilities.getHelper(null));
    }

    public static Object clientCallThread(INumericVar handle, String origName, Object[] argv, IDebuggerHelper helper) {
        Debugger.clientCallThread(handle, origName, argv, null, helper);
        return helper.getNumLiteral(0L, 1, 0, false);
    }

    public static void clientCallThread(INumericVar handle, String origName, Object[] argv, ICobolVar Return2, IDebuggerHelper helper) {
        helper.clientCallThread(handle, origName, argv, Return2, new MyNotifier(Debugger.newThread()));
    }

    public static Object clientCallRun(String origName, Object[] argv) {
        return Debugger.clientCallRun(origName, argv, DebugUtilities.getHelper(null));
    }

    public static Object clientCallRun(String origName, Object[] argv, IDebuggerHelper helper) {
        Debugger.clientCallRun(origName, argv, null, helper);
        return helper.getNumLiteral(0L, 1, 0, false);
    }

    public static void clientCallRun(String origName, Object[] argv, ICobolVar Return2, IDebuggerHelper helper) {
        helper.clientCallRun(origName, argv, Return2, new MyNotifier(Debugger.newThread()));
    }

    public static PicX acceptFromCommandLine(String[] args) {
        return Factory.acceptFromCommandLine(Debugger.getCommandLineArgs(args));
    }

    public static String[] getCommandLineArgs(String[] args) {
        return args != null ? args : programArgs;
    }

    private String run(RunCommand cmd) throws DebuggerException {
        if (this.status != 3) {
            throw new DebuggerException(10);
        }
        programArgs = cmd.getArgs();
        this.status = 1;
        this.stepNumber = 1;
        returnCode = 0;
        return "";
    }

    static String setProgramBreakpoint(ProgramBreakpointCommand cmd, Debugger dbg) throws DebuggerException {
        String prog = cmd.getProgName();
        Class cls = null;
        try {
            cls = Debugger.classForName(DebugUtilities.getIscobolClassName(prog), dbg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cls != null) {
            String[] filenames;
            DebugParagraph[] pars;
            try {
                pars = DebugUtilities.getParagraphs(cls);
            }
            catch (Exception e) {
                pars = null;
            }
            if (pars == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, cls.getName()) + eol;
            }
            try {
                filenames = DebugUtilities.getFilenames(cls);
            }
            catch (Exception e) {
                filenames = null;
            }
            if (filenames == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, cls.getName()) + eol;
            }
            HashMap<String, int[]> map = new HashMap<String, int[]>();
            for (String fn : filenames) {
                int[] i = (int[])map.get(fn);
                if (i == null) {
                    map.put(fn, new int[]{1});
                    continue;
                }
                i[0] = i[0] + 1;
            }
            DebugParagraph p = null;
            for (int i = 0; i < pars.length && p == null; ++i) {
                if (pars[i].isInDeclaratives()) continue;
                p = pars[i];
            }
            if (p != null) {
                String file;
                int lineNo = p.getLineNumber();
                int fileIndex = p.getFileIndex();
                Breakpoint bp = BreakpointManager.addBreakpoint(lineNo, file, ((int[])map.get(file = filenames[fileIndex]))[0] > 1 ? fileIndex : -1, cls.getName(), cmd.getCondition(), cmd.isEnabled());
                bp.setProgramBreakpoint(true);
                returnCode = 0;
                return DebuggerException.getInfoMessage(6, "'" + prog + "'" + eol);
            }
            throw new DebuggerException(3, "'" + prog + "'");
        }
        throw new DebuggerException(23, "'" + prog + "'");
    }

    private static String[] getMethodAndClass(String moduleName, boolean isMethod) {
        String methodName = null;
        String methodBaseName = null;
        String className = null;
        for (String s : new String[]{".", ":>", "::"}) {
            int idx = moduleName.indexOf(s);
            if (idx < 0 || idx >= moduleName.length() - s.length()) continue;
            className = moduleName.substring(0, idx);
            methodName = moduleName.substring(idx + s.length());
            break;
        }
        if (className == null) {
            if (isMethod) {
                methodName = moduleName;
            } else {
                className = moduleName;
            }
        }
        if (methodName != null) {
            int idx;
            methodBaseName = methodName.endsWith("()") ? (methodName = methodName.substring(0, methodName.length() - 2)) : ((idx = methodName.indexOf(40)) >= 0 ? methodName.substring(0, idx) : methodName);
        }
        return new String[]{className, methodName, methodBaseName};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String setMethodBreakpoint(MethodBreakpointCommand cmd, Debugger dbg) throws DebuggerException {
        String file;
        String[] filenames;
        DebugParagraph[] pars;
        String savedName = cmd.getMethodName();
        Class cls = null;
        String[] ss = Debugger.getMethodAndClass(savedName, true);
        String className = ss[0];
        String methodName = ss[1];
        String methodBaseName = ss[2];
        if (className == null) {
            if (dbg == null) throw new DebuggerException(40, "'" + methodBaseName + "'");
            className = dbg.currProgramClass.getName();
            savedName = className + ":>" + savedName;
            cls = dbg.currProgramClass;
        } else {
            try {
                cls = Debugger.classForName(className, dbg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (cls == null) throw new DebuggerException(23, "'" + className + "'");
        try {
            pars = DebugUtilities.getParagraphs(cls);
        }
        catch (Exception e) {
            pars = null;
        }
        if (pars == null) {
            returnCode = 203;
            return DebuggerException.getFormattedInfoMessage(5, cls.getName()) + eol;
        }
        try {
            filenames = DebugUtilities.getFilenames(cls);
        }
        catch (Exception e) {
            filenames = null;
        }
        if (filenames == null) {
            returnCode = 203;
            return DebuggerException.getFormattedInfoMessage(5, cls.getName()) + eol;
        }
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        for (String fn : filenames) {
            int[] i = (int[])map.get(fn);
            if (i == null) {
                map.put(fn, new int[]{1});
                continue;
            }
            i[0] = i[0] + 1;
        }
        DebugParagraph p = null;
        if (methodName != methodBaseName) {
            for (int i = 0; i < pars.length && p == null; ++i) {
                String m = pars[i].getMethodName();
                if (m == null || !m.equals(methodName)) continue;
                p = pars[i];
            }
        } else {
            HashMap<String, DebugParagraph> result = new HashMap<String, DebugParagraph>();
            for (int i = 0; i < pars.length; ++i) {
                String m = pars[i].getMethodName();
                if (m == null) continue;
                if (m.equals(methodName)) {
                    result.clear();
                    result.put(m, pars[i]);
                    break;
                }
                if (!m.startsWith(methodName) || result.containsKey(m)) continue;
                result.put(m, pars[i]);
            }
            if (result.size() > 1) {
                throw new DebuggerException(8, "'" + methodBaseName + "'");
            }
            if (result.size() == 1) {
                p = (DebugParagraph)result.values().toArray()[0];
            }
        }
        if (p == null) throw new DebuggerException(40, "'" + methodBaseName + "'");
        int lineNo = p.getLineNumber();
        int fileIndex = p.getFileIndex();
        Breakpoint bp = BreakpointManager.addBreakpoint(lineNo, file, ((int[])map.get(file = filenames[fileIndex]))[0] > 1 ? fileIndex : -1, cls.getName(), cmd.getCondition(), cmd.isEnabled());
        bp.setMethodName(savedName);
        returnCode = 0;
        return DebuggerException.getInfoMessage(21, "'" + methodBaseName + "'" + eol);
    }

    private static String setBreakpoint(int lineNo, String file, int fileIndex, String progName, boolean enabled, String path, Expression condition, Debugger dbg) throws DebuggerException {
        Class pd = null;
        boolean ok = true;
        pd = DebugUtilities.getIscobolClass(progName);
        if (pd == null) {
            pd = DebugUtilities.getIscobolClass(file);
        }
        boolean useCurrClass = false;
        if (pd == null && dbg != null && dbg.currProgramClass != null) {
            pd = dbg.currProgramClass;
            try {
                String[] filenames = DebugUtilities.getFilenames(pd);
                Filename fn = new Filename(file);
                for (String f : filenames) {
                    if (!new Filename(f).equals(fn)) continue;
                    useCurrClass = true;
                    break;
                }
            }
            catch (Exception filenames) {
                // empty catch block
            }
            if (!useCurrClass) {
                pd = null;
            }
        }
        String warning = "";
        if (pd != null) {
            String[] filenames;
            DebugLine[] lines;
            try {
                lines = DebugUtilities.getLines(pd);
            }
            catch (Exception e) {
                lines = null;
            }
            if (lines == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, pd.getName()) + eol;
            }
            try {
                filenames = DebugUtilities.getFilenames(pd);
            }
            catch (Exception e) {
                filenames = null;
            }
            if (filenames == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, pd.getName()) + eol;
            }
            ok = false;
            Filename fn = new Filename(file);
            for (DebugLine dl : lines) {
                int l = dl.getLineNumber();
                int idx = dl.getFileIndex();
                if (lineNo != l || !new Filename(filenames[idx]).equals(fn)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new DebuggerException(2, "" + lineNo + ", file " + file);
            }
        } else {
            warning = "; " + DebuggerException.getWarningMessage(1);
        }
        BreakpointManager.addBreakpoint(lineNo, file, fileIndex, progName, condition, enabled);
        returnCode = 0;
        return DebuggerException.getInfoMessage(7, "" + lineNo + ", file " + path + warning + eol);
    }

    private static String setBreakpoint(String par, String file, int fileIndex, String progName, boolean enabled, String path, Expression condition, Debugger dbg) throws DebuggerException {
        int lineNo = 0;
        Class pd = null;
        String warning = "";
        pd = DebugUtilities.getIscobolClass(progName);
        if (pd == null) {
            pd = DebugUtilities.getIscobolClass(file);
        }
        boolean useCurrClass = false;
        if (pd == null && dbg != null && dbg.currProgramClass != null) {
            pd = dbg.currProgramClass;
            try {
                String[] filenames = DebugUtilities.getFilenames(pd);
                Filename fn = new Filename(file);
                for (String f : filenames) {
                    if (!new Filename(f).equals(fn)) continue;
                    useCurrClass = true;
                    break;
                }
            }
            catch (Exception filenames) {
                // empty catch block
            }
            if (!useCurrClass) {
                pd = null;
            }
        }
        String parOrig = par;
        if (pd != null) {
            String[] filenames;
            DebugParagraph[] pars;
            try {
                pars = DebugUtilities.getParagraphs(pd);
            }
            catch (Exception e) {
                pars = null;
            }
            if (pars == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, pd.getName()) + eol;
            }
            try {
                filenames = DebugUtilities.getFilenames(pd);
            }
            catch (Exception e) {
                filenames = null;
            }
            if (filenames == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, pd.getName()) + eol;
            }
            Filename fn = new Filename(file);
            String sec = null;
            int idx = par.indexOf(" of ");
            if (idx >= 0) {
                sec = par.substring(idx + 4).trim();
                par = par.substring(0, idx).trim();
            }
            DebugParagraph dp = null;
            for (int i = 0; i < pars.length; ++i) {
                String p = pars[i].getParagraphName();
                if (!par.equalsIgnoreCase(p) || !new Filename(filenames[pars[i].getFileIndex()]).equals(fn)) continue;
                if (sec != null) {
                    if (!DebugUtilities.isInSection(pd, pars[i].getParagraphNumber(), pars[i].isInDeclaratives(), sec)) continue;
                    dp = pars[i];
                    lineNo = pars[i].getLineNumber();
                    idx = pars[i].getFileIndex();
                    break;
                }
                if (dp == null) {
                    dp = pars[i];
                    lineNo = pars[i].getLineNumber();
                    idx = pars[i].getFileIndex();
                    continue;
                }
                throw new DebuggerException(42, parOrig + ", file " + file);
            }
            if (dp == null) {
                throw new DebuggerException(3, parOrig + ", file " + file);
            }
            fileIndex = idx;
        } else {
            warning = "; " + DebuggerException.getWarningMessage(2);
        }
        BreakpointManager.addBreakpoint(parOrig, lineNo, file, fileIndex, progName, condition, enabled);
        returnCode = 0;
        return DebuggerException.getInfoMessage(8, parOrig + ", file " + path + warning + eol);
    }

    private static String clearBreakpoint(String par, String file, int fileIndex, String progName, String path) throws DebuggerException {
        Breakpoint bp;
        int lineNo = 0;
        String parOrig = par;
        Class pd = null;
        pd = DebugUtilities.getIscobolClass(progName);
        if (pd == null) {
            pd = DebugUtilities.getIscobolClass(file);
        }
        if (pd != null) {
            String[] filenames;
            DebugParagraph[] pars;
            try {
                pars = DebugUtilities.getParagraphs(pd);
            }
            catch (Exception e) {
                pars = null;
            }
            if (pars == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, pd.getName()) + eol;
            }
            try {
                filenames = DebugUtilities.getFilenames(pd);
            }
            catch (Exception e) {
                filenames = null;
            }
            if (filenames == null) {
                returnCode = 203;
                return DebuggerException.getInfoMessage(5, "'" + pd.getName() + "'" + eol);
            }
            Filename fn = new Filename(file);
            String sec = null;
            int idx = par.indexOf(" of ");
            if (idx >= 0) {
                sec = par.substring(idx + 4).trim();
                par = par.substring(0, idx).trim();
            }
            DebugParagraph dp = null;
            for (int i = 0; i < pars.length; ++i) {
                String p = pars[i].getParagraphName();
                if (!par.equalsIgnoreCase(p) || !new Filename(filenames[pars[i].getFileIndex()]).equals(fn)) continue;
                if (sec != null) {
                    if (!DebugUtilities.isInSection(pd, pars[i].getParagraphNumber(), pars[i].isInDeclaratives(), sec)) continue;
                    dp = pars[i];
                    lineNo = pars[i].getLineNumber();
                    idx = pars[i].getFileIndex();
                    break;
                }
                if (dp == null) {
                    dp = pars[i];
                    lineNo = pars[i].getLineNumber();
                    idx = pars[i].getFileIndex();
                    continue;
                }
                throw new DebuggerException(42, parOrig + ", file " + file);
            }
            if (dp == null) {
                throw new DebuggerException(28, parOrig + ", file " + file);
            }
        }
        if ((bp = parOrig != null ? BreakpointManager.removeBreakpoint(parOrig, file, progName) : BreakpointManager.removeBreakpoint(lineNo, file, fileIndex, progName)) != null) {
            returnCode = 0;
            return DebuggerException.getInfoMessage(9, parOrig + ", file " + path + eol);
        }
        throw new DebuggerException(28, parOrig + ", file " + path);
    }

    private static String listBreakpoints() {
        StringBuffer ret = new StringBuffer();
        Breakpoint[] bps = BreakpointManager.getBreakpoints();
        for (int i = 0; i < bps.length; ++i) {
            ret.append(bps[i] + eol);
        }
        returnCode = 0;
        return ret.toString();
    }

    private static String clearAllBreakpoints() {
        BreakpointManager.removeAllBreakpoints();
        returnCode = 0;
        return DebuggerException.getInfoMessage(10, eol);
    }

    private static String clearBreakpoint(int lineNo, String file, int fileIndex, String progName) throws DebuggerException {
        Breakpoint bp = BreakpointManager.removeBreakpoint(lineNo, file, fileIndex, progName);
        if (bp != null) {
            returnCode = 0;
            return DebuggerException.getInfoMessage(18, "" + lineNo + ", file " + file + eol);
        }
        throw new DebuggerException(29, "" + lineNo + ", file " + file);
    }

    private String showMonitors() {
        StringBuffer ret = new StringBuffer();
        Watch[] mons = BreakpointManager.getMonitors(this);
        if (mons != null) {
            for (int i = 0; i < mons.length; ++i) {
                ret.append(mons[i] + eol);
            }
        }
        return ret.toString();
    }

    private String listMonitors() {
        returnCode = 0;
        return this.showMonitors();
    }

    private String listThreads() {
        StringBuffer Return2 = new StringBuffer();
        ThreadObject[] threads = Debugger.getThreads(false, null);
        for (int i = 0; i < threads.length; ++i) {
            Return2.append(threads[i] + eol);
        }
        return Return2.toString();
    }

    private String setEnvMonitor(String envPropName, Condition cond, boolean enabled) {
        BreakpointManager.addEnvMonitor(envPropName, this.getHelper().acceptFromEnv(envPropName), cond, enabled);
        return DebuggerException.getInfoMessage(19, "'" + envPropName + "'" + eol);
    }

    private String clearEnvMonitor(String envPropName) throws DebuggerException {
        if (!BreakpointManager.removeEnvMonitor(envPropName)) {
            throw new DebuggerException(30, "'" + envPropName + "'");
        }
        returnCode = 0;
        return DebuggerException.getInfoMessage(11, "'" + envPropName + "'" + eol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setMonitor(VarName varname, Condition cond, String moduleName, String propName, boolean hex, boolean enabled, boolean addingDeferred) throws DebuggerException {
        Object[] current;
        boolean isOptimizable;
        block27: {
            if (this.status == 3) {
                throw new DebuggerException(9);
            }
            isOptimizable = !varname.containsVariables();
            current = null;
            try {
                current = this.setCurrentObjects(moduleName);
            }
            catch (DebuggerException ex) {
                if (addingDeferred) break block27;
                throw ex;
            }
        }
        try {
            String condVal;
            IscobolField field = this.findObjectVar(varname, isOptimizable);
            if (field == null && varname != null) {
                String constValue = this.findConstant(varname.getName(), false);
                if (constValue != null) {
                    throw new DebuggerException(13, "'" + varname.getName() + "'");
                }
                field = this.findGetProp(varname);
            }
            if (field == null) {
                throw new DebuggerException(7, varname != null ? "'" + varname.getName() + "'" : null);
            }
            if (field.getVar() instanceof CobolFile) {
                throw new DebuggerException(15, "'" + varname.getName() + "'");
            }
            IDebuggerHelper helper = this.getHelper();
            boolean isCobolVar = field.getVar() instanceof ICobolVar;
            boolean isExternal = false;
            if (isCobolVar) {
                for (ICobolVar cv = (ICobolVar)field.getVar(); cv != null && !isExternal; cv = cv.getIParent()) {
                    isExternal = helper.isExternal(cv.getName());
                }
            }
            if (hex && !isCobolVar) {
                throw new DebuggerException(15, "'" + varname.getName() + "'");
            }
            if (isCobolVar && ((ICobolVar)field.getVar()).isFinal()) {
                throw new DebuggerException(13, "'" + varname.getName() + "'");
            }
            if (field.getVar() instanceof Level88 && cond != null && (condVal = cond.getValue()) != null) {
                if (!condVal.equalsIgnoreCase("true") && !condVal.equalsIgnoreCase("false")) {
                    throw new DebuggerException(24, "'" + condVal + "'");
                }
                cond.setValue(false, condVal.toLowerCase());
            }
            if (propName != null) {
                if (field.getVar() instanceof BaseGUIControl) {
                    IObjectVar tmp = helper.getVarObject(4, ((BaseGUIControl)field.getVar()).getName(), false);
                    tmp.setIId(field.getVar());
                    field.setVar(tmp);
                } else if (!(field.getVar() instanceof INumericVar)) {
                    throw new DebuggerException(21, "'" + varname.getName() + "'");
                }
            } else if (field.getVar() instanceof BaseGUIControl) {
                throw new DebuggerException(22);
            }
            String cn = this.getCurrClassname();
            if (propName != null) {
                INumericVar handle = (INumericVar)field.getVar();
                String propValue = DebugUtilities.inquireProp(handle, propName, this.currProgramClass, false, false);
                BreakpointManager.addMonitor(handle, varname.getFullName(), cond, cn, propName, propValue, hex, enabled);
            } else {
                BreakpointManager.addMonitor(varname, isOptimizable ? field : null, field.getVar(), varname.getFullName(), cond, isExternal ? "external" : cn, hex, enabled);
            }
            returnCode = 0;
            StringBuffer msg = new StringBuffer();
            msg.append("'" + varname.getFullName() + "'");
            if (cond != null && cond.getType() != 0) {
                msg.append(", NOTIFY WHEN ");
                msg.append(cond);
            }
            if (!enabled) {
                msg.append(", DISABLED");
            }
            msg.append(eol);
            String string = DebuggerException.getInfoMessage(12, msg.toString());
            return string;
        }
        finally {
            if (!addingDeferred) {
                this.restoreCurrentObjects(current);
            }
        }
    }

    private String clearMonitor(VarName varname, String cls, String propName) throws DebuggerException {
        boolean ok = false;
        if (this.status == 3) {
            if (cls == null) {
                throw new DebuggerException(9);
            }
            ok = BreakpointManager.removeMonitor(cls, varname.getFullName(), propName);
        } else {
            if (cls == null) {
                cls = this.getCurrClassname();
            }
            ok = BreakpointManager.removeMonitor(cls, varname.getFullName(), propName);
        }
        if (ok) {
            returnCode = 0;
            return DebuggerException.getInfoMessage(13, "'" + varname.getFullName() + "'" + eol);
        }
        throw new DebuggerException(11, "'" + varname.getFullName() + "'");
    }

    private String clearAllMonitors() {
        BreakpointManager.removeAllMonitors();
        returnCode = 0;
        return DebuggerException.getInfoMessage(14, eol);
    }

    private String Continue() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.status = 4;
        this.stepNumber = 1;
        returnCode = 0;
        return "";
    }

    private String stepInto(StepIntoCommand cmd) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.status = 1;
        this.stepNumber = cmd.getStepNumber() > 0 ? cmd.getStepNumber() : 1;
        returnCode = 0;
        return "";
    }

    private String stepOver() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.status = 2;
        this.stepNumber = 1;
        this.blockDebugger = false;
        this.intoDeep = this.parStack.size();
        this.intoDeepPrg = this.getModuleStackSize();
        returnCode = 0;
        return "";
    }

    private boolean shouldCheckDynamic() {
        return lastCmd != 6;
    }

    static boolean checkDynamicIndexes(ICobolVar cVar, int[] idxs) {
        return !cVar.isInDynamicTable() || cVar.existsDynamicElement(idxs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String displayTree(DisplayCommand cmd) throws DebuggerException {
        boolean deferred = cmd.isDeferredIfNotRunning();
        VarName varname = cmd.getVarName();
        boolean showHex = cmd.displayAsHex();
        boolean showText = cmd.displayAsText();
        String moduleName = cmd.getClassName();
        short showChildren = cmd.getShowChildren();
        if (this.status == 3) {
            if (deferred) {
                deferredDisplayCommands.add(cmd);
                returnCode = 0;
                return "";
            }
            throw new DebuggerException(9);
        }
        Object[] current = this.setCurrentObjects(moduleName);
        try {
            IscobolField field;
            if (moduleName == null) {
                moduleName = this.getCurrClassname();
            }
            int[] indexes = null;
            if (varname.hasSubscript()) {
                indexes = this.resolveSubscripts(varname);
                if (indexes == null) {
                    throw new DebuggerException(5);
                }
                varname.clearSubscripts();
            }
            if ((field = this.findObjectVar(varname, false, true)) == null) {
                String constValue = this.findConstant(varname.getName(), !showHex);
                if (constValue != null) {
                    int len;
                    String v;
                    if (showHex) {
                        v = DebugUtilities.buildValueStringLevel78(constValue, showText);
                        len = constValue.length() / 2;
                    } else {
                        v = constValue;
                        len = constValue.length();
                    }
                    Debugger.addTree(DebugUtilities.buildTree(varname.getFullName(), v, showHex, 0, len), moduleName);
                    returnCode = 0;
                    String string = DebuggerException.getInfoMessage(15, "'" + varname.getFullName() + "'" + eol);
                    return string;
                }
                field = this.findGetProp(varname);
            }
            if (field == null) {
                throw new DebuggerException(7, varname != null ? "'" + varname.getName() + "'" : null);
            }
            if (field.getVar() instanceof ICobolVar) {
                if (varname.hasSubvalue()) {
                    indexes = null;
                }
                ICobolVar cVar = (ICobolVar)field.getVar();
                if (indexes != null && !Debugger.checkDynamicIndexes(cVar, indexes)) {
                    Debugger.addTree(DebugUtilities.buildTree(varname.getFullName(), DebuggerConstants.NULL_VALUE, showHex), moduleName);
                } else {
                    try {
                        Debugger.addTree(DebugUtilities.buildTree(varname.getFullName(), cVar, indexes, showHex, showText, showChildren), moduleName);
                    }
                    catch (IscobolRuntimeException e) {
                        int err;
                        String other = null;
                        if (e.getErrNum() == 1) {
                            err = 6;
                        } else {
                            err = 26;
                            other = ": DISPLAY '" + varname.getName() + "' (" + e + ")";
                        }
                        throw new DebuggerException(err, other);
                    }
                    catch (NullPointerException e) {
                        Debugger.addTree(DebugUtilities.buildTree(varname.getFullName(), DebuggerConstants.NULL_VALUE, showHex), moduleName);
                    }
                    catch (Exception e) {
                        if (e instanceof ClassCastException && cVar.isInDynamicTable()) {
                            throw new DebuggerException(6);
                        }
                        throw new DebuggerException(26, ": DISPLAY '" + varname.getName() + "' (" + e + ")");
                    }
                }
            } else if (field.getVar() instanceof Level88) {
                Level88 l88 = (Level88)field.getVar();
                ICobolVar cVar = l88.getParent();
                if (indexes != null && !Debugger.checkDynamicIndexes(cVar, indexes)) {
                    Debugger.addTree(DebugUtilities.buildTree(varname.getFullName(), DebuggerConstants.NULL_VALUE, showHex), moduleName);
                } else {
                    try {
                        if (indexes != null) {
                            l88 = l88.intAt(indexes);
                        }
                        Debugger.addTree(DebugUtilities.buildTree(varname.getFullName(), l88, showHex), moduleName);
                    }
                    catch (Exception ex) {
                        Debugger.addTree(DebugUtilities.buildTree(varname.getFullName(), "false", showHex), moduleName);
                    }
                }
            } else if (field.getVar() instanceof CobolFile) {
                Debugger.addTree(DebugUtilities.buildTree(varname.getFullName(), Debugger.getFileInfo((CobolFile)field.getVar()), showHex), moduleName);
            } else {
                if (indexes != null) {
                    field.adjustIndexes(indexes);
                    field.setVar(Debugger.findObjectVarAt(field.getVar(), indexes));
                }
                Debugger.addTree(DebugUtilities.buildTree(varname.getFullName(), DebugUtilities.toString(field.getVar()), showHex), moduleName);
            }
            returnCode = 0;
            String string = DebuggerException.getInfoMessage(15, "'" + varname.getFullName() + "'" + eol);
            return string;
        }
        finally {
            this.restoreCurrentObjects(current);
        }
    }

    static String getFileInfo(CobolFile cf) {
        String str = "Closed ";
        switch (cf.getOpenMode()) {
            case 1: {
                str = "Opened INPUT ";
                break;
            }
            case 2: {
                str = "Opened OUTPUT ";
                break;
            }
            case 3: {
                str = "Opened I-O ";
                break;
            }
            case 6: {
                str = "Opened EXTEND ";
            }
        }
        str = str + "last file-status = '" + cf.getFileStatus() + "'";
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String display(VarName varname, String moduleName, String propName, boolean propHex, boolean full, boolean offsetLen) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        Object[] current = this.setCurrentObjects(moduleName);
        try {
            IscobolField field = this.findObjectVar(varname, true);
            if (field == null) {
                String constValue = this.findConstant(varname.getName(), true);
                if (constValue != null) {
                    dbgVar = varname;
                    dbgVar.setType(14);
                    dbgVar.setValue(constValue);
                    dbgVar.setOffset(0);
                    dbgVar.setLength(constValue != null ? constValue.length() : 0);
                } else {
                    field = this.findGetProp(varname);
                    if (field == null) {
                        throw new DebuggerException(7, varname != null ? "'" + varname.getName() + "'" : null);
                    }
                }
            }
            if (field != null) {
                dbgVar = varname;
                if (propName != null) {
                    if (offsetLen) {
                        throw new DebuggerException(5);
                    }
                    if (field.getVar() instanceof BaseGUIControl) {
                        IObjectVar tmp = this.getHelper().getVarObject(4, ((BaseGUIControl)field.getVar()).getName(), false);
                        tmp.setIId(field.getVar());
                        field.setVar(tmp);
                    } else if (!(field.getVar() instanceof INumericVar)) {
                        throw new DebuggerException(21, "'" + varname.getName() + "'");
                    }
                    dbgVar.setOffset(0);
                    dbgVar.setLength(0);
                    dbgVar.setType(15);
                    dbgVar.setValue(DebugUtilities.inquireProp((INumericVar)field.getVar(), propName, this.currProgramClass, propHex, full));
                } else {
                    if (field.getVar() instanceof BaseGUIControl) {
                        throw new DebuggerException(offsetLen ? 15 : 22);
                    }
                    if (field.getVar() instanceof ICobolVar) {
                        ICobolVar cVar = (ICobolVar)field.getVar();
                        dbgVar.setType(DebugUtilities.getVarType(cVar, this.getHelper()));
                        try {
                            dbgVar.setValue(DebugUtilities.toString(cVar, full ? Integer.MAX_VALUE : DebugUtilities.MAX_DISPLAY_LENGTH()));
                            dbgVar.setOffset(cVar.getOffset());
                            dbgVar.setLength(cVar instanceof IPicAnyLength ? cVar.getLength() : cVar.getMaxLength());
                        }
                        catch (Exception ex) {
                            dbgVar.setValue(DebuggerConstants.NULL_VALUE);
                            dbgVar.setOffset(0);
                            dbgVar.setLength(0);
                        }
                    } else if (field.getVar() instanceof Level88) {
                        if (offsetLen) {
                            throw new DebuggerException(15);
                        }
                        Level88 l88 = (Level88)field.getVar();
                        dbgVar.setType(12);
                        dbgVar.setValue(l88.toString(full ? Integer.MAX_VALUE : DebugUtilities.MAX_DISPLAY_LENGTH()));
                        dbgVar.setOffset(0);
                        dbgVar.setLength(0);
                    } else if (field.getVar() instanceof CobolFile) {
                        if (offsetLen) {
                            throw new DebuggerException(15);
                        }
                        CobolFile cf = (CobolFile)field.getVar();
                        String str = Debugger.getFileInfo(cf);
                        dbgVar.setType(13);
                        dbgVar.setValue(str);
                        dbgVar.setOffset(0);
                        dbgVar.setLength(0);
                    } else if (field.getVar() == NULL_OBJECT) {
                        dbgVar.setType(2);
                        dbgVar.setValue(DebuggerConstants.NULL_VALUE);
                        dbgVar.setOffset(0);
                        dbgVar.setLength(0);
                    } else {
                        dbgVar.setType(2);
                        String val = DebugUtilities.toString(field.getVar());
                        dbgVar.setValue(val);
                        dbgVar.setOffset(0);
                        dbgVar.setLength(val == DebuggerConstants.NULL_VALUE || val == DebuggerConstants.ERROR_VALUE ? 0 : val.length());
                    }
                }
            }
            returnCode = 0;
            StringBuffer Return2 = new StringBuffer("+ " + varname.getFullName());
            if (propName != null) {
                Return2.append("::" + propName);
            }
            Return2.append(" = " + dbgVar.getValue() + eol);
            String string = Return2.toString();
            return string;
        }
        finally {
            this.restoreCurrentObjects(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String displayAsHexString(VarName varname, String moduleName, boolean full) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        Object[] current = this.setCurrentObjects(moduleName);
        try {
            IscobolField field = this.findObjectVar(varname, true);
            String constValue = this.findConstant(varname.getName(), false);
            StringBuffer ret = new StringBuffer();
            if (constValue != null) {
                dbgVar = varname;
                String v = DebugUtilities.buildValueStringLevel78(constValue, false);
                dbgVar.setValue(v);
                dbgVar.setType(14);
                dbgVar.setOffset(0);
                dbgVar.setLength(constValue.length());
                ret.append(v);
            } else {
                if (field == null) {
                    field = this.findGetProp(varname);
                }
                if (field == null) {
                    throw new DebuggerException(7, varname != null ? "'" + varname.getName() + "'" : null);
                }
                if (field.getVar() instanceof Level88) {
                    dbgVar = varname;
                    dbgVar.setType(12);
                    try {
                        dbgVar.setValue(DebugUtilities.toString(field.getVar(), full ? Integer.MAX_VALUE : DebugUtilities.MAX_DISPLAY_LENGTH()));
                    }
                    catch (Exception ex) {
                        dbgVar.setValue(DebuggerConstants.NULL_VALUE);
                    }
                } else {
                    if (!(field.getVar() instanceof ICobolVar)) {
                        throw new DebuggerException(15, "'" + varname.getName() + "'");
                    }
                    dbgVar = varname;
                    ICobolVar cVar = (ICobolVar)field.getVar();
                    dbgVar.setType(DebugUtilities.getVarType(cVar, this.getHelper()));
                    try {
                        ret.append(DebugUtilities.toHexString(cVar, full ? Integer.MAX_VALUE : DebugUtilities.MAX_DISPLAY_LENGTH()));
                        dbgVar.setValue(ret.toString());
                    }
                    catch (Exception ex) {
                        dbgVar.setValue(DebuggerConstants.NULL_VALUE);
                        ret.append(DebuggerConstants.NULL_VALUE);
                    }
                }
            }
            returnCode = 0;
            String string = ret.insert(0, "+ " + varname.getFullName() + " = ").append(eol).toString();
            return string;
        }
        finally {
            this.restoreCurrentObjects(current);
        }
    }

    private String findConstant(String varName, boolean showTextValue) {
        Object prog = null;
        if (this.currMethod != null) {
            prog = this.currMethod;
        } else if (this.currProgram != null) {
            prog = this.currProgram;
        }
        if (prog != null) {
            return DebugUtilities.findConstant(varName, prog, showTextValue);
        }
        return null;
    }

    private String let(VarName varname, String moduleName, String propName, String value) throws DebuggerException {
        IscobolField field;
        Object[] current;
        block27: {
            if (this.status == 3) {
                throw new DebuggerException(9);
            }
            current = this.setCurrentObjects(moduleName);
            field = this.findObjectVar(varname, true);
            if (field == null && varname != null) {
                String constValue = this.findConstant(varname.getName(), false);
                if (constValue != null) {
                    throw new DebuggerException(13, "'" + varname.getName() + "'");
                }
                field = this.findSetProp(varname);
            }
            if (field == null) {
                throw new DebuggerException(7, varname != null ? "'" + varname.getName() + "'" : null);
            }
            if (propName != null) {
                Object tmp;
                if (field.getVar() instanceof BaseGUIControl) {
                    tmp = this.getHelper().getVarObject(4, ((BaseGUIControl)field.getVar()).getName(), false);
                    tmp.setIId(field.getVar());
                    field.setVar(tmp);
                } else if (!(field.getVar() instanceof INumericVar)) {
                    throw new DebuggerException(21, "'" + varname.getName() + "'");
                }
                DebugUtilities.modifyProp((INumericVar)field.getVar(), propName, value, this.currProgramClass);
                returnCode = 0;
                tmp = "+ new value of " + varname.getFullName() + "::" + propName + " is " + DebugUtilities.inquireProp((INumericVar)field.getVar(), propName, this.currProgramClass, false, false) + eol;
                return tmp;
            }
            if (field.getVar() instanceof BaseGUIControl) {
                throw new DebuggerException(22);
            }
            if (field.getVar() instanceof Level88) {
                if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                    throw new DebuggerException(24, "'" + value + "'");
                }
                Level88 l88 = (Level88)field.getVar();
                try {
                    l88.setValue(Boolean.valueOf(value));
                    String string = "+ new value of " + varname.getFullName() + " is " + l88 + eol;
                    return string;
                }
                catch (Exception ex) {
                    throw new DebuggerException(26, ": LET '" + varname.getName() + "' (" + ex + ")");
                }
            }
            if (!(field.getVar() instanceof ICobolVar)) break block27;
            ICobolVar cVar = (ICobolVar)field.getVar();
            if (cVar.isFinal()) {
                throw new DebuggerException(13, "'" + varname.getName() + "'");
            }
            try {
                IDebuggerHelper helper = this.getHelper();
                ICobolVar srcValue = cVar instanceof INumericVar ? helper.numVal(value, cVar.isDecimalPointComma()) : (cVar instanceof IPicNumEdit ? helper.numValC(value, cVar.isDecimalPointComma(), ((IPicNumEdit)cVar).getCurrencyChar()) : helper.getStrLiteral(value));
                cVar.setValue(srcValue);
                returnCode = 0;
                String string = "+ new value of " + varname.getFullName() + " is " + cVar + eol;
                return string;
            }
            catch (Exception ex) {
                throw new DebuggerException(26, ":LET '" + varname.getName() + "' (" + ex + ")");
            }
        }
        if (field instanceof IscobolProp && field.isCobolVar()) {
            try {
                IDebuggerHelper helper = this.getHelper();
                ICobolVar srcValue = INumericVar.class.isAssignableFrom(field.getType()) ? helper.numVal(value, false) : (IPicNumEdit.class.isAssignableFrom(field.getType()) ? helper.numValC(value, false, '$') : helper.getStrLiteral(value));
                ((IscobolProp)field).setValue(srcValue, this);
                returnCode = 0;
                String string = "+ new value of " + varname.getFullName() + " is " + srcValue + eol;
                return string;
            }
            catch (Throwable ex) {
                if (ex.getCause() != null) {
                    ex = ex.getCause();
                }
                throw new DebuggerException(26, ":LET '" + varname.getName() + "' (" + ex + ")");
            }
        }
        throw new DebuggerException(15, "'" + varname.getName() + "'");
        finally {
            this.restoreCurrentObjects(current);
        }
    }

    private String letAsHex(VarName varname, String moduleName, String value) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        Object[] current = this.setCurrentObjects(moduleName);
        try {
            IscobolField field = this.findObjectVar(varname, true);
            if (field == null && varname != null) {
                String constValue = this.findConstant(varname.getName(), false);
                if (constValue != null) {
                    throw new DebuggerException(13, "'" + varname.getName() + "'");
                }
                field = this.findSetProp(varname);
            }
            if (field == null) {
                throw new DebuggerException(7, varname != null ? "'" + varname.getName() + "'" : null);
            }
            if (field.getVar() instanceof ICobolVar) {
                ICobolVar cVar = (ICobolVar)field.getVar();
                if (cVar.isFinal()) {
                    throw new DebuggerException(13, "'" + varname.getName() + "'");
                }
                boolean ok = false;
                try {
                    ok = DebugUtilities.setValueAsHex(cVar, value);
                }
                catch (Exception ex) {
                    throw new DebuggerException(26, ": LET '" + varname.getName() + "' (" + ex + ")");
                }
                if (ok) {
                    returnCode = 0;
                    String string = "+ new value of " + varname.getFullName() + " is " + DebugUtilities.toHexString(cVar, DebugUtilities.MAX_DISPLAY_LENGTH()) + eol;
                    return string;
                }
                throw new DebuggerException(32, "'" + value + "'");
            }
            if (field instanceof IscobolProp && field.isCobolVar()) {
                try {
                    ((IscobolProp)field).setHexValue(value, this);
                }
                catch (DebuggerException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    if (ex.getCause() != null) {
                        ex = ex.getCause();
                    }
                    throw new DebuggerException(26, ": LET '" + varname.getName() + "' (" + ex + ")");
                }
                returnCode = 0;
                String string = "+ new value of " + varname.getFullName() + " is " + value + eol;
                return string;
            }
            throw new DebuggerException(15, "'" + varname.getName() + "'");
        }
        finally {
            this.restoreCurrentObjects(current);
        }
    }

    private String stepOutOfParagraph() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.status = 5;
        this.stepNumber = 1;
        this.blockDebugger = false;
        this.intoDeep = this.parStack.size();
        returnCode = 0;
        return "";
    }

    private String stepOutOfProgram() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.status = 6;
        this.stepNumber = 1;
        this.blockDebugger = false;
        this.intoDeepPrg = this.getModuleStackSize();
        returnCode = 0;
        return "";
    }

    ParagraphObject[] getParStack() {
        ParagraphObject[] pars = new ParagraphObject[this.parStack.size()];
        this.parStack.toArray(pars);
        return pars;
    }

    private String traceOn(TraceOnCommand cmd) {
        Config.setProperty("iscobol.tracelevel", "" + cmd.getTraceLevel());
        String logfile = cmd.getLogfileName();
        if (logfile != null && logfile.length() > 0) {
            Config.setProperty("iscobol.logfile", logfile);
        }
        returnCode = 0;
        return DebuggerException.getInfoMessage(16, "tracelevel = " + cmd.getTraceLevel() + (logfile != null ? ", logfile = " + LoggerFactory.getLogFile() : "") + eol);
    }

    private String traceOff() throws DebuggerException {
        if (LoggerFactory.getTraceLevel() == 0) {
            throw new DebuggerException(17);
        }
        Config.setProperty("iscobol.tracelevel", "0");
        returnCode = 0;
        return DebuggerException.getInfoMessage(17, eol);
    }

    public static void enterPar(int lineNo, String fileName, String parName, int parNum, Class progClass, Object prog, Object method) {
        try {
            Debugger.intEnterPar(lineNo, fileName, -1, parName, parNum, progClass, prog, method, null, false);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void enterPar(int lineNo, String fileName, String parName, int parNum, Class progClass, Object prog, Object method, String methodName) {
        try {
            Debugger.intEnterPar(lineNo, fileName, -1, parName, parNum, progClass, prog, method, methodName, false);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void enterPar(int lineNo, String fileName, int fileIndex, String parName, int parNum, Class progClass, Object prog, Object method, String methodName) {
        try {
            Debugger.intEnterPar(lineNo, fileName, fileIndex, parName, parNum, progClass, prog, method, methodName, false);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void enterParExt(int lineNo, String fileName, int fileIndex, String parName, int parNum, Class progClass, Object prog, Object method, String methodName, boolean isInDeclaratives) throws GotoException {
        Debugger.intEnterPar(lineNo, fileName, fileIndex, parName, parNum, progClass, prog, method, methodName, isInDeclaratives);
    }

    private static void intEnterPar(int lineNo, String fileName, int fileIndex, String parName, int parNum, Class progClass, Object prog, Object method, String methodName, boolean isInDeclaratives) throws GotoException {
        Debugger dbg = null;
        String progName = null;
        AppData ad = Debugger.getAppData();
        if (ad.parStackLog != null) {
            progName = DebugUtilities.getProgName(prog, progClass);
            ad.parStackLog.info("ENTER PARAGRAPH '" + parName + "' [" + progName + (methodName != null ? ":>" + methodName : "") + "]");
        }
        if (globalStatus.getValue() != 0) {
            dbg = Debugger.getCurrentDebugger();
            boolean isLastPar = dbg.lastPerformParnum == 0 || parNum == dbg.lastPerformParnum;
            String classLoc = Debugger.getClassLocation(progClass);
            String epName = null;
            if (method == progClass) {
                method = null;
                epName = methodName;
                methodName = null;
            }
            ParagraphObject po = new ParagraphObject(fileName, fileIndex, parName, isLastPar, progClass, prog, progName != null ? progName : DebugUtilities.getProgName(prog, progClass), classLoc, method, methodName, dbg.progStack.size(), dbg.methodStack.size(), lineNo, isInDeclaratives, parNum);
            if (epName != null) {
                po.setEntryPointName(epName);
            }
            dbg.parStack.push(po);
            dbg.currMethodName = methodName;
            if (dbg.threadObj.getDescription() == null) {
                dbg.threadObj.setDescription(parName + " [" + progClass.getName() + "]");
            }
            dbg.oldLine = dbg.currLine;
            dbg.oldFile = dbg.currFile;
            dbg.oldProgramClass = dbg.currProgramClass;
            dbg.oldFileIndex = dbg.currFileIndex;
            dbg.currLine = lineNo;
            dbg.currFile = fileName;
            dbg.currFileIndex = fileIndex;
            dbg.setCurrProgramClass(progClass);
            dbg.currProgramClassLocation = classLoc;
            if (dbg.currMethod != method) {
                dbg.updateMethodObj(method);
            }
            dbg.currMethodClass = method != null ? method.getClass() : null;
            dbg.currMethod = method;
            if (dbg.status != 11) {
                dbg.blockDebugger = false;
            }
            if (dbg.currProgram != prog) {
                dbg.updateProgramObj(prog);
            }
            dbg.currProgram = prog;
            dbg.debug(parName, DebugUtilities.getSectionName(progClass, parNum, isInDeclaratives));
        } else {
            dbg = Debugger.getCurrentDebugger();
            boolean isLastPar = dbg.lastPerformParnum == 0 || parNum == dbg.lastPerformParnum;
            dbg.parStack.push(new ParagraphObject(fileName, fileIndex, parName, isLastPar, progClass, prog, progName != null ? progName : DebugUtilities.getProgName(prog, progClass), null, method, methodName, dbg.progStack.size(), dbg.methodStack.size(), lineNo, isInDeclaratives, parNum));
            dbg.currMethodName = methodName;
        }
    }

    public static void exitPar() {
        ParagraphObject par = null;
        Debugger dbg = Debugger.getCurrentDebugger();
        if (!dbg.parStack.isEmpty()) {
            par = dbg.parStack.pop();
            if (globalStatus.getValue() != 0) {
                if (dbg.appData.parStackLog != null) {
                    dbg.appData.parStackLog.info("EXIT PARAGRAPH '" + par.getName() + "' [" + par.getProgName() + "]");
                }
                dbg.blockDebugIfNecessary(par);
                if (par.isLastPar()) {
                    dbg.lastPerformParnum = 0;
                }
            } else if (dbg.appData.parStackLog != null) {
                dbg.appData.parStackLog.info("EXIT PARAGRAPH '" + par.getName() + "' [" + par.getProgName() + "]");
            }
        }
    }

    public static void outlinePerform(int lineNo, String fileName, int lastParnum) {
        Debugger dbg = Debugger.getCurrentDebugger();
        dbg.lastPerformParnum = lastParnum;
        try {
            dbg.intStatement(lineNo, fileName, -1);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void outlinePerform(int lineNo, String fileName, int fileIndex, int lastParnum) {
        Debugger dbg = Debugger.getCurrentDebugger();
        dbg.lastPerformParnum = lastParnum;
        try {
            dbg.intStatement(lineNo, fileName, fileIndex);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static boolean outlinePerformExt(int lineNo, String fileName, int fileIndex, int lastParnum) throws GotoException {
        Debugger dbg = Debugger.getCurrentDebugger();
        dbg.lastPerformParnum = lastParnum;
        return dbg.intStatement(lineNo, fileName, fileIndex);
    }

    public static void statement(int lineNo, String fileName, String keyWord) {
        Debugger dbg = Debugger.getCurrentDebugger();
        try {
            dbg.intStatement(lineNo, fileName, -1);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void statement(int lineNo, String fileName) {
        Debugger dbg = Debugger.getCurrentDebugger();
        try {
            dbg.intStatement(lineNo, fileName, -1);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void statement(int lineNo, String fileName, int fileIndex) {
        Debugger dbg = Debugger.getCurrentDebugger();
        try {
            dbg.intStatement(lineNo, fileName, fileIndex);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static boolean statementExt(int lineNo, String fileName, int fileIndex) throws GotoException {
        Debugger dbg = Debugger.getCurrentDebugger();
        return dbg.intStatement(lineNo, fileName, fileIndex);
    }

    private boolean intStatement(int lineNo, String fileName, int fileIndex) throws GotoException {
        if (globalStatus.getValue() != 0) {
            this.oldLine = this.currLine;
            this.oldFile = this.currFile;
            this.oldFileIndex = this.currFileIndex;
            this.oldProgramClass = this.currProgramClass;
            this.currLine = lineNo;
            this.currFile = fileName;
            this.currFileIndex = fileIndex;
            if (!this.parStack.isEmpty()) {
                ParagraphObject po = this.parStack.peek();
                po.setLine(this.currLine);
                po.setFile(this.currFile);
                po.setFileIndex(this.currFileIndex);
            }
            if (lineNo < 0) {
                switch (this.status) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: {
                        return false;
                    }
                }
                return true;
            }
            if ((this.status == 2 || this.status == 12) && this.intoDeep == this.parStack.size() && this.intoDeepPrg == this.getModuleStackSize()) {
                this.blockDebugger = true;
            }
            return this.debug(null, null);
        }
        return true;
    }

    public static void enterMethod(Class progClass, Object prog, Object method) {
        Debugger.enterMethod(progClass, prog, method, null);
    }

    public static void enterMethod(Class progClass, Object prog, Object method, String methodName) {
        Debugger dbg = null;
        if (globalStatus.getValue() != 0) {
            dbg = Debugger.getCurrentDebugger();
            dbg.methodStack.push(new MethodObject(method, progClass, prog, methodName));
            if (methodName != null && dbg.appData.parStackLog != null) {
                dbg.appData.parStackLog.info("ENTER METHOD " + progClass.getName() + ":>" + methodName + " {");
            }
            dbg.updateMethodObj(method);
            dbg.currMethod = method;
            dbg.currMethodName = methodName;
            dbg.currMethodClass = method.getClass();
            dbg.setCurrProgramClass(progClass);
            dbg.currProgram = prog;
            dbg.executeDeferredOperations();
        } else {
            dbg = Debugger.getCurrentDebugger();
            dbg.methodStack.push(new MethodObject(method, progClass, prog, methodName));
            if (methodName != null && dbg.appData.parStackLog != null) {
                dbg.appData.parStackLog.info("ENTER METHOD " + progClass.getName() + ":>" + methodName + " {");
            }
            dbg.currMethodName = methodName;
        }
    }

    private boolean blockDebugIfNecessary(ParagraphObject po) {
        int stat = Debugger.getStatus();
        if ((stat == 5 || stat == 9) && this.intoDeep > this.parStack.size() || (stat == 2 || stat == 12) && this.intoDeep >= this.parStack.size() && this.intoDeepPrg >= this.getModuleStackSize() && po.isLastPar()) {
            this.blockDebugger = true;
        }
        return this.blockDebugger;
    }

    private boolean blockDebugIfNecessary() {
        int stackSize = this.getModuleStackSize();
        if ((this.status == 6 || this.status == 10) && this.intoDeepPrg > stackSize || (this.status == 2 || this.status == 12) && this.intoDeep >= this.parStack.size() && this.intoDeepPrg >= stackSize) {
            this.blockDebugger = true;
        }
        return this.blockDebugger;
    }

    private int getModuleStackSize() {
        return this.progStack.size() + this.methodStack.size();
    }

    public static void exitMethod() {
        Debugger.getCurrentDebugger().intExitMethod();
    }

    private void intExitMethod() {
        MethodObject methodObj = this.methodStack.pop();
        this.removeMethParagraphs(this.methodStack.size() + 1);
        if (this.currMethodName != null && this.appData.parStackLog != null) {
            this.appData.parStackLog.info("EXIT METHOD " + methodObj.getProgramClass().getName() + ":>" + this.currMethodName + " }");
        }
        if (!this.parStack.isEmpty()) {
            ParagraphObject po = this.parStack.peek();
            this.currMethodName = po.getMethodName();
            if (globalStatus.getValue() != 0) {
                if (this.currMethod != po.getMethod()) {
                    this.updateMethodObj(po.getMethod());
                }
                this.currMethod = po.getMethod();
                Class clazz = this.currMethodClass = this.currMethod != null ? this.currMethod.getClass() : null;
                if (this.currProgram != po.getProgram()) {
                    this.updateProgramObj(po.getProgram());
                }
                this.currProgram = po.getProgram();
                this.setCurrProgramClass(po.getProgClass());
                if (po.isLastPar()) {
                    this.lastPerformParnum = 0;
                }
                if (!this.blockDebugger && !this.blockDebugIfNecessary(po)) {
                    this.blockDebugIfNecessary();
                }
            }
        }
    }

    private void addMonitors(String key, String classname) {
        Watch[] mons = BreakpointManager.getMonitorToAdd(key);
        if (mons.length > 0) {
            for (int i = 0; i < mons.length; ++i) {
                int retSave = returnCode;
                try {
                    this.setMonitor(mons[i].getVarName(), mons[i].getCondition(), classname, mons[i].getPropName(), mons[i].isHexadecimal(), mons[i].isEnabled(), true);
                }
                catch (DebuggerException e) {
                    String msg = e.getMessage();
                    this.out.println("- set monitor failed: " + msg.substring(2));
                }
                returnCode = retSave;
            }
            BreakpointManager.removeMonitorToAdd(key);
        }
    }

    private void executeDeferredOperations() {
        String cls = this.getCurrClassname();
        this.addMonitors(cls, cls);
        this.addMonitors("external", null);
        while (!deferredDisplayCommands.isEmpty()) {
            try {
                this.displayTree((DisplayCommand)deferredDisplayCommands.remove(0));
            }
            catch (DebuggerException e) {
                String msg = e.getMessage();
                this.out.println("- display -tree failed: " + msg.substring(2));
            }
        }
    }

    public static void enterProgram(String fileName, Object prg) {
        Debugger dbg = null;
        if (globalStatus.getValue() != 0) {
            dbg = Debugger.getCurrentDebugger();
            dbg.progStack.push(prg);
            dbg.setCurrProgramClass(prg.getClass());
            if (dbg.currProgram != prg) {
                dbg.updateProgramObj(prg);
            }
            dbg.currProgram = prg;
            dbg.oldFile = dbg.currFile;
            dbg.currFile = fileName;
            dbg.currFileIndex = -1;
            boolean bl = dbg.blockDebugger = dbg.status == 11;
            if (prg != null) {
                dbg.executeDeferredOperations();
            }
        } else {
            dbg = Debugger.getCurrentDebugger();
            dbg.progStack.push(prg);
        }
    }

    public static void exitProgram() {
        Debugger dbg = Debugger.getCurrentDebugger();
        if (dbg.currMethod == null) {
            dbg.intExitProgram();
        } else {
            dbg.intExitMethod();
        }
    }

    private void setCurrProgramClass(Class clazz) {
        this.currProgramClass = clazz;
        this.currProgramClassLocation = Debugger.getClassLocation(clazz);
        this.hyphenRepl = (char)95;
        this.cod1 = false;
        try {
            for (String opt : DebugUtilities.getCompilerOptions(clazz)) {
                if ("-smfu".equalsIgnoreCase(opt)) {
                    this.hyphenRepl = (char)36;
                } else {
                    if (!"-cod1".equalsIgnoreCase(opt)) continue;
                    this.cod1 = true;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getClassLocation(Class clazz) {
        String[] s = classLocations.get(clazz);
        if (s == null) {
            File classLoc;
            s = new String[1];
            if (clazz.getClassLoader() instanceof CallLoader.LoaderWithTime && (classLoc = ((CallLoader.LoaderWithTime)clazz.getClassLoader()).getClassLocation()).isDirectory()) {
                s[0] = classLoc.getAbsolutePath();
            }
            classLocations.put(clazz, s);
        }
        return s[0];
    }

    private void intExitProgram() {
        if (globalStatus.getValue() != 0) {
            this.progStack.pop();
            this.removeProgParagraphs(this.progStack.size() + 1);
            if (!this.parStack.isEmpty()) {
                ParagraphObject po = this.parStack.peek();
                this.currMethodName = po.getMethodName();
                this.setCurrProgramClass(po.getProgClass());
                if (this.currProgram != po.getProgram()) {
                    this.updateProgramObj(po.getProgram());
                }
                this.currProgram = po.getProgram();
                if (this.currMethod != po.getMethod()) {
                    this.updateMethodObj(po.getMethod());
                }
                this.currMethod = po.getMethod();
                Class clazz = this.currMethodClass = this.currMethod != null ? this.currMethod.getClass() : null;
                if (po.isLastPar()) {
                    this.lastPerformParnum = 0;
                }
                this.blockDebugIfNecessary(po);
            }
            if (!this.blockDebugger) {
                this.blockDebugIfNecessary();
            }
        } else {
            this.progStack.pop();
            this.removeProgParagraphs(this.progStack.size() + 1);
        }
    }

    public static void exit() {
        Debugger.exit(0);
    }

    public static void exit(int exitCode) {
        int gs = globalStatus.getValue();
        if (gs != 0 && gs != 3) {
            Debugger.writeResponse(new DebugResponse(103, ""));
        }
        System.exit(exitCode);
    }

    public static void stop(String label) {
        Debugger.stop(null, null, 0, true, label);
    }

    public static void stop(String inFile, String outFile, int recLen, boolean lineSeq, String label) {
        IDebuggerHelper helper = Debugger.getCurrentDebugger().getHelper();
        helper.displayUponSysOut(false, label, outFile, recLen, lineSeq);
        if (globalStatus.getValue() != 0 && globalStatus.getValue() != 3) {
            globalStatus.setValue(5);
        } else {
            helper.acceptFromConsole(inFile);
        }
    }

    private void removeProgParagraphs(int progStackSize) {
        ParagraphObject par;
        int s = this.parStack.size();
        for (int i = s - 1; i >= 0 && (par = (ParagraphObject)this.parStack.elementAt(i)).getProgStackSize() == progStackSize; --i) {
            this.parStack.remove(i);
        }
    }

    private void removeMethParagraphs(int methStackSize) {
        ParagraphObject par;
        int s = this.parStack.size();
        for (int i = s - 1; i >= 0 && (par = (ParagraphObject)this.parStack.elementAt(i)).getMethStackSize() == methStackSize; --i) {
            this.parStack.remove(i);
        }
    }

    private static void suspend() {
        globalStatus.setValue(1);
    }

    static void setSuspending() {
        globalStatus.setValue(5);
    }

    private static void resume() {
        Debugger.resume(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resume(int gs) {
        globalStatus.setValue(gs);
        GlobalStatus globalStatus = Debugger.globalStatus;
        synchronized (globalStatus) {
            Debugger.globalStatus.notifyAll();
        }
    }

    public static void attach(InputStream in, OutputStream out) {
        Debugger.attach(in, out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attach(InputStream in, OutputStream out, boolean remote) {
        Object msg;
        Debugger.suspend();
        DebugResponse resp = null;
        if (activeDebugger == null) {
            if (remote) {
                resp = new DebugResponse(0, "", 2);
                msg = IscobolSystem.isAS() ? "isCOBOL Application Server" : "Loading...";
                resp.setInfo(new DebugResponse.DebugInfo((String)msg));
            }
        } else {
            long timestamp;
            String sourceFile;
            msg = debuggerInstances;
            synchronized (msg) {
                Enumeration e = debuggerInstances.elements();
                while (e.hasMoreElements()) {
                    Debugger dbg = (Debugger)e.nextElement();
                    ((Debugger)e.nextElement()).status = 4;
                    dbg.stepNumber = 1;
                }
            }
            int[] curIdx = new int[1];
            ThreadObject[] threads = Debugger.getThreads(true, curIdx);
            Watch[] ws = BreakpointManager.getMonitors(activeDebugger.getCurrClassname(), activeDebugger);
            try {
                sourceFile = DebugUtilities.getSourcefile(Debugger.activeDebugger.currProgramClass);
            }
            catch (Exception e) {
                sourceFile = "";
            }
            try {
                timestamp = DebugUtilities.getTimestamp(Debugger.activeDebugger.currProgramClass);
            }
            catch (Exception e) {
                timestamp = 0L;
            }
            resp = new DebugResponse(0, Debugger.activeDebugger.currLine, null, ws, threads, curIdx[0], Runtime.getRuntime().totalMemory(), Runtime.getRuntime().freeMemory(), Debugger.activeDebugger.currFile, Debugger.activeDebugger.currFileIndex, sourceFile, timestamp, 2, null, (Tree[])null, "");
            resp.setInfo(Debugger.getInfo(991, Debugger.activeDebugger.currProgramClass));
        }
        debugDataOut = new DataOutputStream(out);
        debugDataIn = new DataInputStream(in);
        commandListener = new CommandListener(debugDataIn, blockingMode);
        IscobolSystem.duplicateEnv(commandListener);
        debugIn = commandListener.getInputStream();
        if (remote) {
            Debugger.firstWrite[0] = true;
        }
        debugOut = new DebugOutputStream(s -> {
            DataOutputStream dataOutputStream = debugDataOut;
            synchronized (dataOutputStream) {
                DebugUtilities.writeRawText(debugDataOut, s, firstWrite);
            }
        });
        debugErr = new DebugOutputStream(s -> {
            DataOutputStream dataOutputStream = debugDataOut;
            synchronized (dataOutputStream) {
                DebugUtilities.writeErrorMessage(debugDataOut, s, firstWrite);
            }
        });
        if (redirectStreams) {
            System.setIn(debugIn);
            System.setOut(debugOut);
            System.setErr(debugErr);
        }
        lastCmd = 3;
        returnCode = 0;
        if (remote) {
            resp.setFirstBlockMode(blockingMode);
            firstProcess = false;
            if (blockingMode == 1) {
                firstBlock = true;
            }
            Debugger.writeResponse(resp);
        }
        globalStatus.setThrowStopRunException(false);
        Debugger.resume(4);
        if (doNotify) {
            doNotify = false;
            ConnectionListener connectionListener = connList;
            synchronized (connectionListener) {
                connList.notifyAll();
            }
        }
        commandListener.start();
    }

    public static boolean isBreakpointCommand(int id) {
        switch (id) {
            case 0: 
            case 9: 
            case 19: 
            case 23: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRuntimeCommand(int id) {
        switch (id) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 56: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMonitorCommand(int id) {
        switch (id) {
            case 13: 
            case 14: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unattach(boolean throwSRE) {
        System.setIn(systemIn);
        System.setOut(systemOut);
        System.setErr(systemErr);
        connList.endConnection();
        if (commandListener != null) {
            IscobolSystem.destroyEnv(commandListener);
            commandListener = null;
        }
        Hashtable hashtable = debuggerInstances;
        synchronized (hashtable) {
            Enumeration e = debuggerInstances.elements();
            while (e.hasMoreElements()) {
                Debugger dbg = (Debugger)e.nextElement();
                ((Debugger)e.nextElement()).status = 0;
                dbg.stepNumber = 1;
            }
        }
        globalStatus.setWait(false);
        globalStatus.setThrowStopRunException(throwSRE);
        Debugger.resume(3);
    }

    private void updateProgramObj(Object prog) {
        this.theProgramObj = prog == null ? null : Debugger.getProgramObj(prog);
    }

    private void updateMethodObj(Object meth) {
        this.theMethodObj = meth == null ? null : Debugger.getMethodObj(meth);
    }

    private static Object getProgramObj(Object prog) {
        try {
            Field f = prog.getClass().getDeclaredField("$$theProgram$$");
            f.setAccessible(true);
            return f.get(prog);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object getMethodObj(Object meth) {
        try {
            Field f = meth.getClass().getDeclaredField("$$theMethod$$");
            f.setAccessible(true);
            return f.get(meth);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static DebugResponse suspending() {
        return Debugger.suspending(true);
    }

    static DebugResponse suspending(boolean changeStatus) {
        if (globalStatus.getValue() != 0 && globalStatus.getValue() != 3) {
            ParagraphObject[] parStack;
            if (changeStatus) {
                Debugger.setSuspending();
            }
            int[] ctidx = new int[1];
            ThreadObject[] tds = Debugger.getThreads(true, ctidx);
            int lastLine = 0;
            int lastFileIndex = 0;
            String lastFile = "";
            String lastProgramFile = "";
            long lastTm = 0L;
            if (ctidx[0] >= 0 && ctidx[0] < tds.length && (parStack = tds[ctidx[0]].getParStack()).length > 0) {
                ParagraphObject po = parStack[parStack.length - 1];
                lastLine = po.getLine();
                lastFile = po.getFile();
                lastFileIndex = po.getFileIndex();
                try {
                    lastProgramFile = DebugUtilities.getSourcefile(po.getProgClass());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    lastTm = DebugUtilities.getTimestamp(po.getProgClass());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new DebugResponse(0, lastLine, lastFile, lastFileIndex, lastProgramFile, lastTm, 28, tds, ctidx[0]);
        }
        return null;
    }

    public static boolean resuming() {
        if (globalStatus.getValue() == 5) {
            globalStatus.setValue(2);
            return true;
        }
        return false;
    }

    public static int getStatus() {
        return Debugger.getCurrentDebugger().status;
    }

    private static String getFilename(String fn) {
        return fn == null || fn.length() == 0 ? fn : new File(fn).getName();
    }

    static FileLoader getFileLoader() {
        return activeDebugger != null ? Debugger.activeDebugger.appData.fileLoader : null;
    }

    static DebugResponse getResponse(String response, int lastCmd) {
        boolean running = activeDebugger != null ? Debugger.activeDebugger.status != 3 : false;
        return Debugger.getResponse(null, running, 0, response, lastCmd);
    }

    private static DebugResponse getResponse(Debugger currDbg, boolean running, int firstBlock, String response, int lastCmd) {
        Breakpoint[] bps = null;
        Watch[] ws = null;
        ThreadObject[] threads = null;
        int[] curIdx = new int[]{-1};
        Tree[] trees = null;
        String sourceFile = "";
        String oldSourceFile = "";
        long timestamp = 0L;
        int currLine = 0;
        int currFileIndex = 0;
        String currFile = "";
        int oldLine = 0;
        int oldFileIndex = 0;
        String oldFile = "";
        if (isCompositeCmd || Debugger.isBreakpointCommand(lastCmd)) {
            bps = BreakpointManager.getBreakpoints();
        }
        if (currDbg != null) {
            currLine = currDbg.currLine;
            currFile = currDbg.currFile;
            currFileIndex = currDbg.currFileIndex;
            oldLine = currDbg.oldLine;
            oldFile = currDbg.oldFile;
            oldFileIndex = currDbg.oldFileIndex;
            if (isCompositeCmd || Debugger.isRuntimeCommand(lastCmd) || Debugger.isMonitorCommand(lastCmd)) {
                ws = BreakpointManager.getMonitors(currDbg.getCurrClassname(), currDbg);
            }
            if (running) {
                threads = Debugger.getThreads(true, curIdx);
            }
            if (tree != null && !tree.isEmpty()) {
                trees = new Tree[tree.size()];
                tree.toArray(trees);
            }
            try {
                sourceFile = DebugUtilities.getSourcefile(currDbg.currProgramClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                oldSourceFile = DebugUtilities.getSourcefile(currDbg.oldProgramClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                timestamp = DebugUtilities.getTimestamp(currDbg.currProgramClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DebugResponse resp = new DebugResponse(returnCode, currLine, bps, ws, threads, curIdx[0], running ? Runtime.getRuntime().totalMemory() : 0L, running ? Runtime.getRuntime().freeMemory() : 0L, currFile, currFileIndex, sourceFile, timestamp, lastCmd, dbgVar, trees, response);
        resp.setOldLine(oldLine);
        resp.setOldFile(oldFile);
        resp.setOldFileIndex(oldFileIndex);
        resp.setOldProgram(oldSourceFile);
        resp.setFirstBlockMode(firstBlock);
        if (dbgEnvValue != null) {
            resp.setVarValue(dbgEnvValue);
        }
        return resp;
    }

    static void setRedirectStreams(boolean v) {
        if (redirectStreams != v) {
            redirectStreams = v;
            if (redirectStreams) {
                System.setOut(debugOut);
                System.setErr(debugErr);
            } else {
                System.setOut(systemOut);
                System.setErr(systemErr);
            }
        }
    }

    static int getActiveDebuggerStatus() {
        return activeDebugger != null ? Debugger.activeDebugger.status : 3;
    }

    static {
        redirectStreams = true;
        globalStatus = new GlobalStatus(0);
        firstProcess = true;
        firstWrite = new boolean[]{true};
        debuggerInstances = new Hashtable();
        deferredDisplayCommands = new Vector();
        classLocations = new HashMap<Class, String[]>();
    }

    private static class MyNotifier
    implements MonitorNotifier {
        Debugger dbg;

        MyNotifier(Debugger d) {
            this.dbg = d;
        }

        @Override
        public void startThread() {
            Debugger.enterThread(this.dbg);
        }

        @Override
        public void endThread() {
            Debugger.exitThread();
        }
    }

    private static class AppData
    implements PropertyChangeListener {
        private Logger parStackLog;
        private FileLoader fileLoader;
        private String codePrefix = "";
        private CallLoader callLoader;

        private AppData() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String key = evt.getPropertyName();
            if (key.equals(Config.getPrefix() + "tracelevel")) {
                this.parStackLog = LoggerFactory.get(4);
            }
        }

        CallLoader getCallLoader() {
            String cp = Config.getProperty(".code_prefix", "");
            if (!cp.equals(this.codePrefix)) {
                this.callLoader = CallLoader.getInstance(cp, false);
                this.codePrefix = cp;
            }
            return this.callLoader;
        }
    }

    private static class GlobalStatus {
        private int value = 1;
        private boolean waitConnection;
        private boolean throwStopRunException;

        public GlobalStatus(int v) {
            this.setValue(v);
        }

        public boolean getThrowStopRunException() {
            return this.throwStopRunException;
        }

        public synchronized void setThrowStopRunException(boolean throwStopRunException) {
            this.throwStopRunException = throwStopRunException;
        }

        public synchronized void setWait(boolean b) {
            this.waitConnection = b;
        }

        public synchronized boolean getWait() {
            return this.waitConnection;
        }

        public synchronized void setValue(int v) {
            this.value = v;
        }

        public synchronized int getValue() {
            return this.value;
        }

        public synchronized int mustSuspend() {
            if (this.getThrowStopRunException()) {
                return 2;
            }
            if (this.value == 5) {
                this.value = 2;
                return 1;
            }
            if (this.value == 4) {
                this.value = 2;
                return blockingMode != 1 ? 1 : 0;
            }
            return 0;
        }
    }

    public static class SelfDataItem
    extends IscobolDataItem {
        SelfDataItem(Object var) {
            this.var = var;
        }

        @Override
        public Class getType() {
            return this.var.getClass();
        }

        @Override
        public Object refresh(Debugger debugger) {
            return this.var;
        }
    }

    public static class IscobolDataItem
    extends IscobolField {
        private int[] indexes;
        private int[] dimensions;
        private int leftPos;
        private int subLen;

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public Object refresh(Debugger dbg) {
            Object objInstance = null;
            if (dbg == null) {
                return this.var;
            }
            if (dbg.getProgramObject() != null) {
                objInstance = dbg.getProgramObject();
            } else if (dbg.getMethodObject() != null) {
                objInstance = dbg.getMethodObject();
            } else if (this.field.getDeclaringClass() == dbg.getCurrProgramClass()) {
                objInstance = dbg.getCurrProgram();
            } else if (this.field.getDeclaringClass() == dbg.getCurrMethodClass()) {
                objInstance = dbg.getCurrMethod();
            } else {
                return this.var;
            }
            try {
                this.var = this.field.get(objInstance);
                if (this.isCobolVar) {
                    ICobolVar cVar = (ICobolVar)this.var;
                    if (this.indexes != null) {
                        if (Debugger.checkDynamicIndexes(cVar, this.indexes)) {
                            cVar = cVar.intIAt(this.indexes);
                        } else {
                            this.var = null;
                            return null;
                        }
                    }
                    if (this.leftPos > 0) {
                        cVar = this.subLen > 0 ? cVar.intISub(this.leftPos, this.subLen) : cVar.intISub(this.leftPos);
                    }
                    this.var = cVar;
                } else if (this.indexes != null) {
                    this.var = Debugger.findObjectVarAt(this.var, this.indexes);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.var;
        }

        @Override
        public String toString() {
            try {
                return DebugUtilities.toString(this.var);
            }
            catch (Exception ex) {
                return DebuggerConstants.NULL_VALUE;
            }
        }

        @Override
        void adjustIndexes(int[] indexes) {
            try {
                Field occursFlag = this.field.getDeclaringClass().getDeclaredField(this.field.getName() + "$occurs");
                if (occursFlag.getType() == Boolean.TYPE) {
                    int i = 0;
                    while (i < indexes.length) {
                        int n = i++;
                        indexes[n] = indexes[n] - 1;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static /* synthetic */ int[] access$502(IscobolDataItem x0, int[] x1) {
            x0.indexes = x1;
            return x1;
        }

        static /* synthetic */ int[] access$602(IscobolDataItem x0, int[] x1) {
            x0.dimensions = x1;
            return x1;
        }
    }

    public static class IscobolProp
    extends IscobolField {
        private IscobolProp next;
        private Field setfield;
        private IscobolDataItem dataItem;
        private Method method;
        private boolean set;

        IscobolProp(Field field, IscobolDataItem dataItem, boolean set) {
            this.field = field;
            this.dataItem = dataItem;
            this.set = set;
        }

        IscobolProp(Method method, Field setfield, IscobolDataItem dataItem, boolean set) {
            this.dataItem = dataItem;
            this.method = method;
            this.setfield = setfield;
            this.set = set;
        }

        @Override
        public void setCobolVar(boolean cv) {
        }

        @Override
        public boolean isCobolVar() {
            return ICobolVar.class.isAssignableFrom(this.getType());
        }

        @Override
        public Class getType() {
            if (this.next != null) {
                return this.next.getType();
            }
            if (this.field != null) {
                return this.field.getType();
            }
            if (this.set) {
                return this.method.getParameterTypes()[0];
            }
            return this.method.getReturnType();
        }

        public void setHexValue(String val, Debugger dbg) throws Exception {
            this.setValue(null, val, dbg);
        }

        public void setValue(ICobolVar val, Debugger dbg) throws Exception {
            this.setValue(val, null, dbg);
        }

        private void setValue(ICobolVar val, String hexVal, Debugger dbg) throws Exception {
            if (this.next != null || this.set && this.isCobolVar()) {
                Object obj = null;
                if (this.dataItem != null) {
                    obj = this.dataItem.refresh(dbg);
                }
                IscobolProp n = this;
                while (n.next != null) {
                    obj = n.refresh(dbg, obj);
                    n = n.next;
                }
                if (n.field != null) {
                    ICobolVar cv = (ICobolVar)n.field.get(obj);
                    this.setValue(val, hexVal, cv);
                } else {
                    ICobolVar cv = (ICobolVar)n.setfield.get(obj);
                    this.setValue(val, hexVal, cv);
                    n.method.invoke(obj, cv);
                }
            }
        }

        private void setValue(ICobolVar val, String hexVal, ICobolVar dest) throws Exception {
            if (val != null) {
                dest.setValue(val);
            } else {
                try {
                    DebugUtilities.setValueAsHex(dest, hexVal);
                }
                catch (Exception ex) {
                    throw new DebuggerException(32, "'" + hexVal + "'");
                }
            }
        }

        @Override
        public Object refresh(Debugger dbg) {
            Object obj = null;
            if (this.dataItem != null) {
                obj = this.dataItem.refresh(dbg);
            }
            obj = this.refresh(dbg, obj);
            IscobolProp n = this.next;
            while (n != null) {
                obj = n.refresh(dbg, obj);
                n = n.next;
            }
            this.var = obj;
            return this.var;
        }

        private Object refresh(Debugger dbg, Object obj) {
            if (this.field != null) {
                try {
                    this.setVar(this.field.get(obj));
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.setVar(this.method.invoke(obj, new Object[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.var;
        }

        @Override
        void adjustIndexes(int[] indexes) {
        }
    }

    public static abstract class IscobolField {
        protected Field field;
        protected Object var;
        protected boolean isCobolVar;

        public abstract Class getType();

        abstract void adjustIndexes(int[] var1);

        public Object getVar() {
            return this.var;
        }

        public void setVar(Object var) {
            this.var = var;
        }

        public boolean isCobolVar() {
            return this.isCobolVar;
        }

        public void setCobolVar(boolean isCobolVar) {
            this.isCobolVar = isCobolVar;
        }

        public abstract Object refresh(Debugger var1);

        public String toString() {
            try {
                return DebugUtilities.toString(this.var);
            }
            catch (Exception ex) {
                return DebuggerConstants.NULL_VALUE;
            }
        }
    }
}

