/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.interfaces.debugger.IDebugParagraphExtension;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public class DebugParagraph
implements IDebugParagraphExtension,
DataExternalizable,
Comparable<DebugParagraph> {
    private static final long serialVersionUID = 1000007L;
    private String paragraphName;
    private int lineNumber;
    private int fileIndex;
    private boolean isInDeclaratives;
    private int paragraphNumber;
    private boolean isSection;
    private String methodName;

    public DebugParagraph() {
    }

    public DebugParagraph(String s) {
        StringTokenizer stn = new StringTokenizer(s);
        if (stn.hasMoreTokens()) {
            this.paragraphName = stn.nextToken();
            if (stn.hasMoreTokens()) {
                this.lineNumber = Integer.parseInt(stn.nextToken());
                if (stn.hasMoreTokens()) {
                    this.fileIndex = Integer.parseInt(stn.nextToken());
                    if (stn.hasMoreTokens()) {
                        this.isInDeclaratives = stn.nextToken().equals("D");
                        if (stn.hasMoreTokens()) {
                            this.paragraphNumber = Integer.parseInt(stn.nextToken());
                        }
                    }
                }
            }
        }
    }

    public DebugParagraph(String paragraphName, int lineNumber, int fileIndex) {
        this.paragraphName = paragraphName;
        this.lineNumber = lineNumber;
        this.fileIndex = fileIndex;
    }

    public DebugParagraph(String paragraphName, int lineNumber, int fileIndex, boolean isInDeclaratives, int paragraphNumber) {
        this(null, paragraphName, lineNumber, fileIndex, isInDeclaratives, paragraphNumber, false);
    }

    public DebugParagraph(String methodName, String paragraphName, int lineNumber, int fileIndex, boolean isInDeclaratives, int paragraphNumber) {
        this(methodName, paragraphName, lineNumber, fileIndex, isInDeclaratives, paragraphNumber, false);
    }

    public DebugParagraph(String methodName, String paragraphName, int lineNumber, int fileIndex, boolean isInDeclaratives, int paragraphNumber, boolean isSection) {
        this.methodName = methodName;
        this.paragraphName = paragraphName;
        this.lineNumber = lineNumber;
        this.fileIndex = fileIndex;
        this.isInDeclaratives = isInDeclaratives;
        this.paragraphNumber = paragraphNumber;
        this.isSection = isSection;
    }

    @Override
    public String getParagraphName() {
        return this.paragraphName;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getFileIndex() {
        return this.fileIndex;
    }

    @Override
    public boolean isInDeclaratives() {
        return this.isInDeclaratives;
    }

    @Override
    public boolean isSection() {
        return this.isSection;
    }

    @Override
    public int getParagraphNumber() {
        return this.paragraphNumber;
    }

    @Override
    public int compareTo(DebugParagraph dp) {
        int r = 0;
        if (this.methodName != null) {
            r = this.methodName.compareTo(dp.methodName);
        }
        if (r == 0) {
            if (this.isInDeclaratives) {
                r = dp.isInDeclaratives ? 0 : -1;
            } else {
                int n = r = dp.isInDeclaratives ? 1 : 0;
            }
        }
        if (r == 0) {
            r = this.paragraphNumber - dp.paragraphNumber;
        }
        return r;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        RtsUtil.writeUTFOptmz(this.paragraphName, out);
        out.writeInt(this.lineNumber);
        out.writeInt(this.fileIndex);
        out.writeInt(this.paragraphNumber);
        out.writeBoolean(this.isInDeclaratives);
        out.writeBoolean(this.isSection);
        RtsUtil.writeUTFOptmz(this.methodName, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.paragraphName = RtsUtil.readUTFOptmz(in);
        this.lineNumber = in.readInt();
        this.fileIndex = in.readInt();
        this.paragraphNumber = in.readInt();
        this.isInDeclaratives = in.readBoolean();
        this.isSection = in.readBoolean();
        this.methodName = RtsUtil.readUTFOptmz(in);
    }

    public String toString() {
        return "DebugParagraph(" + this.paragraphName + "," + this.lineNumber + "," + this.fileIndex + "," + this.paragraphNumber + "," + this.isInDeclaratives + "," + this.isSection + "," + this.methodName + ")";
    }
}

