/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.coverage;

import com.iscobol.coverage.CoverageElement;
import com.iscobol.coverage.CoverageStatement;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class CoverageParagraph
extends CoverageElement {
    private Map<CoverageStatement, CoverageStatement> statements = new TreeMap<CoverageStatement, CoverageStatement>();
    public String name;

    public CoverageStatement getStatement(CoverageStatement stmt) {
        return this.statements.get(stmt);
    }

    public CoverageStatement removeStatement(CoverageStatement stmt) {
        return this.statements.remove(stmt);
    }

    public Collection<CoverageStatement> getStatements() {
        return this.statements.values();
    }

    public void addStatement(CoverageStatement cstmt) {
        this.statements.put(cstmt, cstmt);
    }

    public int getTotalStatements() {
        return this.statements.size();
    }

    public int getMissedStatements() {
        if ("red".equals(this.color)) {
            return this.getTotalStatements();
        }
        Collection<CoverageStatement> statements = this.getStatements();
        int missed = 0;
        for (CoverageStatement s : statements) {
            if (!"red".equals(s.color)) continue;
            ++missed;
        }
        return missed;
    }

    public double getStatementCoverageRatio() {
        int missed = this.getMissedStatements();
        int total = this.getTotalStatements();
        double covRatio = 0.0;
        if (total > 0) {
            covRatio = 1.0 - (double)missed / (double)total;
        }
        return covRatio;
    }
}

