/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Token;
import com.iscobol.interfaces.compiler.IOptionListForCodeAnalyzer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Locale;

public class OptionListForCodeAnalyzer
extends OptionList
implements IOptionListForCodeAnalyzer {
    private String cOpt;
    private String conlyOpt;
    private Token[] lastPropName = new Token[1];
    private Token[] lastPropValue = new Token[1];
    private int[] lastSourceFormat = new int[1];
    private boolean[] propertiesRestored = new boolean[1];
    private PropertyChangeListener listener;

    private OptionListForCodeAnalyzer(String[] argv, String c, String conly) {
        super(argv);
        this.cOpt = c;
        this.conlyOpt = conly;
    }

    @Override
    public void checkOptions() {
        if (this.getOption("-jj") != null && this.getOption("-jc") == null) {
            String[][] opts = new String[][]{{"-d", this.getOption("-d")}, {"-dx", this.getOption("-dx")}, {"-g", this.getOption("-g")}, {"-jo=", this.getOption("-jo=")}};
            if (opts[1][1] != null && opts[0][1] == null) {
                opts[0][1] = "";
            }
            super.checkOptions();
            for (String[] opt : opts) {
                if (opt[1] == null) continue;
                this.addOption(opt[0] + opt[1]);
            }
        } else {
            super.checkOptions();
        }
    }

    public static OptionListForCodeAnalyzer newInstance(String[] argv) {
        ArrayList<String> newArgv = new ArrayList<String>();
        String c = null;
        String conly = null;
        for (String opt : argv) {
            String lw = opt.toLowerCase();
            if (lw.startsWith("-c=")) {
                c = opt.substring("-c=".length());
                continue;
            }
            if (lw.startsWith("-conly=")) {
                conly = opt.substring("-conly=".length());
                continue;
            }
            newArgv.add(opt);
        }
        return new OptionListForCodeAnalyzer(newArgv.toArray(new String[newArgv.size()]), c, conly);
    }

    @Override
    public String getOptionC() {
        return this.cOpt;
    }

    @Override
    public String getOptionCONLY() {
        return this.conlyOpt;
    }

    @Override
    public void restoreProperties() {
        this.propertiesRestored[0] = true;
        super.restoreProperties();
    }

    @Override
    public boolean isPropertiesRestored() {
        return this.propertiesRestored[0];
    }

    @Override
    public Token getLastPropertyName() {
        return this.lastPropName[0];
    }

    @Override
    public Token getLastPropertyValue() {
        return this.lastPropValue[0];
    }

    @Override
    public int getLastSourceFormat() {
        return this.lastSourceFormat[0];
    }

    @Override
    protected void setProperty(Token prop, Token value, int sourceFormat) {
        String propName = prop.getOriginalWord();
        if (prop.getToknum() == 10001) {
            propName = propName.substring(1, propName.length() - 1);
        }
        if ("easydb.output".equals(propName = propName.toLowerCase(Locale.US))) {
            return;
        }
        this.lastPropName[0] = prop;
        this.lastPropValue[0] = value;
        this.lastSourceFormat[0] = sourceFormat;
        super.setProperty(prop, value, sourceFormat);
        if (this.listener != null) {
            String propValue = null;
            if (value != null) {
                propValue = value.getOriginalWord();
                if (value.getToknum() == 10001) {
                    propValue = propValue.substring(1, propValue.length() - 1);
                }
            }
            propName = "iscobol.compiler." + propName;
            this.listener.propertyChange(new PropertyChangeEvent(this, propName, null, propValue));
        }
    }

    @Override
    public void setListener(PropertyChangeListener listener) {
        this.listener = listener;
    }
}

