/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.Verb;
import java.util.Hashtable;

public class Open
extends Verb
implements CobolToken,
ErrorsNumbers {
    private static int BULK_ADDITION = -1;
    private Token sharing;
    private Token fileName;
    private SelectList sels = new SelectList();
    private Hashtable openModes = new Hashtable();
    private Hashtable openLocks = new Hashtable();
    private Hashtable openMass = new Hashtable();
    private Hashtable openBulk = new Hashtable();
    private Hashtable openRewi = new Hashtable();
    private boolean acOpt;

    public Open(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.acOpt = t.getOptionList().getOption("-ca") != null;
        Token mode = this.tm.getToken();
        if (mode.getToknum() == 474) {
            this.sharing = mode;
            mode = this.tm.getToken();
        }
        while (mode.getToknum() == 535 || mode.getToknum() == 624 || mode.getToknum() == 519 || mode.getToknum() == 478) {
            this.parse(mode);
            mode = this.tm.getToken();
        }
        this.tm.ungetToken();
        if (this.openModes.size() == 0) {
            throw new GeneralErrorException(54, 4, this.keyWord, mode.getWord(), this.error);
        }
    }

    private void parse(Token oMode) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        Token all = new Token(262, "ALL", 0, 0, "dummy");
        if (this.sharing == null) {
            this.sharing = all;
        }
        if ((tk = this.tm.getToken()).getToknum() == 723) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 814) {
                tk = this.tm.getToken();
            }
            if (tk.isAll()) {
                tk = this.sharing = all;
                this.tm.ungetToken();
            } else {
                this.sharing = tk;
            }
            if (this.sharing.getToknum() == 262 || this.sharing.getToknum() == 597) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 621) {
                    tk = this.tm.getToken();
                }
            } else if (this.sharing.getToknum() == 667) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 615) {
                    tk = this.tm.getToken();
                } else {
                    this.error.print(31, 3, tk, "ONLY/" + tk.getWord());
                }
            } else {
                throw new GeneralErrorException(29, 4, this.keyWord, this.sharing.getWord(), this.error);
            }
        }
        while ((this.fileName = tk).getToknum() == 10009) {
            Token massUpdate = null;
            Token bulkAddition = null;
            Token noRewind = null;
            Select sel = this.pc.getSelect(this.fileName.getWord());
            if (sel == null) {
                throw new GeneralErrorException(53, 4, this.fileName, this.fileName.getWord(), this.error);
            }
            if (sel.isSort()) {
                throw new GeneralErrorException(103, 4, this.fileName, this.fileName.getWord(), this.error);
            }
            if (!sel.allowsOpenIO() && oMode.getToknum() == 519) {
                this.error.print(54, 2, this.fileName, this.fileName.getWord());
            }
            this.sels.addItem(sel);
            this.openModes.put(sel, oMode);
            tk = this.tm.getToken();
            if (this.acOpt && tk.getToknum() == 264) {
                this.sharing = this.tm.getToken();
                if (this.sharing.getToknum() == 262 || this.sharing.getToknum() == 597) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 622) {
                        this.tm.ungetToken();
                    }
                } else if (this.sharing.getToknum() == 669) {
                    this.sharing.setToknum(667);
                } else if (this.sharing.getToknum() == 818) {
                    this.sharing.setToknum(262);
                } else if (this.sharing.getToknum() == 795) {
                    this.sharing.setToknum(262);
                } else {
                    throw new GeneralErrorException(15, 4, this.sharing, this.sharing.getWord(), this.error);
                }
                tk = this.tm.getToken();
            }
            this.tm.ungetToken();
            tk = Open.myGetToken(this.tm);
            if (tk.getToknum() == 814 || tk.getToknum() == 597 || tk.getToknum() == 571 || tk.getToknum() == 580 || tk.getToknum() == BULK_ADDITION) {
                if (tk.getToknum() == 814) {
                    tk = Open.myGetToken(this.tm);
                }
                if (tk.getToknum() == 597) {
                    tk = Open.myGetToken(this.tm);
                    if (tk.getToknum() != 699) {
                        this.error.print(31, 3, tk, "REWIND/" + tk.getWord());
                        this.tm.ungetToken();
                    } else {
                        noRewind = tk;
                    }
                } else if (tk.getToknum() == 571) {
                    this.sharing = tk;
                } else if (tk.getToknum() == 580) {
                    massUpdate = tk;
                } else if (tk.getToknum() == BULK_ADDITION) {
                    bulkAddition = tk;
                } else {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                tk = Open.myGetToken(this.tm);
            } else if (tk.getToknum() == 495) {
                tk = Open.myGetToken(this.tm);
                if (tk.getToknum() == 571) {
                    this.sharing = tk;
                } else if (tk.getToknum() == 580) {
                    massUpdate = tk;
                } else if (tk.getToknum() == BULK_ADDITION) {
                    bulkAddition = tk;
                } else {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                tk = Open.myGetToken(this.tm);
            }
            this.openLocks.put(sel, this.sharing);
            if (noRewind != null) {
                this.openRewi.put(sel, noRewind);
            }
            if (massUpdate != null) {
                this.openMass.put(sel, massUpdate);
            }
            if (bulkAddition != null) {
                this.openBulk.put(sel, bulkAddition);
            }
            if (this.sharing.getToknum() == 474) continue;
            this.sharing = all;
        }
        if (this.sels.getItemNum() == 0) {
            throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
    }

    private static Token myGetToken(TokenManager t) throws EndOfProgramException, GeneralErrorException {
        String word;
        Token Return2 = t.getToken();
        if (Return2.getToknum() == 10009 && "BULK-ADDITION".equals(word = Return2.getWord())) {
            Return2.setToknum(BULK_ADDITION);
        }
        return Return2;
    }

    @Override
    public void check() throws GeneralErrorException {
        Select sel = this.sels.getFirst();
        while (sel != null) {
            Token mode = (Token)this.openModes.get(sel);
            if (mode.getToknum() == 535 || !sel.hasLockSupport()) {
                this.sharing = (Token)this.openLocks.get(sel);
                if (!(this.sharing == null || this.sharing.getToknum() != 597 && this.sharing.getToknum() != 571 && this.sharing.getToknum() != 474 && this.sharing.getToknum() != 667 || sel.hasLockSupport())) {
                    this.error.print(169, 2, this.keyWord, sel.fileName.getWord());
                }
                if (sel.getLockMode(mode.getToknum()) == 474 && !sel.hasLockSupport()) {
                    this.error.print(169, 2, this.keyWord, sel.fileName.getWord());
                }
            }
            sel = this.sels.getNext();
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        String openMode = null;
        boolean hasGlobalDecl = this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        this.getCodeDebug(Return2);
        Select sel = this.sels.getFirst();
        while (sel != null) {
            Token mode = (Token)this.openModes.get(sel);
            this.sharing = (Token)this.openLocks.get(sel);
            Token massUpdate = (Token)this.openMass.get(sel);
            Token bulkAddition = (Token)this.openBulk.get(sel);
            Token noRewind = (Token)this.openRewi.get(sel);
            boolean hasDeclaratives = this.pc.getDeclarative(sel) != null || hasGlobalDecl;
            Return2.append(this.parent.getIndent());
            Return2.append("try {");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            Return2.append(sel.getName());
            Return2.append(".open(");
            Return2.append(sel.getPathCode());
            Return2.append(",");
            if (mode.getToknum() == 535) {
                openMode = "CobolFile.OPEN_INPUT";
                Return2.append("CobolFile.OPEN_INPUT");
            } else if (mode.getToknum() == 624) {
                openMode = "CobolFile.OPEN_OUTPUT";
                Return2.append("CobolFile.OPEN_OUTPUT");
            } else if (mode.getToknum() == 519) {
                openMode = "CobolFile.OPEN_IO";
                Return2.append("CobolFile.OPEN_IO");
            } else if (mode.getToknum() == 478) {
                openMode = "CobolFile.OPEN_EXTEND";
                Return2.append("CobolFile.OPEN_EXTEND");
            }
            Return2.append(",");
            if (sel.getLockMode(mode.getToknum()) == 474) {
                Return2.append("CobolFile.LOCK_EXCLUSIVE");
            } else if (this.sharing != null) {
                if (this.sharing.getToknum() == 597 || this.sharing.getToknum() == 571 || this.sharing.getToknum() == 474) {
                    Return2.append("CobolFile.LOCK_EXCLUSIVE");
                } else if (this.sharing.getToknum() == 667) {
                    Return2.append("CobolFile.LOCK_READERS");
                } else {
                    Return2.append("CobolFile.LOCK_NONE");
                }
            } else {
                Return2.append("CobolFile.LOCK_NONE");
            }
            if (sel.getLockMode(mode.getToknum()) == 290) {
                Return2.append(" + CobolFile.LOCK_AUTOMATIC");
            }
            if (sel.getMultipleRecords()) {
                Return2.append(" + CobolFile.LOCK_MULTI");
            }
            if (bulkAddition != null) {
                Return2.append(" + CobolFile.LOCK_BULK+CobolFile.LOCK_MASS_UPDATE");
            } else if (sel.getMassUpdate() || massUpdate != null) {
                Return2.append(" + CobolFile.LOCK_MASS_UPDATE");
            }
            if (sel.isWithRollback()) {
                Return2.append(" + CobolFile.LOCK_TRANSACTION");
            }
            if (sel.isEncrypted()) {
                Return2.append(" + CobolFile.FILE_ENCRYPTED");
            }
            if (sel.hasBefore || sel.isExternal() || sel.getFD().isExternal()) {
                Return2.append(" + CobolFile.FILE_PRT_MACHINE_CODE");
            }
            Return2.append(");");
            Use.putFileStatus(Return2, sel, this.parent.getIndent());
            Use.putDeclaratives(Return2, this.pc, sel, this.parent.getIndent(), openMode, hasDeclaratives);
            Return2.append(eol);
            sel = this.sels.getNext();
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public SelectList getSels() {
        return this.sels;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public Hashtable getOpenModes() {
        return this.openModes;
    }

    public Hashtable getOpenLocks() {
        return this.openLocks;
    }

    public Hashtable getOpenMass() {
        return this.openMass;
    }

    public Hashtable getOpenBulk() {
        return this.openBulk;
    }

    public Hashtable getOpenRewi() {
        return this.openRewi;
    }
}

