/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Exit
extends Verb
implements CobolToken,
ErrorsNumbers {
    static final int EXIT_FIRST = 0;
    static final int EXIT_PLAIN = 0;
    static final int EXIT_PROGRAM = 1;
    static final int EXIT_PARAGRAPH = 2;
    static final int EXIT_SECTION = 3;
    static final int EXIT_PERFORM = 4;
    static final int EXIT_PERFORM_CYCLE = 5;
    static final int EXIT_METHOD = 6;
    static final int EXIT_LAST = 6;
    private final int type;
    Token tk_returnval;
    VariableName vn_returnval;

    public Exit(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 654: {
                if (this.parent.parent.inThread()) {
                    throw new GeneralErrorException(142, 4, this.keyWord, "THREAD", this.error);
                }
                if (p instanceof CobolMethod) {
                    throw new GeneralErrorException(142, 4, this.keyWord, "METHOD", this.error);
                }
                this.type = 1;
                tk = this.tm.getToken();
                if (tk.getToknum() == 506 || tk.getToknum() == 695) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 10002 || tk.getToknum() == 10017 || tk.getToknum() == 10001) {
                    this.tk_returnval = tk;
                    break;
                }
                if (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    this.vn_returnval = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                    break;
                }
                this.tm.ungetToken();
                break;
            }
            case 631: {
                if (this.parent.parent.inThread()) {
                    throw new GeneralErrorException(142, 4, this.keyWord, "THREAD", this.error);
                }
                this.type = 2;
                break;
            }
            case 710: {
                if (this.parent.parent.inThread()) {
                    throw new GeneralErrorException(142, 4, this.keyWord, "THREAD", this.error);
                }
                this.type = 3;
                this.parent.parent.setExitSect(true);
                break;
            }
            case 633: {
                if (!this.parent.parent.inLoop()) {
                    throw new GeneralErrorException(85, 4, this.keyWord, "", this.error);
                }
                tk = this.tm.getToken();
                if (tk.getToknum() == 387) {
                    this.type = 5;
                    break;
                }
                this.type = 4;
                this.tm.ungetToken();
                break;
            }
            case 585: {
                if (!(p instanceof CobolMethod)) {
                    throw new GeneralErrorException(142, 4, this.keyWord, "METHOD", this.error);
                }
                this.type = 6;
                break;
            }
            default: {
                this.tm.ungetToken();
                this.type = 0;
            }
        }
    }

    public Exit(int ty, Token kw, Block par, Pcc p, TokenManager t, Errors err) {
        super(kw, par, p, t, err);
        if (ty < 0 || ty > 6) {
            throw new IllegalArgumentException();
        }
        this.type = ty;
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        boolean debug = this.tm.getOptionList().getOption("-d") != null;
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.isExitProgram()) {
            Return2.append("if (Factory.isCalled(\"");
            Return2.append(this.pc.getClassName());
            Return2.append("\")) ");
            if (this.tk_returnval != null) {
                if (this.tk_returnval.getToknum() == 10002) {
                    Return2.append("{");
                    Return2.append(this.getReturnCode());
                    Return2.append(".set (");
                    Return2.append(this.getCodeLiteral(this.tk_returnval));
                    Return2.append("); throw GobackException.go;}");
                } else {
                    Return2.append("throw new GobackException(");
                    Return2.append(this.getCodeLiteral(this.tk_returnval));
                    Return2.append(");");
                }
            } else if (this.vn_returnval != null) {
                Return2.append("throw new GobackException(");
                Return2.append(this.vn_returnval.getCode());
                Return2.append(");");
            } else {
                Return2.append("throw GobackException.go;");
            }
        } else if (this.isExitParagraph()) {
            Return2.append("if(true) ");
            if (debug) {
                Return2.append("{ ");
                Paragraph.getDebugExitCode(Return2);
                Return2.append(" ");
            }
            int rc = this.getDeferredMethodId() > 0 ? -4 : 0;
            Return2.append(" return " + rc + ";");
            if (debug) {
                Return2.append(" }");
            }
        } else if (this.isExitSection()) {
            Return2.append("if(true) ");
            if (debug) {
                Return2.append("{ ");
                Paragraph.getDebugExitCode(Return2);
                Return2.append(" ");
            }
            Return2.append(" throw ExitSectionException.go;");
            if (debug) {
                Return2.append(" }");
            }
        } else if (this.isExitPerform()) {
            int sns = this.parent.getParent().getParagraphCodeLimit();
            int performDeferredMethodId = 0;
            if (sns > 0) {
                Verb parentVerb = this.getParent().getParentVerb();
                while (parentVerb != null && !(parentVerb instanceof Perform)) {
                    parentVerb = parentVerb.getParent().getParentVerb();
                }
                performDeferredMethodId = parentVerb.getDeferredMethodId();
            }
            if (performDeferredMethodId == this.getDeferredMethodId()) {
                if (this.isExitPerformCycle()) {
                    Return2.append(this.parent.getExitPerformCycle());
                } else {
                    Return2.append("if(true) break");
                    if (this.parent != null && this.parent.getParent() != null) {
                        Return2.append(this.parent.getParent().getActPerf());
                    }
                    Return2.append(";");
                }
            } else if (this.isExitPerformCycle()) {
                Return2.append("if (true) return -2;");
            } else {
                Return2.append("if (true) return -1;");
            }
        } else if (this.isExitMethod()) {
            Return2.append("if(true) throw GobackException.go;");
        } else {
            Return2.append(";");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public boolean isExitProgram() {
        return this.type == 1;
    }

    public boolean isExitParagraph() {
        return this.type == 2;
    }

    public boolean isExitSection() {
        return this.type == 3;
    }

    public boolean isExitPerform() {
        return this.type == 4 || this.type == 5;
    }

    public boolean isExitPerformCycle() {
        return this.type == 5;
    }

    public boolean isExitMethod() {
        return this.type == 6;
    }

    public boolean isExitPlain() {
        return this.type == 0;
    }
}

