/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.AppServerImpl;
import com.iscobol.as.ClientThread;
import com.iscobol.as.IDEHandler;
import com.iscobol.as.Login;
import com.iscobol.gui.AppFactory;
import com.iscobol.gui.AppServer;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.ServerCall;
import com.iscobol.interfaces.runtime.IIDESettings;
import com.iscobol.io.LockManagerHandler;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.Worker;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rts.Auth;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ServerHandler
extends AbstractServerRpcHandler
implements IServerCallbackHandler,
AppServer {
    final Session session;
    protected final int sessionId;
    private static final long serialVersionUID = 10L;
    private byte[] challenge;

    public ServerHandler(DualRpcServerDispatcher disp) throws IOException {
        super(disp);
        AppServerImpl.getLogger().info("new AppServerImpl");
        this.getDispatcher().setCallbackHandler(this);
        ServerCaller caller = new ServerCaller(disp, new RemoteRegistry());
        this.sessionId = RemoteRegistry.setCaller(caller);
        this.session = this.getDispatcher().getSession();
        this.session.setSessionId(this.sessionId);
    }

    @Override
    public void brokenConnection() {
        Session session = this.getDispatcher().getSession();
        com.iscobol.logger.Logger log = RemoteRegistry.getProblemLogger(session.getSessionId());
        if (log != null) {
            log.info(ServerHandler.class.getName() + ": closed client connection from " + session.getRemoteHost() + " on port " + session.getRemotePort());
        }
        ServerCaller c = (ServerCaller)RemoteRegistry.removeCaller(session.getSessionId());
        c.getRegistry().clear();
        session.closeSession();
        this.kill(this.sessionId, 253);
        if (log != null) {
            log.close();
        }
    }

    @Override
    public void info() throws IOException {
        AppServerImpl.info();
    }

    @Override
    public void kill(int id, int xCode) {
        AppServerImpl.kill(id, xCode);
    }

    public void cleanUp(int id, Logger log) {
        AppServerImpl.cleanUp(id, log);
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void unexport() {
    }

    public String getRemoteHost() {
        try {
            return this.getDispatcher().getSession().getRemoteHost();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public int getRemotePort() {
        try {
            return this.getDispatcher().getSession().getRemotePort();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public String getCsVersion() throws IOException {
        return this.getCSVersion();
    }

    @Override
    public String getCSVersion() throws IOException {
        this.check();
        StringBuffer sb = new StringBuffer();
        sb.append(Version.getCsVersion());
        String updateSite = Config.getProperty("iscobol.as.clientupdate.site", null);
        if (updateSite != null) {
            File f;
            sb.append(";");
            sb.append(updateSite);
            String defVer = RuntimeProperties.getShortBuildNumber();
            sb.append(";");
            sb.append(Config.getProperty("iscobol.as.clientupdate.version", defVer));
            String swPropFile = Config.getProperty("iscobol.as.clientupdate.propfile", null);
            if (swPropFile != null && (f = new File(swPropFile)).exists() && f.isFile() && f.canRead()) {
                Properties props = new Properties();
                try {
                    RtsUtil.loadProperties(props, f);
                    Enumeration<?> en = props.propertyNames();
                    while (en.hasMoreElements()) {
                        String propName = (String)en.nextElement();
                        sb.append(";");
                        sb.append(propName);
                        sb.append("=");
                        sb.append(props.getProperty(propName));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }

    public int getUserCount() {
        return AppServerImpl.getUserCount();
    }

    @Override
    public int start(String clientVersion, String prog, String[] args, GuiFactory gf) throws IOException {
        this.check();
        gf.exit("ERROR: Client release is incompatible with Iscobol Application Server");
        return -1;
    }

    @Override
    public int start(String clientVersion, String prog, String[] args, String iscobolconf, GuiFactory gf) throws IOException {
        this.check();
        gf.exit("ERROR: Client release is incompatible with Iscobol Application Server");
        return -1;
    }

    static DualRpcServer init(String hostName, int portNumber, boolean reuseAddress, Logger log, String serverName) {
        try {
            DualRpcServer server = new DualRpcServer(hostName, portNumber, reuseAddress, serverName);
            server.setMaxConnections(Config.getProperty(".as.max_connections", 512));
            server.setKeepAlive(Config.getProperty(".as.keepalive", true));
            server.setIgnoreMaxConnectionsLimit(true);
            server.registerServerSideHandlerClassname(ServerHandler.class.getName());
            server.setRpcWorkerFactory(new IRpcWorkerFactory(){

                @Override
                public Thread getRpcWorkerThread(IRpcMessageDispatcher dispatcher, Message message) {
                    ServerCaller caller = (ServerCaller)RemoteRegistry.getCaller(dispatcher.getSession().getSessionId());
                    return new Worker(dispatcher, message, caller.getRegistry());
                }
            });
            server.setMessageSerializer(new IscobolMessageSerializer());
            log.info(serverName + " bound in registry");
            Class lm = LockManagerHandler.get().theLockManager;
            log.info("LockManager: " + (lm == null ? "null" : LockManagerHandler.get().theLockManager.getName()));
            return server;
        }
        catch (Exception e) {
            log.severe(serverName + " err: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static int getDefaultPort() {
        return 10999;
    }

    @Override
    public int start(String app, String[] args, GuiFactory gf) throws IOException {
        this.check();
        gf.exit("ERROR: Client release is incompatible with Iscobol Application Server");
        return -1;
    }

    @Override
    public ServerCall getServerCall(String clientVersion, int clientSessionId) throws IOException {
        String[] clData = new String[6];
        return this.getServerCall(clientVersion, clientSessionId, clData);
    }

    @Override
    public ServerCall getServerCall(String clientVersion, int clientSessionId, String iscobolconf) throws IOException {
        String[] clData = new String[6];
        clData[0] = iscobolconf;
        return this.getServerCall(clientVersion, clientSessionId, clData);
    }

    @Override
    public ServerCall getServerCall(String clientVersion, int clientSessionId, String[] clData) throws IOException {
        this.check();
        int auth = Config.getProperty("iscobol.as.authentication", 1);
        if (auth == 2) {
            String login = null;
            byte[] hashPasswd = null;
            if (clData.length > 1 && clData[1] != null) {
                login = clData[1];
            }
            if (clData.length > 2 && clData[2] != null) {
                try {
                    hashPasswd = ServerHandler.getBytes(clData[2]);
                }
                catch (NumberFormatException ex) {
                    hashPasswd = null;
                }
            }
            Login l = new Login();
            if (login == null || this.challenge == null || l.checkLogin(login, hashPasswd, this.challenge, ClientThread.AUTH_FILE) == null) {
                throw new IscobolRuntimeException(146, login);
            }
        }
        return AppServerImpl.getServerCall(this.getRemoteHost(), this.getRemotePort(), this.sessionId, clientSessionId, clData, this.getDispatcher());
    }

    private static byte[] getBytes(String hexString) throws NumberFormatException {
        byte[] b = new byte[hexString.length() / 2];
        int i = 0;
        int j = 0;
        while (i < hexString.length()) {
            b[j] = (byte)Integer.parseInt(hexString.substring(i, i + 2), 16);
            i += 2;
            ++j;
        }
        return b;
    }

    private void check() throws IOException {
        if (this.getDispatcher().getSession().isMaxConnectionLimitExceeded()) {
            throw new IOException("Max number of connections reached: " + this.getDispatcher().getDualRpcServer().getMaxConnections());
        }
    }

    @Override
    public int start(String prog, String[] args, String iscobolconf, AppFactory af) throws IOException {
        this.check();
        String[] clData = new String[6];
        clData[0] = iscobolconf;
        return AppServerImpl.start(this.getRemoteHost(), this.getRemotePort(), this.session, prog, args, clData, af);
    }

    @Override
    public int start(String prog, String[] args, String[] clData, AppFactory af) throws IOException {
        this.check();
        if (prog == null) {
            if (clData.length > 0 && clData[0] != null && clData[0].length() > 0) {
                Properties p = new Properties();
                try {
                    RtsUtil.loadPropertiesWithImport(p, clData[0]);
                    prog = p.getProperty("iscobol.default_program");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (prog == null && AppServerImpl.defaultPrg != null) {
                prog = AppServerImpl.defaultPrg;
            }
            if (prog != null) {
                String[] ss = RtsUtil.parseArguments(prog);
                args = new String[ss.length - 1];
                prog = ss[0];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = ss[i + 1];
                }
            } else {
                af.exit("Program name not specified");
                return 0;
            }
        }
        return AppServerImpl.start(this.getRemoteHost(), this.getRemotePort(), this.session, prog, args, clData, af);
    }

    public int start(String prog, String od, String runMode, byte[] confFileContents, boolean debug, AppFactory af) throws IOException {
        this.check();
        IIDESettings conf = IDEHandler.getConfigurationFile();
        if (conf != null) {
            String deplFolder = od;
            Map<String, String> m = conf.getRuntimeModes().get(runMode);
            if (m != null) {
                String confFile;
                String cp;
                m = new LinkedHashMap<String, String>(m);
                Map<String, String> def = conf.getModes().get("Default");
                if (def != null && (cp = def.get("iscobol.classpath")) != null) {
                    m.put("iscobol.classpath", cp);
                }
                if (confFileContents != null) {
                    File tmp = File.createTempFile("iscobol", ".conf");
                    tmp.deleteOnExit();
                    confFile = tmp.getAbsolutePath();
                    FileOutputStream out = new FileOutputStream(tmp);
                    out.write(confFileContents);
                    out.close();
                } else {
                    confFile = m.get("iscobol.prog.conffile");
                }
                String utility = m.get("iscobol.prog.utilityopt");
                String a = m.get("iscobol.prog.args");
                String[] args = a != null ? RtsUtil.parseArguments(a) : new String[]{};
                String[] clData = new String[5];
                clData[0] = confFile;
                clData[3] = "" + debug;
                clData[4] = "" + "___iscobol.option.true".equals(utility);
                return AppServerImpl.start(this.getRemoteHost(), this.getRemotePort(), this.session, prog, args, clData, m, deplFolder, af);
            }
            throw new IOException("IDE runtime mode not found: '" + runMode + "'");
        }
        throw new IOException("IDE configuration file not found");
    }

    @Override
    public byte[] initServerCallSession() throws IOException {
        int auth = Config.getProperty("iscobol.as.authentication", 1);
        this.challenge = auth != 2 ? Auth.nullChallenge() : Auth.newChallenge();
        return this.challenge;
    }
}

