/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.ServerHandler;
import com.iscobol.gui.ServerCall;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.client.IClientCallbackHandler;
import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rts.Auth;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Version;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicN;
import com.iscobol.types.PicXAnyLength;
import java.io.IOException;

public class ServerCallHandler
extends AbstractClientRpcHandler
implements IClientCallbackHandler {
    private String host;
    private String port;
    private ServerCall serverCall;
    private DualRpcClient client;
    private int sessionId;

    @Override
    public void brokenConnection() {
        Logger log = RemoteRegistry.getClientProblemLogger();
        if (log != null) {
            log.info(ServerCallHandler.class.getName() + ": disconnected from " + this.host + ", port " + this.port);
        }
    }

    public static ServerCallHandler init(String host, String port) {
        return ServerCallHandler.init(host, port, null);
    }

    public static ServerCallHandler init(String host, String port, String iscobolconf) {
        String clientVer = Version.getCsVersion();
        try {
            String serverVer;
            ServerCallHandler sch = new ServerCallHandler();
            while (true) {
                sch.host = host == null || host.length() == 0 ? "localhost" : host;
                try {
                    sch.port = Integer.parseInt(port) <= 0 ? Integer.toString(ServerHandler.getDefaultPort()) : port;
                }
                catch (NumberFormatException e) {
                    sch.port = Integer.toString(ServerHandler.getDefaultPort());
                }
                sch.client = new DualRpcClient(host, Integer.parseInt(sch.port));
                sch.sessionId = RemoteRegistry.setCaller(new ClientCaller(sch.client));
                Logger problemLog = LoggerFactory.get(64);
                Logger rpcCallLog = LoggerFactory.get(128);
                RemoteRegistry.setClientProblemLogger(problemLog);
                RemoteRegistry.setClientRpcCallLogger(rpcCallLog);
                sch.client.setCallbackHandler(sch);
                sch.client.registerClientSideHandler(sch);
                sch.client.setMessageSerializer(new IscobolMessageSerializer());
                if (problemLog != null) {
                    problemLog.info(ServerCallHandler.class + ": connecting to " + sch.host + ", port " + sch.port);
                }
                sch.client.connect();
                serverVer = (String)sch.client.call(ServerHandler.class.getName(), "getCSVersion");
                if (serverVer.charAt(0) != '@') break;
                sch.client.disconnect();
                if (serverVer.charAt(1) == '!') {
                    throw new IscobolRuntimeException(3, "No server available");
                }
                int colon = serverVer.indexOf(58);
                if (colon > 0) {
                    host = serverVer.substring(1, colon);
                    port = serverVer.substring(colon + 1, serverVer.length());
                    continue;
                }
                sch.host = serverVer.substring(1, serverVer.length());
            }
            int idx = serverVer.indexOf(59);
            if (idx >= 0) {
                serverVer = serverVer.substring(0, idx);
            }
            if (!clientVer.equals(serverVer)) {
                System.err.println("ERROR: Client release (" + clientVer + ") is incompatible with Application Server (" + serverVer + ")");
            }
            String login = Config.getProperty(".user.name", System.getProperty("user.name", null));
            String passwd = Config.getProperty(".user.passwd", "");
            int pwdSize = passwd.length() << 1;
            PicN cPwd = new PicN(new byte[pwdSize], 0, pwdSize, null, null, "", false, false);
            cPwd.set(passwd, false);
            PicXAnyLength rand = Factory.getVarXAnyLength(new byte[0], 0, 0, false, null, null, null, "rand", false, false);
            byte[] rndb = (byte[])sch.client.call(ServerHandler.class.getName(), "initServerCallSession");
            rand.set(rndb);
            String ALG = Auth.getAlgorithmFromChallenge(rand);
            PicXAnyLength hPwd = new PicXAnyLength(new byte[0], 0, 0, null, null, "", false, false);
            PicXAnyLength hhPw = new PicXAnyLength(new byte[0], 0, 0, null, null, "", false, false);
            Auth.getDigest(new CobolVar[]{hPwd, cPwd}, ALG);
            Auth.getDigest(new CobolVar[]{hhPw, rand, hPwd}, ALG);
            byte[] hashPasswd = ((CobolVar)hhPw).getMemory();
            String[] clData = new String[6];
            clData[0] = iscobolconf;
            clData[1] = login;
            clData[2] = ServerCallHandler.toHexString(hashPasswd);
            sch.serverCall = (ServerCall)sch.client.call(ServerHandler.class.getName(), "getServerCall", Version.getVersion(), new Integer(sch.sessionId), clData);
            return sch;
        }
        catch (CallException e) {
            String[] msg = e.getMessage() != null && e.getMessage().startsWith("getCSVersion") ? new String[]{"ERROR: Client release (" + clientVer + ") is incompatible with Application Server"} : e.getMessage().split("(\\n)|(\\r\\n)");
            throw new IscobolRuntimeException(20, msg.length > 0 ? msg[0] : "");
        }
        catch (IscobolRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i]);
            if (hex.length() < 2) {
                sb.append("0").append(hex);
                continue;
            }
            if (hex.length() > 2) {
                sb.append(hex.substring(hex.length() - 2));
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public ServerCall getServerCall() {
        return this.serverCall;
    }

    public void shutdown() throws IOException {
        this.serverCall.shutdown();
        try {
            this.client.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RemoteRegistry.removeCaller(this.sessionId);
    }

    public final String activateLic(byte[] s, String hID, int flag) throws IOException {
        return Config.srl(s, hID, flag);
    }
}

