      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. Customer.

       WORKING-STORAGE SECTION.
       copy "constants.def".
       copy "customer.wrk".
       copy "customer.wrk" replacing 
                                 leading "Customer" by "Customer-back"
                                 leading "Cust" by "Cust-back".
       copy "state.wrk".
       copy "isfonts.def".
       copy "isgui.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "image-handling.wrk".
       77  key-status is special-names crt status pic 999.
       77  w-key             pic 9(5).
       77  w-key-back        pic 9(5).
       77  sub1              handle of window.
       77  h-main            handle of window.

       77  varx3             pic xxx.

       01  lookup-record.
           05 lr-code        pic  z(5).
           05 lr-first-name  pic  x(30).
           05 lr-last-name   pic  x(30).
           
       77  selected          pic 9(5).

       01                    pic 9.
           88 check-ok       value 0 false 1.
       77  err-message       pic x any length.
       77  err-icon          pic 9.
       77  err-code          pic 99.
       77  htoolbar          handle of window.
       77  htoolbar-lookup   handle of window.
       
       77  key-pressed       pic x.
       77  h-status          handle of status-bar.

       77  env-code          pic 9.

       78  78-id-cust-code   value 1.
       78  78-id-first-name  value 2.
       78  78-id-cust-state  value 3.

       SCREEN SECTION.
       01  s1.
           03 frame
              line                          2
              col                           2
              size                          123
              lines                         8
              engraved
              title                         "Customer"
              . 
           03 label
              line                          4 
              col                           3
              size                          14
              title                         "Customer code:"
              . 
           03 entry-field
              line                          4
              col                           19
              size                          5
              numeric
              right
              value                         cust-code
              id                            78-id-cust-code 
              .
           03 label
              line                          6
              col                           3
              size                          11   
              title                         "First name:"
              . 
           03 entry-field
              line                          6
              col                           19
              size                          102
              value                         Cust-First-Name
              id                            78-id-first-name 
              .
           03 label
              line                          8
              col                           3
              size                          11
              title                         "Last name:"
              .
           03 entry-field
              line                          8
              col                           19
              size                          102
              value                         Cust-last-Name
              .
           03 frame
              line                          12 
              col                           2
              size                          123
              lines                         6
              engraved
              title                         "Address" 
              .
           03 label
              line                          14 
              col                           3
              size                          11
              title                         "Street:".
           03 entry-field
              line                          14
              size                          45
              col                           19
              value                         Cust-Street
              .
           03 label
              line                          14
              col                           68
              size                          11
              title                         "City:"
              .
           03 entry-field
              line                          14
              col                           76
              size                          45
              value                         Cust-City
              .
           03 label
              line                          16
              col                           3
              size                          11
              title                         "State:"
              .
           03 entry-field
              line                          16
              col                           19
              size                          5
              value                         Cust-State
              after                         CHECK-STATE
              id                            78-id-cust-state
              .
           03 label
              line                          16 
              col                           27
              size                          50
              title                         state-description
              .
           03 label
              line                          16
              col                           68
              size                          11
              title                         "Zip code:"
              .
           03 entry-field
              line                          16
              col                           76
              size                          9
              value                         Cust-Zip
              .
           03 frame
              line                          20
              col                           2
              size                          123
              lines                         8
              engraved
              title                         "Detail".
           03 label
              line                          22 
              col                           3
              size                          11
              title                         "Gender:"
              .
           03 Radio-button
              line                          22
              col                           19
              size                          8
              value                         Cust-Gender
              title                         "Male"
              group                         1
              group-value                   "M"
              .
           03 Radio-button
              line                          22
              col                           30
              size                          8
              value                         Cust-Gender
              title                         "Female"
              group                         1
              group-value                   "F"
              .
           03 label
              line                          24 
              size                          18
              col                           3
              title                         "Phone number:"
              .
           03 entry-field
              line                          24
              col                           19
              size                          103
              value                         Cust-Phone
              .
           03 label
              line                          26
              col                           3
              size                          18
              title                         "CellPhone number:".
           03 entry-field
              col                           19
              size                          103
              value                         Cust-CellPhone
              .

       01  s-func.
           03 push-button
              col                           2
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-lookup
              bitmap-width                  78-tb-bmp-width
              title-position                2
              exception-value               1
              self-act
              hint                          "F1"
              title                         "Lookup"
              css-icon                      "fa-list"
              .
           03 push-button
              col                           14.4
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-lookup
              bitmap-width                  78-tb-bmp-width
              title-position                2
              exception-value               2
              self-act
              hint                          "F1"
              title                         "Lookup State"
              css-icon                      "fa-list"
              .
           03 push-button
              col                           26.4
              exception-value               5
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-first
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F5"
              title                         "First"
              css-icon                      "fa-angle-double-left"
              .
           03 push-button
              col                           38.6
              exception-value               6
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-prev
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F6"
              title                         "Prev"
              css-icon                      "fa-angle-left"
              .
           03 push-button
              col                           50.8
              exception-value               7
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-next
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F7"
              title                         "Next"
              css-icon                      "fa-angle-right"
              .
           03 push-button
              col                           63.0
              exception-value               8
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-last
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F8"
              title                         "Last"
              css-icon                      "fa-angle-double-right"
              .
           03 bar
              col                           75.3
              lines                         2 
              width                         2
              size                          1
              color                         16
              shading                       (-1, 1)
              .
           03 push-button
              col                           75.5
              exception-value               9
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-save
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F9"
              title                         "Save"
              css-icon                      "fa-save"
              .
           03 push-button
              col                           87.7
              exception-value               3
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-delete
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F3"
              title                         "Delete"
              css-icon                      "fa-trash"
              .

           03 bar
              col                           100
              lines                         2 
              width                         2
              size                          1
              color                         16
              shading                       (-1, 1)
              .
           03 pb-pdf
              push-button
              col                           100.5
              exception-value               10
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-print
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F10"
              title                         "Print"
              css-icon                      "fa-file-pdf-o"
              .
           03 bar
              col                           112.8
              lines                         2
              width                         2
              size                          1
              color                         16
              shading                       (-1, 1)
              .
           03 push-button
              col                           113.3
              exception-value               27
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-exit
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "Esc"
              title                         "Exit"
              css-icon                      "fa-times"
              .

       01  s-lookup.
           03 gd-lookup 
              grid 
              line                          5
              col                           2
              lines                         12
              size                          69
              display-columns               (1, 8, 38)
              data-columns                  (1, 6, 36)
              alignment                     ("R", "L", "L")
              data-types                    ("Z(5)", "X", "X") 
              heading-color                 257
              cursor-frame-width            0
              row-Cursor-Background-Color   rgb x#6D8AD6
              row-Cursor-Foreground-Color   rgb x#FFFFFF
              boxed
              column-headings 
              centered-headings
              tiled-headings
              Adjustable-Columns
              sortable-columns
              rows-per-page                 10
              Vscroll
              Row-Background-Color-Pattern  (0, -14675438)
              EVENT PROCEDURE               GD-LOOKUP-EVENT
              .
           03 label 
              col                           2 
              line                          2
              size                          68
              title "Select a customer by double clicking on the row or 
      -             "pressing 'Select' button"
              center
              .

       01 s-lookup-tool.
           03 Push-Button
              col                           1.2 
              line                          3
              lines                         2.2 
              cells
              size                          13 cells
              bitmap-width                  78-tb-bmp-width
              bitmap-number                 78-nb-save 
              exception-value               3
              title                         "&Select"
              hint                          "(F3)"
              title-position                2
              self-act
              css-icon                      "fa-check-circle"
              .
           03 bar
              col                           15.0
              lines                         2 
              width                         2
              size                          1
              color                         16
              shading                       (-1, 1)
              .
           03 push-button 
              title                         "&Exit"
              hint                          "(Esc)"
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-exit 
              title-position                2
              lines                         2.2 cells
              size                          12 cells
              bitmap-width                  78-tb-bmp-width
              col                           15.6
              exception-value               27
              self-act
              css-icon                      "fa-times"
              .

       PROCEDURE DIVISION.
       MAIN.

           call "PCUSTOMER" using 78-OPEN-I-O
           call "PSTATE" using 78-OPEN-INPUT

           display independent graphical window
                   system menu
                   title  "CUSTOMER MAINTENANCE"
                   size 125
                   lines 30
                   line 1
                   control font small-font
                   visible 0
                   undecorated
                   handle h-main
                   event  WIN-EVT
                   .

           display s1.

           display tool-bar lines 2.5 control font small-font 
                   handle htoolbar upon h-main
           display s-func upon htoolbar.

           call "W$CENTER_WINDOW" using h-main
           
           modify h-main visible 1
           
           perform until key-status = 27
              accept s1 
                 on exception 
                    continue 
              end-accept
              evaluate key-status
              when 1
                   perform LOOKUP
              when 2   
                   perform LOOKUP-STATE
              when 3
                   perform REC-DELETE
              when 5
                   perform REC-FIRST
              when 6
                   perform REC-PREV
              when 7
                   perform REC-NEXT
              when 8
                   perform REC-LAST
              when 9
                   perform REC-SAVE
              when 10
                   perform PRINT-REPORT
              end-evaluate
              move 4   to accept-control
           end-perform.
           call "PCUSTOMER" using 78-close
           call "PSTATE" using 78-close

           destroy h-main
           goback.

       SHOW-RECORD.
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
              display s1
           end-if.

       REC-FIRST.
           move low-value to w-key(1:)
           call "PCUSTOMER" using 78-start-great, w-key
           call "PCUSTOMER" using 78-read-next, customer-rec
           perform SHOW-RECORD.

       REC-PREV.  
           call "PCUSTOMER" using 78-read-prev, customer-rec
           perform SHOW-RECORD.

       REC-NEXT.  
           call "PCUSTOMER" using 78-read-next, customer-rec
           perform SHOW-RECORD.

       REC-LAST.  
           move high-value to w-key
           call "PCUSTOMER" using 78-start-less, w-key
           call "PCUSTOMER" using 78-read-next, customer-rec
           perform SHOW-RECORD.

       REC-DELETE.
           display message 
                 "ARE YOU SURE YOU WANT TO DELETE THIS RECORD?"
                 type mb-yes-no
                 default mb-no
                 icon mb-warning-icon  
                 giving varx3
           if varx3 = mb-yes 
              call "PCustomer" using 78-delete, cust-code
              if return-code > 9
                 perform SHOW-ERROR
              else
                 initialize customer-rec
                 move "M" to Cust-Gender
                 display s1
              end-if
           end-if.

       REC-SAVE.
           perform CHECK-FIELDS.
           if check-ok
              call "PCustomer" using 78-write, customer-rec
              if return-code = 22
                 call "PCustomer" using 78-rewrite, customer-rec
                 if return-code > 9
                    perform SHOW-ERROR
                 end-if
              end-if
           end-if.

       CHECK-FIELDS.
           set check-ok   to true.

           if cust-Code = 0
              move "CUSTOMER CODE MANDATORY"  to err-message
              perform SHOW-ERROR
              move 78-id-cust-code to control-id
              set check-ok   to false
           end-if

           if check-ok 
              if Cust-First-Name = space and 
                 Cust-Last-Name = space
                 move "CUSTOMER NAME MANDATORY"  to err-message
                 perform SHOW-ERROR
                 move 78-id-first-name   to control-id
                 set check-ok   to false
              end-if
           end-if
           
           if check-ok
              perform CHECK-STATE
           end-if.
           .

       CHECK-STATE.
           set check-ok   to true
           if Cust-State not = space
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, State-rec
              if return-code > 9
                 move "INVALID STATE CODE"  to err-message
                 perform SHOW-ERROR
                 move space  to State-Description
                 move 78-id-cust-state   to control-id
                 set check-ok   to false
              end-if
              display s1
           end-if
           .

       PRINT-REPORT.
           call "PCustomer" using 78-close.

           modify pb-pdf css-icon "fa-spinner fa-spin"

           call "PRINTCUSTOMER".

           modify pb-pdf css-icon "fa-file-pdf-o"

           call "PCustomer" using 78-open-i-o.
           call "PCustomer" using 78-read, customer-rec.

       SHOW-FILE-ERROR.
           initialize err-message
           
           if return-code = 10
              move "NO MORE RECORDS"  to err-message
              move mb-warning-icon    to err-icon
           else
              move return-code        to err-code 
              move err-code           to err-message
              move mb-error-icon      to err-icon
           end-if
           
           display message box err-message
                   title "ERROR: "
                   icon err-icon 
           .

       SHOW-ERROR.
           display message box err-message
                   title "ERROR: "
                   icon mb-error-icon 
           .

       LOOKUP.
           move customer-rec to customer-back-rec

           display floating graphical window
                   background-low  
                   title  "CUSTOMER LOOKUP"
                   size 75
                   lines 25
                   control font small-font
                   visible 0
                   handle sub1
                   .

           display s-lookup upon sub1

           display tool-bar lines 2.5 control font small-font 
                   handle htoolbar-lookup upon sub1
           display s-lookup-tool upon htoolbar-lookup.

           move 0 to selected
           modify gd-lookup(1, 1) cell-data "code"
           modify gd-lookup(1, 2) cell-data "first name"
           modify gd-lookup(1, 3) cell-data "Last name"
           
           modify sub1 visible 1
           
           perform load-table
           perform until key-status = 27 or 13
              accept s-lookup
                 on exception 
                   continue
              end-accept
              perform S-LOOKUP-AFTER-ACCEPT
           end-perform

           destroy sub1

           if selected = 0
              move Cust-back-Code    to Cust-Code
              call "PCUSTOMER" using 78-read, customer-rec
              move customer-back-rec to customer-rec
              move 0                 to return-code
           else
              call "PCUSTOMER" using 78-read, customer-rec
           end-if
           perform SHOW-RECORD

           move 0 to key-status
           .

       LOOKUP-STATE.
           call "LOOKUP-STATE" using state-rec
           move state-Code   to Cust-State
           display s1
           .

       S-LOOKUP-AFTER-ACCEPT.
           if key-status = 3|13
              inquire gd-lookup cursor-y selected
           end-if
           if selected > 0
              inquire gd-lookup(selected, 1) cell-data cust-code
              move 27  to key-status
           end-if.

       MOVE-CUST-TO-W.
           move cust-code          to lr-Code.
           move cust-first-name    to lr-First-Name.
           move cust-last-name     to lr-last-Name.
           modify gd-lookup record-to-add lookup-record.

       LOAD-TABLE.
           modify gd-lookup mass-update 1
           move low-value to w-key.
           call "PCUSTOMER" using 78-start-great w-key.
           perform until 1 = 2
              call "PCUSTOMER" using 78-read-next customer-rec
              if return-code > 9
                 exit perform
              end-if
              perform MOVE-CUST-TO-W
           end-perform.
           modify gd-lookup mass-update 0.

       GD-LOOKUP-EVENT.
           evaluate event-type
           when msg-begin-entry
                inquire gd-lookup entry-reason key-pressed
                if key-pressed = grer-enter or 
                   key-pressed = grer-dblclick
                   move event-data-2    to selected
                end-if
                set event-action to event-action-fail-terminate
           end-evaluate
           .

       LOAD-BMP.
           call "W$BITMAP" using wbitmap-load 
                                 "tools.png"
                          giving h-tools.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 27 to key-status
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 27 to key-status
           end-evaluate
           .
