      *    Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *    may freely modify and redistribute this program.
      
       program-id. webclient-bridge.

       input-output section.
       file-control.
       copy "users.sl".

       data division.
       file section.
       copy "users.fd".
           
       working-storage section.
           copy "common.wrk".
           copy "color.wrk".
           copy "iwc.wrk".
           copy "iwc.lks".
           copy "settings.wrk".
           
       77  pgm-name             pic x any length.
       77  logged-user          pic x any length.
       
       77  status-users         pic xx.

       77  path-font            pic x any length.
       77  font-name            pic x any length.
       77  wrk-font-name        pic x any length.
       77  toolbar-characters   pic n any length.
       
       77  num-param            pic 9(3).
       77  wrk-string           pic x any length.

       77                       pic x.
           88 multi-webapp      value "m".
           88 single-webapp     value "s".

       77  session-id           pic x any length.

       01  iwc-struct.
           03 iwc-action     pic x any length.
           03 iwc-data       pic x any length.
           03 iwc-bytes      pic x any length.
       77  wrk-return-code   pic s99.

       linkage section.
       copy "webclient-bridge.lks".

       procedure division using wb-lks.
       MAIN.
      
           call "C$NARG" using num-param
           evaluate num-param
           when 3
                set multi-webapp  to true
           when 1
                set single-webapp to true
           when other
                display message "Unauthorized Session"
                        icon mb-error-icon
                goback
           end-evaluate

           call "IWC"

           if multi-webapp
              accept wrk-string from command-line
              unstring wrk-string delimited by " "
                       into pgm-name 
                            logged-user
                            session-id

              open input Users
              move logged-user  to users-id
              read Users
                 invalid
                    display message "Unauthorized User"
                            icon mb-error-icon
                    goback
              end-read
              close Users

              move logged-user     to user-logged
              move users-type      to user-type
              call "IWC-START-COMUNICATION"
              set multi-webapp     to true

      *    called from another cobol program
           else
              move wb-logged-user  to user-logged
              move wb-user-type    to user-type
              move wb-pgm-name     to pgm-name
              set single-webapp    to true
           end-if

           perform SETTINGS

           move pgm-name  to name-of-main-pgm

           perform LOAD-FONT
           perform LOAD-IMAGE

           display standard graphical window
                   lines 37
                   size 108
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   link to thread
                   undecorated.

           if multi-webapp
              perform GET-SESSION-ID
              if iwc-send-data not = session-id
                    display message "Unauthorized Session"
                            icon mb-error-icon
                    goback
              end-if
           end-if

           call pgm-name.

           perform DESTROY-RESOURCE

           if multi-webapp
              call "IWC-STOP-COMUNICATION"
           end-if
           
           goback.

       GET-SESSION-ID.
           call "IWC-GET-SESSION-ID"

           perform until 1 = 2
              initialize iwc-send-action
                         iwc-send-data
                         iwc-send-bytes

              call "IWC-GET-MESSAGE" using iwc-send-action
                                           iwc-send-data
                                           iwc-send-bytes
                                           iwc-status-get
                                    giving return-code
              evaluate iwc-send-action
              when 78-iwc-session-id
                   exit perform
              end-evaluate
           end-perform
           .

       LOAD-IMAGE.
           string nx"f002" |search 
                  nx"f0c7" |save 
                  nx"f2ed" |delete 
                  nx"f100" |first
                  nx"f104" |previuous
                  nx"f105" |next
                  nx"f101" |last
                  nx"f2f5" |exit 
                  nx"f02f" |print
                  nx"f15b" |new 
                  nx"f129" |about 
                  nx"f2f6" |logout
                  nx"f1c1" |pdf
                  nx"f044" |edit
                  nx"f03e" |print preview
                  nx"f5a0" |map
                  nx"f7bf" |satellite
                  nx"f018" |road
                  nx"f7a2" |terrian
                  nx"f140" |show area
                  nx"f5da" |description
                  nx"f5a0" |reposition area
                  into toolbar-characters.
           initialize wbitmap-lsf-data
           move h-font-awsome               to wbitmap-lsf-font(1)
                                               wbitmap-lsf-font(2)
           move toolbar-characters          to wbitmap-lsf-characters(1)
                                               wbitmap-lsf-characters(2)
           move 78-toolbar-fore-color          to wbitmap-lsf-color(1)
           move 78-toolbar-pb-rollover-color   to wbitmap-lsf-color(2)

           call "W$BITMAP" using wbitmap-load-symbol-font-ex
                                 18
                                 wbitmap-lsf-data
                          giving h-tools
           .

       LOAD-FONT.
           accept path-font from environment "font_folder"

           initialize font-name
           string path-font  delimited by size
                  "/Font Awesome 5 Free-Solid-900.otf"
                             delimited by size
                  into font-name

           call "w$createfont" using font-name
                                     wrk-font-name

           initialize wfont-data
           set wfdevice-console to true
           move wrk-font-name   to wfont-name
           move 10              to wfont-size
           call "W$FONT" using wfont-get-font
                               h-font-awsome
                               wfont-data

           initialize font-name
           string path-font                    delimited by size
                  "/SourceSansPro-Regular.ttf" delimited by size
                  into font-name

           call "w$createfont" using font-name
                                     wrk-font-name

           initialize wfont-data
           move wrk-font-name   to wfont-name
           move 13              to wfont-size
           call "W$FONT" using wfont-get-font h-font wfont-data

           move wrk-font-name   to wfont-name
           move 13              to wfont-size
           call "W$FONT" using wfont-get-font h-font-toolbar wfont-data
           .

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy h-sta 
                   h-font
                   h-font-toolbar 
           call "W$BITMAP" using wbitmap-destroy h-tools
           .

           copy "settings.prd".