const MENU_CONTAINER_START = '<li class="nav-item menu-open" ><a href="#" class="nav-link menu-container-toggle"><i class="nav-icon far fa-folder"></i><p>$description<i class="fas fa-angle-left right"></i></p></a><ul class="nav nav-treeview">';
const MENU_CONTAINER_END = '</ul>';

const MENU_ITEM = '<li class="nav-item"><a id="$progId" href="#" '+
 'data-id="$progId" data-description="$description" ' + 
 'data-js="startApplication(\'$description\' , \'$progId\')"'+
   'onclick="return startApplication(\'$description\' , \'$progId\')"'+
   ' class="menu-item nav-link"><i class="nav-icon fas fa-archive"></i><p>$description</p></a></li>';


   var menuAppInstance = {
      options: {
          autoStart: true,
          args: '',
          connectionUrl:baseAddress + '/' + menuWebAppName,
      }
    }

function buildMenu(menu){
 
   menu.userMenu.level1.forEach(
      mi => {

         var domNode = buildMenuContainer(mi);
 
         if (mi.children){
            mi.children.forEach(mi => {
              domNode += buildMenuItem(mi);
            })
         }

         domNode += closeMenuContainer();

         document.getElementById('menu').appendChild($($.parseHTML(domNode))[0]);

      }
   )

   //build search options
   $('#menu-search').SidebarSearch('init')
   
   // attach menu group toggle switch event
   $('.menu-container-toggle').on('click', e => {
      $(e.target.closest('li')).toggleClass('menu-open')
    });
  

 }

 function buildMenuContainer(menuItem){
    if (!menuItem.type){
       return createMenuContainer(menuItem['prog-id'], menuItem.description);
    }
 }

 function buildMenuItem(menuItem){
   if (menuItem.type === 'gui'){
      return createMenuItem(menuItem.progId, menuItem.description);
   }
}


 function createMenuContainer(progId, description){
    return MENU_CONTAINER_START.replaceAll('$progId', progId).replaceAll('$description', description);
 }

 function closeMenuContainer(){
   return MENU_CONTAINER_END;
 }

 function createMenuItem(progId, description){
   return MENU_ITEM.replaceAll('$progId', progId).replaceAll('$description', description);
}

