$(document).ready(function () {
	$('#listCustomers').on('shown.bs.modal', function () {
		retrieveCustomers();
	});
	$('#listState').on('shown.bs.modal', function () {
		retrieveState();
	});
});

var response = {
	CustomerRec: null,
	status: null
}
var stateResponse = {
	stateRec: null,
	status: null
}

/********** Button handlers ****************/

function first() {
	callServer('FIRST');
}

function next() {
	if (response.CustomerRec != null)
		callServerWithID('NEXT', response.CustomerRec.Code);
}

function previous() {
	if (response.CustomerRec != null)
		callServerWithID('PREV', response.CustomerRec.Code);
}

function last() {
	callServer('LAST');
}

function deleteCustomer() {
	if (response.CustomerRec != null) {
		callServerWithID('DELETE', response.CustomerRec.Code);
		first();
	}
}

function search() {
	// if we don't have a CustomerRec yet, create one
	if (response.CustomerRec == null)
		response.CustomerRec = new Object();
	// set the id of the Customer we're looking for
	response.CustomerRec.Code = $('#searchField').val();
	callServerWithID('SEARCH', response.CustomerRec.Code);

	$('#searchField').val('');
}

function updateCustomer() {
	var Customer = retrieveCustomerData();
	var data = new Object();
	data.CustomerRec = Customer;
	callServerWithData('SAVE', data);
}

function listCustomers() {

	//	$('#listCustomers').modal();
}

function retrieveCustomers() {
	callServer('LOOKUP', listCustomerSuccess)
}

function listCustomerSuccess(data, textStatus, jqXHR) {

	response.CustomerRec = data["Response"].CustomerRec;
	response.RequestStatus = data["Response"].RequestStatus;
	var customers = data["Response"].lk_lookup.lk_lookup_record;

	// fill customer lookup table
	var table = document.getElementById('customerTable');
	for (var i = table.rows.length - 1; i > 0; i--)
		table.deleteRow(i);

	for (var i = 0; i < customers.length; i++) {
		row = table.insertRow(table.rows.length);
		row.style = { 'cursor': 'pointer' };

		var cellCode = row.insertCell(0);
		var cellContent = document.createTextNode(customers[i].Code);
		cellCode.appendChild(cellContent);

		var cellFirstName = row.insertCell(1);
		var cellContent = document.createTextNode(customers[i].FirstName || '');
		cellFirstName.appendChild(cellContent);

		var cellLastName = row.insertCell(2);
		var cellContent = document.createTextNode(customers[i].lastName || '');
		cellLastName.appendChild(cellContent);


		row.onclick = function () {
			callServerWithID('SEARCH', this.firstElementChild.innerHTML);
			$('#listCustomers').modal('hide');
		}

	}

}

function clearData() {
	response = {
		CustomerRec: null,
		status: null
	};
	$('#id').val('');
	$('#FirstName').val('');
	$('#LastName').val('');
	$('#Street').val('');
	$('#City').val('');
	$('#State').val('');
	$('#ZipCode').val('');
	$('#Gender').val('');
	$('#PhoneNumber').val('');
	$('#CellPhoneNumber').val('');
}

function pdfReport() {
	window.open("servlet/PRINTCUSTOMER?nocache=" + Math.random());
}

function retrieveCustomerData() {
	var Customer = {
		Code: $('#id').val(),
		FullName: {
			FirstName: $('#FirstName').val(),
			LastName: $('#LastName').val()
		},
		Address: {
			Street: $('#Street').val(),
			City: $('#City').val(),
			State: $('#State').val(),
			ZipCode: $('#ZipCode').val()
		},
		Gender: $('#Gender').val(),
		Phone: $('#PhoneNumber').val(),
		CellPhone: $('#CellPhoneNumber').val()
	}

	var res = JSON.stringify(Customer);

	return Customer;
}

/************* Web service calls and response handlers *******/

function callServer(operation, successFctn, errorFctn) {
	var successFunctionToCall = handleSuccess;
	var errorFunctionToCall = handleError;
	if (successFctn)
		successFunctionToCall = successFctn;
	if (errorFctn)
		errorFunctionToCall = errorFunctionToCall;

	var url = 'servlet/' + operation + "?nc=" + Math.random();

	$.ajax(url,
		{
			type: 'GET',
			contentType: "application/json",
			success: successFunctionToCall,
			error: errorFunctionToCall
		}
	);

}

function callServerWithID(operation, id) {
	var url = 'servlet/' + operation + '?Code=' + id + "&nc=" + Math.random();

	$.ajax(url,
		{
			type: 'GET',
			contentType: "application/json",
			success: handleSuccess,
			error: handleError
		}
	);

}


function callServerWithData(operation, dataToSend) {
	var CustomerRec = JSON.stringify(dataToSend);
	var url = 'servlet/' + operation + "?nc=" + Math.random();
	$.ajax(url,
		{
			type: 'POST',
			contentType: "application/json",
			success: handleSuccess,
			error: handleError,
			dataType: 'json',
			data: CustomerRec
		}
	);
}

function handleError(jqXHR, textStatus, errorThrown) {
	$("#rsperror").html(textStatus + " " + jqXHR.status + " " + jqXHR.statusText +
		"\n" + jqXHR.responseText);
}

function handleSuccess(data, textStatus, jqXHR) {
	response.CustomerRec = data["Response"].CustomerRec;
	response.RequestStatus = data["Response"].RequestStatus;

	if (response.CustomerRec) {
		$('#id').val(response.CustomerRec.Code);
		$('#FirstName').val(response.CustomerRec.FullName.FirstName);
		$('#LastName').val(response.CustomerRec.FullName.LastName);
		$('#Street').val(response.CustomerRec.Address.Street);
		$('#City').val(response.CustomerRec.Address.City);
		$('#State').val(response.CustomerRec.Address.State);
		$('#ZipCode').val(response.CustomerRec.Address.ZipCode);
		$('#Gender').val(response.CustomerRec.Gender);
		$('#PhoneNumber').val(response.CustomerRec.Phone);
		$('#CellPhoneNumber').val(response.CustomerRec.CellPhone);

		// search state details+
		if (response.CustomerRec.Address.State != null && response.CustomerRec.Address.State != '') {
			searchState(response.CustomerRec.Address.State);
		} else {
			$('#stateDescription').val('');
		}


	}

	if (response.RequestStatus.FileStatus == 0) {
		$("#rsperror").html(response.RequestStatus.Status + " " + (response.RequestStatus.ReturnMessage || ''));
	} else {
		$("#rsperror").html(response.RequestStatus.Status +
			" - File Status: " + response.RequestStatus.FileStatus +
			" - " + response.RequestStatus.ReturnMessage);
	}
	return response.status == "OK";
}


function searchState(stateCode) {
	// if we don't have a StateRec yet, create one
	if (response.StateRec == null)
		response.StateRec = new Object();
	// set the id of the State we're looking for
	callServerWithStateID('STATESEARCH', stateCode);
}


function callServerWithStateID(operation, id) {
	var url = 'servlet/' + operation + '?Code=' + id + "&nc=" + Math.random();

	$.ajax(url,
		{
			type: 'GET',
			contentType: "application/json",
			success: (res) => {
				stateResponse.stateRec = res.Response.StateRec;
				$('#State').val(stateResponse.stateRec.Code);
				$('#stateDescription').val(stateResponse.stateRec.Description);
			},
			error: handleError
		}
	);
}

function retrieveState() {
	callServer('STATELOOKUP', (data) => {
		response.StateRec = data["Response"].StateRec;
		response.RequestStatus = data["Response"].RequestStatus;
		var State = data["Response"].lk_lookup.lk_lookup_record;

		// fill State lookup table
		var table = document.getElementById('stateTable');
		for (var i = table.rows.length - 1; i > 0; i--)
			table.deleteRow(i);

		for (var i = 0; i < State.length; i++) {
			row = table.insertRow(table.rows.length);
			row.style = { 'cursor': 'pointer' };

			var cellCode = row.insertCell(0);
			var cellContent = document.createTextNode(State[i].Code);
			cellCode.appendChild(cellContent);

			var cellFirstName = row.insertCell(1);
			var cellContent = document.createTextNode(State[i].Description);
			cellFirstName.appendChild(cellContent);

			row.onclick = function () {
				callServerWithStateID('STATESEARCH', this.firstElementChild.innerHTML);
				$('#listState').modal('hide');
			}

		};
	})
}
