      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. wprogress.

       WORKING-STORAGE SECTION.
       copy "iscoblib.def".   
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  path-help               pic x any length.
       77  path-copy-client-help   pic x any length.
       77  path-user-home          pic x any length.
       77  wstatus                 pic s9.

       77  w-flags                 pic 99.
       77  pd-handle               usage handle.

       01  w-message-line.
           03 filler     pic x(10) value "Progress: ".
           03 w-perc     pic 999.
           03 filler     pic x(4)  value "/100".

       77  CANCEL-STATUS PIC 9.

       SCREEN SECTION.
       01  Mask.
           03 Pb-open
              push-button
              line                 4
              col                  2
              size                 16 cells
              title                "Start Processing"
              exception-value      101
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           accept terminal-abilities from terminal-info.
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$PROGRESSDIALOG routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 101
                   perform SHOW-PROGRESS 
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       SHOW-PROGRESS.

           compute w-flags = wprogressdialog-notime + 
                             wprogressdialog-noprogressbar .
           call "W$PROGRESSDIALOG" using wprogressdialog-create
                                         "My customized title" 
                                         "Aborting Process"
                                         w-flags
                                  giving pd-handle.

           perform varying w-perc from 0 by 10 until w-perc > 100

              call "W$PROGRESSDIALOG" using wprogressdialog-set-line
                                            pd-handle, 
                                            w-message-line, 
                                            1, 
                                            0

              call "W$PROGRESSDIALOG" using wprogressdialog-query-cancel
                                            pd-handle 
                                     giving cancel-status
              if cancel-status = 1
                 exit perform
              end-if
      *    the following C$SLEEP emulates the real processing
              call "C$SLEEP" using 0.5
           end-perform.

           call "W$PROGRESSDIALOG" using wprogressdialog-destroy
                                         pd-handle.

           IF CANCEL-STATUS = 1
              display message "Process Aborted"
           ELSE
              display message "Process Completed"
           END-IF.

           