      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    WMENU.
       
       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "iscobol.def".
       copy "isfonts.def".
       copy "isresize.def".
       77  hWin                    usage handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  crt-status              is special-names crt status pic 9(5). 

       77  w-check                 pic 9 value 1.
       77  h-img                   pic s9(9) comp-4.

       77  h-menu-font             handle of font.

       77  version                 pic x any length.

       78  mnu-new                 value 1001.
       78  mnu-open                value 1002.
       78  mnu-save                value 1003.
       78  mnu-cut                 value 2001.
       78  mnu-copy                value 2002.
       78  mnu-paste               value 2003.
       
       78  tray-click              value 3001.
       78  tray-dbl-click          value 3002.
       78  tray-version            value 3003.
       
       78  pupup-item              value 4001.

       77  h-popup                 handle of menu.
       77  h-tray-menu             handle of menu.

       77  menu-type               pic 9 value 1.
           88 menu-bar             value 1.
           88 hamburger-menu       value 2.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 3
              col                  3
              title                "Menu style: " 
              .
           03 radio-button
              group                1
              group-value          1
              line                 3.10
              col                  15 
              title                "Menu-bar"
              value                menu-type
              exception-value      101
              self-act
              .
           03 radio-button
              group                1
              group-value          2
              line                 3.10
              col                  32
              title                "Hamburger" 
              value                menu-type
              exception-value      101
              self-act
              .
           03 cb
              check-box
              title                "Check/Uncheck MenuItem"
              line                 6 
              col                  3
              value                w-check
              exception-value      102
              .
           03 label
              line                 8
              col                  3
              title                "Ensure visible: " 
              .
           03 push-button
              title                "'File' element"
              line                 8
              col                  16
              size                 11
              exception-value      103
              .
           03 push-button
              title                "'Edit' element"
              line                 8 
              col                  30
              size                 11
              exception-value      104
              .
           03 label
              line                 10
              col                  3
              size                 18 cells
              title                "Last menu choice: " 
              .
           03 lb-choice
              label
              line                 10
              col                  21
              size                 30
              .
           03 label
              line                 13
              col                  3
              title                "Right click on the screen to open po
      -                            "p-up menu" 
              .
           03 label
              line                 16
              col                  3
              title                "A tray area icon has been created by 
      -                            " the application" 
              .
           03 label
              line                 17
              col                  3
              title                "Left or Right click on the tray area
      -                            " icon to interact" 
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       Main.

      *    attributes for hamburger menu
           initialize wfont-data
           move "Arial" to wfont-name
           move 11 to wfont-size

           call "W$FONT" using wfont-get-font h-menu-font wfont-data

           call "w$menu" using wmenu-set-attribute
                               "default-font" 
                               h-menu-font.

           call "w$menu" using wmenu-set-attribute
                               "width" 
                               150.

           call "w$menu" using wmenu-set-attribute
                               "height"
                               210.

           call "w$menu" using wmenu-set-attribute
                               "layout-manager"
                               "lm-zoom"

           call "w$bitmap" using wbitmap-load, "files/tools.gif",
                          giving h-img

           perform BUILD-MENU
           perform BUILD-TRAY-MENU 
           perform BUILD-POPUP-MENU

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$MENU Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   pop-up menu h-popup
                   event  WIN-EVT

           call "w$menu" using wmenu-show 
                               menu-handle.
           call "w$menu" using wmenu-show 
                               h-tray-menu

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform 

           destroy Mask
           destroy hWin
           destroy control-font
           call "W$MENU" using wmenu-destroy-delayed
                               menu-handle
           call "W$MENU" using wmenu-destroy-delayed 
                               h-popup
           call "W$MENU" using wmenu-destroy-delayed 
                               h-tray-menu
           destroy h-menu-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                call "W$MENU" using wmenu-destroy-delayed 
                                    menu-handle
                perform BUILD-MENU

                call "w$menu" using wmenu-show 
                                    menu-handle
           when 102 
                inquire cb value w-check
                if w-check = 0
                   call "w$menu" using wmenu-uncheck
                                       menu-handle, 80
                else
                   call "w$menu" using wmenu-check 
                                       menu-handle, 80
                end-if
           when 103
                call "w$menu" using wmenu-ensure-visible 
                                    sub-handle-1 
                                    0
           when 104
                call "w$menu" using wmenu-ensure-visible 
                                    sub-handle-2
                                    0
           when mnu-new
                modify lb-choice title "New"
           when mnu-open
                modify lb-choice title "Open"
           when mnu-save
                modify lb-choice title "Save"
           when mnu-cut
                modify lb-choice title "Cut"
           when mnu-copy
                modify lb-choice title "Copy"
           when mnu-paste
                modify lb-choice title "Paste"
           when tray-click
                display message "Click on tray"
           when tray-dbl-click
                display message "Double Click on tray"
           when tray-version
           when pupup-item
                call "C$VERSION" using version
                display message "isCOBOL Framework version:" 
                               x"0D0a" 
                                version
           end-evaluate.

       BUILD-MENU. 
           evaluate true
           when menu-bar
                call "w$menu" using wmenu-new 
                             giving menu-handle
           when hamburger-menu
                call "w$menu" using wmenu-new-hamburger 
                             giving menu-handle
           end-evaluate
           
           call "w$menu" using wmenu-new giving sub-handle-1
           
           call "w$menu" using wmenu-add, menu-handle, 0, 0,
                               "&File", 0, sub-handle-1
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "&New", mnu-new
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-new h-img 3 16
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "&Open", mnu-open
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-open h-img 9 16
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "&Save", mnu-save
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-save h-img 10 16
           call "w$menu" using wmenu-add, sub-handle-1, 0, w-separator
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "E&xit", 27
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 27 h-img 1 16

           call "w$menu" using wmenu-new giving sub-handle-2

           call "w$menu" using wmenu-add, menu-handle, 0, 0,
                               "&Edit", 0, sub-handle-2
           call "w$menu" using wmenu-add, sub-handle-2, 0, 0,
                               "&Cut", mnu-cut
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-cut h-img 2 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, 0,
                               "&Copy", mnu-copy
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-copy h-img 3 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, 0,
                               "&Paste", mnu-paste
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-paste h-img 4 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, w-separator
           call "w$menu" using wmenu-add, sub-handle-2, 0, w-disabled,
                               " w-disabled", 70
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 70 h-img 5 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, w-checked,
                               " w-checked", 80
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 80 h-img 8 16

           if w-check = 0
              call "w$menu" using wmenu-uncheck
                                  menu-handle, 80
           else
              call "w$menu" using wmenu-check 
                                  menu-handle, 80
           end-if
           .

       BUILD-TRAY-MENU.
           call "w$menu" using wmenu-new-tray 
                               "isCOBOL Tray Icon" 
                               tray-click
                               tray-dbl-click
                        giving h-tray-menu.

           call "W$MENU" using wmenu-add h-tray-menu 0 0 
                                "isCOBOL Version" 
                               tray-version
           call "W$MENU" using wmenu-add h-tray-menu 0 0 "E&xit" 27
           .

       BUILD-POPUP-MENU.
           call "W$MENU" using wmenu-new-popup giving h-popup.
               
           call "W$MENU" using wmenu-add h-popup 0 0 "isCOBOL Version" 
                               pupup-item.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
