      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. MROUTINES.

       WORKING-STORAGE SECTION.
           copy "isgui.def".
           copy "isfonts.def".
           copy "iscrt.def".
           copy "iscobol.def".   copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  m1                      handle.
       77  m2                      handle.
       77  msize                   pic s9(9).
       77  mvalue                  pic x(8).

       77  h-float                 handle of window.
       77  PBOK                    handle of push-button.

       SCREEN SECTION.
       01  Mask.
           03 push-button
              line                 02 
              col                  02
              size                 12
              title                "M$ Routines"
              exception-value      102
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.                            
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "M$ Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue
              end-accept
              evaluate crt-status
              when 102
                   perform MTEST
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       MTEST.

      *shows a window for the output
           display independent window
                   lines 17, size 55
                   title  "M$ Routines"
                   handle h-float

      * MTEST.
           display label line 2, col 2, size 75 cells, 
                   title "Allocate two 8 bytes memory areas"
           call "M$ALLOC" using 8, m1
           if m1 < 1 
              perform MERROR
           end-if
           call "M$ALLOC" using 8, m2
           if m2 < 1         
              perform MERROR
           end-if

           display label line 4, col 2, size 75 cells, 
                   title "Verify the size of memory areas"
           call "M$SIZE" using m1, giving msize
           if msize not = 8
              perform MERROR
           end-if
           call "M$SIZE" using m2, giving msize
           if msize not = 8
              perform MERROR
           end-if

           display label line 6, col 2, size 75 cells, 
                   title "Fill first memory area with 'X' characters"
           call "M$FILL" using m1, "X", 8

           display label line 8, col 2, size 75 cells, 
                   title "Fill second memory area with the word 'Hello'"
           call "M$PUT" using m2, "Hello", 8, 1

           display label line 10, col 2, size 75 cells, 
                   title "Copy content of first memory area to the secon
      -                  "d memory area"
           call "M$COPY" using m1, m2, 8

           display label line 12, col 2, size 75 cells, 
                   title "Query the value of the second memory area"
           call "M$GET" using m2, mvalue, 8, 1
           if mvalue(1:5) not = "Hello"
              perform MERROR
           end-if

           display label line 14, col 2, size 75 cells, 
                   title "Free memory areas, end of test"
           call "M$FREE" using m1
           call "M$FREE" using m2
           .

           display push-button line 16 col 2 title "OK" handle PBOK
           accept PBOK
           destroy h-float
           .

       MERROR.
           display message "An error occurred!"
                   icon    mb-warning-icon
           .

       WIN-EVT.  
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
