      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. IIO.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "isopensave.def".
       copy "isfilesys.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  h-float                 handle of window.
       77  PBOK                    handle of push-button.
       77  f                       handle .
       77  i                       pic 9(3).
       77  locks                   pic 9(3). 
       77  file-io                 pic x(128).
       77  key-io                  pic x(10).
       77  rec-buffer              pic x(22).
       77  findex                  pic x(32).
       
       77  error-desc              pic x(50).

       77  wrk-title               pic x(40).
       77  wrk-line                pic 99.

       78  keysize                 value 2.
       77  edit-9                  pic z(15)9.
       77  edit-x                  pic x(16)   redefines edit-9.
       77  edit-9-2                pic z(15)9.
       77  edit-x-2                pic x(16)   redefines edit-9-2.
       01                          pic 0.
           88 operation-failed     value 1 false zero.
       
       SCREEN SECTION.
       01  Mask.
           03  label 
               line                4
               col                 3
               title               "current file.index:"
               .
           03  label  
               col                 20
               title               findex
               .  
           03 push-button
              line                 06 
              col                  02
              size                 12
              title                "&File handling"
              exception-value      102
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept findex from environment "file.index"
              on exception 
                 move "jisam" to findex
           end-accept.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low
                   resizable
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "I$IO Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 102
                   perform FILE-HANDLING
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .


       FILE-HANDLING.
      *shows a window for the output
           display independent window
                   system menu
                   lines 29, size 40
                   title "i-o operations"
                   control font control-font
                   font control-font
                   handle h-float

           set operation-failed to false.

      *creates the file
      *this is the FD
      * 01 record.
      *  03 record-key pic 99.
      *  03 key-data   pic x(20).

           move 2 to wrk-line

           display "Creating file..." line wrk-line col 2 

           call "C$GETENV" USING "user.home"
                                 file-io
           string file-io        delimited by trailing space
                  "/iss-file-io" delimited by size
                  into file-io
           move zero to BLOCK-MULTIPLE PRE-ALLOCATION-AMOUNT 
                      EXTENSION-AMOUNT COMPRESSION-FACTOR ENCRYPTED-FLAG
           move 22 to max-rec-size
           move 22 to min-rec-size
           move 1 to num-keys
           move "1,0,2,0" to key-io
           inspect file-io replacing trailing spaces by low-value
           inspect key-io  replacing trailing spaces by low-value
           inspect logical-info  replacing trailing spaces by low-value
           set make-function to true

           call "i$io" using io-function, file-io, 0, physical-info, 
                                          logical-info, key-io
           if return-code = 0
              perform DISPLAY-ERROR
           else
              perform DISPLAY-OK
           end-if           
      *opening 
           if not operation-failed
              add 2 to wrk-line
              display "Opening file..." line wrk-line col 2 
              perform OPEN-IO
           end-if

      *record writing
           if not operation-failed
              add 2 to wrk-line
              display "Writing into file..." line wrk-line col 2 
              move "02aaa" to rec-buffer
              set write-function to true
              call "I$IO" using io-function, f, rec-buffer, 0
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *record writing
           if not operation-failed
              move "03aaa" to rec-buffer
              set write-function to true
              call "I$IO" using io-function, f, rec-buffer, 0
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *start
           if not operation-failed
              add 2 to wrk-line
              display "Getting the first record..." line wrk-line col 2 
              move low-values    to rec-buffer
              set start-function to true
              set f-not-less     to true
              move 0             to key-num
              call "I$IO" using io-function, f, rec-buffer, key-num, 
                             keysize, start-mode
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *read next
           if not operation-failed
              add 2 to wrk-line
              display "Reading next record..." line wrk-line col 2 
              set next-function to true
              move 0 to key-num
              call "I$IO" using io-function, f, rec-buffer, key-num
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *record rewriting
           if not operation-failed
              add 2 to wrk-line
              display "Rewriting into file..." line wrk-line col 2
              move "02bbb" to rec-buffer
              set rewrite-function to true
              call "I$IO" using io-function, f, rec-buffer, 0
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *record deleting
           if not operation-failed
              add 2 to wrk-line
              display "Deleting record..." line wrk-line col 2 
              move "03" to rec-buffer
              set delete-function to true
              call "I$IO" using io-function, f, rec-buffer
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if
      *close
           if not operation-failed
              add 2 to wrk-line
              display "Closing file..." line wrk-line col 2  
              perform IIO-CLOSE
              if return-code = 0
                 perform DISPLAY-ERROR
              else
                 perform DISPLAY-OK
              end-if
           end-if.

      *info file
           if not operation-failed
              add 2 to wrk-line
              display "Info file..." line wrk-line col 2 
              perform OPEN-IO

              if return-code not = 0
                 perform IIO-QUERY
                 perform IIO-CLOSE
              else
                 perform DISPLAY-ERROR
              end-if
           end-if.

           add 2 to wrk-line
           display push-button line wrk-line col 2 title "OK" 
                   handle PBOK
           accept PBOK
           destroy h-float
           .

       IIO-QUERY.
           set info-function to true
      *    number of records
           set get-record-count to true
           call "I$IO" using io-function, f, info-mode, 
                                             record-count-info 
      *    locked records
           set get-lock-count to true
           call "I$IO" using io-function, f, info-mode, locks 
      *    logical pharams    
           set get-logical-params to true
           call "I$IO" using io-function, f, info-mode, logical-info

           initialize wrk-title
           move min-rec-size to edit-9
           call "C$JUSTIFY" using edit-x, "L"
           string "Min Rec Size: " delimited by size 
                  edit-x delimited by trailing space
                  into wrk-title

           add 2 to wrk-line
           display wrk-title line wrk-line col 2 

           initialize wrk-title
           move max-rec-size to edit-9
           call "C$JUSTIFY" using edit-x, "L"
           string "Max Rec Size: " delimited by size  
                  edit-x delimited by trailing space
                  into wrk-title
           add 2 to wrk-line
           display wrk-title line wrk-line col 2 

           initialize wrk-title
           move num-keys  to edit-9
           call "C$JUSTIFY" using edit-x, "L"
           string "Number of keys: "  delimited by size 
                  edit-x delimited by trailing space
                  into wrk-title
           add 2 to wrk-line
           display wrk-title line wrk-line col 2 

           initialize wrk-title
           move locks  to edit-9
           call "C$JUSTIFY" using edit-x, "L"
           move number-of-records  to edit-9-2
           call "C$JUSTIFY" using edit-x-2, "L"
           string "Record count: " delimited by size
                  edit-x-2         delimited by trailing space
                  " ("             delimited by size
                  edit-x           delimited by trailing space
                  " locked)"       delimited by size
                  into wrk-title
           add 2 to wrk-line
           display wrk-title line wrk-line col 2 
           .

       IIO-CLOSE.
           set close-function to true
           call "I$IO" using io-function, f
           .
           
       OPEN-IO.
           set open-function to true
           move fio to open-mode    
           call "i$io" using io-function, file-io, 
                             open-mode, logical-info

           if return-code = 0
              perform DISPLAY-ERROR
           else
              perform DISPLAY-OK
              move return-code to f
           end-if
           .

       DISPLAY-ERROR.
           set operation-failed to true.
           display "FAILED" col 34.

           move f-errno      to edit-9
           call "C$JUSTIFY" using edit-x, "L"
           
           initialize error-desc
           string "f-errno: "   delimited by size
                  edit-x        delimited by trailing space
                  into error-desc 
           add 2 to wrk-line
           display error-desc   line wrk-line col 2
           add 2 to wrk-line
           display f-errmsg line wrk-line col 2.

           evaluate true
           when e-sys-err   
                move "system or interface error"        to error-desc
           when e-param-err                   
                move "wrong data for i$io"              to error-desc
           when e-too-many-files              
                move "too many files opened"            to error-desc
           when e-mode-clash                  
                move "mode clash"                       to error-desc
           when e-rec-locked                  
                move "record locked"                    to error-desc
           when e-broken                      
                move "file broken"                      to error-desc
           when e-duplicate  
                move "duplicated record"                to error-desc
           when e-not-found                   
                move "record not found"                 to error-desc
           when e-undef-record
                move "undefined record"                 to error-desc
           when e-disk-full                   
                move "disk full"                        to error-desc
           when e-file-locked                 
                move "file locked"                      to error-desc
           when e-rec-changed                 
                move "record size changed"              to error-desc
           when e-mismatch                    
                move "record mismatch"                  to error-desc
           when e-no-memory                   
                move "no more memory"                   to error-desc
           when e-missing-file 
                move "file not found or unrecognized"   to error-desc
           when e-permission                  
                move "no permission"                    to error-desc
           when e-no-support
                move "unsupported operation"            to error-desc
           when e-no-locks
                move "no more locks available"          to error-desc
           when e-interface                   
                move "interface error (9D)"             to error-desc
           when e-license-err                 
                move "license expired"                  to error-desc
           when other
                move "unknown error"                    to error-desc
           end-evaluate.  

           add 2 to wrk-line
           display error-desc line wrk-line col 2. 

       DISPLAY-OK.
           display "OK" col 34.

       WIN-EVT.  
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
