      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. GETDIGEST.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status           is special-names crt status pic 9(5).
       77  hWin                 handle of window.
       77  control-font         handle of font.
       77  close-win            pic 9 value 0.

       77  params               pic x any length.
       77  digest               pic x any length.
       77  en-encrypted-data    pic x any length.
       77  en-res-str           pic x any length.
       77  encryption-method    pic x any length.
       
       SCREEN SECTION.
       01  Mask.
           03  label 
               line             2
               col              3
               title            "Current as.digest (encryption method):"
               .
           03  label  
               col              35
               title            encryption-method
               .  
           03 label
              line              4
              col               2
              size              30 cells
              title             "Input string:"
              .
           03 entry-field
              line              6 
              col               2
              value             params
              size              57 cells
              max-text          256
              boxed             
              .
           03 push-button
              line              6
              col               + 2
              title             "Get Digest"
              size              10 cells
              exception-value   101
              .       
           03 label
              line              8 
              col               2 
              size              30 cells
              title             "Digest:"
              . 
           03 ef-result
              entry-field
              line              10
              col               2  
              size              57 cells
              max-text          256
              boxed
              read-only
              .
           03 Pb-exit  
              push-button
              line              20 
              col               62 
              size              8 cells
              title             "Exit" 
              exception-value   27
              .
 
       PROCEDURE DIVISION.
       MAIN. 

           accept encryption-method from environment "as.digest"
              on exception 
                 move "SHA-1" to encryption-method
           end-accept.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "A$GET_DIGEST Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              if crt-status = 101
                 perform GET-DIGEST
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       GET-DIGEST.
           call "A$GET_DIGEST" using digest, params
           perform CONVERT-FROM-ASCII-TO-HEX
           modify ef-result value digest
           .

       CONVERT-FROM-ASCII-TO-HEX.
           move digest     to en-encrypted-data
           call "ASCII2HEX" using en-encrypted-data, en-res-str.
           move en-res-str to digest.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
