      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CSOCSERVER.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscoblib.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status                 special-names crt status pic 9(5).
       77  hWin                       handle of window.
       77  control-font               handle of font.
                                            
       77  Socket-server-handle       handle.
       77  Socket-client-handle       handle.
       
       77  data-to-send               pic x any length.
       77  first-byte                 pic x.
       77  segment-of-data-received   pic x(10).
       77  data-received              pic x any length.

       77  op-time                    pic 9(8).

       01  gd-operation-rec.
           05 time-operation          pic x(5).
           05 kind-operation          pic x(10).
           05 result-operation        pic x(50). 
           
       77  data-length                pic 9(3) value 100.
       77  read-amount                pic s999.

       77  num-of-packet              pic 9(10).
       77  size-of-last-packet        pic 9(2).

       77  server-port                pic x(5).

       77  num-param                  pic 9(2).

       77  returncode                 pic s9.

       77  base-sorg-path             pic x(20). 
       77  command                    pic x(100).
       77  e-exit                     pic 9.
       77  error-description          pic x any length.

       01  kind-of-result             pic x.
           88 type-error              value "e".
           88 type-ok                 value "o".
           88 type-description        value "d".

       78  78-red                     value x#C40000.
       78  78-green                   value x#00AE00.

       LINKAGE SECTION.
       77  link-server-port           pic x(5).
       
       SCREEN SECTION.
       01  mask.
           03 frame
              engraved
              title                         "Log"
              line                          2
              col                           2
              lines                         17
              size                          68
              .
           03 gd
              grid 
              line                          4
              col                           3
              lines                         9
              size                          66 cells
              display-columns               (1, 10, 20)
              data-columns                  (1, 6, 16)
              alignment                     ("c", "l", "l")
              data-types                    ("x(5)", "x(10)", "x(50)") 
              protection                    1
              row-background-color-pattern  (0, -14675438)
              vscroll
              .
           03 push-button
              line                          20 
              col                           2 
              size                          20 cells
              title                         "Source code" 
              exception-value               201
              .
           03 pb-exit  
              push-button
              line                          20 
              col                           62 
              size                          8 cells
              title                         "Exit" 
              exception-value               27
              enabled                       e-exit
              .

       PROCEDURE DIVISION using link-server-port.
       MAIN.
           call "C$NARG" using num-param.
           if num-param > zero
              move link-server-port   to server-port
           else
              move "8765"             to server-port
           end-if

           accept base-sorg-path from environment "home_source".

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$SOCKET Routine (SERVER)"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display mask

           move "CREATE"  to kind-operation
           initialize result-operation
           string "Creating server socket on port: " delimited by size
                  server-port                        delimited by size
                  into  result-operation

           perform SHOW-RESULT.

           call "C$SOCKET" using csocket-create-server, 
                                 server-port
                          giving socket-server-handle.
           if socket-server-handle = null
              perform CREATION-SERVER-ERRROR
           else
              perform thread ACCEPT-FROM-CLIENT
           end-if.

           perform until crt-status = 27
              accept Mask 
                 on exception
                    continue
              end-accept 
              evaluate crt-status
              when 27
                   if e-exit = zero
                      move zero to crt-status
                   end-if
              when 201
                   perform VIEW-SORG
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       CREATION-SERVER-ERRROR.
           move "CREATE"                    to kind-operation
           initialize result-operation
           set type-error                   to true
           move "Cannot create the server"  to  result-operation
           perform SHOW-RESULT

           call "C$SOCKET" using csocket-last-error
                                 socket-server-handle
                                 error-description
                          giving return-code
           initialize result-operation
           set type-description    to true
           move error-description  to  result-operation
           perform SHOW-RESULT

           move 1   to e-exit 
           modify Pb-exit enabled 1.

       CLOSE-SERVER.
           CALL "C$SOCKET" USING CSOCKET-CLOSE, 
                                 Socket-client-handle.

           move "CLOSE "           to kind-operation
           move "Close the server" to result-operation
           perform SHOW-RESULT.
           CALL "C$SOCKET" using CSOCKET-CLOSE, 
                                 socket-server-handle.

       ACCEPT-FROM-CLIENT.
           move "ACCEPT"                             to kind-operation
           set type-description                      to true
           move "Waiting for connection from client" to result-operation
           perform SHOW-RESULT.

           call "C$SOCKET" using csocket-accept, 
                                 socket-server-handle
                          giving socket-client-handle.

           if socket-client-handle = null
              move "ACCEPT"  to kind-operation
              set type-error to true
              move "Failed accepting connection from client" 
                             to result-operation
              perform SHOW-RESULT
           else
              move "ACCEPT"                    to kind-operation
              set type-ok                      to true
              move "Connected with the client" to result-operation
              perform SHOW-RESULT

              perform until exit 
                 move "READ"                to kind-operation
                 move "Reading client data" to  result-operation
                 perform SHOW-RESULT

      *    Wait for receive the data from the client. I read only the
      *    first byte.
                 move 1   to data-length
                 call "C$SOCKET" using csocket-read, 
                                       socket-client-handle,
                                       first-byte
                                       data-length
                                giving read-amount

                 if read-amount < 0
                    move "READ"                to kind-operation
                    set type-error             to true
                    move "Comunication error with the client" 
                                               to result-operation
                    perform SHOW-RESULT
                    perform CLOSE-SERVER
                    move 1                     to e-exit 
                    modify Pb-exit enabled 1
                    exit perform
                 else
                    perform READ-DATA-FROM-CLIENT
                    if data-received = "QUIT"
                       move "QUIT"             to kind-operation
                       initialize result-operation
                       move "Server shutdown"  to result-operation
                       perform SHOW-RESULT
                       perform SEND-DATA-TO-CLIENT
                       
                       perform CLOSE-SERVER
                       move 1                  to e-exit 
                       modify Pb-exit enabled 1
                       exit perform
                    else
                       move "READ"             to kind-operation
                       initialize result-operation
                       set type-ok to true
                       string "Received data: '"  delimited by size
                              data-received       delimited by size
                              "'"                 delimited by size
                             into  result-operation
                       perform SHOW-RESULT
                       perform SEND-DATA-TO-CLIENT
                    end-if
                  end-if
              end-perform

              move "CLOSE "  to kind-operation
              move "Close connection with the client " 
                             to  result-operation
              perform SHOW-RESULT
           END-IF.

       READ-DATA-FROM-CLIENT.
           move first-byte to data-received

      *    Retreive the size of the buffer to read
           move 0   to data-length
           call "C$SOCKET" using CSOCKET-READ, 
                                 socket-client-handle,
                                 segment-of-data-received 
                                 data-length
                          giving read-amount

           divide READ-AMOUNT by 10 giving num-of-packet
                                 remainder size-of-last-packet

           perform num-of-packet times
              move 10 to DATA-LENGTH
              call "C$SOCKET" using CSOCKET-READ, 
                                    socket-client-handle,
                                    segment-of-data-received, 
                                    data-length
                             giving read-amount
              string data-received             delimited by size
                     segment-of-data-received  delimited by size
                     into data-received
           end-perform.

           if size-of-last-packet not = zero
              move size-of-last-packet   to DATA-LENGTH
              call "C$SOCKET" 
                 using CSOCKET-READ, 
                       Socket-client-handle,
                       segment-of-data-received(1:size-of-last-packet) 
                       data-length
                giving read-amount
              string data-received    delimited by size
                     segment-of-data-received(1:size-of-last-packet)
                                      delimited by size
                     into data-received
           end-if.

       SEND-DATA-TO-CLIENT.
           move function lower-case(data-received)   to data-to-send

           move "WRITE"   to kind-operation
           initialize result-operation
           set type-description to true
           string "Writing data on client: '"  delimited by size
                  data-to-send                 delimited by size
                  "'"                          delimited by size
                  into  result-operation
           perform SHOW-RESULT

           set data-length to size of data-to-send 
           CALL "C$SOCKET" USING CSOCKET-WRITE, 
                                 socket-client-handle,
                                 data-to-send, 
                                 data-length
                           giving returncode

           move "WRITE" to kind-operation
           if returncode < 0
               move "Cannot write data on client" 
                                            to  result-operation
               set type-error               to true
           else
              move "Data written correctly on client" 
                                            to  result-operation
              set type-ok                   to true
           end-if
           perform SHOW-RESULT.

       SHOW-RESULT.
           accept op-time  from time
           initialize time-operation
           string op-time(1:2)   delimited by size
                  ":"            delimited by size
                  op-time(3:2)   delimited by size
                  into time-operation

           modify gd insertion-index 1,
                     record-to-add gd-operation-rec.

           evaluate true
           when type-error
                modify gd(1) row-foreground-color rgb 78-red
           when type-ok
                modify gd(1) row-foreground-color rgb 78-green
           end-evaluate.
           
           set type-description to true.

       WIN-EVT.
           if event-type = msg-close and e-exit = zero
              set event-action  to event-action-fail
           end-if
           .

       VIEW-SORG.
           initialize command
           string base-sorg-path      delimited by trailing space
                  "s-routines"        delimited by space
                  "/CSOCSERVER.cbl"   delimited by size
                                      into command.

           call run "TEXTVIEWER"  using command.
