      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CMONITOR.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  crt-status              special-names crt status pic 9(5).
       77  close-win               pic 9 value 0.

       77  title-lbl-monitor             pic x any length.
       77  title-lbl-main-monitor        pic x any length.
       77  number-of-monitor             pic 9(2).
       77  main-monitor                  pic 9(2).
       77  idx                           pic 9(2).

       01  rec-grid-monitor.
           05 gf-number                  pic z9.
           05 gf-usable-screen-height    pic z(3)9.
           05 gf-usable-screen-width     pic z(3)9.
           05 gf-physical-screen-height  pic z(3)9.
           05 gf-physical-screen-width   pic z(3)9.
           05 gf-start-y                 pic -(4)9.
           05 gf-start-x                 pic -(4)9.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              title                "Number of intalled monitors:"
              .
           03 label
              line                 2
              col                  25
              title                title-lbl-monitor
              .
           03 label
              line                 4
              col                  2
              title                "Main monitor:"
              .
           03 label
              line                 4
              col                  25
              title                title-lbl-main-monitor
              .
           03 gd-monitor
              grid
              column-headings
              Adjustable-Columns
              centered-headings
              sortable-columns
              reordering-columns
              heading-color        257
              vscroll 
              Protection           1
              line                 6
              col                  2
              lines                13 cells
              size                 68 cells
              .
           03 Pb-exit
              push-button
              line                 20
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       INI.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$MONITOR Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           perform GET-INFO

           display Mask
           perform LOAD-MONITOR-DETAIL

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .

       GET-INFO.
           call "C$MONITOR" using cmonitor-get-no-monitor
                                  number-of-monitor
                                  main-monitor
                GIVING return-Code.
           if return-Code = 0
              move "C$MONITOR not supported"   to title-lbl-monitor
              move zero                        to number-of-monitor
              move space                       to title-lbl-main-monitor
           else
              move number-of-monitor           to title-lbl-monitor
              move main-monitor                to title-lbl-main-monitor
           end-if.


       LOAD-MONITOR-DETAIL.
           perform GRID-HEADER

           perform varying idx from 1 by 1 until idx > number-of-monitor
              CALL "C$MONITOR" USING CMONITOR-GET-MONITOR-INFO
                                     idx
                                     CMONITOR-DATA
                              GIVING return-Code
              if return-code = 1
                 perform SHOW-MONITOR
              end-if
           end-perform.

       GRID-HEADER.
           modify gd-monitor
                  column-dividers (1 1 1 1 1 1 1)
                  data-columns (record-position of gf-number 
                                record-position 
                                         of gf-usable-screen-height
                                record-position 
                                         of gf-usable-screen-width
                                record-position 
                                         of gf-physical-screen-height
                                record-position 
                                         of gf-physical-screen-width
                                record-position 
                                         of gf-start-y
                                record-position 
                                         of gf-start-x
                               )
                  display-columns ( 1 5 17 29 41 53 59 )
                  separation ( 5 5 5 5 5 5 5 )
                  alignment ( "R" "R" "R" "R" "R" "R" "R")
                  data-types ( "9" "9" "9" "9" "9" "9" "9").
           
           modify gd-monitor(1, 1) cell-data = "N�".
           modify gd-monitor(1, 2) cell-data = "Usable height".
           modify gd-monitor(1, 3) cell-data = "Usable width".
           modify gd-monitor(1, 4) cell-data = "Physical height"
           modify gd-monitor(1, 5) cell-data = "Physical width".
           modify gd-monitor(1, 6) cell-data = "Start Y".
           modify gd-monitor(1, 7) cell-data = "Start X".

       SHOW-MONITOR.
           initialize rec-grid-monitor

           move idx to gf-number.

           move cmonitor-usable-screen-height
                                            to gf-usable-screen-height  
           move cmonitor-usable-screen-width
                                            to gf-usable-screen-width
           move cmonitor-physical-screen-height
                                            to gf-physical-screen-height
           move cmonitor-physical-screen-width
                                            to gf-physical-screen-width 
           move cmonitor-start-y            to gf-start-y
           move cmonitor-start-x            to gf-start-x

           modify gd-monitor record-to-add rec-grid-monitor.
           
           if idx = main-monitor 
              modify gd-monitor(idx + 1, 1) row-color 481
           end-if.

       WIN-EVT.  
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
