      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CENCRYPTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  encryption-key          pic x any length.
       77  encryption-algorithm    pic x any length.
       77  en-source-str           pic x any length.
       77  en-encrypted-data       pic x any length.
       77  en-res-str              pic x any length.
       77  de-source-str           pic x any length.
       77  de-encrypted-data       pic x any length.
       77  de-decrypted-data       pic x any length.
       77  de-encrypted-data-2     pic x any length.
       77  w-error                 pic x any length.
       77  encrypted-data-len      pic 9(4) comp.

       SCREEN SECTION.
       01  Mask.
           03 label 
              line                 2
              col                  2
              size                 20 cells
              lines                2
              title                "Encrypt/Decrypt Key:" 
              .
           03 entry-field 
              line                 2
              col                  22
              size                 47 cells 
              value                encryption-key
              .   
           03 label 
              line                 4
              col                  2
              size                 20 cells
              lines                2
              title                "Algorithm:" 
              .
           03 cb-algorithm
              combo-box 
              line                 4
              col                  22
              max-text             16
              size                 47 cells
              placeholder          "Select the encryption algorithm"
              value                encryption-algorithm
              .   
           03 label 
              line                 7
              col                  2
              size                 22 cells
              title                "Data to encrypt:" 
              .
           03 entry-field 
              line                 7
              col                  22
              size                 47 cells 
              value                en-source-str
              .   
           03 label 
              line                 9
              col                  2
              size                 22 cells
              title                "Encrypted data (hex):" 
              .
           03 entry-field 
              read-only
              line                 9
              col                  22
              size                 47 cells 
              value                en-res-str  
              .   
           03 push-button
              line                 11
              col                  2
              size                 10 cells
              title                "Encrypt"
              exception-value      101
              self-act
              .
           03 label 
              line                 14
              col                  2
              size                 22 cells
              title                "Data to Decrypt(hex):" 
              .
           03 entry-field 
              line                 14
              col                  22
              size                 47 cells 
              value                de-source-str  
              .
           03 label 
              line                 16
              col                  2
              size                 22 cells
              title                "Decrypted data:" 
              .
           03 entry-field 
              read-only
              line                 16
              col                  22
              size                 47 cells 
              value                de-decrypted-data
              .
           03 push-button
              line                 18
              col                  2
              size                 10 cells
              title                "Decrypt"
              exception-value      102
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.

           accept encryption-algorithm 
                           from environment "crypt.algorithm"

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$DECRYPT and C$ENCRYPT Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           modify cb-algorithm item-to-add("AES", "RC2", "Blowfish")

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status 
              when 101 
                   perform ENCRYPT
              when 102 
                   perform DECRYPT
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       ENCRYPT.
           if encryption-algorithm not = space
             set environment "crypt.algorithm" to encryption-algorithm 
           end-if
           call "C$ENCRYPT" using en-source-str, 
                                  encryption-key, 
                                  en-encrypted-data
                                  w-error
                           giving return-code

           if return-code = 0
              perform CONVERT-FROM-ASCII-TO-HEX
              display Mask
           else
              display message "Error occurred during the encryption"
                              x"0D0A"
                              w-error
                      icon    mb-error-icon
           end-if
           .

       DECRYPT.
           if encryption-algorithm not = space
             set environment "crypt.algorithm" to encryption-algorithm 
           end-if
           perform CONVERT-HEX-TO-ASCII

           call "C$DECRYPT" using de-encrypted-data, 
                                  encryption-key, 
                                  de-decrypted-data
                                  w-error
                           giving return-code

           if return-code = 0
              perform CONVERT-FROM-ASCII-TO-HEX
              display Mask
           else
              display message "Error occurred during the decryption"
                              x"0D0A"
                              w-error
                      icon    mb-error-icon
           end-if

           display mask
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .

       CONVERT-FROM-ASCII-TO-HEX.
           call "ASCII2HEX" using en-encrypted-data, en-res-str.
           move en-res-str   to de-source-str.

       CONVERT-HEX-TO-ASCII.
           call "HEX2ASCII" using  de-encrypted-data-2
                                   de-source-str.

           compute encrypted-data-len = (length of de-source-str / 2)
           initialize de-encrypted-data
           move de-encrypted-data-2(1:encrypted-data-len) 
                                             to de-encrypted-data.
