      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CBLLOCATEFILE.

       CONFIGURATION SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       COPY "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
        
       77  opensave-status         pic 999.
       77  file-name               pic x(128).
       77  wstatus                 pic s9(5).

       77  user-mode        pic x comp-x.
       01  actual-file-spec.
           03 buffer-len    pic x(2) comp-x.
           03 buffer        pic x(128).
       77  exist-flag       pic x comp-x.
       77  path-flag        pic x comp-x.

       77  status-code      pic xx comp-5.

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.
       77  e-client                pic 9.

       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              . 
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 label
              line                 4 
              col                  2
              size                 4 cells
              title                "File"
              .
           03 file-inf
              entry-field
              line                 6
              col                  2
              value                file-name
              size                 62 cells
              max-text             256
              .
           03 pb-choose
              push-button
              line                 6 
              col                  + 2
              title                "..."
              size                 3
              exception-value      101
              enabled              e-client
              self-act
              .
           03 push-button
              line                 8  
              col                  2
              title                "&Locate"
              size                 10
              exception-value      102
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
              

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if
           move 1                        to e-client
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CBL_LOCATE_FILE Routine"
                   lines 21 
                   min-lines 21
                   size 70 min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask 

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                perform CHOOSE-FILE
           when 102
                perform LOCATE-FILE
           when 103
                if rb-value = 2
                   set client-execution   to true
                   move 1                 to e-client
                else
                   set server-execution   to true
                   move zero              to e-client
                end-if
                modify pb-choose enabled e-client
           end-evaluate
           .

       CHOOSE-FILE.
           move 1 to opnsav-default-filter
           move "All Files (*.*)" to opnsav-filters
           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data
                                giving opensave-status
           if opensave-status > 0
              modify file-inf value opnsav-filename
           end-if
           .

       LOCATE-FILE.
           inquire file-inf value in file-name
           MOVE 0 TO user-mode
           initialize actual-file-spec
           move 128 to buffer-len

           evaluate true
           when client-execution
                call client "CBL_LOCATE_FILE" using file-name
                                                    user-mode
                                                    actual-file-spec
                                                    exist-flag
                                                    path-flag
                                          returning status-code
           when standalone-execution
           when server-execution
                call "CBL_LOCATE_FILE" using file-name
                                             user-mode
                                             actual-file-spec
                                             exist-flag
                                             path-flag
                                   returning status-code
           end-evaluate.

           evaluate status-code
           when 0
                evaluate exist-flag
                when 0
                     display message buffer
                                    x"0D0A"
                                    "File not found or not searched for"
                             icon    mb-default-icon
                when 1
                     display message buffer
                                    x"0D0A"
                                    "File was found in a library that "
                                    "was already open"
                             icon    mb-default-icon
                when 2
                     display message buffer
                                    x"0D0A"
                                    "File was found in a library "
                                    "specified in user-file-spec"
                             icon    mb-default-icon
                when 3
                     display message buffer
                                    x"0D0A"
                                    "File was found as a separate "
                                    "disk file"
                             icon    mb-default-icon
                end-evaluate
           when 1
                display message "The environment variable does "
                                "not exist",
                        icon    mb-default-icon
           when 2
                display message "There is no next path"
                        icon    mb-default-icon
           when 3
                display message "The resolved filename is too "
                                "large for the buffer",
                        icon    mb-default-icon
           when 4
                display message "Resulting filename is illegal",
                        icon    mb-default-icon
           when 255
                display message "Other error",
                        icon    mb-default-icon
           end-evaluate
           . 

       CALL-OPEN.
           move 1 to opnsav-default-filter
           move "All Files (*.*)" to opnsav-filters
           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data
                                giving opensave-status
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .