      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CBLJOINFILE.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isopensave.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  opensave-status         pic s9.
       77  fi-base-name            pic x(30).
       77  fi-extension            pic x(10).
       77  fi-path                 pic x(256).
       01  join-buffer             pic x(256).

       01  cblt-splitjoin-buf.
           03 cblte-sj-param-length            pic x(2) comp-x.
           03 cblte-sj-split-join-flag1        pic x comp-x.
           03 cblte-sj-split-join-flag2        pic x comp-x.
           03 cblte-sj-device-offset           pic x(2) comp-x.
           03 cblte-sj-device-length           pic x(2) comp-x.
           03 cblte-sj-basename-offset         pic x(2) comp-x.
           03 cblte-sj-basename-length         pic x(2) comp-x.
           03 cblte-sj-extension-offset        pic x(2) comp-x.
           03 cblte-sj-extension-length        pic x(2) comp-x.
           03 cblte-sj-total-length            pic x(2) comp-x.
           03 cblte-sj-split-buf-len           pic x(2) comp-x.
           03 cblte-sj-join-buf-len            pic x(2) comp-x.
           03 cblte-sj-first-component-length  pic x(2) comp-x.

       SCREEN SECTION.
       01  Mask.
           03 label               
              line                 4
              col                  2
              size                 10 cells
              title                "Path:"
              .
           03 f-path
              entry-field
              line                 4
              col                  + 2
              value                fi-path
              size                 52 cells
              max-text             256
              boxed
              .
           03 push-button
              line                 4
              col                  + 2
              title                "..."
              size                 4 cells
              exception-value      101
              self-act
              .
           03 label               
              line                 6
              col                  2
              size                 10 cells
              title                "Base name:"
              .
           03 f-base-name
              entry-field
              line                 6
              col                  + 2
              value                fi-base-name
              size                 52 cells
              max-text             30
              boxed
              .
           03 label               
              line                 8 
              col                  2
              size                 10 cells
              title                "Extension:"
              .
           03 f-extension
              entry-field
              line                 8 
              col                  + 2
              value                fi-extension
              size                 11 cells
              max-text             10
              boxed
              .
           03 push-button
              line                 10
              col                  13
              title                "&Join Name"
              size                 10
              exception-value      102
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
               
       PROCEDURE DIVISION.
       MAIN. 
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low
                   resizable
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CBL_JOIN_FILENAME Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                     continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                initialize opensave-data
                call "C$OPENSAVEBOX" using opensave-browse-folder
                                           opensave-data
                                     giving opensave-status
                if opensave-status > 0
                   modify f-path value opnsav-filename
                end-if
           when 102
                move 1 to cblte-sj-device-offset
                          cblte-sj-basename-offset
                          cblte-sj-extension-offset
      
                move length of fi-path to cblte-sj-device-length
                move length of fi-base-name 
                                      to cblte-sj-basename-length
                move length of fi-extension 
                                      to cblte-sj-extension-length
                move length of join-buffer to cblte-sj-join-buf-len
      
                move 0 to cblte-sj-split-join-flag1
                move 24 to cblte-sj-param-length
      
                call "CBL_JOIN_FILENAME" using cblt-splitjoin-buf
                                               join-buffer
                                               fi-path
                                               fi-base-name
                                               fi-extension

                 display message join-buffer 
                                 icon mb-default-icon
                        title   "Joined file name"
           end-evaluate
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .