      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. grid-list-export.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isopensave.def".

       01  tab-album.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Let It Be".
           03 filler               pic x(5)  value "4:03".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Let It Be".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Apple Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Yellow Submarine".
           03 filler               pic x(5)  value "2:40".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Revolver".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Apple Records".
           03 filler               pic 9(4)  value 1966.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(5)  value "2:21".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Parlophone".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Yesterday".
           03 filler               pic x(5)  value "2:07".
           03 filler               pic x(20) value "Beatles".
           03 filler               pic x(30) value "Help!".
           03 filler               pic x(15) value "Pop".
           03 filler               pic x(30) value "Parlophone".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Angie".
           03 filler               pic x(5)  value "4:30".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Goats Head Soup".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "R.S.Records".
           03 filler               pic 9(4)  value 1973.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Start Me Up".
           03 filler               pic x(5)  value "3:32".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Tattoo You".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value 
                                               "Rolling Stones records".
           03 filler               pic 9(4)  value 1981.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Satisfaction".
           03 filler               pic x(5)  value "3:45".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "Out of Our Heads".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Decca/ABKCO".
           03 filler               pic 9(4)  value 1965.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Rain Fall Down".
           03 filler               pic x(5)  value "4:55".
           03 filler               pic x(20) value "The Rolling Stones".
           03 filler               pic x(30) value "A Bigger Bang".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Polydor Records".
           03 filler               pic 9(4)  value 2005.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Maria Maria".
           03 filler               pic x(5)  value "4:19".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Supernatural".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "BMG Arista/Ariola".
           03 filler               pic 9(4)  value 1999.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Oye como va".
           03 filler               pic x(5)  value "4:36".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Abraxas".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Columbia Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value 
                                               "Lightning in the sky".
           03 filler               pic x(5)  value "3:50".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Marathon".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Columbia Records".
           03 filler               pic 9(4)  value 1979.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Foo Foo".
           03 filler               pic x(5)  value "6:29".
           03 filler               pic x(20) value "Santana".
           03 filler               pic x(30) value "Shaman".
           03 filler               pic x(15) value "Latin Rock".
           03 filler               pic x(30) value "Arista".
           03 filler               pic 9(4)  value 2002.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Money for Nothing".
           03 filler               pic x(5)  value "6:19".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value 
                                                  "After Midnight Live". 
           03 filler               pic x(15) value "Rock/Pop".
           03 filler               pic x(30) value "Immortal".
           03 filler               pic 9(4)  value 2006.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "After Midnight".
           03 filler               pic x(5)  value "2:51".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "Eric Clapton".
           03 filler               pic x(15) value "Rock/Pop".
           03 filler               pic x(30) value 
                                               "Atco, Polydor Records".
           03 filler               pic 9(4)  value 1970.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Bad Love".
           03 filler               pic x(5)  value "6:25".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "24 Nights".
           03 filler               pic x(15) value "Blues rock".
           03 filler               pic x(30) value "Duck Records".
           03 filler               pic 9(4)  value 1991.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value 
                                               "Next Time You See Her".
           03 filler               pic x(5)  value "4:02".
           03 filler               pic x(20) value "Eric Clapton".
           03 filler               pic x(30) value "Slowhand".
           03 filler               pic x(15) value "Blues".
           03 filler               pic x(30) value "Polydor".
           03 filler               pic 9(4)  value 1977.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Albachiara".
           03 filler               pic x(5)  value "4:05".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value 
                                         "Non siamo mica gli americani".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Lotus LOP".
           03 filler               pic 9(4)  value 1979.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Tango".
           03 filler               pic x(5)  value "3:07".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Liberi Liberi".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Emi".
           03 filler               pic 9(4)  value 1988.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "C'e' chi dice no". 
           03 filler               pic x(5)  value "4:38".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "C'e' chi dice no". 
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Carosello".
           03 filler               pic 9(4)  value 1987.
      ***
           03 filler               pic 9(3).
           03 filler               pic x(30) value "Bollicine".
           03 filler               pic x(5)  value "5:40".
           03 filler               pic x(20) value "Vasco Rossi".
           03 filler               pic x(30) value "Bollicine".
           03 filler               pic x(15) value "Rock".
           03 filler               pic x(30) value "Carosello".
           03 filler               pic 9(4)  value 1983.

       01  tab-album-red           redefines tab-album.
           03 ta-item              occurs 20.
              05 ta-prog           pic z(3).
              05 ta-title          pic x(30).
              05 ta-length         pic x(5).
              05 ta-Artist         pic x(20).
              05 ta-album          pic x(30).
              05 ta-genre          pic x(15).
              05 ta-label          pic x(30).
              05 ta-year           pic 9(4).

       77  crt-status              special-names crt status pic 9(5).
       77  hMain                   handle of window.
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9    value 0.

       01  gd-data.
           05 gd-prog              pic z(3).
           05 gd-title             pic x(30).
           05 gd-length            pic x(5).
           05 gd-Artist            pic x(20).
           05 gd-album             pic x(30).
           05 gd-genre             pic x(15).
           05 gd-label             pic x(30).
           05 gd-year              pic 9(4).

       77  idx                     pic 9(3).
       
       77  file-path               pic x any length.
       77  file-format             pic x(4) value "xlsx".
       77  open-after-export       pic 9 value 1.

       SCREEN SECTION.

       01  Mask.
           03 label
              line                 2
              col                  2
              title                "File name"
              transparent
              . 
           03 ef1
              entry-field 
              line                 2 
              col                  12 
              size                 53 cells
              max-text             256
              value                file-path
              .
           03 push-button
              line                 2 
              col                  66 
              size                 4 cells
              title                "..." 
              exception-value      101
              self-act
              .
           03 label
              line                 4
              col                  2
              title                "File Format"
              transparent
              . 
           03 radio-button
              line                 4
              col                  12
              title                "xlsx"
              group                1
              group-value          "xlsx"
              value                file-format
              transparent
              . 
           03 radio-button
              line                 4
              col                  22
              title                "xls"
              group                1
              group-value          "xls"
              value                file-format
              transparent
              . 
           03 check-box
              line                 6
              col                  2
              size                 20
              left-text-alignment  1
              left-text
              title                "Open after export"
              value                open-after-export
              transparent
              . 
           03 Gd
              grid 
              line                 8
              col                  2
              lines                11 cells
              size                 32 cells
              display-columns      (1, 5, 25, 35, 55, 80, 100, 120)
              data-columns         (1, 4, 34, 39, 59, 89, 104, 134)
              alignment            ("C", "L", "C", "L", "L", "L", "L", 
                                    "R")
              data-types           ("Z(3)", "X(30)", "X(5)", "X(20)", 
                                    "X(30)", "X(15)", "X(30)", "9(4)") 
              virtual-width        130
              end-color            -16774581
              heading-color        257
              border-color         rgb x#ACACAC
              heading-cursor-background-color 
                                   rgb x#FFDC61
              boxed
              column-headings 
              row-headings 
              centered-headings
              tiled-headings
              adjustable-Columns
              reordering-columns
              sortable-columns
              vscroll
              row-background-color-pattern = (-16777215, -14675438)
              .
           03 Ls
              list-box
              line                 8
              col                  37
              lines                11 cells
              size                 32 cells
              unsorted
              row-background-color-pattern = (-16777215, -14675438)
              .
           03 push-button
              line                 20 
              col                  2
              size                 20 cells
              title                "Grid export"
              exception-value      102
              .
           03 push-button
              line                 20 
              col                  37
              size                 20 cells
              title                "List-box export"
              exception-value      103
              .
           03 push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.   
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title "EXPORT feature"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
                   control font control-font

           display mask

           modify  Gd mass-update 1
           modify  gd x 2, y 1, cell-data "Title"
           modify  gd x 2, y 1, column-protection 1
           modify  gd x 3, y 1, cell-data "Length"
           modify  gd x 4, y 1, cell-data "Artist"
           modify  gd x 5, y 1, cell-data "Album"
           modify  gd x 6, y 1, cell-data "Genre"
           modify  gd x 7, y 1, cell-data "Label"
           modify  gd x 8, y 1, cell-data "Year"

           modify  gd insertion-index 2
           perform varying idx from 1 by 1 until idx > 20
              move idx to ta-prog(idx)
              move ta-item(idx)  to gd-data
              modify gd record-to-add gd-data
           end-perform
           modify  gd mass-update 0

           modify  ls mass-update 1
           perform varying idx from 1 by 1 until idx > 20
              modify ls item-to-add ta-title(idx)
           end-perform
           modify  ls mass-update 0

           perform until crt-status = 27 or close-win = 1
              accept Mask
                   on exception 
                      continue
              end-accept
              evaluate crt-status
              when 101
                   perform CHOOSE-FILE
              when 102
                   perform EXPORT-GRID-TO-EXCEL
              when 103
                   perform EXPORT-LISTBOX-TO-EXCEL
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       CHOOSE-file.
           initialize opensave-data

           initialize opensave-data

           string "Excell Workbook (*.xlsx)|*.xlsx|"
                  "Excell 97-2003 Workbook (*.xls)|*.xls|"
                  "All Excel files (*.xls;*.xlsx)|*.xls*.xls"
                  delimited by size
                  into opnsav-filters.

           move "isCobolGrid.xls" to opnsav-filename

           if file-format = "xlsx"
              move 1   to opnsav-default-filter
           else
              move 2   to opnsav-default-filter
           end-if
           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data

           if return-code not < 0
              move opnsav-filename to file-path
              modify Ef1 value file-path
           end-if
           .
           
       EXPORT-GRID-TO-EXCEL.
           modify gd export-file-name file-path
           modify gd export-file-format file-format
           modify gd export-file-open open-after-export
           modify gd action action-export
           .

       EXPORT-LISTBOX-TO-EXCEL.
           modify ls export-file-name file-path
           modify ls export-file-format file-format
           modify ls export-file-open open-after-export
           modify ls action action-export
           .
           