       PROGRAM-ID. control-background-image.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  hWatermark              pic s9(9) comp-4.
       77  hEf                     handle of entry-field.

       01  tab-album.
      ***
           03 filler pic x(30) value "Next Time You See Her".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(15) value "Blues".
      ***
           03 filler pic x(30) value "Bad Love".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(15) value "Blues rock".
      ***
           03 filler pic x(30) value "Foo Foo".
           03 filler pic x(20) value "Santana".
           03 filler pic x(15) value "Latin Rock".
      ***
           03 filler pic x(30) value "Lightning in the sky".
           03 filler pic x(20) value "Santana".
           03 filler pic x(15) value "Latin Rock".
      ***
           03 filler pic x(30) value "Maria Maria".
           03 filler pic x(20) value "Santana".
           03 filler pic x(15) value "Latin Rock".
      ***
           03 filler pic x(30) value "Oye como va".
           03 filler pic x(20) value "Santana".
           03 filler pic x(15) value "Latin Rock".
      ***
           03 filler pic x(30) value "Help!".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(15) value "Pop".
      ***
           03 filler pic x(30) value "Let It Be".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(15) value "Pop".
      ***
           03 filler pic x(30) value "Yellow Submarine".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(15) value "Pop".
      ***
           03 filler pic x(30) value "Yesterday".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(15) value "Pop".
      ***
           03 filler pic x(30) value "Angie".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Rain Fall Down".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Satisfaction".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Start Me Up".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Albachiara".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Tango".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "C'e' chi dice no". 
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "Bollicine".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(15) value "Rock".
      ***
           03 filler pic x(30) value "After Midnight".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(15) value "Rock/Pop".
      ***
           03 filler pic x(30) value "Money for Nothing".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(15) value "Rock/Pop".

       01  tab-album-red     redefines tab-album.
           03 ta-item        occurs 20.
              05 ta-title    pic x(30).
              05 ta-Artist   pic x(20).
              05 ta-genre    pic x(15).

       77  old-ta-Artist     pic x(20).
       77  old-ta-genre      pic x(15).
       77  item-name         pic x(50).
       77  cont              pic 99.
       77  tv-item           unsigned-int.
       77  tv-item-parent    unsigned-int.
       77  tv-item-child     unsigned-int.

       SCREEN SECTION.
       01  Mask.
           03 Tb1-container
              tab-control
              line                          2 
              col                           2
              lines                         17 cells
              size                          68 cells
              allow-container
              tab-flat
              relative-offset
              active-tab-border-width       (0 0 2 0)
              tab-border-width              (0 0 1 0)
              tab-foreground-color          rgb x#ACACAC
              tab-border-color              rgb x#ACACAC
              active-tab-border-color       rgb x#395a9d
              active-tab-background-color   rgb x#dae1e5 
              active-tab-foreground-color   rgb x#354c5c
              .
           03 tb1-container-page1 
              tab-group Tb1-container tab-group-value 1.
              05 scroll-pane-1
                 scroll-pane
                 line                       3 
                 col                        4 
                 lines                      11 
                 size                       60 
                 transparent 
                 border-color rgb           x#ACACAC
                 background-bitmap-handle   hWatermark
                 background-bitmap-scale    1
                 .
              05 scroll-pane-page scroll-group scroll-pane-1.
                 07 label
                    line                    2
                    col                     2
                    size                    8 cells
                    title                   "Title:"
                    transparent
                    .
                 07 Ef1 
                    entry-field
                    line                    2
                    col                     12
                    size                    40 cells
                    id                      1
                    .
                 07 label
                    line                    4 
                    col                     2
                    size                    8 cells
                    title                   "Length:"
                    transparent
                    .
                 07 Ef2
                    entry-field
                    line                    4
                    col                     12
                    size                    40 cells
                    id                      2   
                    .       
                 07 label
                    line                    6
                    col                     2
                    size                    8 cells
                    title                   "Artist:"
                    transparent
                    .
                 07 Ef3
                    entry-field
                    line                    6
                    col                     12
                    size                    40 cells
                    id                      3
                    .
                 07 label
                    line                    8
                    col                     2
                    size                    8 cells
                    title                   "Genre:"
                    transparent
                    .                      
                 07 Ef4
                    entry-field
                    line                    8
                    col                     12
                    size                    40 cells
                    id                      4
                    .
                 07 label
                    line                    10
                    col                     2
                    size                    8 cells
                    title                   "Label:"
                    transparent
                    .
                 07 Ef5
                    entry-field
                    line                    10
                    col                     12
                    size                    40 cells
                    id                      5
                    .
                 07 label
                    line                    12
                    col                     2
                    size                    8 cells
                    title                   "Year:"
                    transparent
                    .
                 07 Ef6
                    entry-field    
                    line                    12
                    col                     12
                    size                    40 cells
                    id                      6
                    .
           03 tb1-container-page2 
              tab-group Tb1-container       tab-group-value 2.
              05 Tb1-accordion
                 tab-control
                 line                       2 
                 col                        4 
                 lines                      13 
                 size                       60 
                 accordion
                 relative-offset
                 tab-background-color       rgb x#354c5c
                 tab-foreground-color       rgb x#ffffff
                 tab-rollover-color         rgb x#6A98C6
                 tab-flat
                 tab-delay                  700
                 background-bitmap-handle   hWatermark
                 background-bitmap-scale    1
                 .
              05 tb1-accordion-page1 
                 tab-group Tb1-accordion tab-group-value 1.
                 07 label 
                    line                    4
                    col                     4
                    title                   "This is the first page"
                    transparent
                    .
                 07 entry-field
                    line                    6
                    col                     4
                    .
              05 tb1-container-page2
                 tab-group Tb1-accordion tab-group-value 2.
                 07 label
                    line                    4
                    col                     4 
                    title                   "This is the second page"
                    transparent
                    .
                 07 entry-field
                    line                    6
                    col                     4
                    .
           03 tb1-container-page3 
              tab-group Tb1-container tab-group-value 3.
              05 frame 
                 line                       3 
                 col                        4 
                 lines                      11 
                 size                       60 
                 title                      "frame background image"
                 transparent
                 background-bitmap-handle   hWatermark
                 background-bitmap-scale    1
                 .
              07 entry-field
                 line                       6
                 col                        6
                 .
           03 tb1-container-page4 
              tab-group Tb1-container       tab-group-value 4.
              05 Tv1 
                 tree-view
                 buttons 
                 lines-at-root
                 line                       3 
                 col                        4 
                 lines                      11 
                 size                       60 
                 show-sel-always
                 selection-background-color rgb x#6883AE
                 selection-foreground-color rgb x#FFFFFF
                 background-bitmap-handle   hWatermark
                 background-bitmap-scale    1
                 .
           03 tb1-container-page5
              tab-group Tb1-container       tab-group-value 5.
              05 Ls
                 list-box
                 line                       3 
                 col                        4 
                 lines                      11 
                 size                       60 cells
                 unsorted
                 background-bitmap-handle   hWatermark
                 background-bitmap-scale    1
                 .
           03 Pb-exit
              push-button
              line                          20 
              col                           62 
              size                          8 cells
              title                         "Exit" 
              exception-value               27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "W$BITMAP" using wbitmap-load, 
                                 "files/background-image.png"
                          giving hWatermark.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Background image on Controls"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           modify Tb1-container tab-to-add ("Scroll-pane", 
                                            "Tab Accordion"
                                            "Frame"
                                            "Treeview"
                                            "Listbox")

           modify Tb1-accordion tab-to-add ("Page1", "Page2")
                                tab-alignment ("L", "L")

           perform LOAD-TREE
           perform LOAD-LIST

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue 
              end-accept
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWatermark
           destroy hWin
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, hWatermark
           goback
           .
        
       LOAD-TREE.
           modify tv1 mass-update 1
           move low-value to old-ta-genre
           move low-value to old-ta-Artist
           perform varying cont from 1 by 1 until cont > 20
              if ta-genre(cont) not = old-ta-genre
                 perform ADD-TREE-PARENT
              else
                 if ta-Artist(cont) not = old-ta-Artist
                    perform ADD-TREE-CHILD
                 else
                    perform ADD-TREE-CHILD-CHILD
                 end-if
              end-if
           end-perform
           modify tv1 mass-update 0
           .

       ADD-TREE-PARENT.
           move ta-genre(cont)  to old-ta-genre
           modify Tv1 parent null 
                      item-to-add ta-genre(cont) giving tv-item-parent
                      has-children 1 
                      item-foreground-color rgb x#6883AE
           perform ADD-TREE-CHILD
           .

       ADD-TREE-CHILD.
           move ta-Artist(cont) to old-ta-Artist
           modify Tv1 parent tv-item-parent
                      item-to-add ta-Artist(cont) giving tv-item-child
                      has-children 1
                      item-foreground-color rgb x#6A98C6
           perform ADD-TREE-CHILD-CHILD
           .

       ADD-TREE-CHILD-CHILD.
           modify Tv1 parent tv-item-child  
                      item-to-add ta-title(cont) giving tv-item
                      has-children 0
                      item-foreground-color rgb x#354C5C 
           if cont < 7
              modify Tv1 ensure-visible = tv-item
           end-if.
           .

       LOAD-LIST.
           modify LS mass-update 1
           modify LS reset-list 1
           perform varying cont from 1 by 1 until cont > 20
              modify LS item-to-add ta-title(cont)
           end-perform
           modify LS mass-update 0
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
