      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. push-button.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  hBmpPB                  pic s9(9) comp-4.
       77  pb-enabled              pic 9 value 1.

       SCREEN SECTION.
       01  Mask.
           03 frame 
              col                        2 
              line                       2
              lines                      4
              size                       68
              engraved
              height-in-cells
              width-in-cells
              title                      "Standard button"
              . 
           03 pb-enable 
              push-button
              line                       3.5
              size                       24
              col                        5
              title                      "disable"
              exception-value            100
              .
           03 pb-text-left
              push-button
              line                       3.5
              col                        42
              size                       24
              title                      "Left Alignment"
              left
              rollover-foreground-color  rgb x#D51515
              .
           05 frame 
              col                        2 
              line                       6.5
              lines                      8
              size                       68
              engraved
              height-in-cells
              width-in-cells
              title                      "Bitmap button"
              . 
           03 pb-bmp
              push-button
              line                       8
              col                        11
              lines                      75  
              size                       75 
              bitmap
              bitmap-width               75
              bitmap-handle              hBmpPB
              bitmap-number              2
              bitmap-rollover            1
              bitmap-pressed             3
              bitmap-disabled            4
              bitmap-scale               2
              .
           05 pb-bmp-text
              push-button 
              title                      "Text and image"
              bitmap
              bitmap-width               75
              bitmap-handle              hBmpPB
              bitmap-number              2
              bitmap-rollover            1
              bitmap-pressed             3
              bitmap-disabled            4
              bitmap-scale               2
              title-position             1
              lines                      6 cells 
              size                       24 cells
              line                       8
              col                        42
              multiline
              rollover-foreground-color  rgb x#D51515
              .
           03 frame 
              col                        2
              line                       15
              lines                      5
              size                       68
              engraved
              height-in-cells
              width-in-cells
              title                      "Colored button"
              . 
           03 pb-flat-1
              push-button
              flat
              title "Flat"
              lines                      2 cells 
              size                       24 cells
              col                        5
              line                       17
              background-color           rgb x#C5DCEA
              foreground-color           rgb x#354C5C
              disabled-background-color  rgb x#DDE4EF
              disabled-foreground-color  rgb x#4B6C83
              rollover-background-color  rgb x#A6F9DE
              rollover-foreground-color  rgb x#D51515
              .
           03 pb-flat-2
              push-button
              flat
              title                      "rollover border color"
              lines                      2 cells 
              size                       24 cells
              col                        42
              line                       17
              background-color           rgb x#6A98C6
              foreground-color           rgb x#FFFFFF
              disabled-background-color  rgb x#8DB0D3
              disabled-foreground-color  rgb x#EEEEEE
              rollover-background-color  rgb x#A6F9DE
              rollover-foreground-color  rgb x#D51515
              rollover-border-color      rgb x#990066
              border-width               (2 2 2 2)
              .
           03 Pb-exit  
              push-button
              line                       20 
              col                        62 
              size                       8 cells
              title                      "Exit" 
              exception-value            27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "W$BITMAP" using wbitmap-load, "./files/pb.gif"
                          giving hBmpPB

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "PUSH-BUTTON Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception    
                    if crt-status = 100
                        if pb-enabled = 1
                           modify pb-bmp       enabled 0
                           modify pb-bmp-text  enabled 0
                           modify pb-flat-1    enabled 0
                           modify pb-flat-2    enabled 0
                           move   0   to pb-enabled
                           modify pb-enable title "enable"
                        else
                           modify pb-bmp       enabled 1
                           modify pb-bmp-text  enabled 1
                           modify pb-flat-1    enabled 1
                           modify pb-flat-2    enabled 1
                           move   1   to pb-enabled
                           modify pb-enable title "disable"
                        end-if
                    end-if
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin 
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, hBmpPB
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
