      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. numval.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  control-font            handle of font. 
       77  close-win               pic 9 value 0.
       77  var                     pic x any length.
       77  result-test             pic 9.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  3
              size                 50 cells
              title                "Input a string with letters and numb
      -                            "ers:" 
              .
           03 Ef-Val1
              entry-field  
              line                 4
              col                  3
              size                 18 
              value                var
              .
           03 frame
              engraved
              title                "Extract numbers"
              line                 7
              col                  3
              lines                9
              size                 24
              .
           03 push-button
              line                 9
              col                  4
              size                 20
              title                "NUMVAL"
              exception-value      101
              .
           03 push-button
              line                 11
              col                  4
              size                 20
              title                "NUMVAL-C"
              exception-value      102
              .
           03 push-button
              line                 13
              col                  4
              size                 20
              title                "NUMVAL-F"
              exception-value      103
              .
           03 frame
              engraved
              title                "Test numbers"
              line                 7
              col                  37
              lines                9
              size                 24
              .
           03 push-button
              line                 9
              col                  38
              size                 20
              title                "TEST-NUMVAL"
              exception-value      201
              .
           03 push-button
              line                 11
              col                  38
              size                 20
              title                "TEST-NUMVAL-C"
              exception-value      202
              .
           03 push-button
              line                 13
              col                  38
              size                 20
              title                "TEST-NUMVAL-F"
              exception-value      203
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              self-act
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "NUMVAL Function"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       EXCEPTION-HANDLING.
           evaluate crt-status 
           when 101
                perform NUMVAL
           when 102
                perform NUMVAL-C
           when 103
                perform NUMVAL-F
           when 201
                perform TEST-NUMVAL
           when 202
                perform TEST-NUMVAL-C
           when 203
                perform TEST-NUMVAL-F
           end-evaluate.

       NUMVAL.
           display message box function numval(var)
                   title   "Numbers"
           .

       NUMVAL-C.
           display message box function numval-c(var)
                   title   "Numbers"
           .

       NUMVAL-F.
           display message box function numval-c(var)
                   title   "Numbers"
           .

       TEST-NUMVAL.
           set result-test to function test-numval(var)
           if result-test = 0
              display message "test-numval ok"
           else
              display message "test-numval failed: " result-test
           end-if
           .

       TEST-NUMVAL-C.
           set result-test to function test-numval-c(var)
           if result-test = 0
              display message "test-numval-c ok"
           else
              display message "test-numval-c failed: " result-test
           end-if
           .

       TEST-NUMVAL-F.
           set result-test to function test-numval-f(var)
           if result-test = 0
              display message "test-numval-f ok"
           else
              display message "test-numval-f failed: " result-test
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move EVENT-ACTION-FAIL-TERMINATE  to EVENT-ACTION 
                move 1 to close-win
           end-evaluate
           .
