      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. ISCUSTOMER.
       configuration section.
       special-names.   

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
        copy "customer.sl".
       DATA DIVISION.
       FILE SECTION.
        COPY "customer.fd".

       WORKING-STORAGE SECTION.

       copy "common.wrk".
       copy "color.wrk".

       77  STATUS-Customer   PIC XX.

       01  screen-value.
           05 scr-id          pic  x(10).
           05 scr-fname       pic  x(20).
           05 scr-lname       pic  x(50).
           05 scr-tel1        pic  x(15).
           05 scr-tel2        pic  x(15).
           05 scr-fax         pic  x(15).
           05 scr-addr        pic  x(50).
           05 scr-contact     pic  x(20).
           05 scr-email       pic  x(30).

       78  id-ef-scr-id        value 100.
       78  id-ef-scr-fname     value 101.
       78  id-ef-scr-lname     value 102.
       78  id-ef-scr-tel1      value 103.
       78  id-ef-scr-tel2      value 104.
       78  id-ef-scr-fax       value 105.
       78  id-ef-scr-addr      value 106.
       78  id-ef-scr-contact   value 107.
       78  id-ef-scr-email     value 108.

       01                       pic 9.
           88 all-ok            value 1 false zero.

       77  choice               pic x.
       77  wrk-customer         pic x(10).
       77  cont                 pic 9(3).

        screen section.
       01 mask-main.
           05  label
               foreground-color RGB 78-lbl-menu-foreground-color
               background-color RGB 78-lbl-menu-background-color
               right
               col 31 
               line 1
               lines 2 
               size 76
               height-in-cells
               width-in-cells
               . 
           05  frame 
               raised
               line 3 
               col 31
               lines 20 cells
               size 76 cells
               .
           05  Label, 
               col 32
               LINE 4
               title R"Customer_id"
               transparent
               .
           05  Label
               col 32
               line 6
               title r"First_Name"
               transparent
               .
           05  Label
               col 32
               line 8
               title r"Last_Name"
               transparent
               .
           05  Label
               col 32
               line 10
               title r"Telephone_1"
               transparent
               .
           05  Label
               col 32
               line 12
               title r"Telephone_2"
               transparent
               .
           05  Label
               col 32
               line 14
               title r"Fax"
               transparent
               .
           05  Label
               col 32
               line 16
               title r"Address"
               transparent
               .
           05  Label
               col 32
               line 18
               title r"Contact"
               transparent
               .
           05  Label
               col 32
               line 20
               title r"E-mail"
               transparent
               .
           
           05  ef-scr-id Entry-Field
               COL 50 
               LINE 4
               SIZE 10
               max-text 10
               id id-ef-scr-id
               value scr-id
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               after AFT-EF-SCR-ID
               .
           05  ef-scr-fname Entry-Field, 
               COL 50
               LINE 6
               SIZE 50
               max-text 20
               value scr-fname
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               id id-ef-scr-fname
               .
           05  ef-scr-lname Entry-Field, 
               COL 50
               LINE 8
               SIZE 50
               max-text 50
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               value scr-lname
               id id-ef-scr-lname
               .
           05  ef-scr-tel1 Entry-Field, 
               COL 50
               LINE 10
               SIZE 50
               max-text 15
               value scr-tel1
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               id id-ef-scr-tel1
               .
           05  ef-scr-tel2 Entry-Field, 
               col 50
               line 12
               size 50
               max-text 15
               value scr-tel2
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               id id-ef-scr-tel2
               .
           05  ef-scr-fax Entry-Field, 
               col 50
               line 14
               size 50
               max-text 15
               value scr-fax
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               id id-ef-scr-fax
               .
           05  ef-scr-addr Entry-Field, 
               col 50
               line 16
               size 50
               max-text 50
               value scr-addr
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               id id-ef-scr-addr
               .
           05  ef-scr-contact Entry-Field, 
               col 50
               line 18
               size 50
               max-text 20
               value scr-contact
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               id id-ef-scr-contact
               .
           05  ef-scr-email Entry-Field, 
               col 50
               line 20
               size 50
               max-text 30
               value scr-email
               border-width (0, 0, 2, 0)
               border-color rgb 78-ef-border-color
               id id-ef-scr-email
               .

           copy "standard-mask-tool.scr".

       PROCEDURE DIVISION.
       DECLARATIVES.
       CUSTOMER-ERR section.
           use after standard error procedure on customer.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       
       MAIN.

           perform OPEN-FILES.
           
           initialize screen-value.
           
           display independent graphical window
                   title R"isCOBOL_Application_Customer"
                   lines 22
                   size 107
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   system menu
                   link to thread
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2 
                   .
           
           call "ISTOOLTIP"
           cancel "ISTOOLTIP".
           
           display tool-bar 
                   lines 2.5 
                   control font h-font 
                   handle h-tool 
                   upon h-sta

           display mask-main upon h-sta
           display mask-tool upon h-tool

           modify h-sta visible 1

           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform       
           
           perform EXIT-PRG.
           goback
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-new
                initialize cust-record
                perform DISPLAY-SCREEN
           when 78-exe-save
                perform SAVE-RECORD
           when 78-exe-delete
                perform DELETE-RECORD
                initialize cust-record
                perform DISPLAY-SCREEN
           when 78-exe-first
                perform READ-FIRST
                perform DISPLAY-SCREEN
           when 78-exe-prev
                perform READ-PREV
                perform DISPLAY-SCREEN
           when 78-exe-next
                perform READ-NEXT
                perform DISPLAY-SCREEN
           when 78-exe-last
                perform READ-LAST
                perform DISPLAY-SCREEN
           when 78-exe-zoom
                PERFORM ZOOM-PARAGRAPH
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           end-evaluate.

       DELETE-RECORD.
           display message box 
                          R"Are_you_sure_to_delete_the_selected_record?"
                   type mb-yes-no
                   default mb-no
                   giving choice
           if choice = mb-yes
             inquire ef-scr-id  value scr-id
             move scr-id   to Cust-id
             delete Customer record
                invalid
                   continue
             end-delete
           end-if.

       SAVE-RECORD.
           set all-ok  to true
           perform CONTROL-ALL
           
           if all-ok
              move scr-id      to cust-id
              move scr-fname   to cust-fname
              move scr-lname   to cust-lname
              move scr-tel1    to cust-tel1
              move scr-tel2    to cust-tel2
              move scr-fax     to cust-fax
              move scr-addr    to cust-addr
              move scr-contact to cust-contact
              move scr-email   to cust-email
           
              rewrite cust-record
                 invalid
                    write cust-record
              end-rewrite
           end-if.
 
       CONTROL-ALL.
           inquire ef-scr-id      value cust-id
           inquire ef-scr-fname   value cust-fname
           inquire ef-scr-lname   value cust-lname
           inquire ef-scr-tel1    value cust-tel1
           inquire ef-scr-tel2    value cust-tel2
           inquire ef-scr-addr    value cust-addr
           inquire ef-scr-fax     value cust-fax
           inquire ef-scr-contact value cust-contact
           inquire ef-scr-email   value cust-email
           
           if cust-id = space
              display message box R"Customer_id_is_mandatory!"
              move id-ef-scr-id  to control-id
              set all-ok          to false
           end-if.
           
           if all-ok
              if cust-lname = space
                 display message box R"Last_name_is_mandatory!"
                 move id-ef-scr-lname   to control-id
                 set all-ok             to false
              end-if
           end-if.
           
           if all-ok and cust-email not = space
              move zero   to cont
              inspect cust-email tallying cont for all "@"
              if cont not = 1
                 display message box R"Wrong_e-mail_address!"
                 move id-ef-scr-email   to control-id
                 set all-ok             to false
              end-if
           end-if.
 
       READ-FIRST.
           move low-value  to Cust-id
           start Customer key not < Cust-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize cust-record
              not invalid
                read Customer next no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize cust-record
                end-read
           end-start.
 
       READ-LAST.
           move high-value  to Cust-id
           start Customer key not > Cust-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize cust-record
              not invalid
                read Customer previous no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize cust-record
                end-read
           end-start.
 
       READ-PREV.
           inquire ef-scr-id VALUE scr-id.
           if scr-id = space
              perform READ-LAST
           else
              move scr-id  to Cust-id
              read Customer no lock
                invalid
                   start Customer key not < Cust-key
                      invalid
                         initialize cust-record
                   end-start
              end-read
              read Customer previous no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.

       READ-NEXT.
           inquire ef-scr-id VALUE scr-id.
           if scr-id = space
              perform READ-FIRST
           else
              move scr-id  to Cust-id
              read Customer no lock
                invalid
                   start Customer key not > Cust-key
                      invalid
                         initialize cust-record
                   end-start
              end-read
              read Customer next no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.
 
       RECORD-NOT-FOUND.
           display message box R"Record_not_found".
 
       DISPLAY-SCREEN.
           move cust-id      to scr-id     
           move cust-fname   to scr-fname  
           move cust-lname   to scr-lname  
           move cust-tel1    to scr-tel1   
           move cust-tel2    to scr-tel2   
           move cust-fax     to scr-fax    
           move cust-addr    to scr-addr   
           move cust-contact to scr-contact
           move cust-email   to scr-email  
           
           display mask-main.
 
       OPEN-FILES.
           open I-O Customer.

       EXIT-PRG.
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close Customer.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       AFT-EF-SCR-ID.
           if key-status = 13
              perform LOAD-RECORD
           end-if.

       LOAD-RECORD.
           move scr-id  to Cust-id
           read Customer no lock
              invalid
                 perform RECORD-NOT-FOUND
              not invalid
                 perform DISPLAY-SCREEN
           end-read.

       ZOOM-PARAGRAPH.
           evaluate control-id
           when id-ef-scr-id
                call "ZCUSTOMER" using wrk-customer
                cancel "ZCUSTOMER"
                if wrk-customer not = space
                   move wrk-customer   to scr-id
                   perform LOAD-RECORD
                end-if
           end-evaluate.

           copy "dec-file.prd".
