public class TestBean {

	public static void main(String[] args) {
		beanSONGS beanSongs = new beanSONGS();
		
		beanSongs.set_url("http://localhost:8080/songs-soap/servlet/SONGS");
		
		System.out.println("I like Vasco Rossi... let's add one of his hits");
		beanSongs.setOperation("I");
		beanSongs.setAlbum("VascoNonStop");
		beanSongs.setArtist("Vasco Rossi");
		beanSongs.setTitle("Un mondo migliore");
		beanSongs.setGenre("Pop rock");
		beanSongs.setLabel("Universal");
		beanSongs.setLength("4:11");
		beanSongs.setYear(2016);
		beanSongs.setAuthorAt(1, "Vasco Rossi");
		beanSongs.setAuthorAt(2, "");
		beanSongs.setAuthorAt(3, "");
		beanSongs.setAuthorAt(4, "");
		beanSongs.setAuthorAt(5, "");
		
		beanSongs.run();
		
		System.out.println("Let's read song with id=5");
		beanSongs.setlnk_op_code("R");
		beanSongs.setId(5);
		beanSongs.run();
		printSongInfo(beanSongs);
		
		//print whole database
		
		System.out.println("Complete track list");
		System.out.println("-------------------");
		beanSongs.setlnk_op_code("F");
		beanSongs.run();
		beanSongs.setlnk_op_code("N");
		
		while ("OK".equals(beanSongs.getlnk_status())) {
			printSongInfo(beanSongs);
			beanSongs.run();
		};
		
	}

	private static void printSongInfo(beanSONGS beanSongs) {
		if ("OK".equals(beanSongs.getlnk_status())){
			System.out.println("album: " + beanSongs.getAlbum());
			System.out.println("artist: " + beanSongs.getArtist());
			System.out.println("title: " + beanSongs.getTitle());
			System.out.println("genre: " + beanSongs.getGenre());
			System.out.println("length: " + beanSongs.getLength());
			System.out.println("label: " + beanSongs.getLabel());
			for (int i=1;i<=5;i++)
				if (beanSongs.getAuthorAt(i)!=null && !"".equals(beanSongs.getAuthorAt(i).trim()))
					System.out.println("author: " +beanSongs.getAuthorAt(i).trim());
			
			System.out.println("------------------------------------------");
			System.out.println();
		}//beanSongs.getlnk_sd_authorAt(0)
	}

}
