
##### isCOBOL release 2025 R2 build#1158.10-20251128-41083 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**This sample shows how to share the JISAM file thru an ODBC source using the ODBC Driver**
**for isCOBOL File Server.**

**You cannot use this type of approach with c-tree. Instead, use the specific**
**sample installed with the c-tree server**

**In order to use this sample you need to install the "ODBC driver for**
**isCOBOL File Server" option of isCOBOL UDBC**

**This sample use 2 files:**

- file1 is an indexed file with only one record definition
- filem is an indexed file with multiple record definitions

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

----------
### Section 1: Create the Jisam file with JUTIL utility 

This section shows how to create and load two different indexed Jisam data files from the 
sequential files file1.seq and filem.seq


 - 1 Using a command prompt window go to the "$ISCOBOL/sample/as/fs/odbc" 
     folder.

 - 2 Create file1 file

        jutil -makeimg file1 00071,00071,001,01,0,003,00000

 - 3 Load data into file1 from a sequential file

        jutil -load file1 file1.seq

 - 4 Create filem file

        jutil -makeimg filem 00125,00125,001,01,0,004,00000

 - 5 Load data into filem from a sequential file

        jutil -load filem filem.seq

 **Note:**

    Instead of executing the previous steps you can run create.sh to create the 
    Jisam indexed data files

----------
### Section 2: Create the Jisam file with isCOBOL 

 This section shows how to create two different indexed Jisam data files using a Cobol 
 Program

 - 1 Using a command prompt window go to the "$ISCOBOL/sample/as/fs/odbc" 
     folder.

 - 2 Compile the programs

        iscc -efd *.cbl

 - 3 Run the PROG_FILE1 program to create file1

        iscrun PROG_FILE1

 - 4 Run the PROG_MULTI program to create filem

        iscrun PROG_MULTI

----------
### Section 3: Create the ODBC connection on a single machine

 This section shows how to create the ODBC data source

 - 1 Using a command prompt window go to the "$ISCOBOL/sample/as/fs/odbc" 
     folder.

 - 2 Start the File Server

        iscserver -hostname <hostname | IP address> -fs -fsport <fs-port-number> -as -port <as-port-number>

 **NOTE:**

        If you have already started an instance of the Application Server,
        you can start a new instance of it on a different port

 - 3 Create the DSN

     - 3a. Open Control Panel, Administrative Tools, ODBC Data Sources. if you're running the 32 
           bit ODBC on a 64 bit Windows, you have to open the 32 bit ODBC manager
 
     - 3b. Select "User DSN" or "System DSN" page.
 
     - 3c. Click on the "Add" button.

     - 3d. Select "Veryant ODBC Driver for File Server" from the available drivers.
 
 - 4 Fill the "Veryant ODBC for File Server Setup" window

     - "Data Source Name": is the name of the Data Source. ODBC programs will connect to this 
                           Data Source to work with the files.
                           For example "VeryantODBC"
        
     - "Dictionary Directory": is the directory containing the EFD (extend file descriptors) 
                               of the files of our DSN. EFD files are xml files generated by 
                               the isCOBOL compiler if you compile with the -efd option.
       In this sample $ISCOBOL/sample/as/fs/odbc folder

     - "Server Address": is the address of the machine where the isCOBOL File Server is active 
                         and listening.
       In this sample 127.0.0.1 or space
 
     - "Server Port": is the port of the machine where the isCOBOL File Server is active and listening. 
       In this sample 10997 or space

 - 5 Press "Test connection" button to check the connection with the isCOBOL File Server

 - 6 Press "OK"

 - 7 Execute your ODBC client to see the data

----------
### Section 4: Create the ODBC connection 

 This section shows how to create the ODBC data source where File Server and ODBC are on two different machines

 **On the isCOBOL file server machine**

 - 1 Using a command prompt window go to the "$ISCOBOL/sample/as/fs/odbc" 
     folder.

 - 2 Create the efdrmt.dir
 
 - 3 Add into the efdrmt.dir the list of the xml files you want to be available into the ODBC connection.
     Into our sample the content can be

        file1.xml
        filem.xml

 - 4 Start the File Server

        iscserver -hostname <hostname | IP address> -fs -fsport <fs-port-number> -as -port <as-port-number>

 **NOTE:**

        If you have already started an instance of the Application Server,
        you can start a new instance of it on a different port

 **On the ODBC machine**

 - 1 Create the DSN

     - 1a. Open Control Panel, Administrative Tools, ODBC Data Sources. if you're running the 32 
           bit ODBC on a 64 bit Windows, you have to open the 32 bit ODBC manager
 
     - 1b. Select "User DSN" or "System DSN" page.
 
     - 1c. Click on the "Add" button.

     - 2d. Select "Veryant ODBC Driver for File Server" from the available drivers.
 
 - 2 Fill the "Veryant ODBC for File Server Setup" window

     - "Data Source Name": is the name of the Data Source. ODBC programs will connect to this 
                           Data Source to work with the files.
                           For example "VeryantODBC"
        
     - "Dictionary Directory": is the directory of the server that containing the EFD (extend 
                               file descriptors) of the files of our DSN. You need to add : before
                               the folder
                               EFD files are xml files generated by the isCOBOL compiler if you 
                               compile with the -efd option.

       In this sample :$ISCOBOL/sample/as/fs/odbc folder

     - "Server Address": is the address of the machine where the isCOBOL File Server is active 
                         and listening.
       In this sample 127.0.0.1 or space
 
     - "Server Port": is the port of the machine where the isCOBOL File Server is active and listening. 
       In this sample 10997 or space

 - 3 Press "Test connection" button to check the connection with the isCOBOL File Server

 - 4 Press "OK"

 - 5 Execute your ODBC client to see the data
