function filter(){
    var term=document.getElementById('filter').value.toLowerCase();
    var table=document.getElementById('coveragetable');

    if (table!=null){
        for (var r=1;r<table.rows.length-1;r++){
            rowContent='';
            for (c=0;c<table.rows[c].cells.length;c++)
                rowContent+=table.rows[r].cells[c].innerText.toLowerCase();

            if (rowContent.indexOf(term)>=0)
                table.rows[r].style['display']='';
            else
                table.rows[r].style['display']='none'  
        }
        calcTotals();
    }
}

function clearFilter(){
    document.getElementById('filter').value = '';
    filter();
}

function initFilter(){
    vars = getUrlVars();
    if (vars['filter']!=null){
        term=document.getElementById('filter').value = vars['filter'];
        filter();
    }
}

function getUrlVars() {
    var vars = {};
    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
        vars[key] = value;
    });
    return vars;
}

function getPercentageCellIndex(row){
	return row.cells.length - 3;
}

function formatSecs(v) {
	return new Intl.NumberFormat(undefined, {style: 'decimal', maximumFractionDigits: '3', minimumFractionDigits: '3'}).format(v);
}

function calcTotals(){
    var table=document.getElementById('coveragetable');

    var totPerc=0;
    var totSecs=0;
    var regex = /([0-9]|\.|\,)+/g;
    if (table!=null){
	    var pcIdx = getPercentageCellIndex(table.rows[0]);
        for (var r=1;r<table.rows.length-1;r++){
            if (table.rows[r].style['display']!='none'){
                totPerc += table.rows[r].cells[pcIdx].innerText.match(regex).map(function(v) { return parseFloat(v.replace(',','.')); })[0];
                totSecs += table.rows[r].cells[pcIdx+1].innerText.match(regex).map(
									function(v) { 
										v = v.replace(',','').replace('.','');
										var f = parseFloat(v) / 1000.0;
										return f; 
							        })[0];
            }  
        }
        document.getElementById('totalPerc').innerText = totPerc.toFixed(2) + '%';
        document.getElementById('totalSecs').innerText = formatSecs(totSecs);

    } 
}

function init(){
    initFilter();
    calcTotals();
    //sortColumn(a, false);
}
