/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file.internals;

import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.LockType;
import java.io.IOException;
import java.nio.channels.FileLock;

public class Lock {
    private final FileLock instance;
    private FileLock extenderInstance;
    private final FileAddress address;
    private long size;
    private LockType type;

    public boolean isProgramLock() {
        return this.type == LockType.PROGRAM || this.type == LockType.PROGRAM_AND_TRANSACTION;
    }

    public boolean isTransactionLock() {
        return this.type == LockType.TRANSACTION || this.type == LockType.PROGRAM_AND_TRANSACTION;
    }

    public void updateType(LockType type) {
        if (type != null) {
            if (type != this.type) {
                this.type = LockType.PROGRAM_AND_TRANSACTION;
            }
        } else {
            this.type = null;
        }
    }

    public void extend(FileLock extenderInstance) {
        this.extenderInstance = extenderInstance;
        this.size = this.instance.size() + extenderInstance.size();
    }

    public boolean release() {
        try {
            this.instance.release();
            if (this.extenderInstance != null) {
                this.instance.release();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public Lock(int segment, FileLock instance, LockType type) {
        this.instance = instance;
        this.address = new FileAddress(segment, instance.position());
        this.size = instance.size();
        this.type = type;
    }

    public Lock(int segment, FileLock instance) {
        this(segment, instance, LockType.PROGRAM);
    }

    public String toString() {
        return "address: (" + this.address + "), size: " + this.size;
    }

    public FileAddress getAddress() {
        return this.address;
    }

    public long getSize() {
        return this.size;
    }

    public LockType getType() {
        return this.type;
    }
}

