/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.Config;
import com.veryant.vision4j.file.Constants;
import com.veryant.vision4j.file.Status;
import com.veryant.vision4j.file.internals.Block;
import com.veryant.vision4j.file.internals.BufferBlock;
import com.veryant.vision4j.file.internals.CacheDataType;
import com.veryant.vision4j.file.internals.CacheResult;
import com.veryant.vision4j.file.internals.FileDescriptor;
import com.veryant.vision4j.file.internals.ReadAheadBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FileSystemCache
implements Constants {
    private final Status status;
    private final int numBuffers;
    private final boolean buffersNodesOnly;
    private boolean readAhead;
    private final ReadAheadBuffer readAheadBuffer = new ReadAheadBuffer();
    private long buffersVersion;
    private final List<HashMap<Long, BufferBlock>> buffersMap = new ArrayList<HashMap<Long, BufferBlock>>();
    private final BufferBlock[] buffers;
    private int mruHead;
    private int lruHead;
    private int fileDescriptorCounter = 0;

    private void addIntoMap(BufferBlock bufferBlock) {
        this.buffersMap.get(bufferBlock.getFileDescriptorId() - 1).put(bufferBlock.getBlockNumber(), bufferBlock);
    }

    private void deleteFromMap(BufferBlock bufferBlock) {
        this.buffersMap.get(bufferBlock.getFileDescriptorId() - 1).remove(bufferBlock.getBlockNumber());
    }

    private BufferBlock getFromMap(int fileDescriptorId, long blockNumber) {
        return this.buffersMap.get(fileDescriptorId - 1).get(blockNumber);
    }

    private boolean lookupMap(int fileDescriptorId, long blockNumber) {
        return this.buffersMap.get(fileDescriptorId - 1).containsKey(blockNumber);
    }

    private static long sectorModule(long val) {
        return val & 0x1FFL;
    }

    private static boolean notAlignedRegion(long offset, int size) {
        return FileSystemCache.sectorModule(offset) != 0L || FileSystemCache.sectorModule(size) != 0L;
    }

    private CacheResult isCachedRegion(FileDescriptor file, long offset, int size) {
        int amount;
        long blockNumber = offset >> 9;
        int blockOffset = (int)FileSystemCache.sectorModule(offset);
        int hitCount = 0;
        int blockCount = 0;
        for (int i = size; i > 0; i -= amount) {
            amount = 512 - blockOffset;
            if (amount > i) {
                amount = i;
            }
            if (this.lookupMap(file.getId(), blockNumber)) {
                ++hitCount;
            }
            ++blockCount;
            ++blockNumber;
            blockOffset = 0;
        }
        if (hitCount == 0) {
            return CacheResult.NONE;
        }
        if (hitCount < blockCount) {
            return CacheResult.PARTIAL;
        }
        return CacheResult.FULL;
    }

    private int getCachedRegion(FileDescriptor file, long offset, int size, Block buffer, int bufferOffset) {
        int amount;
        long blockNumber = offset >> 9;
        int blockOffset = (int)FileSystemCache.sectorModule(offset);
        for (int i = size; i > 0; i -= amount) {
            BufferBlock bufferBlock;
            amount = 512 - blockOffset;
            if (amount > i) {
                amount = i;
            }
            if ((bufferBlock = this.getFromMap(file.getId(), blockNumber)) == null) {
                return -1;
            }
            this.bumpBuffer(bufferBlock.getIndex());
            buffer.copy(bufferOffset, bufferBlock.getBlock(), blockOffset, amount);
            bufferOffset += amount;
            ++blockNumber;
            blockOffset = 0;
        }
        return size;
    }

    private void bumpBuffer(int bufferIndex) {
        if (bufferIndex == this.mruHead) {
            return;
        }
        if (bufferIndex == this.lruHead) {
            this.lruHead = this.buffers[bufferIndex].getLruLink();
            this.buffers[this.lruHead].setMruLink(-1);
        } else {
            int lru = this.buffers[bufferIndex].getLruLink();
            int mru = this.buffers[bufferIndex].getMruLink();
            this.buffers[lru].setMruLink(mru);
            this.buffers[mru].setLruLink(lru);
        }
        this.buffers[bufferIndex].setMruLink(this.mruHead);
        this.buffers[bufferIndex].setLruLink(-1);
        this.buffers[this.mruHead].setLruLink(bufferIndex);
        this.mruHead = bufferIndex;
    }

    private void ignoreBuffer(int bufferIndex) {
        if (bufferIndex == this.lruHead) {
            return;
        }
        if (bufferIndex == this.mruHead) {
            this.mruHead = this.buffers[bufferIndex].getMruLink();
            this.buffers[this.mruHead].setLruLink(-1);
        } else {
            int lru = this.buffers[bufferIndex].getLruLink();
            int mru = this.buffers[bufferIndex].getMruLink();
            this.buffers[lru].setMruLink(mru);
            this.buffers[mru].setLruLink(lru);
        }
        this.buffers[bufferIndex].setLruLink(this.lruHead);
        this.buffers[bufferIndex].setMruLink(-1);
        this.buffers[this.lruHead].setMruLink(bufferIndex);
        this.lruHead = bufferIndex;
    }

    private int doCacheNotAlignedRegion(FileDescriptor file, long offset, int size, Block buffer, int bufferOffset) {
        int amount;
        long blockNumber = offset >> 9;
        int blockOffset = (int)FileSystemCache.sectorModule(offset);
        int totalAmount = 0;
        for (int i = size; i > 0; i -= amount) {
            BufferBlock bufferBlock;
            amount = 512 - blockOffset;
            if (amount > i) {
                amount = i;
            }
            if ((bufferBlock = this.loadBufferBlock(file, blockNumber)) == null) {
                int readBytes = this.readRegion(file, offset + (long)totalAmount, amount, buffer, bufferOffset + totalAmount);
                if (readBytes < amount) {
                    return -1;
                }
            } else {
                buffer.copy(bufferOffset + totalAmount, bufferBlock.getBlock(), blockOffset, amount);
            }
            totalAmount += amount;
            ++blockNumber;
            blockOffset = 0;
        }
        return size;
    }

    private BufferBlock loadBufferBlock(FileDescriptor file, long blockNumber) {
        int readResult;
        BufferBlock bufferBlock = this.getFromMap(file.getId(), blockNumber);
        if (bufferBlock != null) {
            this.bumpBuffer(bufferBlock.getIndex());
            return bufferBlock;
        }
        bufferBlock = this.buffers[this.lruHead];
        if (bufferBlock.getFileDescriptorId() > 0) {
            this.deleteFromMap(bufferBlock);
        }
        if ((readResult = this.readRegion(file, blockNumber << 9, 512, bufferBlock.getBlock(), 0)) < 0) {
            bufferBlock.setFileDescriptorId(0);
            bufferBlock.setBlockNumber(-1L);
            return null;
        }
        bufferBlock.setFileDescriptorId(file.getId());
        bufferBlock.setBlockNumber(blockNumber);
        this.addIntoMap(bufferBlock);
        this.bumpBuffer(bufferBlock.getIndex());
        return bufferBlock;
    }

    private int doCacheRegion(FileDescriptor file, long offset, int size, Block buffer, int bufferOffset) {
        if (this.readRegion(file, offset, size, buffer, bufferOffset) < size) {
            return -1;
        }
        long blockNumber = offset >> 9;
        for (int i = size; i > 0; i -= 512) {
            BufferBlock bufferBlock = this.getFromMap(file.getId(), blockNumber);
            if (bufferBlock == null) {
                bufferBlock = this.buffers[this.lruHead];
                if (bufferBlock.getFileDescriptorId() > 0) {
                    this.deleteFromMap(bufferBlock);
                }
                bufferBlock.setFileDescriptorId(file.getId());
                bufferBlock.setBlockNumber(blockNumber);
                bufferBlock.getBlock().copy(0, buffer, bufferOffset, 512);
                this.addIntoMap(bufferBlock);
            }
            this.bumpBuffer(bufferBlock.getIndex());
            bufferOffset += 512;
            ++blockNumber;
        }
        return size;
    }

    private int readRegion(FileDescriptor file, long offset, int size, Block buffer, int bufferOffset) {
        FileChannel fileChannel = file.getChannel();
        if (this.readAhead && size <= 4096) {
            long readAheadOffset = this.readAheadBuffer.getOffset();
            if (file.getId() != this.readAheadBuffer.getFileDescriptorId() || offset < readAheadOffset || offset + (long)size > readAheadOffset + 4096L) {
                try {
                    fileChannel.position(offset);
                    int bytesRead = fileChannel.read(ByteBuffer.wrap(this.readAheadBuffer.getBlock().getBytes(), 0, 4096));
                    if (bytesRead < size) {
                        size = bytesRead;
                    }
                    this.readAheadBuffer.setFileDescriptorId(bytesRead < 512 ? 0 : file.getId());
                    this.readAheadBuffer.setOffset(offset);
                }
                catch (IOException e) {
                    this.readAheadBuffer.setFileDescriptorId(0);
                    this.readAhead = false;
                }
            }
            if (this.readAhead) {
                buffer.copy(bufferOffset, this.readAheadBuffer.getBlock(), (int)(offset - this.readAheadBuffer.getOffset()), size);
                return size;
            }
        }
        try {
            fileChannel.position(offset);
            return fileChannel.read(ByteBuffer.wrap(buffer.getBytes(), bufferOffset, size));
        }
        catch (IOException e) {
            return -1;
        }
    }

    private int readFromCache(FileDescriptor file, long offset, int size, Block buffer, int bufferOffset) {
        if (FileSystemCache.notAlignedRegion(offset, size)) {
            return this.doCacheNotAlignedRegion(file, offset, size, buffer, bufferOffset);
        }
        if (this.isCachedRegion(file, offset, size) == CacheResult.FULL) {
            return this.getCachedRegion(file, offset, size, buffer, bufferOffset);
        }
        return this.doCacheRegion(file, offset, size, buffer, bufferOffset);
    }

    private int writeRegion(FileDescriptor file, long offset, int size, Block buffer, int bufferOffset) {
        try {
            FileChannel fileChannel = file.getChannel();
            fileChannel.position(offset);
            return fileChannel.write(ByteBuffer.wrap(buffer.getBytes(), bufferOffset, size));
        }
        catch (IOException e) {
            return -1;
        }
    }

    private int writeRegionAndUpdateCache(FileDescriptor file, long offset, int size, Block buffer, int bufferOffset) {
        int amount;
        int writtenBytes = this.writeRegion(file, offset, size, buffer, bufferOffset);
        if (writtenBytes < size) {
            return writtenBytes;
        }
        long blockNumber = offset >> 9;
        int blockOffset = (int)FileSystemCache.sectorModule(offset);
        for (int i = size; i > 0; i -= amount) {
            BufferBlock bufferBlock;
            amount = 512 - blockOffset;
            if (amount > i) {
                amount = i;
            }
            if ((bufferBlock = this.getFromMap(file.getId(), blockNumber)) != null) {
                this.bumpBuffer(bufferBlock.getIndex());
                bufferBlock.getBlock().copy(blockOffset, buffer, bufferOffset, amount);
            }
            bufferOffset += amount;
            ++blockNumber;
            blockOffset = 0;
        }
        return size;
    }

    private boolean useCache(CacheDataType cacheDataType) {
        if (this.numBuffers > 0) {
            return this.buffersNodesOnly ? cacheDataType == CacheDataType.INDEX : cacheDataType != CacheDataType.HEADER;
        }
        return false;
    }

    public FileSystemCache(Status status) {
        this.status = status;
        this.numBuffers = Config.V_BUFFERS_PER_FILE.getIntegerValue();
        this.readAhead = Config.V_READ_AHEAD.isOn();
        this.buffersNodesOnly = Config.V_BUFFERS_NODES_ONLY.isOn();
        this.buffers = new BufferBlock[this.numBuffers];
        for (int i = 0; i < this.numBuffers; ++i) {
            this.buffers[i] = new BufferBlock(i);
            this.buffers[i].setFileDescriptorId(0);
            this.buffers[i].setBlockNumber(-1L);
            this.buffers[i].setLruLink(i - 1);
            this.buffers[i].setMruLink(i + 1);
        }
        if (this.numBuffers > 0) {
            this.buffers[this.numBuffers - 1].setMruLink(-1);
        }
        this.mruHead = 0;
        this.lruHead = this.numBuffers - 1;
    }

    public void syncCache() {
    }

    public void checkCacheVersion(long treeVersion) {
        if (treeVersion != this.buffersVersion) {
            this.readAheadBuffer.setFileDescriptorId(0);
            for (int i = 0; i < this.numBuffers; ++i) {
                this.buffers[i].setFileDescriptorId(0);
                this.buffers[i].setBlockNumber(-1L);
            }
            this.buffersVersion = 0L;
            for (HashMap<Long, BufferBlock> map : this.buffersMap) {
                map.clear();
            }
        }
    }

    public void setCacheVersion(long treeVersion) {
        this.buffersVersion = treeVersion;
    }

    public FileLock lock(FileDescriptor file) {
        while (true) {
            try {
                return file.getChannel().lock(0L, 1L, false);
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                continue;
            }
            catch (IOException | RuntimeException e) {
                this.status.setErrno(1);
                return null;
            }
            break;
        }
    }

    public FileLock testLock(FileDescriptor file, long offset, int size) {
        try {
            FileLock ret = file.getChannel().tryLock(offset, size, false);
            if (ret == null) {
                this.status.setErrno(5);
            }
            return ret;
        }
        catch (OverlappingFileLockException e) {
            this.status.setErrno(5);
        }
        catch (IOException | RuntimeException e) {
            this.status.setErrno(1);
        }
        return null;
    }

    public void unlock(FileLock lock) {
        try {
            lock.release();
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
    }

    public FileDescriptor open(String fileName, int openMode) {
        try {
            FileDescriptor fileDescriptor = new FileDescriptor(this.fileDescriptorCounter + 1, fileName, openMode);
            ++this.fileDescriptorCounter;
            this.buffersMap.add(new HashMap());
            return fileDescriptor;
        }
        catch (NoSuchFileException e) {
            this.status.setErrno(15);
        }
        catch (SecurityException | AccessDeniedException e) {
            this.status.setErrno(16);
        }
        catch (IOException | RuntimeException e) {
            this.status.setErrno(1);
        }
        return null;
    }

    public boolean remove(String fileName) {
        Path pathToRemove = Paths.get(fileName, new String[0]);
        if (Files.isDirectory(pathToRemove, new LinkOption[0])) {
            this.status.setErrno(1);
            return false;
        }
        try {
            Files.delete(pathToRemove);
            return true;
        }
        catch (NoSuchFileException e) {
            this.status.setErrno(15);
        }
        catch (SecurityException | AccessDeniedException e) {
            this.status.setErrno(16);
        }
        catch (IOException | RuntimeException e) {
            this.status.setErrno(1);
        }
        return false;
    }

    public boolean rename(String oldName, String newName) {
        Path oldPath = Paths.get(oldName, new String[0]);
        Path newPath = Paths.get(newName, new String[0]);
        if (Files.isDirectory(oldPath, new LinkOption[0]) || Files.isDirectory(oldPath, new LinkOption[0])) {
            this.status.setErrno(1);
            return false;
        }
        try {
            Files.move(oldPath, newPath, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (NoSuchFileException e) {
            this.status.setErrno(15);
        }
        catch (SecurityException | AccessDeniedException e) {
            this.status.setErrno(16);
        }
        catch (IOException | RuntimeException e) {
            this.status.setErrno(1);
        }
        return false;
    }

    public boolean checkSize(FileDescriptor file, long size) {
        try {
            return file.getChannel().size() == size;
        }
        catch (IOException e) {
            return false;
        }
    }

    public long seek(FileDescriptor file, long offset) {
        file.setOffset(offset);
        return offset;
    }

    public int read(FileDescriptor file, Block buffer, CacheDataType type) {
        return this.read(file, buffer, 0, buffer.size(), type);
    }

    public int read(FileDescriptor file, Block buffer, int bufferOffset, int length, CacheDataType type) {
        int bytesRead;
        int n = bytesRead = this.useCache(type) ? this.readFromCache(file, file.getOffset(), length, buffer, bufferOffset) : this.readRegion(file, file.getOffset(), length, buffer, bufferOffset);
        if (bytesRead >= 0) {
            if (bytesRead != length) {
                this.status.setErrno(6);
                this.status.setIntErrno(9);
            }
            file.incOffset(bytesRead);
        } else {
            this.status.setErrno(1);
        }
        return bytesRead;
    }

    public int write(FileDescriptor file, Block buffer, CacheDataType type) {
        return this.write(file, buffer, 0, buffer.size(), type);
    }

    public int write(FileDescriptor file, Block buffer, int bufferOffset, int length, CacheDataType type) {
        int bytesWritten;
        this.readAheadBuffer.setFileDescriptorId(0);
        int n = bytesWritten = this.useCache(type) ? this.writeRegionAndUpdateCache(file, file.getOffset(), length, buffer, bufferOffset) : this.writeRegion(file, file.getOffset(), length, buffer, bufferOffset);
        if (bytesWritten >= 0) {
            if (bytesWritten != length) {
                this.status.setErrno(10);
            }
            file.incOffset(bytesWritten);
        } else {
            this.status.setErrno(1);
        }
        return bytesWritten;
    }

    public boolean close(FileDescriptor file) {
        try {
            if (this.readAheadBuffer.getFileDescriptorId() == file.getId()) {
                this.readAheadBuffer.setFileDescriptorId(0);
            }
            this.buffersVersion = 0L;
            file.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

