/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.converters;

import com.veryant.cobol.converters.NumericDisplay;
import com.veryant.cobol.data.CobolBigDecimal;
import com.veryant.cobol.data.IMemory;

public class LAE
extends NumericDisplay {
    public static int loadInt(IMemory iMemory, int n, int n2) {
        int n3 = n + n2;
        int n4 = iMemory.get(n++) & 0xFF;
        int n5 = DIGITS[n4];
        while (n < n3) {
            n5 = n5 * 10 + (iMemory.get(n++) & 0xF);
        }
        if (NEGATIVELY_SIGNED_TABLE[n4]) {
            return -n5;
        }
        return n5;
    }

    public static long loadLong(IMemory iMemory, int n, int n2) {
        int n3 = n + n2;
        int n4 = iMemory.get(n++) & 0xFF;
        long l = DIGITS[n4];
        while (n < n3) {
            l = l * 10L + (long)(iMemory.get(n++) & 0xF);
        }
        if (NEGATIVELY_SIGNED_TABLE[n4]) {
            return -l;
        }
        return l;
    }

    public static CobolBigDecimal loadBigDecimal(IMemory iMemory, int n, int n2, int n3) {
        byte[] byArray = new byte[n2];
        while (n2 > 1) {
            byArray[--n2] = (byte)(iMemory.get(n + n2) & 0xF);
        }
        int n4 = iMemory.get(n) & 0xFF;
        byArray[0] = DIGITS[n4];
        return CobolBigDecimal.from(NEGATIVELY_SIGNED_TABLE[n4], byArray, n3);
    }

    public static void store(int n, IMemory iMemory, int n2, int n3) {
        LAE.store((byte)48, n, iMemory, n2, n3);
        if (n < 0) {
            iMemory.put(n2, NEG_EBCDIC_ASCII[iMemory.get(n2) - 48]);
        } else {
            iMemory.put(n2, POS_EBCDIC_ASCII[iMemory.get(n2) - 48]);
        }
    }

    public static void store(long l, IMemory iMemory, int n, int n2) {
        LAE.store((byte)48, l, iMemory, n, n2);
        if (l < 0L) {
            iMemory.put(n, NEG_EBCDIC_ASCII[iMemory.get(n) - 48]);
        } else {
            iMemory.put(n, POS_EBCDIC_ASCII[iMemory.get(n) - 48]);
        }
    }

    public static void store(CobolBigDecimal cobolBigDecimal, IMemory iMemory, int n, int n2, int n3) {
        LAE.store((byte)48, cobolBigDecimal, iMemory, n, n2, n3);
        if (cobolBigDecimal.isNegative()) {
            iMemory.put(n, NEG_EBCDIC_ASCII[iMemory.get(n) - 48]);
        } else {
            iMemory.put(n, POS_EBCDIC_ASCII[iMemory.get(n) - 48]);
        }
    }
}

