/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.types;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.memory.Chunk;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.scope.NamedConditionDeclaration;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.ISubscriptable;
import com.veryant.cobol.exceptions.COBOLCompilerException;

public class ConditionNameReference
extends AbstractOperand
implements ISubscriptable {
    private final NamedConditionDeclaration declaration;
    private final int subscriptsCount;
    private AbstractOperand[] subscripts;
    private int[] subscriptsMultiplier;

    @Override
    public int getSubscriptsCount() {
        return this.subscriptsCount;
    }

    @Override
    public void setSubscript(int n, AbstractOperand abstractOperand) {
        this.subscripts[n] = abstractOperand;
    }

    @Override
    public AbstractOperand getSubscript(int n) {
        return this.subscripts[n];
    }

    @Override
    public int getSubscriptMultiplier(int n) {
        return this.subscriptsMultiplier[n];
    }

    @Override
    public boolean hasExternalSubscripts() {
        return false;
    }

    public NamedConditionDeclaration getNamedConditionDeclaration() {
        return this.declaration;
    }

    @Override
    public BuiltIn getBuiltIn() {
        return BuiltIn.INTERMEDIATE_CONDITION;
    }

    @Override
    public Magnitude getMagnitude() {
        return null;
    }

    @Override
    public Chunk getChunk() {
        throw new COBOLCompilerException("Internal error, types system fail");
    }

    public ConditionNameReference(ISourceReference iSourceReference, NamedConditionDeclaration namedConditionDeclaration) {
        super(iSourceReference);
        this.declaration = namedConditionDeclaration;
        this.declaration.markAsUsed();
        DataItem dataItem = namedConditionDeclaration.getParent().getDataItem();
        this.subscriptsCount = dataItem.getOccursRank();
        if (this.subscriptsCount > 0) {
            dataItem.denyPromotion();
            this.subscripts = new AbstractOperand[this.subscriptsCount];
            this.subscriptsMultiplier = new int[this.subscriptsCount];
            DataItem dataItem2 = dataItem.isOccurs() ? dataItem : dataItem.getParentOccurs();
            for (int i = this.subscriptsCount - 1; i >= 0; --i) {
                this.subscriptsMultiplier[i] = ((DynamicChunk)dataItem2.getChunk()).getSize();
                dataItem2 = dataItem2.getParentOccurs();
            }
        }
    }

    public String toString() {
        return this.declaration.toString();
    }
}

