/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.emitters.jvm.MathPrecision;
import com.veryant.cobol.compiler.stmts.AbstractArithmeticStatement;
import com.veryant.cobol.compiler.types.AbstractOperand;

public class Divide
extends AbstractArithmeticStatement {
    private final AbstractOperand operand;
    private final AbstractOperand byOperand;
    private final AbstractOperand[] intoOperands;
    private final AbstractOperand[] givingOperands;
    private final AbstractOperand remainderOperand;

    @Override
    public Statements getStatement() {
        return Statements.DIVIDE;
    }

    @Override
    public MathPrecision getPrecision() {
        if (IOperand.isFloatingPoint(this.operand) || IOperand.isFloatingPoint(this.byOperand)) {
            return MathPrecision.FLOATING_POINT_PRECISION;
        }
        if (this.intoOperands != null) {
            for (AbstractOperand abstractOperand : this.intoOperands) {
                if (!IOperand.isFloatingPoint(abstractOperand)) continue;
                return MathPrecision.FLOATING_POINT_PRECISION;
            }
        }
        return MathPrecision.FIXED_POINT_PRECISION;
    }

    public Divide(ISourceReference iSourceReference, AbstractOperand abstractOperand, AbstractOperand[] abstractOperandArray, AbstractOperand[] abstractOperandArray2, AbstractOperand abstractOperand2) {
        super(iSourceReference);
        this.operand = abstractOperand;
        this.intoOperands = abstractOperandArray;
        this.byOperand = null;
        this.givingOperands = abstractOperandArray2;
        this.remainderOperand = abstractOperand2;
    }

    public Divide(ISourceReference iSourceReference, AbstractOperand abstractOperand, AbstractOperand abstractOperand2, AbstractOperand[] abstractOperandArray, AbstractOperand abstractOperand3) {
        super(iSourceReference);
        this.operand = abstractOperand;
        this.intoOperands = null;
        this.byOperand = abstractOperand2;
        this.givingOperands = abstractOperandArray;
        this.remainderOperand = abstractOperand3;
    }

    public AbstractOperand getOperand() {
        return this.operand;
    }

    public AbstractOperand getByOperand() {
        return this.byOperand;
    }

    public AbstractOperand[] getIntoOperands() {
        return this.intoOperands;
    }

    public AbstractOperand[] getGivingOperands() {
        return this.givingOperands;
    }

    public AbstractOperand getRemainderOperand() {
        return this.remainderOperand;
    }
}

