/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import java.util.Iterator;
import java.util.LinkedList;

public class CodeBlock
extends AbstractStatement
implements Iterable<IStatement> {
    private int rank = 0;
    private final LinkedList<IStatement> block = new LinkedList();
    private boolean unreachableState;
    private int unreachableStatements;

    public void addUnreachableStatement() {
        ++this.unreachableStatements;
    }

    @Override
    public Statements getStatement() {
        return Statements.BLOCK;
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    @Override
    public Iterator<IStatement> iterator() {
        return this.block.iterator();
    }

    public IStatement getLastStatement() {
        return this.block.getLast();
    }

    public int size() {
        return this.block.size();
    }

    public CodeBlock(ISourceReference iSourceReference) {
        super(iSourceReference);
    }

    public CodeBlock() {
        super(Token.NULL);
    }

    public void add(IStatement iStatement) {
        this.block.add(iStatement);
        this.rank += iStatement.getRank();
    }

    public boolean isUnreachableState() {
        return this.unreachableState;
    }

    public void setUnreachableState(boolean bl) {
        this.unreachableState = bl;
    }

    public int getUnreachableStatements() {
        return this.unreachableStatements;
    }
}

