/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.StringFormat;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Functions;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.statements.BaseEmitter;
import com.veryant.cobol.compiler.stmts.Move;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.DataItemReference;

public abstract class MoveEmitter
extends BaseEmitter {
    private static final StringFormat COPY = new StringFormat("Raw.copyMemory({?},{?});");

    public static void emit(JvmCode jvmCode, IStatement iStatement) {
        Move move = (Move)iStatement;
        AbstractOperand abstractOperand = move.getSource();
        AbstractOperand abstractOperand2 = move.getDestination();
        if (!IOperand.isNumeric(abstractOperand2) && abstractOperand2.getStaticSize() == 1) {
            boolean bl = false;
            if (abstractOperand instanceof DataItemReference) {
                bl = ((DataItemReference)abstractOperand).getDataItem().isPromoted();
            }
            if (!bl && abstractOperand.getStaticSize() == 1) {
                Functions.f_load_single_byte(jvmCode, abstractOperand);
                Functions.f_store_single_byte(jvmCode, abstractOperand2);
                return;
            }
        }
        if (abstractOperand.matches(abstractOperand2)) {
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD_ADDR(jvmCode, abstractOperand2);
            Opcodes.INJECT(jvmCode, COPY);
            return;
        }
        switch (abstractOperand.getBuiltIn()) {
            case ALPHA_NUM: 
            case ALPHA_NUM_EBCDIC: 
            case ALPHA: 
            case ALPHA_EBCDIC: 
            case STRING_LITERAL: {
                com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
                break;
            }
            default: {
                com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, abstractOperand);
            }
        }
        com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, abstractOperand2);
    }
}

