/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters;

import com.veryant.cobol.compiler.emitters.Payload;
import com.veryant.cobol.compiler.emitters.TargetCodeSnippet;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.util.ArrayList;

public class TargetCode<T extends TargetCodeSnippet>
extends Payload {
    private final StringBuilder codeBuffer = new StringBuilder();
    private final ArrayList<T> evaluationStack = new ArrayList(50);

    public void push(T t, boolean bl) {
        if (bl) {
            this.evaluationStack.add(t);
        } else {
            this.codeBuffer.append(t);
        }
    }

    public T pop() {
        int n = this.evaluationStack.size();
        if (n == 0) {
            throw new COBOLCompilerException("Internal error, evaluation stack negative");
        }
        return (T)((TargetCodeSnippet)this.evaluationStack.remove(n - 1));
    }

    public T peek() {
        return this.peek(0);
    }

    public T peek(int n) {
        int n2 = this.evaluationStack.size() + n - 1;
        if (n2 < 0) {
            throw new COBOLCompilerException("Internal error, evaluation stack negative");
        }
        return (T)((TargetCodeSnippet)this.evaluationStack.get(n2));
    }

    public int size() {
        return this.codeBuffer.length();
    }

    public int evaluationStackSize() {
        return this.evaluationStack.size();
    }

    public String toString() {
        return this.codeBuffer.toString();
    }
}

