/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ast.AstDataItemReference;
import com.veryant.cobol.compiler.ast.common.AstFrom;
import com.veryant.cobol.compiler.ast.common.AstInvalidKey;
import com.veryant.cobol.compiler.ast.common.AstNotInvalidKey;
import com.veryant.cobol.compiler.ast.statements.AstAbstractFileIOStatement;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.memory.RecordItem;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.stmts.Move;
import com.veryant.cobol.compiler.stmts.Rewrite;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.DataItemReference;

public class AstRewriteStatement
extends AstAbstractFileIOStatement {
    private DataItemReference record = null;

    public AstRewriteStatement(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void validate() {
        DataItemReference dataItemReference;
        AstDataItemReference astDataItemReference = (AstDataItemReference)this.getChild(0);
        AbstractOperand abstractOperand = astDataItemReference.getOperand();
        if (abstractOperand instanceof DataItemReference && (dataItemReference = (DataItemReference)abstractOperand).getDataItem() instanceof RecordItem) {
            this.record = dataItemReference;
            FileDeclaration fileDeclaration = ((RecordItem)this.record.getDataItem()).getFile();
            if (!fileDeclaration.getIsSelectMissing()) {
                switch (fileDeclaration.getOrganization()) {
                    case Relative: 
                    case Indexed: {
                        break;
                    }
                    default: {
                        AstNotInvalidKey astNotInvalidKey;
                        AstInvalidKey astInvalidKey = this.findChild(AstInvalidKey.class);
                        if (astInvalidKey != null) {
                            this.consoleWrite(72, astInvalidKey.getToken(), fileDeclaration.getOrganization().getDescription());
                        }
                        if ((astNotInvalidKey = this.findChild(AstNotInvalidKey.class)) == null) break;
                        this.consoleWrite(72, astNotInvalidKey.getToken(), fileDeclaration.getOrganization().getDescription());
                    }
                }
            }
            return;
        }
        this.consoleWrite(73, this.getToken(), new Object[0]);
    }

    @Override
    public void walk() {
        AstFrom astFrom = this.findChild(AstFrom.class);
        if (astFrom != null) {
            this.getCode().addStatement(new Move(this.getToken(), astFrom.getChildOperand(0), this.record));
        }
        Rewrite rewrite = new Rewrite(this.getToken());
        rewrite.getData().setRecord(this.record);
        rewrite.getData().setFile(((RecordItem)this.record.getDataItem()).getFile());
        rewrite.getData().setSuccessBody(this.walkAsBranch(AstNotInvalidKey.class));
        rewrite.getData().setFailBody(this.walkAsBranch(AstInvalidKey.class));
        this.getCode().addStatement(rewrite);
    }
}

