/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.EntryPointArguments;
import com.veryant.cobol.compiler.LinkageParam;
import com.veryant.cobol.compiler.Section;
import com.veryant.cobol.compiler.ast.AstDataName;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.common.AstUsing;
import com.veryant.cobol.compiler.ast.common.AstUsingParameter;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.stmts.Stop;

public class AstProcedureDivision
extends AstNode {
    public AstProcedureDivision(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void walk() {
        DataItemDeclaration[] dataItemDeclarationArray;
        int n;
        AstUsing astUsing = this.getUniqueChild(AstUsing.class);
        if (astUsing != null) {
            n = astUsing.getChildrenCount();
            Object[] objectArray = new LinkageParam[n];
            for (int i = 0; i < n; ++i) {
                AstUsingParameter astUsingParameter = (AstUsingParameter)astUsing.getChild(i);
                AstDataName object = (AstDataName)astUsingParameter.getChild(0);
                dataItemDeclarationArray = this.getScope().getDataItem(object.getDataName(), null);
                if (dataItemDeclarationArray.length == 0) {
                    this.consoleWrite(41, object.getToken(), object.getDataName());
                    continue;
                }
                if (dataItemDeclarationArray.length > 1) {
                    this.consoleWrite(42, object.getToken(), object.getDataName());
                    continue;
                }
                for (LinkageParam linkageParam : this.getCollector().getLinkage()) {
                    if (linkageParam.getDataItemDeclaration() != dataItemDeclarationArray[0]) continue;
                    linkageParam.setUsed(true);
                    objectArray[i] = linkageParam;
                    break;
                }
                if (objectArray[i] != null) continue;
                this.consoleWrite(84, object.getToken(), object.getDataName());
            }
            this.getCollector().setDefaultArguments(new EntryPointArguments((LinkageParam[])objectArray));
        }
        super.walk();
        n = 0;
        for (FileDeclaration fileDeclaration : this.getCollector().getFiles(false)) {
            n = 1;
            dataItemDeclarationArray = fileDeclaration.getDeclarativeSection();
            if (dataItemDeclarationArray == null) continue;
            this.getCode().addDeclaratives(dataItemDeclarationArray.getStart(), dataItemDeclarationArray.getEnd());
        }
        if (n != 0) {
            for (int i = 0; i < 4; ++i) {
                Section section = this.getCode().getErrorProcedures().get(i);
                if (section == null) continue;
                this.getCode().addDeclaratives(section.getStart(), section.getEnd());
            }
        }
        this.getCode().end(new Stop(Token.NULL, null, null, true));
        this.getCode().flowAnalysis();
    }

    @Override
    public String toString() {
        return "procedure-division";
    }
}

